<?php

/**
 * Response
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * Response Class Doc Comment
 *
 * @category    Class */
 // @description Contains information about a response.
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Response implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Response';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'version' => 'int',
        'libraries' => '\PureCloudSDK\DomainEntityRef[]',
        'texts' => '\PureCloudSDK\ResponseText[]',
        'createdBy' => '\PureCloudSDK\User',
        'dateCreated' => '\DateTime',
        'interactionType' => 'string',
        'substitutions' => '\PureCloudSDK\ResponseSubstitution[]',
        'substitutionsSchema' => '\PureCloudSDK\JsonSchemaDocument',
        'responseType' => 'string',
        'messagingTemplate' => '\PureCloudSDK\MessagingTemplate',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'version' => 'version',
        'libraries' => 'libraries',
        'texts' => 'texts',
        'createdBy' => 'createdBy',
        'dateCreated' => 'dateCreated',
        'interactionType' => 'interactionType',
        'substitutions' => 'substitutions',
        'substitutionsSchema' => 'substitutionsSchema',
        'responseType' => 'responseType',
        'messagingTemplate' => 'messagingTemplate',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'version' => 'setVersion',
        'libraries' => 'setLibraries',
        'texts' => 'setTexts',
        'createdBy' => 'setCreatedBy',
        'dateCreated' => 'setDateCreated',
        'interactionType' => 'setInteractionType',
        'substitutions' => 'setSubstitutions',
        'substitutionsSchema' => 'setSubstitutionsSchema',
        'responseType' => 'setResponseType',
        'messagingTemplate' => 'setMessagingTemplate',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'version' => 'getVersion',
        'libraries' => 'getLibraries',
        'texts' => 'getTexts',
        'createdBy' => 'getCreatedBy',
        'dateCreated' => 'getDateCreated',
        'interactionType' => 'getInteractionType',
        'substitutions' => 'getSubstitutions',
        'substitutionsSchema' => 'getSubstitutionsSchema',
        'responseType' => 'getResponseType',
        'messagingTemplate' => 'getMessagingTemplate',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const INTERACTION_TYPE_CHAT = 'chat';
    public const INTERACTION_TYPE_EMAIL = 'email';
    public const INTERACTION_TYPE_TWITTER = 'twitter';
    public const RESPONSE_TYPE_MESSAGING_TEMPLATE = 'MessagingTemplate';
    public const RESPONSE_TYPE_CAMPAIGN_SMS_TEMPLATE = 'CampaignSmsTemplate';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getInteractionTypeAllowableValues()
    {
        return [
            self::INTERACTION_TYPE_CHAT,
            self::INTERACTION_TYPE_EMAIL,
            self::INTERACTION_TYPE_TWITTER,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getResponseTypeAllowableValues()
    {
        return [
            self::RESPONSE_TYPE_MESSAGING_TEMPLATE,
            self::RESPONSE_TYPE_CAMPAIGN_SMS_TEMPLATE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['libraries'] = isset($data['libraries']) ? $data['libraries'] : null;
        $this->container['texts'] = isset($data['texts']) ? $data['texts'] : null;
        $this->container['createdBy'] = isset($data['createdBy']) ? $data['createdBy'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['interactionType'] = isset($data['interactionType']) ? $data['interactionType'] : null;
        $this->container['substitutions'] = isset($data['substitutions']) ? $data['substitutions'] : null;
        $this->container['substitutionsSchema'] = isset($data['substitutionsSchema']) ? $data['substitutionsSchema'] : null;
        $this->container['responseType'] = isset($data['responseType']) ? $data['responseType'] : null;
        $this->container['messagingTemplate'] = isset($data['messagingTemplate']) ? $data['messagingTemplate'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['libraries'] === null) {
            $invalid_properties[] = "'libraries' can't be null";
        }
        if ($this->container['texts'] === null) {
            $invalid_properties[] = "'texts' can't be null";
        }
        $allowed_values = array("chat", "email", "twitter");
        if (!in_array($this->container['interactionType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'interactionType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("MessagingTemplate", "CampaignSmsTemplate");
        if (!in_array($this->container['responseType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'responseType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['libraries'] === null) {
            return false;
        }
        if ($this->container['texts'] === null) {
            return false;
        }
        $allowed_values = array("chat", "email", "twitter");
        if (!in_array($this->container['interactionType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("MessagingTemplate", "CampaignSmsTemplate");
        if (!in_array($this->container['responseType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version Version number required for updates.
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets libraries
     * @return \PureCloudSDK\DomainEntityRef[]
     */
    public function getLibraries()
    {
        return $this->container['libraries'];
    }

    /**
     * Sets libraries
     * @param \PureCloudSDK\DomainEntityRef[] $libraries One or more libraries response is associated with.
     * @return $this
     */
    public function setLibraries($libraries)
    {
        $this->container['libraries'] = $libraries;

        return $this;
    }

    /**
     * Gets texts
     * @return \PureCloudSDK\ResponseText[]
     */
    public function getTexts()
    {
        return $this->container['texts'];
    }

    /**
     * Sets texts
     * @param \PureCloudSDK\ResponseText[] $texts One or more texts associated with the response.
     * @return $this
     */
    public function setTexts($texts)
    {
        $this->container['texts'] = $texts;

        return $this;
    }

    /**
     * Gets createdBy
     * @return \PureCloudSDK\User
     */
    public function getCreatedBy()
    {
        return $this->container['createdBy'];
    }

    /**
     * Sets createdBy
     * @param \PureCloudSDK\User $createdBy User that created the response
     * @return $this
     */
    public function setCreatedBy($createdBy)
    {
        $this->container['createdBy'] = $createdBy;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param \DateTime $dateCreated The date and time the response was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets interactionType
     * @return string
     */
    public function getInteractionType()
    {
        return $this->container['interactionType'];
    }

    /**
     * Sets interactionType
     * @param string $interactionType The interaction type for this response.
     * @return $this
     */
    public function setInteractionType($interactionType)
    {
        $allowed_values = array('chat', 'email', 'twitter');
        if (!in_array($interactionType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'interactionType', must be one of 'chat', 'email', 'twitter'");
        }
        $this->container['interactionType'] = $interactionType;

        return $this;
    }

    /**
     * Gets substitutions
     * @return \PureCloudSDK\ResponseSubstitution[]
     */
    public function getSubstitutions()
    {
        return $this->container['substitutions'];
    }

    /**
     * Sets substitutions
     * @param \PureCloudSDK\ResponseSubstitution[] $substitutions Details about any text substitutions used in the texts for this response.
     * @return $this
     */
    public function setSubstitutions($substitutions)
    {
        $this->container['substitutions'] = $substitutions;

        return $this;
    }

    /**
     * Gets substitutionsSchema
     * @return \PureCloudSDK\JsonSchemaDocument
     */
    public function getSubstitutionsSchema()
    {
        return $this->container['substitutionsSchema'];
    }

    /**
     * Sets substitutionsSchema
     * @param \PureCloudSDK\JsonSchemaDocument $substitutionsSchema Metadata about the text substitutions in json schema format.
     * @return $this
     */
    public function setSubstitutionsSchema($substitutionsSchema)
    {
        $this->container['substitutionsSchema'] = $substitutionsSchema;

        return $this;
    }

    /**
     * Gets responseType
     * @return string
     */
    public function getResponseType()
    {
        return $this->container['responseType'];
    }

    /**
     * Sets responseType
     * @param string $responseType The response type represented by the response.
     * @return $this
     */
    public function setResponseType($responseType)
    {
        $allowed_values = array('MessagingTemplate', 'CampaignSmsTemplate');
        if (!in_array($responseType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'responseType', must be one of 'MessagingTemplate', 'CampaignSmsTemplate'");
        }
        $this->container['responseType'] = $responseType;

        return $this;
    }

    /**
     * Gets messagingTemplate
     * @return \PureCloudSDK\MessagingTemplate
     */
    public function getMessagingTemplate()
    {
        return $this->container['messagingTemplate'];
    }

    /**
     * Sets messagingTemplate
     * @param \PureCloudSDK\MessagingTemplate $messagingTemplate An optional messaging template definition for responseType.MessagingTemplate.
     * @return $this
     */
    public function setMessagingTemplate($messagingTemplate)
    {
        $this->container['messagingTemplate'] = $messagingTemplate;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
