<?php

/**
 * Survey
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * Survey Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Survey implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Survey';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'conversation' => '\PureCloudSDK\Conversation',
        'surveyForm' => '\PureCloudSDK\SurveyForm',
        'agent' => '\PureCloudSDK\DomainEntityRef',
        'status' => 'string',
        'queue' => '\PureCloudSDK\QueueReference',
        'answers' => '\PureCloudSDK\SurveyScoringSet',
        'completedDate' => '\DateTime',
        'surveyErrorDetails' => '\PureCloudSDK\SurveyErrorDetails',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'conversation' => 'conversation',
        'surveyForm' => 'surveyForm',
        'agent' => 'agent',
        'status' => 'status',
        'queue' => 'queue',
        'answers' => 'answers',
        'completedDate' => 'completedDate',
        'surveyErrorDetails' => 'surveyErrorDetails',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'conversation' => 'setConversation',
        'surveyForm' => 'setSurveyForm',
        'agent' => 'setAgent',
        'status' => 'setStatus',
        'queue' => 'setQueue',
        'answers' => 'setAnswers',
        'completedDate' => 'setCompletedDate',
        'surveyErrorDetails' => 'setSurveyErrorDetails',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'conversation' => 'getConversation',
        'surveyForm' => 'getSurveyForm',
        'agent' => 'getAgent',
        'status' => 'getStatus',
        'queue' => 'getQueue',
        'answers' => 'getAnswers',
        'completedDate' => 'getCompletedDate',
        'surveyErrorDetails' => 'getSurveyErrorDetails',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const STATUS_PENDING = 'Pending';
    public const STATUS_SENT = 'Sent';
    public const STATUS_IN_PROGRESS = 'InProgress';
    public const STATUS_FINISHED = 'Finished';
    public const STATUS_OPT_OUT = 'OptOut';
    public const STATUS_ERROR = 'Error';
    public const STATUS_EXPIRED = 'Expired';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_PENDING,
            self::STATUS_SENT,
            self::STATUS_IN_PROGRESS,
            self::STATUS_FINISHED,
            self::STATUS_OPT_OUT,
            self::STATUS_ERROR,
            self::STATUS_EXPIRED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['conversation'] = isset($data['conversation']) ? $data['conversation'] : null;
        $this->container['surveyForm'] = isset($data['surveyForm']) ? $data['surveyForm'] : null;
        $this->container['agent'] = isset($data['agent']) ? $data['agent'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['queue'] = isset($data['queue']) ? $data['queue'] : null;
        $this->container['answers'] = isset($data['answers']) ? $data['answers'] : null;
        $this->container['completedDate'] = isset($data['completedDate']) ? $data['completedDate'] : null;
        $this->container['surveyErrorDetails'] = isset($data['surveyErrorDetails']) ? $data['surveyErrorDetails'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("Pending", "Sent", "InProgress", "Finished", "OptOut", "Error", "Expired");
        if (!in_array($this->container['status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'status', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("Pending", "Sent", "InProgress", "Finished", "OptOut", "Error", "Expired");
        if (!in_array($this->container['status'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets conversation
     * @return \PureCloudSDK\Conversation
     */
    public function getConversation()
    {
        return $this->container['conversation'];
    }

    /**
     * Sets conversation
     * @param \PureCloudSDK\Conversation $conversation
     * @return $this
     */
    public function setConversation($conversation)
    {
        $this->container['conversation'] = $conversation;

        return $this;
    }

    /**
     * Gets surveyForm
     * @return \PureCloudSDK\SurveyForm
     */
    public function getSurveyForm()
    {
        return $this->container['surveyForm'];
    }

    /**
     * Sets surveyForm
     * @param \PureCloudSDK\SurveyForm $surveyForm Survey form used for this survey.
     * @return $this
     */
    public function setSurveyForm($surveyForm)
    {
        $this->container['surveyForm'] = $surveyForm;

        return $this;
    }

    /**
     * Gets agent
     * @return \PureCloudSDK\DomainEntityRef
     */
    public function getAgent()
    {
        return $this->container['agent'];
    }

    /**
     * Sets agent
     * @param \PureCloudSDK\DomainEntityRef $agent
     * @return $this
     */
    public function setAgent($agent)
    {
        $this->container['agent'] = $agent;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status
     * @return $this
     */
    public function setStatus($status)
    {
        $allowed_values = array('Pending', 'Sent', 'InProgress', 'Finished', 'OptOut', 'Error', 'Expired');
        if (!in_array($status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'status', must be one of 'Pending', 'Sent', 'InProgress', 'Finished', 'OptOut', 'Error', 'Expired'");
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets queue
     * @return \PureCloudSDK\QueueReference
     */
    public function getQueue()
    {
        return $this->container['queue'];
    }

    /**
     * Sets queue
     * @param \PureCloudSDK\QueueReference $queue
     * @return $this
     */
    public function setQueue($queue)
    {
        $this->container['queue'] = $queue;

        return $this;
    }

    /**
     * Gets answers
     * @return \PureCloudSDK\SurveyScoringSet
     */
    public function getAnswers()
    {
        return $this->container['answers'];
    }

    /**
     * Sets answers
     * @param \PureCloudSDK\SurveyScoringSet $answers
     * @return $this
     */
    public function setAnswers($answers)
    {
        $this->container['answers'] = $answers;

        return $this;
    }

    /**
     * Gets completedDate
     * @return \DateTime
     */
    public function getCompletedDate()
    {
        return $this->container['completedDate'];
    }

    /**
     * Sets completedDate
     * @param \DateTime $completedDate Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCompletedDate($completedDate)
    {
        $this->container['completedDate'] = $completedDate;

        return $this;
    }

    /**
     * Gets surveyErrorDetails
     * @return \PureCloudSDK\SurveyErrorDetails
     */
    public function getSurveyErrorDetails()
    {
        return $this->container['surveyErrorDetails'];
    }

    /**
     * Sets surveyErrorDetails
     * @param \PureCloudSDK\SurveyErrorDetails $surveyErrorDetails Additional information about what happened when the survey is in Error status.
     * @return $this
     */
    public function setSurveyErrorDetails($surveyErrorDetails)
    {
        $this->container['surveyErrorDetails'] = $surveyErrorDetails;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
