<?php

/**
 * TimeOffRequestNotification
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * TimeOffRequestNotification Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class TimeOffRequestNotification implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'TimeOffRequestNotification';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'timeOffRequestId' => 'string',
        'user' => '\PureCloudSDK\UserReference',
        'isFullDayRequest' => 'bool',
        'status' => 'string',
        'partialDayStartDateTimes' => '\DateTime[]',
        'fullDayManagementUnitDates' => 'string[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'timeOffRequestId' => 'timeOffRequestId',
        'user' => 'user',
        'isFullDayRequest' => 'isFullDayRequest',
        'status' => 'status',
        'partialDayStartDateTimes' => 'partialDayStartDateTimes',
        'fullDayManagementUnitDates' => 'fullDayManagementUnitDates'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'timeOffRequestId' => 'setTimeOffRequestId',
        'user' => 'setUser',
        'isFullDayRequest' => 'setIsFullDayRequest',
        'status' => 'setStatus',
        'partialDayStartDateTimes' => 'setPartialDayStartDateTimes',
        'fullDayManagementUnitDates' => 'setFullDayManagementUnitDates'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'timeOffRequestId' => 'getTimeOffRequestId',
        'user' => 'getUser',
        'isFullDayRequest' => 'getIsFullDayRequest',
        'status' => 'getStatus',
        'partialDayStartDateTimes' => 'getPartialDayStartDateTimes',
        'fullDayManagementUnitDates' => 'getFullDayManagementUnitDates'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const STATUS_PENDING = 'PENDING';
    public const STATUS_APPROVED = 'APPROVED';
    public const STATUS_DENIED = 'DENIED';
    public const STATUS_CANCELED = 'CANCELED';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_PENDING,
            self::STATUS_APPROVED,
            self::STATUS_DENIED,
            self::STATUS_CANCELED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['timeOffRequestId'] = isset($data['timeOffRequestId']) ? $data['timeOffRequestId'] : null;
        $this->container['user'] = isset($data['user']) ? $data['user'] : null;
        $this->container['isFullDayRequest'] = isset($data['isFullDayRequest']) ? $data['isFullDayRequest'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['partialDayStartDateTimes'] = isset($data['partialDayStartDateTimes']) ? $data['partialDayStartDateTimes'] : null;
        $this->container['fullDayManagementUnitDates'] = isset($data['fullDayManagementUnitDates']) ? $data['fullDayManagementUnitDates'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("PENDING", "APPROVED", "DENIED", "CANCELED");
        if (!in_array($this->container['status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'status', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("PENDING", "APPROVED", "DENIED", "CANCELED");
        if (!in_array($this->container['status'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets timeOffRequestId
     * @return string
     */
    public function getTimeOffRequestId()
    {
        return $this->container['timeOffRequestId'];
    }

    /**
     * Sets timeOffRequestId
     * @param string $timeOffRequestId The ID of this time off request
     * @return $this
     */
    public function setTimeOffRequestId($timeOffRequestId)
    {
        $this->container['timeOffRequestId'] = $timeOffRequestId;

        return $this;
    }

    /**
     * Gets user
     * @return \PureCloudSDK\UserReference
     */
    public function getUser()
    {
        return $this->container['user'];
    }

    /**
     * Sets user
     * @param \PureCloudSDK\UserReference $user The user associated with this time off request
     * @return $this
     */
    public function setUser($user)
    {
        $this->container['user'] = $user;

        return $this;
    }

    /**
     * Gets isFullDayRequest
     * @return bool
     */
    public function getIsFullDayRequest()
    {
        return $this->container['isFullDayRequest'];
    }

    /**
     * Sets isFullDayRequest
     * @param bool $isFullDayRequest Whether this is a full day request (false means partial day)
     * @return $this
     */
    public function setIsFullDayRequest($isFullDayRequest)
    {
        $this->container['isFullDayRequest'] = $isFullDayRequest;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status The status of this time off request
     * @return $this
     */
    public function setStatus($status)
    {
        $allowed_values = array('PENDING', 'APPROVED', 'DENIED', 'CANCELED');
        if (!in_array($status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'status', must be one of 'PENDING', 'APPROVED', 'DENIED', 'CANCELED'");
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets partialDayStartDateTimes
     * @return \DateTime[]
     */
    public function getPartialDayStartDateTimes()
    {
        return $this->container['partialDayStartDateTimes'];
    }

    /**
     * Sets partialDayStartDateTimes
     * @param \DateTime[] $partialDayStartDateTimes A set of start date-times in ISO-8601 format for partial day requests.  Will be not empty if isFullDayRequest == false
     * @return $this
     */
    public function setPartialDayStartDateTimes($partialDayStartDateTimes)
    {
        $this->container['partialDayStartDateTimes'] = $partialDayStartDateTimes;

        return $this;
    }

    /**
     * Gets fullDayManagementUnitDates
     * @return string[]
     */
    public function getFullDayManagementUnitDates()
    {
        return $this->container['fullDayManagementUnitDates'];
    }

    /**
     * Sets fullDayManagementUnitDates
     * @param string[] $fullDayManagementUnitDates A set of dates in yyyy-MM-dd format.  Should be interpreted in the management unit's configured time zone.  Will be not empty if isFullDayRequest == true
     * @return $this
     */
    public function setFullDayManagementUnitDates($fullDayManagementUnitDates)
    {
        $this->container['fullDayManagementUnitDates'] = $fullDayManagementUnitDates;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
