<?php

/**
 * Trunk
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * Trunk Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Trunk implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Trunk';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'description' => 'string',
        'version' => 'int',
        'dateCreated' => '\DateTime',
        'dateModified' => '\DateTime',
        'modifiedBy' => 'string',
        'createdBy' => 'string',
        'state' => 'string',
        'modifiedByApp' => 'string',
        'createdByApp' => 'string',
        'trunkType' => 'string',
        'edge' => '\PureCloudSDK\DomainEntityRef',
        'trunkBase' => '\PureCloudSDK\DomainEntityRef',
        'trunkMetabase' => '\PureCloudSDK\DomainEntityRef',
        'edgeGroup' => '\PureCloudSDK\DomainEntityRef',
        'inService' => 'bool',
        'enabled' => 'bool',
        'logicalInterface' => '\PureCloudSDK\DomainEntityRef',
        'connectedStatus' => '\PureCloudSDK\TrunkConnectedStatus',
        'optionsStatus' => '\PureCloudSDK\TrunkMetricsOptions[]',
        'registersStatus' => '\PureCloudSDK\TrunkMetricsRegisters[]',
        'ipStatus' => '\PureCloudSDK\TrunkMetricsNetworkTypeIp',
        'optionsEnabledStatus' => 'string',
        'registersEnabledStatus' => 'string',
        'family' => 'int',
        'proxyAddressList' => 'string[]',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'description' => 'description',
        'version' => 'version',
        'dateCreated' => 'dateCreated',
        'dateModified' => 'dateModified',
        'modifiedBy' => 'modifiedBy',
        'createdBy' => 'createdBy',
        'state' => 'state',
        'modifiedByApp' => 'modifiedByApp',
        'createdByApp' => 'createdByApp',
        'trunkType' => 'trunkType',
        'edge' => 'edge',
        'trunkBase' => 'trunkBase',
        'trunkMetabase' => 'trunkMetabase',
        'edgeGroup' => 'edgeGroup',
        'inService' => 'inService',
        'enabled' => 'enabled',
        'logicalInterface' => 'logicalInterface',
        'connectedStatus' => 'connectedStatus',
        'optionsStatus' => 'optionsStatus',
        'registersStatus' => 'registersStatus',
        'ipStatus' => 'ipStatus',
        'optionsEnabledStatus' => 'optionsEnabledStatus',
        'registersEnabledStatus' => 'registersEnabledStatus',
        'family' => 'family',
        'proxyAddressList' => 'proxyAddressList',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'description' => 'setDescription',
        'version' => 'setVersion',
        'dateCreated' => 'setDateCreated',
        'dateModified' => 'setDateModified',
        'modifiedBy' => 'setModifiedBy',
        'createdBy' => 'setCreatedBy',
        'state' => 'setState',
        'modifiedByApp' => 'setModifiedByApp',
        'createdByApp' => 'setCreatedByApp',
        'trunkType' => 'setTrunkType',
        'edge' => 'setEdge',
        'trunkBase' => 'setTrunkBase',
        'trunkMetabase' => 'setTrunkMetabase',
        'edgeGroup' => 'setEdgeGroup',
        'inService' => 'setInService',
        'enabled' => 'setEnabled',
        'logicalInterface' => 'setLogicalInterface',
        'connectedStatus' => 'setConnectedStatus',
        'optionsStatus' => 'setOptionsStatus',
        'registersStatus' => 'setRegistersStatus',
        'ipStatus' => 'setIpStatus',
        'optionsEnabledStatus' => 'setOptionsEnabledStatus',
        'registersEnabledStatus' => 'setRegistersEnabledStatus',
        'family' => 'setFamily',
        'proxyAddressList' => 'setProxyAddressList',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'description' => 'getDescription',
        'version' => 'getVersion',
        'dateCreated' => 'getDateCreated',
        'dateModified' => 'getDateModified',
        'modifiedBy' => 'getModifiedBy',
        'createdBy' => 'getCreatedBy',
        'state' => 'getState',
        'modifiedByApp' => 'getModifiedByApp',
        'createdByApp' => 'getCreatedByApp',
        'trunkType' => 'getTrunkType',
        'edge' => 'getEdge',
        'trunkBase' => 'getTrunkBase',
        'trunkMetabase' => 'getTrunkMetabase',
        'edgeGroup' => 'getEdgeGroup',
        'inService' => 'getInService',
        'enabled' => 'getEnabled',
        'logicalInterface' => 'getLogicalInterface',
        'connectedStatus' => 'getConnectedStatus',
        'optionsStatus' => 'getOptionsStatus',
        'registersStatus' => 'getRegistersStatus',
        'ipStatus' => 'getIpStatus',
        'optionsEnabledStatus' => 'getOptionsEnabledStatus',
        'registersEnabledStatus' => 'getRegistersEnabledStatus',
        'family' => 'getFamily',
        'proxyAddressList' => 'getProxyAddressList',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const STATE_ACTIVE = 'active';
    public const STATE_INACTIVE = 'inactive';
    public const STATE_DELETED = 'deleted';
    public const TRUNK_TYPE_EXTERNAL = 'EXTERNAL';
    public const TRUNK_TYPE_PHONE = 'PHONE';
    public const TRUNK_TYPE_EDGE = 'EDGE';
    public const OPTIONS_ENABLED_STATUS_ENABLED = 'ENABLED';
    public const OPTIONS_ENABLED_STATUS_DISABLED = 'DISABLED';
    public const OPTIONS_ENABLED_STATUS_NOT_SUPPORTED = 'NOT_SUPPORTED';
    public const REGISTERS_ENABLED_STATUS_ENABLED = 'ENABLED';
    public const REGISTERS_ENABLED_STATUS_DISABLED = 'DISABLED';
    public const REGISTERS_ENABLED_STATUS_NOT_SUPPORTED = 'NOT_SUPPORTED';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ACTIVE,
            self::STATE_INACTIVE,
            self::STATE_DELETED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTrunkTypeAllowableValues()
    {
        return [
            self::TRUNK_TYPE_EXTERNAL,
            self::TRUNK_TYPE_PHONE,
            self::TRUNK_TYPE_EDGE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getOptionsEnabledStatusAllowableValues()
    {
        return [
            self::OPTIONS_ENABLED_STATUS_ENABLED,
            self::OPTIONS_ENABLED_STATUS_DISABLED,
            self::OPTIONS_ENABLED_STATUS_NOT_SUPPORTED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getRegistersEnabledStatusAllowableValues()
    {
        return [
            self::REGISTERS_ENABLED_STATUS_ENABLED,
            self::REGISTERS_ENABLED_STATUS_DISABLED,
            self::REGISTERS_ENABLED_STATUS_NOT_SUPPORTED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['dateModified'] = isset($data['dateModified']) ? $data['dateModified'] : null;
        $this->container['modifiedBy'] = isset($data['modifiedBy']) ? $data['modifiedBy'] : null;
        $this->container['createdBy'] = isset($data['createdBy']) ? $data['createdBy'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['modifiedByApp'] = isset($data['modifiedByApp']) ? $data['modifiedByApp'] : null;
        $this->container['createdByApp'] = isset($data['createdByApp']) ? $data['createdByApp'] : null;
        $this->container['trunkType'] = isset($data['trunkType']) ? $data['trunkType'] : null;
        $this->container['edge'] = isset($data['edge']) ? $data['edge'] : null;
        $this->container['trunkBase'] = isset($data['trunkBase']) ? $data['trunkBase'] : null;
        $this->container['trunkMetabase'] = isset($data['trunkMetabase']) ? $data['trunkMetabase'] : null;
        $this->container['edgeGroup'] = isset($data['edgeGroup']) ? $data['edgeGroup'] : null;
        $this->container['inService'] = isset($data['inService']) ? $data['inService'] : null;
        $this->container['enabled'] = isset($data['enabled']) ? $data['enabled'] : null;
        $this->container['logicalInterface'] = isset($data['logicalInterface']) ? $data['logicalInterface'] : null;
        $this->container['connectedStatus'] = isset($data['connectedStatus']) ? $data['connectedStatus'] : null;
        $this->container['optionsStatus'] = isset($data['optionsStatus']) ? $data['optionsStatus'] : null;
        $this->container['registersStatus'] = isset($data['registersStatus']) ? $data['registersStatus'] : null;
        $this->container['ipStatus'] = isset($data['ipStatus']) ? $data['ipStatus'] : null;
        $this->container['optionsEnabledStatus'] = isset($data['optionsEnabledStatus']) ? $data['optionsEnabledStatus'] : null;
        $this->container['registersEnabledStatus'] = isset($data['registersEnabledStatus']) ? $data['registersEnabledStatus'] : null;
        $this->container['family'] = isset($data['family']) ? $data['family'] : null;
        $this->container['proxyAddressList'] = isset($data['proxyAddressList']) ? $data['proxyAddressList'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        $allowed_values = array("active", "inactive", "deleted");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        $allowed_values = array("EXTERNAL", "PHONE", "EDGE");
        if (!in_array($this->container['trunkType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'trunkType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("ENABLED", "DISABLED", "NOT_SUPPORTED");
        if (!in_array($this->container['optionsEnabledStatus'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'optionsEnabledStatus', must be one of #{allowed_values}.";
        }

        $allowed_values = array("ENABLED", "DISABLED", "NOT_SUPPORTED");
        if (!in_array($this->container['registersEnabledStatus'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'registersEnabledStatus', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        $allowed_values = array("active", "inactive", "deleted");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("EXTERNAL", "PHONE", "EDGE");
        if (!in_array($this->container['trunkType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("ENABLED", "DISABLED", "NOT_SUPPORTED");
        if (!in_array($this->container['optionsEnabledStatus'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("ENABLED", "DISABLED", "NOT_SUPPORTED");
        if (!in_array($this->container['registersEnabledStatus'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The name of the entity.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description The resource's description.
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version The current version of the resource.
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param \DateTime $dateCreated The date the resource was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets dateModified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['dateModified'];
    }

    /**
     * Sets dateModified
     * @param \DateTime $dateModified The date of the last modification to the resource. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($dateModified)
    {
        $this->container['dateModified'] = $dateModified;

        return $this;
    }

    /**
     * Gets modifiedBy
     * @return string
     */
    public function getModifiedBy()
    {
        return $this->container['modifiedBy'];
    }

    /**
     * Sets modifiedBy
     * @param string $modifiedBy The ID of the user that last modified the resource.
     * @return $this
     */
    public function setModifiedBy($modifiedBy)
    {
        $this->container['modifiedBy'] = $modifiedBy;

        return $this;
    }

    /**
     * Gets createdBy
     * @return string
     */
    public function getCreatedBy()
    {
        return $this->container['createdBy'];
    }

    /**
     * Sets createdBy
     * @param string $createdBy The ID of the user that created the resource.
     * @return $this
     */
    public function setCreatedBy($createdBy)
    {
        $this->container['createdBy'] = $createdBy;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state Indicates if the resource is active, inactive, or deleted.
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('active', 'inactive', 'deleted');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'active', 'inactive', 'deleted'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets modifiedByApp
     * @return string
     */
    public function getModifiedByApp()
    {
        return $this->container['modifiedByApp'];
    }

    /**
     * Sets modifiedByApp
     * @param string $modifiedByApp The application that last modified the resource.
     * @return $this
     */
    public function setModifiedByApp($modifiedByApp)
    {
        $this->container['modifiedByApp'] = $modifiedByApp;

        return $this;
    }

    /**
     * Gets createdByApp
     * @return string
     */
    public function getCreatedByApp()
    {
        return $this->container['createdByApp'];
    }

    /**
     * Sets createdByApp
     * @param string $createdByApp The application that created the resource.
     * @return $this
     */
    public function setCreatedByApp($createdByApp)
    {
        $this->container['createdByApp'] = $createdByApp;

        return $this;
    }

    /**
     * Gets trunkType
     * @return string
     */
    public function getTrunkType()
    {
        return $this->container['trunkType'];
    }

    /**
     * Sets trunkType
     * @param string $trunkType The type of this trunk.
     * @return $this
     */
    public function setTrunkType($trunkType)
    {
        $allowed_values = array('EXTERNAL', 'PHONE', 'EDGE');
        if (!in_array($trunkType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'trunkType', must be one of 'EXTERNAL', 'PHONE', 'EDGE'");
        }
        $this->container['trunkType'] = $trunkType;

        return $this;
    }

    /**
     * Gets edge
     * @return \PureCloudSDK\DomainEntityRef
     */
    public function getEdge()
    {
        return $this->container['edge'];
    }

    /**
     * Sets edge
     * @param \PureCloudSDK\DomainEntityRef $edge The Edge using this trunk.
     * @return $this
     */
    public function setEdge($edge)
    {
        $this->container['edge'] = $edge;

        return $this;
    }

    /**
     * Gets trunkBase
     * @return \PureCloudSDK\DomainEntityRef
     */
    public function getTrunkBase()
    {
        return $this->container['trunkBase'];
    }

    /**
     * Sets trunkBase
     * @param \PureCloudSDK\DomainEntityRef $trunkBase The trunk base configuration used on this trunk.
     * @return $this
     */
    public function setTrunkBase($trunkBase)
    {
        $this->container['trunkBase'] = $trunkBase;

        return $this;
    }

    /**
     * Gets trunkMetabase
     * @return \PureCloudSDK\DomainEntityRef
     */
    public function getTrunkMetabase()
    {
        return $this->container['trunkMetabase'];
    }

    /**
     * Sets trunkMetabase
     * @param \PureCloudSDK\DomainEntityRef $trunkMetabase The metabase used to create this trunk.
     * @return $this
     */
    public function setTrunkMetabase($trunkMetabase)
    {
        $this->container['trunkMetabase'] = $trunkMetabase;

        return $this;
    }

    /**
     * Gets edgeGroup
     * @return \PureCloudSDK\DomainEntityRef
     */
    public function getEdgeGroup()
    {
        return $this->container['edgeGroup'];
    }

    /**
     * Sets edgeGroup
     * @param \PureCloudSDK\DomainEntityRef $edgeGroup The edge group associated with this trunk.
     * @return $this
     */
    public function setEdgeGroup($edgeGroup)
    {
        $this->container['edgeGroup'] = $edgeGroup;

        return $this;
    }

    /**
     * Gets inService
     * @return bool
     */
    public function getInService()
    {
        return $this->container['inService'];
    }

    /**
     * Sets inService
     * @param bool $inService True if this trunk is in-service.  This comes from the trunk_enabled property of the referenced trunk base.
     * @return $this
     */
    public function setInService($inService)
    {
        $this->container['inService'] = $inService;

        return $this;
    }

    /**
     * Gets enabled
     * @return bool
     */
    public function getEnabled()
    {
        return $this->container['enabled'];
    }

    /**
     * Sets enabled
     * @param bool $enabled True if the Edge used by this trunk is in-service
     * @return $this
     */
    public function setEnabled($enabled)
    {
        $this->container['enabled'] = $enabled;

        return $this;
    }

    /**
     * Gets logicalInterface
     * @return \PureCloudSDK\DomainEntityRef
     */
    public function getLogicalInterface()
    {
        return $this->container['logicalInterface'];
    }

    /**
     * Sets logicalInterface
     * @param \PureCloudSDK\DomainEntityRef $logicalInterface The Logical Interface on the Edge to which the trunk is assigned.
     * @return $this
     */
    public function setLogicalInterface($logicalInterface)
    {
        $this->container['logicalInterface'] = $logicalInterface;

        return $this;
    }

    /**
     * Gets connectedStatus
     * @return \PureCloudSDK\TrunkConnectedStatus
     */
    public function getConnectedStatus()
    {
        return $this->container['connectedStatus'];
    }

    /**
     * Sets connectedStatus
     * @param \PureCloudSDK\TrunkConnectedStatus $connectedStatus The connected status of the trunk
     * @return $this
     */
    public function setConnectedStatus($connectedStatus)
    {
        $this->container['connectedStatus'] = $connectedStatus;

        return $this;
    }

    /**
     * Gets optionsStatus
     * @return \PureCloudSDK\TrunkMetricsOptions[]
     */
    public function getOptionsStatus()
    {
        return $this->container['optionsStatus'];
    }

    /**
     * Sets optionsStatus
     * @param \PureCloudSDK\TrunkMetricsOptions[] $optionsStatus The trunk optionsStatus
     * @return $this
     */
    public function setOptionsStatus($optionsStatus)
    {
        $this->container['optionsStatus'] = $optionsStatus;

        return $this;
    }

    /**
     * Gets registersStatus
     * @return \PureCloudSDK\TrunkMetricsRegisters[]
     */
    public function getRegistersStatus()
    {
        return $this->container['registersStatus'];
    }

    /**
     * Sets registersStatus
     * @param \PureCloudSDK\TrunkMetricsRegisters[] $registersStatus The trunk registersStatus
     * @return $this
     */
    public function setRegistersStatus($registersStatus)
    {
        $this->container['registersStatus'] = $registersStatus;

        return $this;
    }

    /**
     * Gets ipStatus
     * @return \PureCloudSDK\TrunkMetricsNetworkTypeIp
     */
    public function getIpStatus()
    {
        return $this->container['ipStatus'];
    }

    /**
     * Sets ipStatus
     * @param \PureCloudSDK\TrunkMetricsNetworkTypeIp $ipStatus The trunk ipStatus
     * @return $this
     */
    public function setIpStatus($ipStatus)
    {
        $this->container['ipStatus'] = $ipStatus;

        return $this;
    }

    /**
     * Gets optionsEnabledStatus
     * @return string
     */
    public function getOptionsEnabledStatus()
    {
        return $this->container['optionsEnabledStatus'];
    }

    /**
     * Sets optionsEnabledStatus
     * @param string $optionsEnabledStatus Returns Enabled when the trunk base supports the availability interval and it has a value greater than 0.
     * @return $this
     */
    public function setOptionsEnabledStatus($optionsEnabledStatus)
    {
        $allowed_values = array('ENABLED', 'DISABLED', 'NOT_SUPPORTED');
        if (!in_array($optionsEnabledStatus, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'optionsEnabledStatus', must be one of 'ENABLED', 'DISABLED', 'NOT_SUPPORTED'");
        }
        $this->container['optionsEnabledStatus'] = $optionsEnabledStatus;

        return $this;
    }

    /**
     * Gets registersEnabledStatus
     * @return string
     */
    public function getRegistersEnabledStatus()
    {
        return $this->container['registersEnabledStatus'];
    }

    /**
     * Sets registersEnabledStatus
     * @param string $registersEnabledStatus Returns Enabled when the trunk base supports the registration interval and it has a value greater than 0.
     * @return $this
     */
    public function setRegistersEnabledStatus($registersEnabledStatus)
    {
        $allowed_values = array('ENABLED', 'DISABLED', 'NOT_SUPPORTED');
        if (!in_array($registersEnabledStatus, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'registersEnabledStatus', must be one of 'ENABLED', 'DISABLED', 'NOT_SUPPORTED'");
        }
        $this->container['registersEnabledStatus'] = $registersEnabledStatus;

        return $this;
    }

    /**
     * Gets family
     * @return int
     */
    public function getFamily()
    {
        return $this->container['family'];
    }

    /**
     * Sets family
     * @param int $family The IP Network Family of the trunk
     * @return $this
     */
    public function setFamily($family)
    {
        $this->container['family'] = $family;

        return $this;
    }

    /**
     * Gets proxyAddressList
     * @return string[]
     */
    public function getProxyAddressList()
    {
        return $this->container['proxyAddressList'];
    }

    /**
     * Sets proxyAddressList
     * @param string[] $proxyAddressList The list of proxy addresses (ports if provided) for the trunk
     * @return $this
     */
    public function setProxyAddressList($proxyAddressList)
    {
        $this->container['proxyAddressList'] = $proxyAddressList;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
