<?php

/**
 * TrunkMetrics
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * TrunkMetrics Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class TrunkMetrics implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'TrunkMetrics';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'eventTime' => '\DateTime',
        'logicalInterface' => '\PureCloudSDK\DomainEntityRef',
        'trunk' => '\PureCloudSDK\DomainEntityRef',
        'calls' => '\PureCloudSDK\TrunkMetricsCalls',
        'qos' => '\PureCloudSDK\TrunkMetricsQoS'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'eventTime' => 'eventTime',
        'logicalInterface' => 'logicalInterface',
        'trunk' => 'trunk',
        'calls' => 'calls',
        'qos' => 'qos'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'eventTime' => 'setEventTime',
        'logicalInterface' => 'setLogicalInterface',
        'trunk' => 'setTrunk',
        'calls' => 'setCalls',
        'qos' => 'setQos'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'eventTime' => 'getEventTime',
        'logicalInterface' => 'getLogicalInterface',
        'trunk' => 'getTrunk',
        'calls' => 'getCalls',
        'qos' => 'getQos'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['eventTime'] = isset($data['eventTime']) ? $data['eventTime'] : null;
        $this->container['logicalInterface'] = isset($data['logicalInterface']) ? $data['logicalInterface'] : null;
        $this->container['trunk'] = isset($data['trunk']) ? $data['trunk'] : null;
        $this->container['calls'] = isset($data['calls']) ? $data['calls'] : null;
        $this->container['qos'] = isset($data['qos']) ? $data['qos'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets eventTime
     * @return \DateTime
     */
    public function getEventTime()
    {
        return $this->container['eventTime'];
    }

    /**
     * Sets eventTime
     * @param \DateTime $eventTime Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setEventTime($eventTime)
    {
        $this->container['eventTime'] = $eventTime;

        return $this;
    }

    /**
     * Gets logicalInterface
     * @return \PureCloudSDK\DomainEntityRef
     */
    public function getLogicalInterface()
    {
        return $this->container['logicalInterface'];
    }

    /**
     * Sets logicalInterface
     * @param \PureCloudSDK\DomainEntityRef $logicalInterface
     * @return $this
     */
    public function setLogicalInterface($logicalInterface)
    {
        $this->container['logicalInterface'] = $logicalInterface;

        return $this;
    }

    /**
     * Gets trunk
     * @return \PureCloudSDK\DomainEntityRef
     */
    public function getTrunk()
    {
        return $this->container['trunk'];
    }

    /**
     * Sets trunk
     * @param \PureCloudSDK\DomainEntityRef $trunk
     * @return $this
     */
    public function setTrunk($trunk)
    {
        $this->container['trunk'] = $trunk;

        return $this;
    }

    /**
     * Gets calls
     * @return \PureCloudSDK\TrunkMetricsCalls
     */
    public function getCalls()
    {
        return $this->container['calls'];
    }

    /**
     * Sets calls
     * @param \PureCloudSDK\TrunkMetricsCalls $calls
     * @return $this
     */
    public function setCalls($calls)
    {
        $this->container['calls'] = $calls;

        return $this;
    }

    /**
     * Gets qos
     * @return \PureCloudSDK\TrunkMetricsQoS
     */
    public function getQos()
    {
        return $this->container['qos'];
    }

    /**
     * Sets qos
     * @param \PureCloudSDK\TrunkMetricsQoS $qos
     * @return $this
     */
    public function setQos($qos)
    {
        $this->container['qos'] = $qos;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
