<?php

/**
 * TwitterIntegrationRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * TwitterIntegrationRequest Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class TwitterIntegrationRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'TwitterIntegrationRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'accessTokenKey' => 'string',
        'accessTokenSecret' => 'string',
        'consumerKey' => 'string',
        'consumerSecret' => 'string',
        'tier' => 'string',
        'envName' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'accessTokenKey' => 'accessTokenKey',
        'accessTokenSecret' => 'accessTokenSecret',
        'consumerKey' => 'consumerKey',
        'consumerSecret' => 'consumerSecret',
        'tier' => 'tier',
        'envName' => 'envName',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'accessTokenKey' => 'setAccessTokenKey',
        'accessTokenSecret' => 'setAccessTokenSecret',
        'consumerKey' => 'setConsumerKey',
        'consumerSecret' => 'setConsumerSecret',
        'tier' => 'setTier',
        'envName' => 'setEnvName',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'accessTokenKey' => 'getAccessTokenKey',
        'accessTokenSecret' => 'getAccessTokenSecret',
        'consumerKey' => 'getConsumerKey',
        'consumerSecret' => 'getConsumerSecret',
        'tier' => 'getTier',
        'envName' => 'getEnvName',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const TIER_PREMIUM = 'premium';
    public const TIER_ENTERPRISE = 'enterprise';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTierAllowableValues()
    {
        return [
            self::TIER_PREMIUM,
            self::TIER_ENTERPRISE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['accessTokenKey'] = isset($data['accessTokenKey']) ? $data['accessTokenKey'] : null;
        $this->container['accessTokenSecret'] = isset($data['accessTokenSecret']) ? $data['accessTokenSecret'] : null;
        $this->container['consumerKey'] = isset($data['consumerKey']) ? $data['consumerKey'] : null;
        $this->container['consumerSecret'] = isset($data['consumerSecret']) ? $data['consumerSecret'] : null;
        $this->container['tier'] = isset($data['tier']) ? $data['tier'] : null;
        $this->container['envName'] = isset($data['envName']) ? $data['envName'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        if ($this->container['accessTokenKey'] === null) {
            $invalid_properties[] = "'accessTokenKey' can't be null";
        }
        if ($this->container['accessTokenSecret'] === null) {
            $invalid_properties[] = "'accessTokenSecret' can't be null";
        }
        if ($this->container['consumerKey'] === null) {
            $invalid_properties[] = "'consumerKey' can't be null";
        }
        if ($this->container['consumerSecret'] === null) {
            $invalid_properties[] = "'consumerSecret' can't be null";
        }
        if ($this->container['tier'] === null) {
            $invalid_properties[] = "'tier' can't be null";
        }
        $allowed_values = array("premium", "enterprise");
        if (!in_array($this->container['tier'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'tier', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        if ($this->container['accessTokenKey'] === null) {
            return false;
        }
        if ($this->container['accessTokenSecret'] === null) {
            return false;
        }
        if ($this->container['consumerKey'] === null) {
            return false;
        }
        if ($this->container['consumerSecret'] === null) {
            return false;
        }
        if ($this->container['tier'] === null) {
            return false;
        }
        $allowed_values = array("premium", "enterprise");
        if (!in_array($this->container['tier'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The name of the Twitter Integration
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets accessTokenKey
     * @return string
     */
    public function getAccessTokenKey()
    {
        return $this->container['accessTokenKey'];
    }

    /**
     * Sets accessTokenKey
     * @param string $accessTokenKey The Access Token Key from Twitter messenger
     * @return $this
     */
    public function setAccessTokenKey($accessTokenKey)
    {
        $this->container['accessTokenKey'] = $accessTokenKey;

        return $this;
    }

    /**
     * Gets accessTokenSecret
     * @return string
     */
    public function getAccessTokenSecret()
    {
        return $this->container['accessTokenSecret'];
    }

    /**
     * Sets accessTokenSecret
     * @param string $accessTokenSecret The Access Token Secret from Twitter messenger
     * @return $this
     */
    public function setAccessTokenSecret($accessTokenSecret)
    {
        $this->container['accessTokenSecret'] = $accessTokenSecret;

        return $this;
    }

    /**
     * Gets consumerKey
     * @return string
     */
    public function getConsumerKey()
    {
        return $this->container['consumerKey'];
    }

    /**
     * Sets consumerKey
     * @param string $consumerKey The Consumer Key from Twitter messenger
     * @return $this
     */
    public function setConsumerKey($consumerKey)
    {
        $this->container['consumerKey'] = $consumerKey;

        return $this;
    }

    /**
     * Gets consumerSecret
     * @return string
     */
    public function getConsumerSecret()
    {
        return $this->container['consumerSecret'];
    }

    /**
     * Sets consumerSecret
     * @param string $consumerSecret The Consumer Secret from Twitter messenger
     * @return $this
     */
    public function setConsumerSecret($consumerSecret)
    {
        $this->container['consumerSecret'] = $consumerSecret;

        return $this;
    }

    /**
     * Gets tier
     * @return string
     */
    public function getTier()
    {
        return $this->container['tier'];
    }

    /**
     * Sets tier
     * @param string $tier The type of twitter account to be used for the integration
     * @return $this
     */
    public function setTier($tier)
    {
        $allowed_values = array('premium', 'enterprise');
        if (!in_array($tier, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'tier', must be one of 'premium', 'enterprise'");
        }
        $this->container['tier'] = $tier;

        return $this;
    }

    /**
     * Gets envName
     * @return string
     */
    public function getEnvName()
    {
        return $this->container['envName'];
    }

    /**
     * Sets envName
     * @param string $envName The Twitter environment name, e.g.: env-beta (required for premium tier)
     * @return $this
     */
    public function setEnvName($envName)
    {
        $this->container['envName'] = $envName;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
