<?php

/**
 * UserScheduleAdherence
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * UserScheduleAdherence Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class UserScheduleAdherence implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'UserScheduleAdherence';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'user' => '\PureCloudSDK\UserReference',
        'managementUnit' => '\PureCloudSDK\ManagementUnit',
        'team' => '\PureCloudSDK\Team',
        'scheduledActivityCategory' => 'string',
        'systemPresence' => 'string',
        'organizationSecondaryPresenceId' => 'string',
        'routingStatus' => 'string',
        'actualActivityCategory' => 'string',
        'isOutOfOffice' => 'bool',
        'adherenceState' => 'string',
        'impact' => 'string',
        'timeOfAdherenceChange' => '\DateTime',
        'presenceUpdateTime' => '\DateTime',
        'activeQueues' => '\PureCloudSDK\QueueReference[]',
        'activeQueuesModifiedTime' => '\DateTime',
        'removedFromManagementUnit' => 'bool',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'user' => 'user',
        'managementUnit' => 'managementUnit',
        'team' => 'team',
        'scheduledActivityCategory' => 'scheduledActivityCategory',
        'systemPresence' => 'systemPresence',
        'organizationSecondaryPresenceId' => 'organizationSecondaryPresenceId',
        'routingStatus' => 'routingStatus',
        'actualActivityCategory' => 'actualActivityCategory',
        'isOutOfOffice' => 'isOutOfOffice',
        'adherenceState' => 'adherenceState',
        'impact' => 'impact',
        'timeOfAdherenceChange' => 'timeOfAdherenceChange',
        'presenceUpdateTime' => 'presenceUpdateTime',
        'activeQueues' => 'activeQueues',
        'activeQueuesModifiedTime' => 'activeQueuesModifiedTime',
        'removedFromManagementUnit' => 'removedFromManagementUnit',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'user' => 'setUser',
        'managementUnit' => 'setManagementUnit',
        'team' => 'setTeam',
        'scheduledActivityCategory' => 'setScheduledActivityCategory',
        'systemPresence' => 'setSystemPresence',
        'organizationSecondaryPresenceId' => 'setOrganizationSecondaryPresenceId',
        'routingStatus' => 'setRoutingStatus',
        'actualActivityCategory' => 'setActualActivityCategory',
        'isOutOfOffice' => 'setIsOutOfOffice',
        'adherenceState' => 'setAdherenceState',
        'impact' => 'setImpact',
        'timeOfAdherenceChange' => 'setTimeOfAdherenceChange',
        'presenceUpdateTime' => 'setPresenceUpdateTime',
        'activeQueues' => 'setActiveQueues',
        'activeQueuesModifiedTime' => 'setActiveQueuesModifiedTime',
        'removedFromManagementUnit' => 'setRemovedFromManagementUnit',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'user' => 'getUser',
        'managementUnit' => 'getManagementUnit',
        'team' => 'getTeam',
        'scheduledActivityCategory' => 'getScheduledActivityCategory',
        'systemPresence' => 'getSystemPresence',
        'organizationSecondaryPresenceId' => 'getOrganizationSecondaryPresenceId',
        'routingStatus' => 'getRoutingStatus',
        'actualActivityCategory' => 'getActualActivityCategory',
        'isOutOfOffice' => 'getIsOutOfOffice',
        'adherenceState' => 'getAdherenceState',
        'impact' => 'getImpact',
        'timeOfAdherenceChange' => 'getTimeOfAdherenceChange',
        'presenceUpdateTime' => 'getPresenceUpdateTime',
        'activeQueues' => 'getActiveQueues',
        'activeQueuesModifiedTime' => 'getActiveQueuesModifiedTime',
        'removedFromManagementUnit' => 'getRemovedFromManagementUnit',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const SCHEDULED_ACTIVITY_CATEGORY_ON_QUEUE_WORK = 'OnQueueWork';
    public const SCHEDULED_ACTIVITY_CATEGORY_BREAK = 'Break';
    public const SCHEDULED_ACTIVITY_CATEGORY_MEAL = 'Meal';
    public const SCHEDULED_ACTIVITY_CATEGORY_MEETING = 'Meeting';
    public const SCHEDULED_ACTIVITY_CATEGORY_OFF_QUEUE_WORK = 'OffQueueWork';
    public const SCHEDULED_ACTIVITY_CATEGORY_TIME_OFF = 'TimeOff';
    public const SCHEDULED_ACTIVITY_CATEGORY_TRAINING = 'Training';
    public const SCHEDULED_ACTIVITY_CATEGORY_UNAVAILABLE = 'Unavailable';
    public const SCHEDULED_ACTIVITY_CATEGORY_UNSCHEDULED = 'Unscheduled';
    public const SYSTEM_PRESENCE_AVAILABLE = 'Available';
    public const SYSTEM_PRESENCE_AWAY = 'Away';
    public const SYSTEM_PRESENCE_BUSY = 'Busy';
    public const SYSTEM_PRESENCE_OFFLINE = 'Offline';
    public const SYSTEM_PRESENCE_IDLE = 'Idle';
    public const SYSTEM_PRESENCE_ON_QUEUE = 'OnQueue';
    public const SYSTEM_PRESENCE_MEAL = 'Meal';
    public const SYSTEM_PRESENCE_TRAINING = 'Training';
    public const SYSTEM_PRESENCE_MEETING = 'Meeting';
    public const SYSTEM_PRESENCE_BREAK = 'Break';
    public const ROUTING_STATUS_OFF_QUEUE = 'OFF_QUEUE';
    public const ROUTING_STATUS_IDLE = 'IDLE';
    public const ROUTING_STATUS_INTERACTING = 'INTERACTING';
    public const ROUTING_STATUS_NOT_RESPONDING = 'NOT_RESPONDING';
    public const ROUTING_STATUS_COMMUNICATING = 'COMMUNICATING';
    public const ACTUAL_ACTIVITY_CATEGORY_ON_QUEUE_WORK = 'OnQueueWork';
    public const ACTUAL_ACTIVITY_CATEGORY_BREAK = 'Break';
    public const ACTUAL_ACTIVITY_CATEGORY_MEAL = 'Meal';
    public const ACTUAL_ACTIVITY_CATEGORY_MEETING = 'Meeting';
    public const ACTUAL_ACTIVITY_CATEGORY_OFF_QUEUE_WORK = 'OffQueueWork';
    public const ACTUAL_ACTIVITY_CATEGORY_TIME_OFF = 'TimeOff';
    public const ACTUAL_ACTIVITY_CATEGORY_TRAINING = 'Training';
    public const ACTUAL_ACTIVITY_CATEGORY_UNAVAILABLE = 'Unavailable';
    public const ACTUAL_ACTIVITY_CATEGORY_UNSCHEDULED = 'Unscheduled';
    public const ADHERENCE_STATE_IN_ADHERENCE = 'InAdherence';
    public const ADHERENCE_STATE_OUT_OF_ADHERENCE = 'OutOfAdherence';
    public const ADHERENCE_STATE_UNSCHEDULED = 'Unscheduled';
    public const ADHERENCE_STATE_UNKNOWN = 'Unknown';
    public const ADHERENCE_STATE_IGNORED = 'Ignored';
    public const IMPACT_POSITIVE = 'Positive';
    public const IMPACT_NEGATIVE = 'Negative';
    public const IMPACT_NEUTRAL = 'Neutral';
    public const IMPACT_UNKNOWN = 'Unknown';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getScheduledActivityCategoryAllowableValues()
    {
        return [
            self::SCHEDULED_ACTIVITY_CATEGORY_ON_QUEUE_WORK,
            self::SCHEDULED_ACTIVITY_CATEGORY_BREAK,
            self::SCHEDULED_ACTIVITY_CATEGORY_MEAL,
            self::SCHEDULED_ACTIVITY_CATEGORY_MEETING,
            self::SCHEDULED_ACTIVITY_CATEGORY_OFF_QUEUE_WORK,
            self::SCHEDULED_ACTIVITY_CATEGORY_TIME_OFF,
            self::SCHEDULED_ACTIVITY_CATEGORY_TRAINING,
            self::SCHEDULED_ACTIVITY_CATEGORY_UNAVAILABLE,
            self::SCHEDULED_ACTIVITY_CATEGORY_UNSCHEDULED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getSystemPresenceAllowableValues()
    {
        return [
            self::SYSTEM_PRESENCE_AVAILABLE,
            self::SYSTEM_PRESENCE_AWAY,
            self::SYSTEM_PRESENCE_BUSY,
            self::SYSTEM_PRESENCE_OFFLINE,
            self::SYSTEM_PRESENCE_IDLE,
            self::SYSTEM_PRESENCE_ON_QUEUE,
            self::SYSTEM_PRESENCE_MEAL,
            self::SYSTEM_PRESENCE_TRAINING,
            self::SYSTEM_PRESENCE_MEETING,
            self::SYSTEM_PRESENCE_BREAK,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getRoutingStatusAllowableValues()
    {
        return [
            self::ROUTING_STATUS_OFF_QUEUE,
            self::ROUTING_STATUS_IDLE,
            self::ROUTING_STATUS_INTERACTING,
            self::ROUTING_STATUS_NOT_RESPONDING,
            self::ROUTING_STATUS_COMMUNICATING,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getActualActivityCategoryAllowableValues()
    {
        return [
            self::ACTUAL_ACTIVITY_CATEGORY_ON_QUEUE_WORK,
            self::ACTUAL_ACTIVITY_CATEGORY_BREAK,
            self::ACTUAL_ACTIVITY_CATEGORY_MEAL,
            self::ACTUAL_ACTIVITY_CATEGORY_MEETING,
            self::ACTUAL_ACTIVITY_CATEGORY_OFF_QUEUE_WORK,
            self::ACTUAL_ACTIVITY_CATEGORY_TIME_OFF,
            self::ACTUAL_ACTIVITY_CATEGORY_TRAINING,
            self::ACTUAL_ACTIVITY_CATEGORY_UNAVAILABLE,
            self::ACTUAL_ACTIVITY_CATEGORY_UNSCHEDULED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getAdherenceStateAllowableValues()
    {
        return [
            self::ADHERENCE_STATE_IN_ADHERENCE,
            self::ADHERENCE_STATE_OUT_OF_ADHERENCE,
            self::ADHERENCE_STATE_UNSCHEDULED,
            self::ADHERENCE_STATE_UNKNOWN,
            self::ADHERENCE_STATE_IGNORED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getImpactAllowableValues()
    {
        return [
            self::IMPACT_POSITIVE,
            self::IMPACT_NEGATIVE,
            self::IMPACT_NEUTRAL,
            self::IMPACT_UNKNOWN,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['user'] = isset($data['user']) ? $data['user'] : null;
        $this->container['managementUnit'] = isset($data['managementUnit']) ? $data['managementUnit'] : null;
        $this->container['team'] = isset($data['team']) ? $data['team'] : null;
        $this->container['scheduledActivityCategory'] = isset($data['scheduledActivityCategory']) ? $data['scheduledActivityCategory'] : null;
        $this->container['systemPresence'] = isset($data['systemPresence']) ? $data['systemPresence'] : null;
        $this->container['organizationSecondaryPresenceId'] = isset($data['organizationSecondaryPresenceId']) ? $data['organizationSecondaryPresenceId'] : null;
        $this->container['routingStatus'] = isset($data['routingStatus']) ? $data['routingStatus'] : null;
        $this->container['actualActivityCategory'] = isset($data['actualActivityCategory']) ? $data['actualActivityCategory'] : null;
        $this->container['isOutOfOffice'] = isset($data['isOutOfOffice']) ? $data['isOutOfOffice'] : null;
        $this->container['adherenceState'] = isset($data['adherenceState']) ? $data['adherenceState'] : null;
        $this->container['impact'] = isset($data['impact']) ? $data['impact'] : null;
        $this->container['timeOfAdherenceChange'] = isset($data['timeOfAdherenceChange']) ? $data['timeOfAdherenceChange'] : null;
        $this->container['presenceUpdateTime'] = isset($data['presenceUpdateTime']) ? $data['presenceUpdateTime'] : null;
        $this->container['activeQueues'] = isset($data['activeQueues']) ? $data['activeQueues'] : null;
        $this->container['activeQueuesModifiedTime'] = isset($data['activeQueuesModifiedTime']) ? $data['activeQueuesModifiedTime'] : null;
        $this->container['removedFromManagementUnit'] = isset($data['removedFromManagementUnit']) ? $data['removedFromManagementUnit'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("OnQueueWork", "Break", "Meal", "Meeting", "OffQueueWork", "TimeOff", "Training", "Unavailable", "Unscheduled");
        if (!in_array($this->container['scheduledActivityCategory'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'scheduledActivityCategory', must be one of #{allowed_values}.";
        }

        $allowed_values = array("Available", "Away", "Busy", "Offline", "Idle", "OnQueue", "Meal", "Training", "Meeting", "Break");
        if (!in_array($this->container['systemPresence'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'systemPresence', must be one of #{allowed_values}.";
        }

        $allowed_values = array("OFF_QUEUE", "IDLE", "INTERACTING", "NOT_RESPONDING", "COMMUNICATING");
        if (!in_array($this->container['routingStatus'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'routingStatus', must be one of #{allowed_values}.";
        }

        $allowed_values = array("OnQueueWork", "Break", "Meal", "Meeting", "OffQueueWork", "TimeOff", "Training", "Unavailable", "Unscheduled");
        if (!in_array($this->container['actualActivityCategory'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'actualActivityCategory', must be one of #{allowed_values}.";
        }

        $allowed_values = array("InAdherence", "OutOfAdherence", "Unscheduled", "Unknown", "Ignored");
        if (!in_array($this->container['adherenceState'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'adherenceState', must be one of #{allowed_values}.";
        }

        $allowed_values = array("Positive", "Negative", "Neutral", "Unknown");
        if (!in_array($this->container['impact'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'impact', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("OnQueueWork", "Break", "Meal", "Meeting", "OffQueueWork", "TimeOff", "Training", "Unavailable", "Unscheduled");
        if (!in_array($this->container['scheduledActivityCategory'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("Available", "Away", "Busy", "Offline", "Idle", "OnQueue", "Meal", "Training", "Meeting", "Break");
        if (!in_array($this->container['systemPresence'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("OFF_QUEUE", "IDLE", "INTERACTING", "NOT_RESPONDING", "COMMUNICATING");
        if (!in_array($this->container['routingStatus'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("OnQueueWork", "Break", "Meal", "Meeting", "OffQueueWork", "TimeOff", "Training", "Unavailable", "Unscheduled");
        if (!in_array($this->container['actualActivityCategory'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("InAdherence", "OutOfAdherence", "Unscheduled", "Unknown", "Ignored");
        if (!in_array($this->container['adherenceState'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("Positive", "Negative", "Neutral", "Unknown");
        if (!in_array($this->container['impact'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets user
     * @return \PureCloudSDK\UserReference
     */
    public function getUser()
    {
        return $this->container['user'];
    }

    /**
     * Sets user
     * @param \PureCloudSDK\UserReference $user The user for whom this status applies
     * @return $this
     */
    public function setUser($user)
    {
        $this->container['user'] = $user;

        return $this;
    }

    /**
     * Gets managementUnit
     * @return \PureCloudSDK\ManagementUnit
     */
    public function getManagementUnit()
    {
        return $this->container['managementUnit'];
    }

    /**
     * Sets managementUnit
     * @param \PureCloudSDK\ManagementUnit $managementUnit The management unit to which this user belongs
     * @return $this
     */
    public function setManagementUnit($managementUnit)
    {
        $this->container['managementUnit'] = $managementUnit;

        return $this;
    }

    /**
     * Gets team
     * @return \PureCloudSDK\Team
     */
    public function getTeam()
    {
        return $this->container['team'];
    }

    /**
     * Sets team
     * @param \PureCloudSDK\Team $team The team to which this user belongs
     * @return $this
     */
    public function setTeam($team)
    {
        $this->container['team'] = $team;

        return $this;
    }

    /**
     * Gets scheduledActivityCategory
     * @return string
     */
    public function getScheduledActivityCategory()
    {
        return $this->container['scheduledActivityCategory'];
    }

    /**
     * Sets scheduledActivityCategory
     * @param string $scheduledActivityCategory Activity for which the user is scheduled
     * @return $this
     */
    public function setScheduledActivityCategory($scheduledActivityCategory)
    {
        $allowed_values = array('OnQueueWork', 'Break', 'Meal', 'Meeting', 'OffQueueWork', 'TimeOff', 'Training', 'Unavailable', 'Unscheduled');
        if (!in_array($scheduledActivityCategory, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'scheduledActivityCategory', must be one of 'OnQueueWork', 'Break', 'Meal', 'Meeting', 'OffQueueWork', 'TimeOff', 'Training', 'Unavailable', 'Unscheduled'");
        }
        $this->container['scheduledActivityCategory'] = $scheduledActivityCategory;

        return $this;
    }

    /**
     * Gets systemPresence
     * @return string
     */
    public function getSystemPresence()
    {
        return $this->container['systemPresence'];
    }

    /**
     * Sets systemPresence
     * @param string $systemPresence Actual underlying system presence value
     * @return $this
     */
    public function setSystemPresence($systemPresence)
    {
        $allowed_values = array('Available', 'Away', 'Busy', 'Offline', 'Idle', 'OnQueue', 'Meal', 'Training', 'Meeting', 'Break');
        if (!in_array($systemPresence, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'systemPresence', must be one of 'Available', 'Away', 'Busy', 'Offline', 'Idle', 'OnQueue', 'Meal', 'Training', 'Meeting', 'Break'");
        }
        $this->container['systemPresence'] = $systemPresence;

        return $this;
    }

    /**
     * Gets organizationSecondaryPresenceId
     * @return string
     */
    public function getOrganizationSecondaryPresenceId()
    {
        return $this->container['organizationSecondaryPresenceId'];
    }

    /**
     * Sets organizationSecondaryPresenceId
     * @param string $organizationSecondaryPresenceId Organization Secondary Presence Id.
     * @return $this
     */
    public function setOrganizationSecondaryPresenceId($organizationSecondaryPresenceId)
    {
        $this->container['organizationSecondaryPresenceId'] = $organizationSecondaryPresenceId;

        return $this;
    }

    /**
     * Gets routingStatus
     * @return string
     */
    public function getRoutingStatus()
    {
        return $this->container['routingStatus'];
    }

    /**
     * Sets routingStatus
     * @param string $routingStatus Actual underlying routing status, used to determine whether a user is actually in adherence when OnQueue
     * @return $this
     */
    public function setRoutingStatus($routingStatus)
    {
        $allowed_values = array('OFF_QUEUE', 'IDLE', 'INTERACTING', 'NOT_RESPONDING', 'COMMUNICATING');
        if (!in_array($routingStatus, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'routingStatus', must be one of 'OFF_QUEUE', 'IDLE', 'INTERACTING', 'NOT_RESPONDING', 'COMMUNICATING'");
        }
        $this->container['routingStatus'] = $routingStatus;

        return $this;
    }

    /**
     * Gets actualActivityCategory
     * @return string
     */
    public function getActualActivityCategory()
    {
        return $this->container['actualActivityCategory'];
    }

    /**
     * Sets actualActivityCategory
     * @param string $actualActivityCategory Activity in which the user is actually engaged
     * @return $this
     */
    public function setActualActivityCategory($actualActivityCategory)
    {
        $allowed_values = array('OnQueueWork', 'Break', 'Meal', 'Meeting', 'OffQueueWork', 'TimeOff', 'Training', 'Unavailable', 'Unscheduled');
        if (!in_array($actualActivityCategory, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'actualActivityCategory', must be one of 'OnQueueWork', 'Break', 'Meal', 'Meeting', 'OffQueueWork', 'TimeOff', 'Training', 'Unavailable', 'Unscheduled'");
        }
        $this->container['actualActivityCategory'] = $actualActivityCategory;

        return $this;
    }

    /**
     * Gets isOutOfOffice
     * @return bool
     */
    public function getIsOutOfOffice()
    {
        return $this->container['isOutOfOffice'];
    }

    /**
     * Sets isOutOfOffice
     * @param bool $isOutOfOffice Whether the user is marked OutOfOffice
     * @return $this
     */
    public function setIsOutOfOffice($isOutOfOffice)
    {
        $this->container['isOutOfOffice'] = $isOutOfOffice;

        return $this;
    }

    /**
     * Gets adherenceState
     * @return string
     */
    public function getAdherenceState()
    {
        return $this->container['adherenceState'];
    }

    /**
     * Sets adherenceState
     * @param string $adherenceState The user's current adherence state
     * @return $this
     */
    public function setAdherenceState($adherenceState)
    {
        $allowed_values = array('InAdherence', 'OutOfAdherence', 'Unscheduled', 'Unknown', 'Ignored');
        if (!in_array($adherenceState, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'adherenceState', must be one of 'InAdherence', 'OutOfAdherence', 'Unscheduled', 'Unknown', 'Ignored'");
        }
        $this->container['adherenceState'] = $adherenceState;

        return $this;
    }

    /**
     * Gets impact
     * @return string
     */
    public function getImpact()
    {
        return $this->container['impact'];
    }

    /**
     * Sets impact
     * @param string $impact The impact of the user's current adherenceState
     * @return $this
     */
    public function setImpact($impact)
    {
        $allowed_values = array('Positive', 'Negative', 'Neutral', 'Unknown');
        if (!in_array($impact, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'impact', must be one of 'Positive', 'Negative', 'Neutral', 'Unknown'");
        }
        $this->container['impact'] = $impact;

        return $this;
    }

    /**
     * Gets timeOfAdherenceChange
     * @return \DateTime
     */
    public function getTimeOfAdherenceChange()
    {
        return $this->container['timeOfAdherenceChange'];
    }

    /**
     * Sets timeOfAdherenceChange
     * @param \DateTime $timeOfAdherenceChange Time when the user entered the current adherenceState in ISO-8601 format
     * @return $this
     */
    public function setTimeOfAdherenceChange($timeOfAdherenceChange)
    {
        $this->container['timeOfAdherenceChange'] = $timeOfAdherenceChange;

        return $this;
    }

    /**
     * Gets presenceUpdateTime
     * @return \DateTime
     */
    public function getPresenceUpdateTime()
    {
        return $this->container['presenceUpdateTime'];
    }

    /**
     * Sets presenceUpdateTime
     * @param \DateTime $presenceUpdateTime Time when presence was last updated.  Used to calculate time in current status. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setPresenceUpdateTime($presenceUpdateTime)
    {
        $this->container['presenceUpdateTime'] = $presenceUpdateTime;

        return $this;
    }

    /**
     * Gets activeQueues
     * @return \PureCloudSDK\QueueReference[]
     */
    public function getActiveQueues()
    {
        return $this->container['activeQueues'];
    }

    /**
     * Sets activeQueues
     * @param \PureCloudSDK\QueueReference[] $activeQueues The list of queues to which this user is joined
     * @return $this
     */
    public function setActiveQueues($activeQueues)
    {
        $this->container['activeQueues'] = $activeQueues;

        return $this;
    }

    /**
     * Gets activeQueuesModifiedTime
     * @return \DateTime
     */
    public function getActiveQueuesModifiedTime()
    {
        return $this->container['activeQueuesModifiedTime'];
    }

    /**
     * Sets activeQueuesModifiedTime
     * @param \DateTime $activeQueuesModifiedTime Time when the list of active queues for this user was last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setActiveQueuesModifiedTime($activeQueuesModifiedTime)
    {
        $this->container['activeQueuesModifiedTime'] = $activeQueuesModifiedTime;

        return $this;
    }

    /**
     * Gets removedFromManagementUnit
     * @return bool
     */
    public function getRemovedFromManagementUnit()
    {
        return $this->container['removedFromManagementUnit'];
    }

    /**
     * Sets removedFromManagementUnit
     * @param bool $removedFromManagementUnit For notification purposes. Used to indicate that a user was removed from the management unit
     * @return $this
     */
    public function setRemovedFromManagementUnit($removedFromManagementUnit)
    {
        $this->container['removedFromManagementUnit'] = $removedFromManagementUnit;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
