<?php

/**
 * BuAgentScheduleActivity
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * BuAgentScheduleActivity Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class BuAgentScheduleActivity implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'BuAgentScheduleActivity';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'startDate' => '\DateTime',
        'lengthMinutes' => 'int',
        'description' => 'string',
        'activityCodeId' => 'string',
        'paid' => 'bool',
        'timeOffRequestId' => 'string',
        'externalActivityId' => 'string',
        'externalActivityType' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'startDate' => 'startDate',
        'lengthMinutes' => 'lengthMinutes',
        'description' => 'description',
        'activityCodeId' => 'activityCodeId',
        'paid' => 'paid',
        'timeOffRequestId' => 'timeOffRequestId',
        'externalActivityId' => 'externalActivityId',
        'externalActivityType' => 'externalActivityType'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'startDate' => 'setStartDate',
        'lengthMinutes' => 'setLengthMinutes',
        'description' => 'setDescription',
        'activityCodeId' => 'setActivityCodeId',
        'paid' => 'setPaid',
        'timeOffRequestId' => 'setTimeOffRequestId',
        'externalActivityId' => 'setExternalActivityId',
        'externalActivityType' => 'setExternalActivityType'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'startDate' => 'getStartDate',
        'lengthMinutes' => 'getLengthMinutes',
        'description' => 'getDescription',
        'activityCodeId' => 'getActivityCodeId',
        'paid' => 'getPaid',
        'timeOffRequestId' => 'getTimeOffRequestId',
        'externalActivityId' => 'getExternalActivityId',
        'externalActivityType' => 'getExternalActivityType'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const EXTERNAL_ACTIVITY_TYPE_COACHING = 'Coaching';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getExternalActivityTypeAllowableValues()
    {
        return [
            self::EXTERNAL_ACTIVITY_TYPE_COACHING,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['startDate'] = isset($data['startDate']) ? $data['startDate'] : null;
        $this->container['lengthMinutes'] = isset($data['lengthMinutes']) ? $data['lengthMinutes'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['activityCodeId'] = isset($data['activityCodeId']) ? $data['activityCodeId'] : null;
        $this->container['paid'] = isset($data['paid']) ? $data['paid'] : null;
        $this->container['timeOffRequestId'] = isset($data['timeOffRequestId']) ? $data['timeOffRequestId'] : null;
        $this->container['externalActivityId'] = isset($data['externalActivityId']) ? $data['externalActivityId'] : null;
        $this->container['externalActivityType'] = isset($data['externalActivityType']) ? $data['externalActivityType'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("Coaching");
        if (!in_array($this->container['externalActivityType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'externalActivityType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("Coaching");
        if (!in_array($this->container['externalActivityType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets startDate
     * @return \DateTime
     */
    public function getStartDate()
    {
        return $this->container['startDate'];
    }

    /**
     * Sets startDate
     * @param \DateTime $startDate The start date/time of this activity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setStartDate($startDate)
    {
        $this->container['startDate'] = $startDate;

        return $this;
    }

    /**
     * Gets lengthMinutes
     * @return int
     */
    public function getLengthMinutes()
    {
        return $this->container['lengthMinutes'];
    }

    /**
     * Sets lengthMinutes
     * @param int $lengthMinutes The length of this activity in minutes
     * @return $this
     */
    public function setLengthMinutes($lengthMinutes)
    {
        $this->container['lengthMinutes'] = $lengthMinutes;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description The description of this activity
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets activityCodeId
     * @return string
     */
    public function getActivityCodeId()
    {
        return $this->container['activityCodeId'];
    }

    /**
     * Sets activityCodeId
     * @param string $activityCodeId The ID of the activity code associated with this activity
     * @return $this
     */
    public function setActivityCodeId($activityCodeId)
    {
        $this->container['activityCodeId'] = $activityCodeId;

        return $this;
    }

    /**
     * Gets paid
     * @return bool
     */
    public function getPaid()
    {
        return $this->container['paid'];
    }

    /**
     * Sets paid
     * @param bool $paid Whether this activity is paid
     * @return $this
     */
    public function setPaid($paid)
    {
        $this->container['paid'] = $paid;

        return $this;
    }

    /**
     * Gets timeOffRequestId
     * @return string
     */
    public function getTimeOffRequestId()
    {
        return $this->container['timeOffRequestId'];
    }

    /**
     * Sets timeOffRequestId
     * @param string $timeOffRequestId The ID of the time off request associated with this activity, if applicable
     * @return $this
     */
    public function setTimeOffRequestId($timeOffRequestId)
    {
        $this->container['timeOffRequestId'] = $timeOffRequestId;

        return $this;
    }

    /**
     * Gets externalActivityId
     * @return string
     */
    public function getExternalActivityId()
    {
        return $this->container['externalActivityId'];
    }

    /**
     * Sets externalActivityId
     * @param string $externalActivityId The ID of the external activity associated with this activity, if applicable
     * @return $this
     */
    public function setExternalActivityId($externalActivityId)
    {
        $this->container['externalActivityId'] = $externalActivityId;

        return $this;
    }

    /**
     * Gets externalActivityType
     * @return string
     */
    public function getExternalActivityType()
    {
        return $this->container['externalActivityType'];
    }

    /**
     * Sets externalActivityType
     * @param string $externalActivityType The type of the external activity associated with this activity, if applicable
     * @return $this
     */
    public function setExternalActivityType($externalActivityType)
    {
        $allowed_values = array('Coaching');
        if (!in_array($externalActivityType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'externalActivityType', must be one of 'Coaching'");
        }
        $this->container['externalActivityType'] = $externalActivityType;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
