<?php

/**
 * BuShortTermForecast
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * BuShortTermForecast Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class BuShortTermForecast implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'BuShortTermForecast';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'weekDate' => '\DateTime',
        'weekCount' => 'int',
        'creationMethod' => 'string',
        'description' => 'string',
        'legacy' => 'bool',
        'metadata' => '\PureCloudSDK\WfmVersionedEntityMetadata',
        'referenceStartDate' => '\DateTime',
        'sourceDays' => '\PureCloudSDK\ForecastSourceDayPointer[]',
        'modifications' => '\PureCloudSDK\BuForecastModification[]',
        'generationResults' => '\PureCloudSDK\BuForecastGenerationResult',
        'timeZone' => 'string',
        'planningGroupsVersion' => 'int',
        'planningGroups' => '\PureCloudSDK\ForecastPlanningGroupsResponse',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'weekDate' => 'weekDate',
        'weekCount' => 'weekCount',
        'creationMethod' => 'creationMethod',
        'description' => 'description',
        'legacy' => 'legacy',
        'metadata' => 'metadata',
        'referenceStartDate' => 'referenceStartDate',
        'sourceDays' => 'sourceDays',
        'modifications' => 'modifications',
        'generationResults' => 'generationResults',
        'timeZone' => 'timeZone',
        'planningGroupsVersion' => 'planningGroupsVersion',
        'planningGroups' => 'planningGroups',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'weekDate' => 'setWeekDate',
        'weekCount' => 'setWeekCount',
        'creationMethod' => 'setCreationMethod',
        'description' => 'setDescription',
        'legacy' => 'setLegacy',
        'metadata' => 'setMetadata',
        'referenceStartDate' => 'setReferenceStartDate',
        'sourceDays' => 'setSourceDays',
        'modifications' => 'setModifications',
        'generationResults' => 'setGenerationResults',
        'timeZone' => 'setTimeZone',
        'planningGroupsVersion' => 'setPlanningGroupsVersion',
        'planningGroups' => 'setPlanningGroups',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'weekDate' => 'getWeekDate',
        'weekCount' => 'getWeekCount',
        'creationMethod' => 'getCreationMethod',
        'description' => 'getDescription',
        'legacy' => 'getLegacy',
        'metadata' => 'getMetadata',
        'referenceStartDate' => 'getReferenceStartDate',
        'sourceDays' => 'getSourceDays',
        'modifications' => 'getModifications',
        'generationResults' => 'getGenerationResults',
        'timeZone' => 'getTimeZone',
        'planningGroupsVersion' => 'getPlanningGroupsVersion',
        'planningGroups' => 'getPlanningGroups',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const CREATION_METHOD_IMPORT = 'Import';
    public const CREATION_METHOD_IMPORTED_HISTORICAL_WEIGHTED_AVERAGE = 'ImportedHistoricalWeightedAverage';
    public const CREATION_METHOD_HISTORICAL_WEIGHTED_AVERAGE = 'HistoricalWeightedAverage';
    public const CREATION_METHOD_ADVANCED = 'Advanced';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getCreationMethodAllowableValues()
    {
        return [
            self::CREATION_METHOD_IMPORT,
            self::CREATION_METHOD_IMPORTED_HISTORICAL_WEIGHTED_AVERAGE,
            self::CREATION_METHOD_HISTORICAL_WEIGHTED_AVERAGE,
            self::CREATION_METHOD_ADVANCED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['weekDate'] = isset($data['weekDate']) ? $data['weekDate'] : null;
        $this->container['weekCount'] = isset($data['weekCount']) ? $data['weekCount'] : null;
        $this->container['creationMethod'] = isset($data['creationMethod']) ? $data['creationMethod'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['legacy'] = isset($data['legacy']) ? $data['legacy'] : null;
        $this->container['metadata'] = isset($data['metadata']) ? $data['metadata'] : null;
        $this->container['referenceStartDate'] = isset($data['referenceStartDate']) ? $data['referenceStartDate'] : null;
        $this->container['sourceDays'] = isset($data['sourceDays']) ? $data['sourceDays'] : null;
        $this->container['modifications'] = isset($data['modifications']) ? $data['modifications'] : null;
        $this->container['generationResults'] = isset($data['generationResults']) ? $data['generationResults'] : null;
        $this->container['timeZone'] = isset($data['timeZone']) ? $data['timeZone'] : null;
        $this->container['planningGroupsVersion'] = isset($data['planningGroupsVersion']) ? $data['planningGroupsVersion'] : null;
        $this->container['planningGroups'] = isset($data['planningGroups']) ? $data['planningGroups'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("Import", "ImportedHistoricalWeightedAverage", "HistoricalWeightedAverage", "Advanced");
        if (!in_array($this->container['creationMethod'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'creationMethod', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("Import", "ImportedHistoricalWeightedAverage", "HistoricalWeightedAverage", "Advanced");
        if (!in_array($this->container['creationMethod'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets weekDate
     * @return \DateTime
     */
    public function getWeekDate()
    {
        return $this->container['weekDate'];
    }

    /**
     * Sets weekDate
     * @param \DateTime $weekDate The start week date of this forecast in yyyy-MM-dd.  Must fall on the start day of week for the associated business unit. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd
     * @return $this
     */
    public function setWeekDate($weekDate)
    {
        $this->container['weekDate'] = $weekDate;

        return $this;
    }

    /**
     * Gets weekCount
     * @return int
     */
    public function getWeekCount()
    {
        return $this->container['weekCount'];
    }

    /**
     * Sets weekCount
     * @param int $weekCount The number of weeks this forecast covers
     * @return $this
     */
    public function setWeekCount($weekCount)
    {
        $this->container['weekCount'] = $weekCount;

        return $this;
    }

    /**
     * Gets creationMethod
     * @return string
     */
    public function getCreationMethod()
    {
        return $this->container['creationMethod'];
    }

    /**
     * Sets creationMethod
     * @param string $creationMethod The method by which this forecast was created
     * @return $this
     */
    public function setCreationMethod($creationMethod)
    {
        $allowed_values = array('Import', 'ImportedHistoricalWeightedAverage', 'HistoricalWeightedAverage', 'Advanced');
        if (!in_array($creationMethod, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'creationMethod', must be one of 'Import', 'ImportedHistoricalWeightedAverage', 'HistoricalWeightedAverage', 'Advanced'");
        }
        $this->container['creationMethod'] = $creationMethod;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description The description of this forecast
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets legacy
     * @return bool
     */
    public function getLegacy()
    {
        return $this->container['legacy'];
    }

    /**
     * Sets legacy
     * @param bool $legacy Whether this forecast contains modifications on legacy metrics
     * @return $this
     */
    public function setLegacy($legacy)
    {
        $this->container['legacy'] = $legacy;

        return $this;
    }

    /**
     * Gets metadata
     * @return \PureCloudSDK\WfmVersionedEntityMetadata
     */
    public function getMetadata()
    {
        return $this->container['metadata'];
    }

    /**
     * Sets metadata
     * @param \PureCloudSDK\WfmVersionedEntityMetadata $metadata Metadata for this forecast
     * @return $this
     */
    public function setMetadata($metadata)
    {
        $this->container['metadata'] = $metadata;

        return $this;
    }

    /**
     * Gets referenceStartDate
     * @return \DateTime
     */
    public function getReferenceStartDate()
    {
        return $this->container['referenceStartDate'];
    }

    /**
     * Sets referenceStartDate
     * @param \DateTime $referenceStartDate The reference start date for interval-based data for this forecast. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setReferenceStartDate($referenceStartDate)
    {
        $this->container['referenceStartDate'] = $referenceStartDate;

        return $this;
    }

    /**
     * Gets sourceDays
     * @return \PureCloudSDK\ForecastSourceDayPointer[]
     */
    public function getSourceDays()
    {
        return $this->container['sourceDays'];
    }

    /**
     * Sets sourceDays
     * @param \PureCloudSDK\ForecastSourceDayPointer[] $sourceDays The source day pointers for this forecast
     * @return $this
     */
    public function setSourceDays($sourceDays)
    {
        $this->container['sourceDays'] = $sourceDays;

        return $this;
    }

    /**
     * Gets modifications
     * @return \PureCloudSDK\BuForecastModification[]
     */
    public function getModifications()
    {
        return $this->container['modifications'];
    }

    /**
     * Sets modifications
     * @param \PureCloudSDK\BuForecastModification[] $modifications Any manual modifications applied to this forecast
     * @return $this
     */
    public function setModifications($modifications)
    {
        $this->container['modifications'] = $modifications;

        return $this;
    }

    /**
     * Gets generationResults
     * @return \PureCloudSDK\BuForecastGenerationResult
     */
    public function getGenerationResults()
    {
        return $this->container['generationResults'];
    }

    /**
     * Sets generationResults
     * @param \PureCloudSDK\BuForecastGenerationResult $generationResults Generation result metadata
     * @return $this
     */
    public function setGenerationResults($generationResults)
    {
        $this->container['generationResults'] = $generationResults;

        return $this;
    }

    /**
     * Gets timeZone
     * @return string
     */
    public function getTimeZone()
    {
        return $this->container['timeZone'];
    }

    /**
     * Sets timeZone
     * @param string $timeZone The time zone for this forecast
     * @return $this
     */
    public function setTimeZone($timeZone)
    {
        $this->container['timeZone'] = $timeZone;

        return $this;
    }

    /**
     * Gets planningGroupsVersion
     * @return int
     */
    public function getPlanningGroupsVersion()
    {
        return $this->container['planningGroupsVersion'];
    }

    /**
     * Sets planningGroupsVersion
     * @param int $planningGroupsVersion The version of the planning groups that was used for this forecast
     * @return $this
     */
    public function setPlanningGroupsVersion($planningGroupsVersion)
    {
        $this->container['planningGroupsVersion'] = $planningGroupsVersion;

        return $this;
    }

    /**
     * Gets planningGroups
     * @return \PureCloudSDK\ForecastPlanningGroupsResponse
     */
    public function getPlanningGroups()
    {
        return $this->container['planningGroups'];
    }

    /**
     * Sets planningGroups
     * @param \PureCloudSDK\ForecastPlanningGroupsResponse $planningGroups A snapshot of the planning groups used for this forecast as of the version number indicated
     * @return $this
     */
    public function setPlanningGroups($planningGroups)
    {
        $this->container['planningGroups'] = $planningGroups;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
