<?php

/**
 * CallHistoryParticipant
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * CallHistoryParticipant Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CallHistoryParticipant implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CallHistoryParticipant';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'address' => 'string',
        'startTime' => '\DateTime',
        'endTime' => '\DateTime',
        'purpose' => 'string',
        'direction' => 'string',
        'ani' => 'string',
        'dnis' => 'string',
        'user' => '\PureCloudSDK\User',
        'queue' => '\PureCloudSDK\Queue',
        'group' => '\PureCloudSDK\Group',
        'disconnectType' => 'string',
        'externalContact' => '\PureCloudSDK\ExternalContact',
        'externalOrganization' => '\PureCloudSDK\ExternalOrganization',
        'didInteract' => 'bool',
        'sipResponseCodes' => 'int[]',
        'flaggedReason' => 'string',
        'outboundCampaign' => '\PureCloudSDK\Campaign'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'address' => 'address',
        'startTime' => 'startTime',
        'endTime' => 'endTime',
        'purpose' => 'purpose',
        'direction' => 'direction',
        'ani' => 'ani',
        'dnis' => 'dnis',
        'user' => 'user',
        'queue' => 'queue',
        'group' => 'group',
        'disconnectType' => 'disconnectType',
        'externalContact' => 'externalContact',
        'externalOrganization' => 'externalOrganization',
        'didInteract' => 'didInteract',
        'sipResponseCodes' => 'sipResponseCodes',
        'flaggedReason' => 'flaggedReason',
        'outboundCampaign' => 'outboundCampaign'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'address' => 'setAddress',
        'startTime' => 'setStartTime',
        'endTime' => 'setEndTime',
        'purpose' => 'setPurpose',
        'direction' => 'setDirection',
        'ani' => 'setAni',
        'dnis' => 'setDnis',
        'user' => 'setUser',
        'queue' => 'setQueue',
        'group' => 'setGroup',
        'disconnectType' => 'setDisconnectType',
        'externalContact' => 'setExternalContact',
        'externalOrganization' => 'setExternalOrganization',
        'didInteract' => 'setDidInteract',
        'sipResponseCodes' => 'setSipResponseCodes',
        'flaggedReason' => 'setFlaggedReason',
        'outboundCampaign' => 'setOutboundCampaign'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'address' => 'getAddress',
        'startTime' => 'getStartTime',
        'endTime' => 'getEndTime',
        'purpose' => 'getPurpose',
        'direction' => 'getDirection',
        'ani' => 'getAni',
        'dnis' => 'getDnis',
        'user' => 'getUser',
        'queue' => 'getQueue',
        'group' => 'getGroup',
        'disconnectType' => 'getDisconnectType',
        'externalContact' => 'getExternalContact',
        'externalOrganization' => 'getExternalOrganization',
        'didInteract' => 'getDidInteract',
        'sipResponseCodes' => 'getSipResponseCodes',
        'flaggedReason' => 'getFlaggedReason',
        'outboundCampaign' => 'getOutboundCampaign'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const DIRECTION_INBOUND = 'inbound';
    public const DIRECTION_OUTBOUND = 'outbound';
    public const DISCONNECT_TYPE_ENDPOINT = 'endpoint';
    public const DISCONNECT_TYPE_CLIENT = 'client';
    public const DISCONNECT_TYPE_SYSTEM = 'system';
    public const DISCONNECT_TYPE_TRANSFER = 'transfer';
    public const DISCONNECT_TYPE_TRANSFERCONFERENCE = 'transfer.conference';
    public const DISCONNECT_TYPE_TRANSFERCONSULT = 'transfer.consult';
    public const DISCONNECT_TYPE_TRANSFERFORWARD = 'transfer.forward';
    public const DISCONNECT_TYPE_TRANSFERNOANSWER = 'transfer.noanswer';
    public const DISCONNECT_TYPE_TRANSFERNOTAVAILABLE = 'transfer.notavailable';
    public const DISCONNECT_TYPE_TRANSPORTFAILURE = 'transport.failure';
    public const DISCONNECT_TYPE_ERROR = 'error';
    public const DISCONNECT_TYPE_PEER = 'peer';
    public const DISCONNECT_TYPE_OTHER = 'other';
    public const DISCONNECT_TYPE_SPAM = 'spam';
    public const FLAGGED_REASON_GENERAL = 'general';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDirectionAllowableValues()
    {
        return [
            self::DIRECTION_INBOUND,
            self::DIRECTION_OUTBOUND,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDisconnectTypeAllowableValues()
    {
        return [
            self::DISCONNECT_TYPE_ENDPOINT,
            self::DISCONNECT_TYPE_CLIENT,
            self::DISCONNECT_TYPE_SYSTEM,
            self::DISCONNECT_TYPE_TRANSFER,
            self::DISCONNECT_TYPE_TRANSFERCONFERENCE,
            self::DISCONNECT_TYPE_TRANSFERCONSULT,
            self::DISCONNECT_TYPE_TRANSFERFORWARD,
            self::DISCONNECT_TYPE_TRANSFERNOANSWER,
            self::DISCONNECT_TYPE_TRANSFERNOTAVAILABLE,
            self::DISCONNECT_TYPE_TRANSPORTFAILURE,
            self::DISCONNECT_TYPE_ERROR,
            self::DISCONNECT_TYPE_PEER,
            self::DISCONNECT_TYPE_OTHER,
            self::DISCONNECT_TYPE_SPAM,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getFlaggedReasonAllowableValues()
    {
        return [
            self::FLAGGED_REASON_GENERAL,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['address'] = isset($data['address']) ? $data['address'] : null;
        $this->container['startTime'] = isset($data['startTime']) ? $data['startTime'] : null;
        $this->container['endTime'] = isset($data['endTime']) ? $data['endTime'] : null;
        $this->container['purpose'] = isset($data['purpose']) ? $data['purpose'] : null;
        $this->container['direction'] = isset($data['direction']) ? $data['direction'] : null;
        $this->container['ani'] = isset($data['ani']) ? $data['ani'] : null;
        $this->container['dnis'] = isset($data['dnis']) ? $data['dnis'] : null;
        $this->container['user'] = isset($data['user']) ? $data['user'] : null;
        $this->container['queue'] = isset($data['queue']) ? $data['queue'] : null;
        $this->container['group'] = isset($data['group']) ? $data['group'] : null;
        $this->container['disconnectType'] = isset($data['disconnectType']) ? $data['disconnectType'] : null;
        $this->container['externalContact'] = isset($data['externalContact']) ? $data['externalContact'] : null;
        $this->container['externalOrganization'] = isset($data['externalOrganization']) ? $data['externalOrganization'] : null;
        $this->container['didInteract'] = isset($data['didInteract']) ? $data['didInteract'] : null;
        $this->container['sipResponseCodes'] = isset($data['sipResponseCodes']) ? $data['sipResponseCodes'] : null;
        $this->container['flaggedReason'] = isset($data['flaggedReason']) ? $data['flaggedReason'] : null;
        $this->container['outboundCampaign'] = isset($data['outboundCampaign']) ? $data['outboundCampaign'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("inbound", "outbound");
        if (!in_array($this->container['direction'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'direction', must be one of #{allowed_values}.";
        }

        $allowed_values = array("endpoint", "client", "system", "transfer", "transfer.conference", "transfer.consult", "transfer.forward", "transfer.noanswer", "transfer.notavailable", "transport.failure", "error", "peer", "other", "spam");
        if (!in_array($this->container['disconnectType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'disconnectType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("general");
        if (!in_array($this->container['flaggedReason'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'flaggedReason', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("inbound", "outbound");
        if (!in_array($this->container['direction'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("endpoint", "client", "system", "transfer", "transfer.conference", "transfer.consult", "transfer.forward", "transfer.noanswer", "transfer.notavailable", "transport.failure", "error", "peer", "other", "spam");
        if (!in_array($this->container['disconnectType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("general");
        if (!in_array($this->container['flaggedReason'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The unique participant ID.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The display friendly name of the participant.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets address
     * @return string
     */
    public function getAddress()
    {
        return $this->container['address'];
    }

    /**
     * Sets address
     * @param string $address The participant address.
     * @return $this
     */
    public function setAddress($address)
    {
        $this->container['address'] = $address;

        return $this;
    }

    /**
     * Gets startTime
     * @return \DateTime
     */
    public function getStartTime()
    {
        return $this->container['startTime'];
    }

    /**
     * Sets startTime
     * @param \DateTime $startTime The time when this participant first joined the conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setStartTime($startTime)
    {
        $this->container['startTime'] = $startTime;

        return $this;
    }

    /**
     * Gets endTime
     * @return \DateTime
     */
    public function getEndTime()
    {
        return $this->container['endTime'];
    }

    /**
     * Sets endTime
     * @param \DateTime $endTime The time when this participant went disconnected for this media (eg: video disconnected time). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setEndTime($endTime)
    {
        $this->container['endTime'] = $endTime;

        return $this;
    }

    /**
     * Gets purpose
     * @return string
     */
    public function getPurpose()
    {
        return $this->container['purpose'];
    }

    /**
     * Sets purpose
     * @param string $purpose The participant's purpose.  Values can be: 'agent', 'user', 'customer', 'external', 'acd', 'ivr
     * @return $this
     */
    public function setPurpose($purpose)
    {
        $this->container['purpose'] = $purpose;

        return $this;
    }

    /**
     * Gets direction
     * @return string
     */
    public function getDirection()
    {
        return $this->container['direction'];
    }

    /**
     * Sets direction
     * @param string $direction The participant's direction.  Values can be: 'inbound' or 'outbound'
     * @return $this
     */
    public function setDirection($direction)
    {
        $allowed_values = array('inbound', 'outbound');
        if (!in_array($direction, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'direction', must be one of 'inbound', 'outbound'");
        }
        $this->container['direction'] = $direction;

        return $this;
    }

    /**
     * Gets ani
     * @return string
     */
    public function getAni()
    {
        return $this->container['ani'];
    }

    /**
     * Sets ani
     * @param string $ani The call ANI.
     * @return $this
     */
    public function setAni($ani)
    {
        $this->container['ani'] = $ani;

        return $this;
    }

    /**
     * Gets dnis
     * @return string
     */
    public function getDnis()
    {
        return $this->container['dnis'];
    }

    /**
     * Sets dnis
     * @param string $dnis The call DNIS.
     * @return $this
     */
    public function setDnis($dnis)
    {
        $this->container['dnis'] = $dnis;

        return $this;
    }

    /**
     * Gets user
     * @return \PureCloudSDK\User
     */
    public function getUser()
    {
        return $this->container['user'];
    }

    /**
     * Sets user
     * @param \PureCloudSDK\User $user The PureCloud user for this participant.
     * @return $this
     */
    public function setUser($user)
    {
        $this->container['user'] = $user;

        return $this;
    }

    /**
     * Gets queue
     * @return \PureCloudSDK\Queue
     */
    public function getQueue()
    {
        return $this->container['queue'];
    }

    /**
     * Sets queue
     * @param \PureCloudSDK\Queue $queue The PureCloud queue for this participant.
     * @return $this
     */
    public function setQueue($queue)
    {
        $this->container['queue'] = $queue;

        return $this;
    }

    /**
     * Gets group
     * @return \PureCloudSDK\Group
     */
    public function getGroup()
    {
        return $this->container['group'];
    }

    /**
     * Sets group
     * @param \PureCloudSDK\Group $group The group involved in the group ring call.
     * @return $this
     */
    public function setGroup($group)
    {
        $this->container['group'] = $group;

        return $this;
    }

    /**
     * Gets disconnectType
     * @return string
     */
    public function getDisconnectType()
    {
        return $this->container['disconnectType'];
    }

    /**
     * Sets disconnectType
     * @param string $disconnectType The reason the participant was disconnected from the conversation.
     * @return $this
     */
    public function setDisconnectType($disconnectType)
    {
        $allowed_values = array('endpoint', 'client', 'system', 'transfer', 'transfer.conference', 'transfer.consult', 'transfer.forward', 'transfer.noanswer', 'transfer.notavailable', 'transport.failure', 'error', 'peer', 'other', 'spam');
        if (!in_array($disconnectType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'disconnectType', must be one of 'endpoint', 'client', 'system', 'transfer', 'transfer.conference', 'transfer.consult', 'transfer.forward', 'transfer.noanswer', 'transfer.notavailable', 'transport.failure', 'error', 'peer', 'other', 'spam'");
        }
        $this->container['disconnectType'] = $disconnectType;

        return $this;
    }

    /**
     * Gets externalContact
     * @return \PureCloudSDK\ExternalContact
     */
    public function getExternalContact()
    {
        return $this->container['externalContact'];
    }

    /**
     * Sets externalContact
     * @param \PureCloudSDK\ExternalContact $externalContact The PureCloud external contact
     * @return $this
     */
    public function setExternalContact($externalContact)
    {
        $this->container['externalContact'] = $externalContact;

        return $this;
    }

    /**
     * Gets externalOrganization
     * @return \PureCloudSDK\ExternalOrganization
     */
    public function getExternalOrganization()
    {
        return $this->container['externalOrganization'];
    }

    /**
     * Sets externalOrganization
     * @param \PureCloudSDK\ExternalOrganization $externalOrganization The PureCloud external organization
     * @return $this
     */
    public function setExternalOrganization($externalOrganization)
    {
        $this->container['externalOrganization'] = $externalOrganization;

        return $this;
    }

    /**
     * Gets didInteract
     * @return bool
     */
    public function getDidInteract()
    {
        return $this->container['didInteract'];
    }

    /**
     * Sets didInteract
     * @param bool $didInteract Indicates whether the contact ever connected
     * @return $this
     */
    public function setDidInteract($didInteract)
    {
        $this->container['didInteract'] = $didInteract;

        return $this;
    }

    /**
     * Gets sipResponseCodes
     * @return int[]
     */
    public function getSipResponseCodes()
    {
        return $this->container['sipResponseCodes'];
    }

    /**
     * Sets sipResponseCodes
     * @param int[] $sipResponseCodes Indicates SIP Response codes associated with the participant
     * @return $this
     */
    public function setSipResponseCodes($sipResponseCodes)
    {
        $this->container['sipResponseCodes'] = $sipResponseCodes;

        return $this;
    }

    /**
     * Gets flaggedReason
     * @return string
     */
    public function getFlaggedReason()
    {
        return $this->container['flaggedReason'];
    }

    /**
     * Sets flaggedReason
     * @param string $flaggedReason The reason specifying why participant flagged the conversation.
     * @return $this
     */
    public function setFlaggedReason($flaggedReason)
    {
        $allowed_values = array('general');
        if (!in_array($flaggedReason, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'flaggedReason', must be one of 'general'");
        }
        $this->container['flaggedReason'] = $flaggedReason;

        return $this;
    }

    /**
     * Gets outboundCampaign
     * @return \PureCloudSDK\Campaign
     */
    public function getOutboundCampaign()
    {
        return $this->container['outboundCampaign'];
    }

    /**
     * Sets outboundCampaign
     * @param \PureCloudSDK\Campaign $outboundCampaign The outbound campaign associated with the participant
     * @return $this
     */
    public function setOutboundCampaign($outboundCampaign)
    {
        $this->container['outboundCampaign'] = $outboundCampaign;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
