<?php

/**
 * CampaignRuleParameters
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * CampaignRuleParameters Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CampaignRuleParameters implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CampaignRuleParameters';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'operator' => 'string',
        'value' => 'string',
        'priority' => 'string',
        'dialingMode' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'operator' => 'operator',
        'value' => 'value',
        'priority' => 'priority',
        'dialingMode' => 'dialingMode'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'operator' => 'setOperator',
        'value' => 'setValue',
        'priority' => 'setPriority',
        'dialingMode' => 'setDialingMode'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'operator' => 'getOperator',
        'value' => 'getValue',
        'priority' => 'getPriority',
        'dialingMode' => 'getDialingMode'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const OPERATOR_EQUALS = 'equals';
    public const OPERATOR_GREATER_THAN = 'greaterThan';
    public const OPERATOR_GREATER_THAN_EQUAL_TO = 'greaterThanEqualTo';
    public const OPERATOR_LESS_THAN = 'lessThan';
    public const OPERATOR_LESS_THAN_EQUAL_TO = 'lessThanEqualTo';
    public const PRIORITY__1 = '1';
    public const PRIORITY__2 = '2';
    public const PRIORITY__3 = '3';
    public const PRIORITY__4 = '4';
    public const PRIORITY__5 = '5';
    public const DIALING_MODE_AGENTLESS = 'agentless';
    public const DIALING_MODE_PREVIEW = 'preview';
    public const DIALING_MODE_POWER = 'power';
    public const DIALING_MODE_PREDICTIVE = 'predictive';
    public const DIALING_MODE_PROGRESSIVE = 'progressive';
    public const DIALING_MODE_EXTERNAL = 'external';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getOperatorAllowableValues()
    {
        return [
            self::OPERATOR_EQUALS,
            self::OPERATOR_GREATER_THAN,
            self::OPERATOR_GREATER_THAN_EQUAL_TO,
            self::OPERATOR_LESS_THAN,
            self::OPERATOR_LESS_THAN_EQUAL_TO,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getPriorityAllowableValues()
    {
        return [
            self::PRIORITY__1,
            self::PRIORITY__2,
            self::PRIORITY__3,
            self::PRIORITY__4,
            self::PRIORITY__5,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDialingModeAllowableValues()
    {
        return [
            self::DIALING_MODE_AGENTLESS,
            self::DIALING_MODE_PREVIEW,
            self::DIALING_MODE_POWER,
            self::DIALING_MODE_PREDICTIVE,
            self::DIALING_MODE_PROGRESSIVE,
            self::DIALING_MODE_EXTERNAL,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['operator'] = isset($data['operator']) ? $data['operator'] : null;
        $this->container['value'] = isset($data['value']) ? $data['value'] : null;
        $this->container['priority'] = isset($data['priority']) ? $data['priority'] : null;
        $this->container['dialingMode'] = isset($data['dialingMode']) ? $data['dialingMode'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("equals", "greaterThan", "greaterThanEqualTo", "lessThan", "lessThanEqualTo");
        if (!in_array($this->container['operator'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'operator', must be one of #{allowed_values}.";
        }

        $allowed_values = array("1", "2", "3", "4", "5");
        if (!in_array($this->container['priority'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'priority', must be one of #{allowed_values}.";
        }

        $allowed_values = array("agentless", "preview", "power", "predictive", "progressive", "external");
        if (!in_array($this->container['dialingMode'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'dialingMode', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("equals", "greaterThan", "greaterThanEqualTo", "lessThan", "lessThanEqualTo");
        if (!in_array($this->container['operator'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("1", "2", "3", "4", "5");
        if (!in_array($this->container['priority'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("agentless", "preview", "power", "predictive", "progressive", "external");
        if (!in_array($this->container['dialingMode'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets operator
     * @return string
     */
    public function getOperator()
    {
        return $this->container['operator'];
    }

    /**
     * Sets operator
     * @param string $operator The operator for comparison. Required for a CampaignRuleCondition.
     * @return $this
     */
    public function setOperator($operator)
    {
        $allowed_values = array('equals', 'greaterThan', 'greaterThanEqualTo', 'lessThan', 'lessThanEqualTo');
        if (!in_array($operator, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'operator', must be one of 'equals', 'greaterThan', 'greaterThanEqualTo', 'lessThan', 'lessThanEqualTo'");
        }
        $this->container['operator'] = $operator;

        return $this;
    }

    /**
     * Gets value
     * @return string
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     * @param string $value The value for comparison. Required for a CampaignRuleCondition.
     * @return $this
     */
    public function setValue($value)
    {
        $this->container['value'] = $value;

        return $this;
    }

    /**
     * Gets priority
     * @return string
     */
    public function getPriority()
    {
        return $this->container['priority'];
    }

    /**
     * Sets priority
     * @param string $priority The priority to set a campaign to. Required for the 'setCampaignPriority' action.
     * @return $this
     */
    public function setPriority($priority)
    {
        $allowed_values = array('1', '2', '3', '4', '5');
        if (!in_array($priority, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'priority', must be one of '1', '2', '3', '4', '5'");
        }
        $this->container['priority'] = $priority;

        return $this;
    }

    /**
     * Gets dialingMode
     * @return string
     */
    public function getDialingMode()
    {
        return $this->container['dialingMode'];
    }

    /**
     * Sets dialingMode
     * @param string $dialingMode The dialing mode to set a campaign to. Required for the 'setCampaignDialingMode' action.
     * @return $this
     */
    public function setDialingMode($dialingMode)
    {
        $allowed_values = array('agentless', 'preview', 'power', 'predictive', 'progressive', 'external');
        if (!in_array($dialingMode, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'dialingMode', must be one of 'agentless', 'preview', 'power', 'predictive', 'progressive', 'external'");
        }
        $this->container['dialingMode'] = $dialingMode;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
