<?php

/**
 * CreateEmailRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * CreateEmailRequest Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CreateEmailRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CreateEmailRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'queueId' => 'string',
        'flowId' => 'string',
        'provider' => 'string',
        'skillIds' => 'string[]',
        'languageId' => 'string',
        'priority' => 'int',
        'attributes' => 'map[string,string]',
        'toAddress' => 'string',
        'toName' => 'string',
        'fromAddress' => 'string',
        'fromName' => 'string',
        'subject' => 'string',
        'direction' => 'string',
        'htmlBody' => 'string',
        'textBody' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'queueId' => 'queueId',
        'flowId' => 'flowId',
        'provider' => 'provider',
        'skillIds' => 'skillIds',
        'languageId' => 'languageId',
        'priority' => 'priority',
        'attributes' => 'attributes',
        'toAddress' => 'toAddress',
        'toName' => 'toName',
        'fromAddress' => 'fromAddress',
        'fromName' => 'fromName',
        'subject' => 'subject',
        'direction' => 'direction',
        'htmlBody' => 'htmlBody',
        'textBody' => 'textBody'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'queueId' => 'setQueueId',
        'flowId' => 'setFlowId',
        'provider' => 'setProvider',
        'skillIds' => 'setSkillIds',
        'languageId' => 'setLanguageId',
        'priority' => 'setPriority',
        'attributes' => 'setAttributes',
        'toAddress' => 'setToAddress',
        'toName' => 'setToName',
        'fromAddress' => 'setFromAddress',
        'fromName' => 'setFromName',
        'subject' => 'setSubject',
        'direction' => 'setDirection',
        'htmlBody' => 'setHtmlBody',
        'textBody' => 'setTextBody'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'queueId' => 'getQueueId',
        'flowId' => 'getFlowId',
        'provider' => 'getProvider',
        'skillIds' => 'getSkillIds',
        'languageId' => 'getLanguageId',
        'priority' => 'getPriority',
        'attributes' => 'getAttributes',
        'toAddress' => 'getToAddress',
        'toName' => 'getToName',
        'fromAddress' => 'getFromAddress',
        'fromName' => 'getFromName',
        'subject' => 'getSubject',
        'direction' => 'getDirection',
        'htmlBody' => 'getHtmlBody',
        'textBody' => 'getTextBody'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const DIRECTION_OUTBOUND = 'OUTBOUND';
    public const DIRECTION_INBOUND = 'INBOUND';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDirectionAllowableValues()
    {
        return [
            self::DIRECTION_OUTBOUND,
            self::DIRECTION_INBOUND,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['queueId'] = isset($data['queueId']) ? $data['queueId'] : null;
        $this->container['flowId'] = isset($data['flowId']) ? $data['flowId'] : null;
        $this->container['provider'] = isset($data['provider']) ? $data['provider'] : null;
        $this->container['skillIds'] = isset($data['skillIds']) ? $data['skillIds'] : null;
        $this->container['languageId'] = isset($data['languageId']) ? $data['languageId'] : null;
        $this->container['priority'] = isset($data['priority']) ? $data['priority'] : null;
        $this->container['attributes'] = isset($data['attributes']) ? $data['attributes'] : null;
        $this->container['toAddress'] = isset($data['toAddress']) ? $data['toAddress'] : null;
        $this->container['toName'] = isset($data['toName']) ? $data['toName'] : null;
        $this->container['fromAddress'] = isset($data['fromAddress']) ? $data['fromAddress'] : null;
        $this->container['fromName'] = isset($data['fromName']) ? $data['fromName'] : null;
        $this->container['subject'] = isset($data['subject']) ? $data['subject'] : null;
        $this->container['direction'] = isset($data['direction']) ? $data['direction'] : null;
        $this->container['htmlBody'] = isset($data['htmlBody']) ? $data['htmlBody'] : null;
        $this->container['textBody'] = isset($data['textBody']) ? $data['textBody'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['provider'] === null) {
            $invalid_properties[] = "'provider' can't be null";
        }
        $allowed_values = array("OUTBOUND", "INBOUND");
        if (!in_array($this->container['direction'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'direction', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['provider'] === null) {
            return false;
        }
        $allowed_values = array("OUTBOUND", "INBOUND");
        if (!in_array($this->container['direction'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets queueId
     * @return string
     */
    public function getQueueId()
    {
        return $this->container['queueId'];
    }

    /**
     * Sets queueId
     * @param string $queueId The ID of the queue to use for routing the email conversation. This field is mutually exclusive with flowId
     * @return $this
     */
    public function setQueueId($queueId)
    {
        $this->container['queueId'] = $queueId;

        return $this;
    }

    /**
     * Gets flowId
     * @return string
     */
    public function getFlowId()
    {
        return $this->container['flowId'];
    }

    /**
     * Sets flowId
     * @param string $flowId The ID of the flow to use for routing email conversation. This field is mutually exclusive with queueId
     * @return $this
     */
    public function setFlowId($flowId)
    {
        $this->container['flowId'] = $flowId;

        return $this;
    }

    /**
     * Gets provider
     * @return string
     */
    public function getProvider()
    {
        return $this->container['provider'];
    }

    /**
     * Sets provider
     * @param string $provider The name of the provider that is sourcing the emails. The Provider \"PureCloud Email\" is reserved for native emails.
     * @return $this
     */
    public function setProvider($provider)
    {
        $this->container['provider'] = $provider;

        return $this;
    }

    /**
     * Gets skillIds
     * @return string[]
     */
    public function getSkillIds()
    {
        return $this->container['skillIds'];
    }

    /**
     * Sets skillIds
     * @param string[] $skillIds The list of skill ID's to use for routing.
     * @return $this
     */
    public function setSkillIds($skillIds)
    {
        $this->container['skillIds'] = $skillIds;

        return $this;
    }

    /**
     * Gets languageId
     * @return string
     */
    public function getLanguageId()
    {
        return $this->container['languageId'];
    }

    /**
     * Sets languageId
     * @param string $languageId The ID of the language to use for routing.
     * @return $this
     */
    public function setLanguageId($languageId)
    {
        $this->container['languageId'] = $languageId;

        return $this;
    }

    /**
     * Gets priority
     * @return int
     */
    public function getPriority()
    {
        return $this->container['priority'];
    }

    /**
     * Sets priority
     * @param int $priority The priority to assign to the conversation for routing.
     * @return $this
     */
    public function setPriority($priority)
    {
        $this->container['priority'] = $priority;

        return $this;
    }

    /**
     * Gets attributes
     * @return map[string,string]
     */
    public function getAttributes()
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes
     * @param map[string,string] $attributes The list of attributes to associate with the customer participant.
     * @return $this
     */
    public function setAttributes($attributes)
    {
        $this->container['attributes'] = $attributes;

        return $this;
    }

    /**
     * Gets toAddress
     * @return string
     */
    public function getToAddress()
    {
        return $this->container['toAddress'];
    }

    /**
     * Sets toAddress
     * @param string $toAddress The email address of the recipient of the email.
     * @return $this
     */
    public function setToAddress($toAddress)
    {
        $this->container['toAddress'] = $toAddress;

        return $this;
    }

    /**
     * Gets toName
     * @return string
     */
    public function getToName()
    {
        return $this->container['toName'];
    }

    /**
     * Sets toName
     * @param string $toName The name of the recipient of the email.
     * @return $this
     */
    public function setToName($toName)
    {
        $this->container['toName'] = $toName;

        return $this;
    }

    /**
     * Gets fromAddress
     * @return string
     */
    public function getFromAddress()
    {
        return $this->container['fromAddress'];
    }

    /**
     * Sets fromAddress
     * @param string $fromAddress The email address of the sender of the email.
     * @return $this
     */
    public function setFromAddress($fromAddress)
    {
        $this->container['fromAddress'] = $fromAddress;

        return $this;
    }

    /**
     * Gets fromName
     * @return string
     */
    public function getFromName()
    {
        return $this->container['fromName'];
    }

    /**
     * Sets fromName
     * @param string $fromName The name of the sender of the email.
     * @return $this
     */
    public function setFromName($fromName)
    {
        $this->container['fromName'] = $fromName;

        return $this;
    }

    /**
     * Gets subject
     * @return string
     */
    public function getSubject()
    {
        return $this->container['subject'];
    }

    /**
     * Sets subject
     * @param string $subject The subject of the email
     * @return $this
     */
    public function setSubject($subject)
    {
        $this->container['subject'] = $subject;

        return $this;
    }

    /**
     * Gets direction
     * @return string
     */
    public function getDirection()
    {
        return $this->container['direction'];
    }

    /**
     * Sets direction
     * @param string $direction Specify OUTBOUND to send an email on behalf of a queue, or INBOUND to create an external conversation. An external conversation is one where the provider is not PureCloud based.
     * @return $this
     */
    public function setDirection($direction)
    {
        $allowed_values = array('OUTBOUND', 'INBOUND');
        if (!in_array($direction, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'direction', must be one of 'OUTBOUND', 'INBOUND'");
        }
        $this->container['direction'] = $direction;

        return $this;
    }

    /**
     * Gets htmlBody
     * @return string
     */
    public function getHtmlBody()
    {
        return $this->container['htmlBody'];
    }

    /**
     * Sets htmlBody
     * @param string $htmlBody An HTML body content of the email.
     * @return $this
     */
    public function setHtmlBody($htmlBody)
    {
        $this->container['htmlBody'] = $htmlBody;

        return $this;
    }

    /**
     * Gets textBody
     * @return string
     */
    public function getTextBody()
    {
        return $this->container['textBody'];
    }

    /**
     * Sets textBody
     * @param string $textBody A text body content of the email.
     * @return $this
     */
    public function setTextBody($textBody)
    {
        $this->container['textBody'] = $textBody;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
