<?php

/**
 * DomainNetworkRoute
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * DomainNetworkRoute Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class DomainNetworkRoute implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'DomainNetworkRoute';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'prefix' => 'string',
        'nexthop' => 'string',
        'persistent' => 'bool',
        'metric' => 'int',
        'family' => 'int'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'prefix' => 'prefix',
        'nexthop' => 'nexthop',
        'persistent' => 'persistent',
        'metric' => 'metric',
        'family' => 'family'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'prefix' => 'setPrefix',
        'nexthop' => 'setNexthop',
        'persistent' => 'setPersistent',
        'metric' => 'setMetric',
        'family' => 'setFamily'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'prefix' => 'getPrefix',
        'nexthop' => 'getNexthop',
        'persistent' => 'getPersistent',
        'metric' => 'getMetric',
        'family' => 'getFamily'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const FAMILY_2 = 2;
    public const FAMILY_23 = 23;
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getFamilyAllowableValues()
    {
        return [
            self::FAMILY_2,
            self::FAMILY_23,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['prefix'] = isset($data['prefix']) ? $data['prefix'] : null;
        $this->container['nexthop'] = isset($data['nexthop']) ? $data['nexthop'] : null;
        $this->container['persistent'] = isset($data['persistent']) ? $data['persistent'] : null;
        $this->container['metric'] = isset($data['metric']) ? $data['metric'] : null;
        $this->container['family'] = isset($data['family']) ? $data['family'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("2", "23");
        if (!in_array($this->container['family'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'family', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("2", "23");
        if (!in_array($this->container['family'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets prefix
     * @return string
     */
    public function getPrefix()
    {
        return $this->container['prefix'];
    }

    /**
     * Sets prefix
     * @param string $prefix The IPv4 or IPv6 route prefix in CIDR notation.
     * @return $this
     */
    public function setPrefix($prefix)
    {
        $this->container['prefix'] = $prefix;

        return $this;
    }

    /**
     * Gets nexthop
     * @return string
     */
    public function getNexthop()
    {
        return $this->container['nexthop'];
    }

    /**
     * Sets nexthop
     * @param string $nexthop The IPv4 or IPv6 nexthop IP address.
     * @return $this
     */
    public function setNexthop($nexthop)
    {
        $this->container['nexthop'] = $nexthop;

        return $this;
    }

    /**
     * Gets persistent
     * @return bool
     */
    public function getPersistent()
    {
        return $this->container['persistent'];
    }

    /**
     * Sets persistent
     * @param bool $persistent True if this route will persist on Edge restart.  Routes assigned by DHCP will be returned as false.
     * @return $this
     */
    public function setPersistent($persistent)
    {
        $this->container['persistent'] = $persistent;

        return $this;
    }

    /**
     * Gets metric
     * @return int
     */
    public function getMetric()
    {
        return $this->container['metric'];
    }

    /**
     * Sets metric
     * @param int $metric The metric being used for route. Lower values will have a higher priority.
     * @return $this
     */
    public function setMetric($metric)
    {
        $this->container['metric'] = $metric;

        return $this;
    }

    /**
     * Gets family
     * @return int
     */
    public function getFamily()
    {
        return $this->container['family'];
    }

    /**
     * Sets family
     * @param int $family The address family for this route.
     * @return $this
     */
    public function setFamily($family)
    {
        $allowed_values = array('2', '23');
        if (!in_array($family, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'family', must be one of '2', '23'");
        }
        $this->container['family'] = $family;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
