<?php

/**
 * EmailMessage
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * EmailMessage Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class EmailMessage implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'EmailMessage';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'to' => '\PureCloudSDK\EmailAddress[]',
        'cc' => '\PureCloudSDK\EmailAddress[]',
        'bcc' => '\PureCloudSDK\EmailAddress[]',
        'from' => '\PureCloudSDK\EmailAddress',
        'subject' => 'string',
        'attachments' => '\PureCloudSDK\Attachment[]',
        'textBody' => 'string',
        'htmlBody' => 'string',
        'time' => '\DateTime',
        'historyIncluded' => 'bool',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'to' => 'to',
        'cc' => 'cc',
        'bcc' => 'bcc',
        'from' => 'from',
        'subject' => 'subject',
        'attachments' => 'attachments',
        'textBody' => 'textBody',
        'htmlBody' => 'htmlBody',
        'time' => 'time',
        'historyIncluded' => 'historyIncluded',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'to' => 'setTo',
        'cc' => 'setCc',
        'bcc' => 'setBcc',
        'from' => 'setFrom',
        'subject' => 'setSubject',
        'attachments' => 'setAttachments',
        'textBody' => 'setTextBody',
        'htmlBody' => 'setHtmlBody',
        'time' => 'setTime',
        'historyIncluded' => 'setHistoryIncluded',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'to' => 'getTo',
        'cc' => 'getCc',
        'bcc' => 'getBcc',
        'from' => 'getFrom',
        'subject' => 'getSubject',
        'attachments' => 'getAttachments',
        'textBody' => 'getTextBody',
        'htmlBody' => 'getHtmlBody',
        'time' => 'getTime',
        'historyIncluded' => 'getHistoryIncluded',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['to'] = isset($data['to']) ? $data['to'] : null;
        $this->container['cc'] = isset($data['cc']) ? $data['cc'] : null;
        $this->container['bcc'] = isset($data['bcc']) ? $data['bcc'] : null;
        $this->container['from'] = isset($data['from']) ? $data['from'] : null;
        $this->container['subject'] = isset($data['subject']) ? $data['subject'] : null;
        $this->container['attachments'] = isset($data['attachments']) ? $data['attachments'] : null;
        $this->container['textBody'] = isset($data['textBody']) ? $data['textBody'] : null;
        $this->container['htmlBody'] = isset($data['htmlBody']) ? $data['htmlBody'] : null;
        $this->container['time'] = isset($data['time']) ? $data['time'] : null;
        $this->container['historyIncluded'] = isset($data['historyIncluded']) ? $data['historyIncluded'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['to'] === null) {
            $invalid_properties[] = "'to' can't be null";
        }
        if ($this->container['from'] === null) {
            $invalid_properties[] = "'from' can't be null";
        }
        if ($this->container['textBody'] === null) {
            $invalid_properties[] = "'textBody' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['to'] === null) {
            return false;
        }
        if ($this->container['from'] === null) {
            return false;
        }
        if ($this->container['textBody'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets to
     * @return \PureCloudSDK\EmailAddress[]
     */
    public function getTo()
    {
        return $this->container['to'];
    }

    /**
     * Sets to
     * @param \PureCloudSDK\EmailAddress[] $to The recipients of the email message.
     * @return $this
     */
    public function setTo($to)
    {
        $this->container['to'] = $to;

        return $this;
    }

    /**
     * Gets cc
     * @return \PureCloudSDK\EmailAddress[]
     */
    public function getCc()
    {
        return $this->container['cc'];
    }

    /**
     * Sets cc
     * @param \PureCloudSDK\EmailAddress[] $cc The recipients that were copied on the email message.
     * @return $this
     */
    public function setCc($cc)
    {
        $this->container['cc'] = $cc;

        return $this;
    }

    /**
     * Gets bcc
     * @return \PureCloudSDK\EmailAddress[]
     */
    public function getBcc()
    {
        return $this->container['bcc'];
    }

    /**
     * Sets bcc
     * @param \PureCloudSDK\EmailAddress[] $bcc The recipients that were blind copied on the email message.
     * @return $this
     */
    public function setBcc($bcc)
    {
        $this->container['bcc'] = $bcc;

        return $this;
    }

    /**
     * Gets from
     * @return \PureCloudSDK\EmailAddress
     */
    public function getFrom()
    {
        return $this->container['from'];
    }

    /**
     * Sets from
     * @param \PureCloudSDK\EmailAddress $from The sender of the email message.
     * @return $this
     */
    public function setFrom($from)
    {
        $this->container['from'] = $from;

        return $this;
    }

    /**
     * Gets subject
     * @return string
     */
    public function getSubject()
    {
        return $this->container['subject'];
    }

    /**
     * Sets subject
     * @param string $subject The subject of the email message.
     * @return $this
     */
    public function setSubject($subject)
    {
        $this->container['subject'] = $subject;

        return $this;
    }

    /**
     * Gets attachments
     * @return \PureCloudSDK\Attachment[]
     */
    public function getAttachments()
    {
        return $this->container['attachments'];
    }

    /**
     * Sets attachments
     * @param \PureCloudSDK\Attachment[] $attachments The attachments of the email message.
     * @return $this
     */
    public function setAttachments($attachments)
    {
        $this->container['attachments'] = $attachments;

        return $this;
    }

    /**
     * Gets textBody
     * @return string
     */
    public function getTextBody()
    {
        return $this->container['textBody'];
    }

    /**
     * Sets textBody
     * @param string $textBody The text body of the email message.
     * @return $this
     */
    public function setTextBody($textBody)
    {
        $this->container['textBody'] = $textBody;

        return $this;
    }

    /**
     * Gets htmlBody
     * @return string
     */
    public function getHtmlBody()
    {
        return $this->container['htmlBody'];
    }

    /**
     * Sets htmlBody
     * @param string $htmlBody The html body of the email message.
     * @return $this
     */
    public function setHtmlBody($htmlBody)
    {
        $this->container['htmlBody'] = $htmlBody;

        return $this;
    }

    /**
     * Gets time
     * @return \DateTime
     */
    public function getTime()
    {
        return $this->container['time'];
    }

    /**
     * Sets time
     * @param \DateTime $time The time when the message was received or sent. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setTime($time)
    {
        $this->container['time'] = $time;

        return $this;
    }

    /**
     * Gets historyIncluded
     * @return bool
     */
    public function getHistoryIncluded()
    {
        return $this->container['historyIncluded'];
    }

    /**
     * Sets historyIncluded
     * @param bool $historyIncluded Indicates whether the history of previous emails of the conversation is included within the email bodies of this message.
     * @return $this
     */
    public function setHistoryIncluded($historyIncluded)
    {
        $this->container['historyIncluded'] = $historyIncluded;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
