<?php

/**
 * ExternalOrganization
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ExternalOrganization Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ExternalOrganization implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ExternalOrganization';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'companyType' => 'string',
        'industry' => 'string',
        'primaryContactId' => 'string',
        'address' => '\PureCloudSDK\ContactAddress',
        'phoneNumber' => '\PureCloudSDK\PhoneNumber',
        'faxNumber' => '\PureCloudSDK\PhoneNumber',
        'employeeCount' => 'int',
        'revenue' => 'int',
        'tags' => 'string[]',
        'websites' => 'string[]',
        'tickers' => '\PureCloudSDK\Ticker[]',
        'twitterId' => '\PureCloudSDK\TwitterId',
        'externalSystemUrl' => 'string',
        'modifyDate' => '\DateTime',
        'createDate' => '\DateTime',
        'trustor' => '\PureCloudSDK\Trustor',
        'schema' => '\PureCloudSDK\DataSchema',
        'customFields' => 'map[string,object]',
        'externalDataSources' => '\PureCloudSDK\ExternalDataSource[]',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'companyType' => 'companyType',
        'industry' => 'industry',
        'primaryContactId' => 'primaryContactId',
        'address' => 'address',
        'phoneNumber' => 'phoneNumber',
        'faxNumber' => 'faxNumber',
        'employeeCount' => 'employeeCount',
        'revenue' => 'revenue',
        'tags' => 'tags',
        'websites' => 'websites',
        'tickers' => 'tickers',
        'twitterId' => 'twitterId',
        'externalSystemUrl' => 'externalSystemUrl',
        'modifyDate' => 'modifyDate',
        'createDate' => 'createDate',
        'trustor' => 'trustor',
        'schema' => 'schema',
        'customFields' => 'customFields',
        'externalDataSources' => 'externalDataSources',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'companyType' => 'setCompanyType',
        'industry' => 'setIndustry',
        'primaryContactId' => 'setPrimaryContactId',
        'address' => 'setAddress',
        'phoneNumber' => 'setPhoneNumber',
        'faxNumber' => 'setFaxNumber',
        'employeeCount' => 'setEmployeeCount',
        'revenue' => 'setRevenue',
        'tags' => 'setTags',
        'websites' => 'setWebsites',
        'tickers' => 'setTickers',
        'twitterId' => 'setTwitterId',
        'externalSystemUrl' => 'setExternalSystemUrl',
        'modifyDate' => 'setModifyDate',
        'createDate' => 'setCreateDate',
        'trustor' => 'setTrustor',
        'schema' => 'setSchema',
        'customFields' => 'setCustomFields',
        'externalDataSources' => 'setExternalDataSources',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'companyType' => 'getCompanyType',
        'industry' => 'getIndustry',
        'primaryContactId' => 'getPrimaryContactId',
        'address' => 'getAddress',
        'phoneNumber' => 'getPhoneNumber',
        'faxNumber' => 'getFaxNumber',
        'employeeCount' => 'getEmployeeCount',
        'revenue' => 'getRevenue',
        'tags' => 'getTags',
        'websites' => 'getWebsites',
        'tickers' => 'getTickers',
        'twitterId' => 'getTwitterId',
        'externalSystemUrl' => 'getExternalSystemUrl',
        'modifyDate' => 'getModifyDate',
        'createDate' => 'getCreateDate',
        'trustor' => 'getTrustor',
        'schema' => 'getSchema',
        'customFields' => 'getCustomFields',
        'externalDataSources' => 'getExternalDataSources',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['companyType'] = isset($data['companyType']) ? $data['companyType'] : null;
        $this->container['industry'] = isset($data['industry']) ? $data['industry'] : null;
        $this->container['primaryContactId'] = isset($data['primaryContactId']) ? $data['primaryContactId'] : null;
        $this->container['address'] = isset($data['address']) ? $data['address'] : null;
        $this->container['phoneNumber'] = isset($data['phoneNumber']) ? $data['phoneNumber'] : null;
        $this->container['faxNumber'] = isset($data['faxNumber']) ? $data['faxNumber'] : null;
        $this->container['employeeCount'] = isset($data['employeeCount']) ? $data['employeeCount'] : null;
        $this->container['revenue'] = isset($data['revenue']) ? $data['revenue'] : null;
        $this->container['tags'] = isset($data['tags']) ? $data['tags'] : null;
        $this->container['websites'] = isset($data['websites']) ? $data['websites'] : null;
        $this->container['tickers'] = isset($data['tickers']) ? $data['tickers'] : null;
        $this->container['twitterId'] = isset($data['twitterId']) ? $data['twitterId'] : null;
        $this->container['externalSystemUrl'] = isset($data['externalSystemUrl']) ? $data['externalSystemUrl'] : null;
        $this->container['modifyDate'] = isset($data['modifyDate']) ? $data['modifyDate'] : null;
        $this->container['createDate'] = isset($data['createDate']) ? $data['createDate'] : null;
        $this->container['trustor'] = isset($data['trustor']) ? $data['trustor'] : null;
        $this->container['schema'] = isset($data['schema']) ? $data['schema'] : null;
        $this->container['customFields'] = isset($data['customFields']) ? $data['customFields'] : null;
        $this->container['externalDataSources'] = isset($data['externalDataSources']) ? $data['externalDataSources'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The name of the company.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets companyType
     * @return string
     */
    public function getCompanyType()
    {
        return $this->container['companyType'];
    }

    /**
     * Sets companyType
     * @param string $companyType
     * @return $this
     */
    public function setCompanyType($companyType)
    {
        $this->container['companyType'] = $companyType;

        return $this;
    }

    /**
     * Gets industry
     * @return string
     */
    public function getIndustry()
    {
        return $this->container['industry'];
    }

    /**
     * Sets industry
     * @param string $industry
     * @return $this
     */
    public function setIndustry($industry)
    {
        $this->container['industry'] = $industry;

        return $this;
    }

    /**
     * Gets primaryContactId
     * @return string
     */
    public function getPrimaryContactId()
    {
        return $this->container['primaryContactId'];
    }

    /**
     * Sets primaryContactId
     * @param string $primaryContactId
     * @return $this
     */
    public function setPrimaryContactId($primaryContactId)
    {
        $this->container['primaryContactId'] = $primaryContactId;

        return $this;
    }

    /**
     * Gets address
     * @return \PureCloudSDK\ContactAddress
     */
    public function getAddress()
    {
        return $this->container['address'];
    }

    /**
     * Sets address
     * @param \PureCloudSDK\ContactAddress $address
     * @return $this
     */
    public function setAddress($address)
    {
        $this->container['address'] = $address;

        return $this;
    }

    /**
     * Gets phoneNumber
     * @return \PureCloudSDK\PhoneNumber
     */
    public function getPhoneNumber()
    {
        return $this->container['phoneNumber'];
    }

    /**
     * Sets phoneNumber
     * @param \PureCloudSDK\PhoneNumber $phoneNumber
     * @return $this
     */
    public function setPhoneNumber($phoneNumber)
    {
        $this->container['phoneNumber'] = $phoneNumber;

        return $this;
    }

    /**
     * Gets faxNumber
     * @return \PureCloudSDK\PhoneNumber
     */
    public function getFaxNumber()
    {
        return $this->container['faxNumber'];
    }

    /**
     * Sets faxNumber
     * @param \PureCloudSDK\PhoneNumber $faxNumber
     * @return $this
     */
    public function setFaxNumber($faxNumber)
    {
        $this->container['faxNumber'] = $faxNumber;

        return $this;
    }

    /**
     * Gets employeeCount
     * @return int
     */
    public function getEmployeeCount()
    {
        return $this->container['employeeCount'];
    }

    /**
     * Sets employeeCount
     * @param int $employeeCount
     * @return $this
     */
    public function setEmployeeCount($employeeCount)
    {
        $this->container['employeeCount'] = $employeeCount;

        return $this;
    }

    /**
     * Gets revenue
     * @return int
     */
    public function getRevenue()
    {
        return $this->container['revenue'];
    }

    /**
     * Sets revenue
     * @param int $revenue
     * @return $this
     */
    public function setRevenue($revenue)
    {
        $this->container['revenue'] = $revenue;

        return $this;
    }

    /**
     * Gets tags
     * @return string[]
     */
    public function getTags()
    {
        return $this->container['tags'];
    }

    /**
     * Sets tags
     * @param string[] $tags
     * @return $this
     */
    public function setTags($tags)
    {
        $this->container['tags'] = $tags;

        return $this;
    }

    /**
     * Gets websites
     * @return string[]
     */
    public function getWebsites()
    {
        return $this->container['websites'];
    }

    /**
     * Sets websites
     * @param string[] $websites
     * @return $this
     */
    public function setWebsites($websites)
    {
        $this->container['websites'] = $websites;

        return $this;
    }

    /**
     * Gets tickers
     * @return \PureCloudSDK\Ticker[]
     */
    public function getTickers()
    {
        return $this->container['tickers'];
    }

    /**
     * Sets tickers
     * @param \PureCloudSDK\Ticker[] $tickers
     * @return $this
     */
    public function setTickers($tickers)
    {
        $this->container['tickers'] = $tickers;

        return $this;
    }

    /**
     * Gets twitterId
     * @return \PureCloudSDK\TwitterId
     */
    public function getTwitterId()
    {
        return $this->container['twitterId'];
    }

    /**
     * Sets twitterId
     * @param \PureCloudSDK\TwitterId $twitterId
     * @return $this
     */
    public function setTwitterId($twitterId)
    {
        $this->container['twitterId'] = $twitterId;

        return $this;
    }

    /**
     * Gets externalSystemUrl
     * @return string
     */
    public function getExternalSystemUrl()
    {
        return $this->container['externalSystemUrl'];
    }

    /**
     * Sets externalSystemUrl
     * @param string $externalSystemUrl A string that identifies an external system-of-record resource that may have more detailed information on the organization. It should be a valid URL (including the http/https protocol, port, and path [if any]). The value is automatically trimmed of any leading and trailing whitespace.
     * @return $this
     */
    public function setExternalSystemUrl($externalSystemUrl)
    {
        $this->container['externalSystemUrl'] = $externalSystemUrl;

        return $this;
    }

    /**
     * Gets modifyDate
     * @return \DateTime
     */
    public function getModifyDate()
    {
        return $this->container['modifyDate'];
    }

    /**
     * Sets modifyDate
     * @param \DateTime $modifyDate Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setModifyDate($modifyDate)
    {
        $this->container['modifyDate'] = $modifyDate;

        return $this;
    }

    /**
     * Gets createDate
     * @return \DateTime
     */
    public function getCreateDate()
    {
        return $this->container['createDate'];
    }

    /**
     * Sets createDate
     * @param \DateTime $createDate Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCreateDate($createDate)
    {
        $this->container['createDate'] = $createDate;

        return $this;
    }

    /**
     * Gets trustor
     * @return \PureCloudSDK\Trustor
     */
    public function getTrustor()
    {
        return $this->container['trustor'];
    }

    /**
     * Sets trustor
     * @param \PureCloudSDK\Trustor $trustor
     * @return $this
     */
    public function setTrustor($trustor)
    {
        $this->container['trustor'] = $trustor;

        return $this;
    }

    /**
     * Gets schema
     * @return \PureCloudSDK\DataSchema
     */
    public function getSchema()
    {
        return $this->container['schema'];
    }

    /**
     * Sets schema
     * @param \PureCloudSDK\DataSchema $schema The schema defining custom fields for this contact
     * @return $this
     */
    public function setSchema($schema)
    {
        $this->container['schema'] = $schema;

        return $this;
    }

    /**
     * Gets customFields
     * @return map[string,object]
     */
    public function getCustomFields()
    {
        return $this->container['customFields'];
    }

    /**
     * Sets customFields
     * @param map[string,object] $customFields Custom fields defined in the schema referenced by schemaId and schemaVersion.
     * @return $this
     */
    public function setCustomFields($customFields)
    {
        $this->container['customFields'] = $customFields;

        return $this;
    }

    /**
     * Gets externalDataSources
     * @return \PureCloudSDK\ExternalDataSource[]
     */
    public function getExternalDataSources()
    {
        return $this->container['externalDataSources'];
    }

    /**
     * Sets externalDataSources
     * @param \PureCloudSDK\ExternalDataSource[] $externalDataSources Links to the sources of data (e.g. one source might be a CRM) that contributed data to this record.  Read-only, and only populated when requested via expand param.
     * @return $this
     */
    public function setExternalDataSources($externalDataSources)
    {
        $this->container['externalDataSources'] = $externalDataSources;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
