<?php

/**
 * InteractionStatsAlert
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * InteractionStatsAlert Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class InteractionStatsAlert implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'InteractionStatsAlert';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'dimension' => 'string',
        'dimensionValue' => 'string',
        'metric' => 'string',
        'mediaType' => 'string',
        'numericRange' => 'string',
        'statistic' => 'string',
        'value' => 'double',
        'ruleId' => 'string',
        'unread' => 'bool',
        'startDate' => '\DateTime',
        'endDate' => '\DateTime',
        'notificationUsers' => '\PureCloudSDK\User[]',
        'alertTypes' => 'string[]',
        'ruleUri' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'dimension' => 'dimension',
        'dimensionValue' => 'dimensionValue',
        'metric' => 'metric',
        'mediaType' => 'mediaType',
        'numericRange' => 'numericRange',
        'statistic' => 'statistic',
        'value' => 'value',
        'ruleId' => 'ruleId',
        'unread' => 'unread',
        'startDate' => 'startDate',
        'endDate' => 'endDate',
        'notificationUsers' => 'notificationUsers',
        'alertTypes' => 'alertTypes',
        'ruleUri' => 'ruleUri',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'dimension' => 'setDimension',
        'dimensionValue' => 'setDimensionValue',
        'metric' => 'setMetric',
        'mediaType' => 'setMediaType',
        'numericRange' => 'setNumericRange',
        'statistic' => 'setStatistic',
        'value' => 'setValue',
        'ruleId' => 'setRuleId',
        'unread' => 'setUnread',
        'startDate' => 'setStartDate',
        'endDate' => 'setEndDate',
        'notificationUsers' => 'setNotificationUsers',
        'alertTypes' => 'setAlertTypes',
        'ruleUri' => 'setRuleUri',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'dimension' => 'getDimension',
        'dimensionValue' => 'getDimensionValue',
        'metric' => 'getMetric',
        'mediaType' => 'getMediaType',
        'numericRange' => 'getNumericRange',
        'statistic' => 'getStatistic',
        'value' => 'getValue',
        'ruleId' => 'getRuleId',
        'unread' => 'getUnread',
        'startDate' => 'getStartDate',
        'endDate' => 'getEndDate',
        'notificationUsers' => 'getNotificationUsers',
        'alertTypes' => 'getAlertTypes',
        'ruleUri' => 'getRuleUri',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const DIMENSION_QUEUE_ID = 'queueId';
    public const DIMENSION_USER_ID = 'userId';
    public const METRIC_T_ABANDON = 'tAbandon';
    public const METRIC_T_ANSWERED = 'tAnswered';
    public const METRIC_T_TALK = 'tTalk';
    public const METRIC_N_OFFERED = 'nOffered';
    public const METRIC_T_HANDLE = 'tHandle';
    public const METRIC_N_TRANSFERRED = 'nTransferred';
    public const METRIC_O_SERVICE_LEVEL = 'oServiceLevel';
    public const METRIC_T_WAIT = 'tWait';
    public const METRIC_T_HELD = 'tHeld';
    public const METRIC_T_ACW = 'tAcw';
    public const MEDIA_TYPE_VOICE = 'voice';
    public const MEDIA_TYPE_CHAT = 'chat';
    public const MEDIA_TYPE_EMAIL = 'email';
    public const MEDIA_TYPE_CALLBACK = 'callback';
    public const MEDIA_TYPE_MESSAGE = 'message';
    public const NUMERIC_RANGE_GT = 'gt';
    public const NUMERIC_RANGE_GTE = 'gte';
    public const NUMERIC_RANGE_LT = 'lt';
    public const NUMERIC_RANGE_LTE = 'lte';
    public const NUMERIC_RANGE_EQ = 'eq';
    public const NUMERIC_RANGE_NE = 'ne';
    public const STATISTIC_COUNT = 'count';
    public const STATISTIC_MIN = 'min';
    public const STATISTIC_RATIO = 'ratio';
    public const STATISTIC_MAX = 'max';
    public const ALERT_TYPES_SMS = 'SMS';
    public const ALERT_TYPES_DEVICE = 'DEVICE';
    public const ALERT_TYPES_EMAIL = 'EMAIL';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDimensionAllowableValues()
    {
        return [
            self::DIMENSION_QUEUE_ID,
            self::DIMENSION_USER_ID,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMetricAllowableValues()
    {
        return [
            self::METRIC_T_ABANDON,
            self::METRIC_T_ANSWERED,
            self::METRIC_T_TALK,
            self::METRIC_N_OFFERED,
            self::METRIC_T_HANDLE,
            self::METRIC_N_TRANSFERRED,
            self::METRIC_O_SERVICE_LEVEL,
            self::METRIC_T_WAIT,
            self::METRIC_T_HELD,
            self::METRIC_T_ACW,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMediaTypeAllowableValues()
    {
        return [
            self::MEDIA_TYPE_VOICE,
            self::MEDIA_TYPE_CHAT,
            self::MEDIA_TYPE_EMAIL,
            self::MEDIA_TYPE_CALLBACK,
            self::MEDIA_TYPE_MESSAGE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getNumericRangeAllowableValues()
    {
        return [
            self::NUMERIC_RANGE_GT,
            self::NUMERIC_RANGE_GTE,
            self::NUMERIC_RANGE_LT,
            self::NUMERIC_RANGE_LTE,
            self::NUMERIC_RANGE_EQ,
            self::NUMERIC_RANGE_NE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatisticAllowableValues()
    {
        return [
            self::STATISTIC_COUNT,
            self::STATISTIC_MIN,
            self::STATISTIC_RATIO,
            self::STATISTIC_MAX,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getAlertTypesAllowableValues()
    {
        return [
            self::ALERT_TYPES_SMS,
            self::ALERT_TYPES_DEVICE,
            self::ALERT_TYPES_EMAIL,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['dimension'] = isset($data['dimension']) ? $data['dimension'] : null;
        $this->container['dimensionValue'] = isset($data['dimensionValue']) ? $data['dimensionValue'] : null;
        $this->container['metric'] = isset($data['metric']) ? $data['metric'] : null;
        $this->container['mediaType'] = isset($data['mediaType']) ? $data['mediaType'] : null;
        $this->container['numericRange'] = isset($data['numericRange']) ? $data['numericRange'] : null;
        $this->container['statistic'] = isset($data['statistic']) ? $data['statistic'] : null;
        $this->container['value'] = isset($data['value']) ? $data['value'] : null;
        $this->container['ruleId'] = isset($data['ruleId']) ? $data['ruleId'] : null;
        $this->container['unread'] = isset($data['unread']) ? $data['unread'] : null;
        $this->container['startDate'] = isset($data['startDate']) ? $data['startDate'] : null;
        $this->container['endDate'] = isset($data['endDate']) ? $data['endDate'] : null;
        $this->container['notificationUsers'] = isset($data['notificationUsers']) ? $data['notificationUsers'] : null;
        $this->container['alertTypes'] = isset($data['alertTypes']) ? $data['alertTypes'] : null;
        $this->container['ruleUri'] = isset($data['ruleUri']) ? $data['ruleUri'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        if ($this->container['dimension'] === null) {
            $invalid_properties[] = "'dimension' can't be null";
        }
        $allowed_values = array("queueId", "userId");
        if (!in_array($this->container['dimension'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'dimension', must be one of #{allowed_values}.";
        }

        if ($this->container['dimensionValue'] === null) {
            $invalid_properties[] = "'dimensionValue' can't be null";
        }
        if ($this->container['metric'] === null) {
            $invalid_properties[] = "'metric' can't be null";
        }
        $allowed_values = array("tAbandon", "tAnswered", "tTalk", "nOffered", "tHandle", "nTransferred", "oServiceLevel", "tWait", "tHeld", "tAcw");
        if (!in_array($this->container['metric'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'metric', must be one of #{allowed_values}.";
        }

        if ($this->container['mediaType'] === null) {
            $invalid_properties[] = "'mediaType' can't be null";
        }
        $allowed_values = array("voice", "chat", "email", "callback", "message");
        if (!in_array($this->container['mediaType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'mediaType', must be one of #{allowed_values}.";
        }

        if ($this->container['numericRange'] === null) {
            $invalid_properties[] = "'numericRange' can't be null";
        }
        $allowed_values = array("gt", "gte", "lt", "lte", "eq", "ne");
        if (!in_array($this->container['numericRange'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'numericRange', must be one of #{allowed_values}.";
        }

        if ($this->container['statistic'] === null) {
            $invalid_properties[] = "'statistic' can't be null";
        }
        $allowed_values = array("count", "min", "ratio", "max");
        if (!in_array($this->container['statistic'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'statistic', must be one of #{allowed_values}.";
        }

        if ($this->container['value'] === null) {
            $invalid_properties[] = "'value' can't be null";
        }
        if ($this->container['ruleId'] === null) {
            $invalid_properties[] = "'ruleId' can't be null";
        }
        if ($this->container['unread'] === null) {
            $invalid_properties[] = "'unread' can't be null";
        }
        if ($this->container['startDate'] === null) {
            $invalid_properties[] = "'startDate' can't be null";
        }
        if ($this->container['notificationUsers'] === null) {
            $invalid_properties[] = "'notificationUsers' can't be null";
        }
        if ($this->container['alertTypes'] === null) {
            $invalid_properties[] = "'alertTypes' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        if ($this->container['dimension'] === null) {
            return false;
        }
        $allowed_values = array("queueId", "userId");
        if (!in_array($this->container['dimension'], $allowed_values)) {
            return false;
        }
        if ($this->container['dimensionValue'] === null) {
            return false;
        }
        if ($this->container['metric'] === null) {
            return false;
        }
        $allowed_values = array("tAbandon", "tAnswered", "tTalk", "nOffered", "tHandle", "nTransferred", "oServiceLevel", "tWait", "tHeld", "tAcw");
        if (!in_array($this->container['metric'], $allowed_values)) {
            return false;
        }
        if ($this->container['mediaType'] === null) {
            return false;
        }
        $allowed_values = array("voice", "chat", "email", "callback", "message");
        if (!in_array($this->container['mediaType'], $allowed_values)) {
            return false;
        }
        if ($this->container['numericRange'] === null) {
            return false;
        }
        $allowed_values = array("gt", "gte", "lt", "lte", "eq", "ne");
        if (!in_array($this->container['numericRange'], $allowed_values)) {
            return false;
        }
        if ($this->container['statistic'] === null) {
            return false;
        }
        $allowed_values = array("count", "min", "ratio", "max");
        if (!in_array($this->container['statistic'], $allowed_values)) {
            return false;
        }
        if ($this->container['value'] === null) {
            return false;
        }
        if ($this->container['ruleId'] === null) {
            return false;
        }
        if ($this->container['unread'] === null) {
            return false;
        }
        if ($this->container['startDate'] === null) {
            return false;
        }
        if ($this->container['notificationUsers'] === null) {
            return false;
        }
        if ($this->container['alertTypes'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name Name of the rule that generated the alert
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets dimension
     * @return string
     */
    public function getDimension()
    {
        return $this->container['dimension'];
    }

    /**
     * Sets dimension
     * @param string $dimension The dimension of concern.
     * @return $this
     */
    public function setDimension($dimension)
    {
        $allowed_values = array('queueId', 'userId');
        if (!in_array($dimension, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'dimension', must be one of 'queueId', 'userId'");
        }
        $this->container['dimension'] = $dimension;

        return $this;
    }

    /**
     * Gets dimensionValue
     * @return string
     */
    public function getDimensionValue()
    {
        return $this->container['dimensionValue'];
    }

    /**
     * Sets dimensionValue
     * @param string $dimensionValue The value of the dimension.
     * @return $this
     */
    public function setDimensionValue($dimensionValue)
    {
        $this->container['dimensionValue'] = $dimensionValue;

        return $this;
    }

    /**
     * Gets metric
     * @return string
     */
    public function getMetric()
    {
        return $this->container['metric'];
    }

    /**
     * Sets metric
     * @param string $metric The metric to be assessed.
     * @return $this
     */
    public function setMetric($metric)
    {
        $allowed_values = array('tAbandon', 'tAnswered', 'tTalk', 'nOffered', 'tHandle', 'nTransferred', 'oServiceLevel', 'tWait', 'tHeld', 'tAcw');
        if (!in_array($metric, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'metric', must be one of 'tAbandon', 'tAnswered', 'tTalk', 'nOffered', 'tHandle', 'nTransferred', 'oServiceLevel', 'tWait', 'tHeld', 'tAcw'");
        }
        $this->container['metric'] = $metric;

        return $this;
    }

    /**
     * Gets mediaType
     * @return string
     */
    public function getMediaType()
    {
        return $this->container['mediaType'];
    }

    /**
     * Sets mediaType
     * @param string $mediaType The media type.
     * @return $this
     */
    public function setMediaType($mediaType)
    {
        $allowed_values = array('voice', 'chat', 'email', 'callback', 'message');
        if (!in_array($mediaType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'mediaType', must be one of 'voice', 'chat', 'email', 'callback', 'message'");
        }
        $this->container['mediaType'] = $mediaType;

        return $this;
    }

    /**
     * Gets numericRange
     * @return string
     */
    public function getNumericRange()
    {
        return $this->container['numericRange'];
    }

    /**
     * Sets numericRange
     * @param string $numericRange The comparison descriptor used against the metric's value.
     * @return $this
     */
    public function setNumericRange($numericRange)
    {
        $allowed_values = array('gt', 'gte', 'lt', 'lte', 'eq', 'ne');
        if (!in_array($numericRange, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'numericRange', must be one of 'gt', 'gte', 'lt', 'lte', 'eq', 'ne'");
        }
        $this->container['numericRange'] = $numericRange;

        return $this;
    }

    /**
     * Gets statistic
     * @return string
     */
    public function getStatistic()
    {
        return $this->container['statistic'];
    }

    /**
     * Sets statistic
     * @param string $statistic The statistic of concern for the metric.
     * @return $this
     */
    public function setStatistic($statistic)
    {
        $allowed_values = array('count', 'min', 'ratio', 'max');
        if (!in_array($statistic, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'statistic', must be one of 'count', 'min', 'ratio', 'max'");
        }
        $this->container['statistic'] = $statistic;

        return $this;
    }

    /**
     * Gets value
     * @return double
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     * @param double $value The threshold value.
     * @return $this
     */
    public function setValue($value)
    {
        $this->container['value'] = $value;

        return $this;
    }

    /**
     * Gets ruleId
     * @return string
     */
    public function getRuleId()
    {
        return $this->container['ruleId'];
    }

    /**
     * Sets ruleId
     * @param string $ruleId The id of the rule.
     * @return $this
     */
    public function setRuleId($ruleId)
    {
        $this->container['ruleId'] = $ruleId;

        return $this;
    }

    /**
     * Gets unread
     * @return bool
     */
    public function getUnread()
    {
        return $this->container['unread'];
    }

    /**
     * Sets unread
     * @param bool $unread Indicates if the alert has been read.
     * @return $this
     */
    public function setUnread($unread)
    {
        $this->container['unread'] = $unread;

        return $this;
    }

    /**
     * Gets startDate
     * @return \DateTime
     */
    public function getStartDate()
    {
        return $this->container['startDate'];
    }

    /**
     * Sets startDate
     * @param \DateTime $startDate The date/time the alert was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setStartDate($startDate)
    {
        $this->container['startDate'] = $startDate;

        return $this;
    }

    /**
     * Gets endDate
     * @return \DateTime
     */
    public function getEndDate()
    {
        return $this->container['endDate'];
    }

    /**
     * Sets endDate
     * @param \DateTime $endDate The date/time the owning rule exiting in alarm status. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setEndDate($endDate)
    {
        $this->container['endDate'] = $endDate;

        return $this;
    }

    /**
     * Gets notificationUsers
     * @return \PureCloudSDK\User[]
     */
    public function getNotificationUsers()
    {
        return $this->container['notificationUsers'];
    }

    /**
     * Sets notificationUsers
     * @param \PureCloudSDK\User[] $notificationUsers The ids of users who were notified of alarm state change.
     * @return $this
     */
    public function setNotificationUsers($notificationUsers)
    {
        $this->container['notificationUsers'] = $notificationUsers;

        return $this;
    }

    /**
     * Gets alertTypes
     * @return string[]
     */
    public function getAlertTypes()
    {
        return $this->container['alertTypes'];
    }

    /**
     * Sets alertTypes
     * @param string[] $alertTypes A collection of notification methods.
     * @return $this
     */
    public function setAlertTypes($alertTypes)
    {
        $allowed_values = array('SMS', 'DEVICE', 'EMAIL');
        if (!in_array($alertTypes, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'alertTypes', must be one of 'SMS', 'DEVICE', 'EMAIL'");
        }
        $this->container['alertTypes'] = $alertTypes;

        return $this;
    }

    /**
     * Gets ruleUri
     * @return string
     */
    public function getRuleUri()
    {
        return $this->container['ruleUri'];
    }

    /**
     * Sets ruleUri
     * @param string $ruleUri
     * @return $this
     */
    public function setRuleUri($ruleUri)
    {
        $this->container['ruleUri'] = $ruleUri;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
