<?php

/**
 * KnowledgeTraining
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * KnowledgeTraining Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class KnowledgeTraining implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'KnowledgeTraining';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'dateTriggered' => '\DateTime',
        'dateCompleted' => '\DateTime',
        'status' => 'string',
        'languageCode' => 'string',
        'knowledgeBase' => '\PureCloudSDK\KnowledgeBase',
        'errorMessage' => 'string',
        'knowledgeDocumentsState' => 'string',
        'datePromoted' => '\DateTime',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'dateTriggered' => 'dateTriggered',
        'dateCompleted' => 'dateCompleted',
        'status' => 'status',
        'languageCode' => 'languageCode',
        'knowledgeBase' => 'knowledgeBase',
        'errorMessage' => 'errorMessage',
        'knowledgeDocumentsState' => 'knowledgeDocumentsState',
        'datePromoted' => 'datePromoted',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'dateTriggered' => 'setDateTriggered',
        'dateCompleted' => 'setDateCompleted',
        'status' => 'setStatus',
        'languageCode' => 'setLanguageCode',
        'knowledgeBase' => 'setKnowledgeBase',
        'errorMessage' => 'setErrorMessage',
        'knowledgeDocumentsState' => 'setKnowledgeDocumentsState',
        'datePromoted' => 'setDatePromoted',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'dateTriggered' => 'getDateTriggered',
        'dateCompleted' => 'getDateCompleted',
        'status' => 'getStatus',
        'languageCode' => 'getLanguageCode',
        'knowledgeBase' => 'getKnowledgeBase',
        'errorMessage' => 'getErrorMessage',
        'knowledgeDocumentsState' => 'getKnowledgeDocumentsState',
        'datePromoted' => 'getDatePromoted',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const STATUS_QUEUED = 'Queued';
    public const STATUS_IN_PROGRESS = 'InProgress';
    public const STATUS_SUCCEEDED = 'Succeeded';
    public const STATUS_FAILED = 'Failed';
    public const KNOWLEDGE_DOCUMENTS_STATE_DRAFT = 'Draft';
    public const KNOWLEDGE_DOCUMENTS_STATE_ACTIVE = 'Active';
    public const KNOWLEDGE_DOCUMENTS_STATE_DISCARDED = 'Discarded';
    public const KNOWLEDGE_DOCUMENTS_STATE_ARCHIVED = 'Archived';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_QUEUED,
            self::STATUS_IN_PROGRESS,
            self::STATUS_SUCCEEDED,
            self::STATUS_FAILED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getKnowledgeDocumentsStateAllowableValues()
    {
        return [
            self::KNOWLEDGE_DOCUMENTS_STATE_DRAFT,
            self::KNOWLEDGE_DOCUMENTS_STATE_ACTIVE,
            self::KNOWLEDGE_DOCUMENTS_STATE_DISCARDED,
            self::KNOWLEDGE_DOCUMENTS_STATE_ARCHIVED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['dateTriggered'] = isset($data['dateTriggered']) ? $data['dateTriggered'] : null;
        $this->container['dateCompleted'] = isset($data['dateCompleted']) ? $data['dateCompleted'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['languageCode'] = isset($data['languageCode']) ? $data['languageCode'] : null;
        $this->container['knowledgeBase'] = isset($data['knowledgeBase']) ? $data['knowledgeBase'] : null;
        $this->container['errorMessage'] = isset($data['errorMessage']) ? $data['errorMessage'] : null;
        $this->container['knowledgeDocumentsState'] = isset($data['knowledgeDocumentsState']) ? $data['knowledgeDocumentsState'] : null;
        $this->container['datePromoted'] = isset($data['datePromoted']) ? $data['datePromoted'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("Queued", "InProgress", "Succeeded", "Failed");
        if (!in_array($this->container['status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'status', must be one of #{allowed_values}.";
        }

        $allowed_values = array("Draft", "Active", "Discarded", "Archived");
        if (!in_array($this->container['knowledgeDocumentsState'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'knowledgeDocumentsState', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("Queued", "InProgress", "Succeeded", "Failed");
        if (!in_array($this->container['status'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("Draft", "Active", "Discarded", "Archived");
        if (!in_array($this->container['knowledgeDocumentsState'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets dateTriggered
     * @return \DateTime
     */
    public function getDateTriggered()
    {
        return $this->container['dateTriggered'];
    }

    /**
     * Sets dateTriggered
     * @param \DateTime $dateTriggered Trigger date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateTriggered($dateTriggered)
    {
        $this->container['dateTriggered'] = $dateTriggered;

        return $this;
    }

    /**
     * Gets dateCompleted
     * @return \DateTime
     */
    public function getDateCompleted()
    {
        return $this->container['dateCompleted'];
    }

    /**
     * Sets dateCompleted
     * @param \DateTime $dateCompleted Training completed date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCompleted($dateCompleted)
    {
        $this->container['dateCompleted'] = $dateCompleted;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status Training status
     * @return $this
     */
    public function setStatus($status)
    {
        $allowed_values = array('Queued', 'InProgress', 'Succeeded', 'Failed');
        if (!in_array($status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'status', must be one of 'Queued', 'InProgress', 'Succeeded', 'Failed'");
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets languageCode
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->container['languageCode'];
    }

    /**
     * Sets languageCode
     * @param string $languageCode Actual language of the Training
     * @return $this
     */
    public function setLanguageCode($languageCode)
    {
        $this->container['languageCode'] = $languageCode;

        return $this;
    }

    /**
     * Gets knowledgeBase
     * @return \PureCloudSDK\KnowledgeBase
     */
    public function getKnowledgeBase()
    {
        return $this->container['knowledgeBase'];
    }

    /**
     * Sets knowledgeBase
     * @param \PureCloudSDK\KnowledgeBase $knowledgeBase Knowledge base which Training does belong to
     * @return $this
     */
    public function setKnowledgeBase($knowledgeBase)
    {
        $this->container['knowledgeBase'] = $knowledgeBase;

        return $this;
    }

    /**
     * Gets errorMessage
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->container['errorMessage'];
    }

    /**
     * Sets errorMessage
     * @param string $errorMessage Any error message during the Training or Promote action.
     * @return $this
     */
    public function setErrorMessage($errorMessage)
    {
        $this->container['errorMessage'] = $errorMessage;

        return $this;
    }

    /**
     * Gets knowledgeDocumentsState
     * @return string
     */
    public function getKnowledgeDocumentsState()
    {
        return $this->container['knowledgeDocumentsState'];
    }

    /**
     * Sets knowledgeDocumentsState
     * @param string $knowledgeDocumentsState State of the Trained Documents, which can be one of these Draft, Active, Discarded, Archived.
     * @return $this
     */
    public function setKnowledgeDocumentsState($knowledgeDocumentsState)
    {
        $allowed_values = array('Draft', 'Active', 'Discarded', 'Archived');
        if (!in_array($knowledgeDocumentsState, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'knowledgeDocumentsState', must be one of 'Draft', 'Active', 'Discarded', 'Archived'");
        }
        $this->container['knowledgeDocumentsState'] = $knowledgeDocumentsState;

        return $this;
    }

    /**
     * Gets datePromoted
     * @return \DateTime
     */
    public function getDatePromoted()
    {
        return $this->container['datePromoted'];
    }

    /**
     * Sets datePromoted
     * @param \DateTime $datePromoted Trained Documents Promoted date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDatePromoted($datePromoted)
    {
        $this->container['datePromoted'] = $datePromoted;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
