<?php

/**
 * NluDomainVersion
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * NluDomainVersion Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class NluDomainVersion implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'NluDomainVersion';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'domain' => '\PureCloudSDK\NluDomain',
        'description' => 'string',
        'language' => 'string',
        'published' => 'bool',
        'dateCreated' => '\DateTime',
        'dateModified' => '\DateTime',
        'dateTrained' => '\DateTime',
        'datePublished' => '\DateTime',
        'trainingStatus' => 'string',
        'evaluationStatus' => 'string',
        'intents' => '\PureCloudSDK\IntentDefinition[]',
        'entityTypes' => '\PureCloudSDK\NamedEntityTypeDefinition[]',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'domain' => 'domain',
        'description' => 'description',
        'language' => 'language',
        'published' => 'published',
        'dateCreated' => 'dateCreated',
        'dateModified' => 'dateModified',
        'dateTrained' => 'dateTrained',
        'datePublished' => 'datePublished',
        'trainingStatus' => 'trainingStatus',
        'evaluationStatus' => 'evaluationStatus',
        'intents' => 'intents',
        'entityTypes' => 'entityTypes',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'domain' => 'setDomain',
        'description' => 'setDescription',
        'language' => 'setLanguage',
        'published' => 'setPublished',
        'dateCreated' => 'setDateCreated',
        'dateModified' => 'setDateModified',
        'dateTrained' => 'setDateTrained',
        'datePublished' => 'setDatePublished',
        'trainingStatus' => 'setTrainingStatus',
        'evaluationStatus' => 'setEvaluationStatus',
        'intents' => 'setIntents',
        'entityTypes' => 'setEntityTypes',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'domain' => 'getDomain',
        'description' => 'getDescription',
        'language' => 'getLanguage',
        'published' => 'getPublished',
        'dateCreated' => 'getDateCreated',
        'dateModified' => 'getDateModified',
        'dateTrained' => 'getDateTrained',
        'datePublished' => 'getDatePublished',
        'trainingStatus' => 'getTrainingStatus',
        'evaluationStatus' => 'getEvaluationStatus',
        'intents' => 'getIntents',
        'entityTypes' => 'getEntityTypes',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const TRAINING_STATUS_UNTRAINED = 'Untrained';
    public const TRAINING_STATUS_TRAINING = 'Training';
    public const TRAINING_STATUS_TRAINED = 'Trained';
    public const TRAINING_STATUS_ERROR = 'Error';
    public const TRAINING_STATUS_UNKNOWN = 'Unknown';
    public const EVALUATION_STATUS_UNEVALUATED = 'Unevaluated';
    public const EVALUATION_STATUS_EVALUATING = 'Evaluating';
    public const EVALUATION_STATUS_EVALUATED = 'Evaluated';
    public const EVALUATION_STATUS_ERROR = 'Error';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTrainingStatusAllowableValues()
    {
        return [
            self::TRAINING_STATUS_UNTRAINED,
            self::TRAINING_STATUS_TRAINING,
            self::TRAINING_STATUS_TRAINED,
            self::TRAINING_STATUS_ERROR,
            self::TRAINING_STATUS_UNKNOWN,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getEvaluationStatusAllowableValues()
    {
        return [
            self::EVALUATION_STATUS_UNEVALUATED,
            self::EVALUATION_STATUS_EVALUATING,
            self::EVALUATION_STATUS_EVALUATED,
            self::EVALUATION_STATUS_ERROR,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['domain'] = isset($data['domain']) ? $data['domain'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['language'] = isset($data['language']) ? $data['language'] : null;
        $this->container['published'] = isset($data['published']) ? $data['published'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['dateModified'] = isset($data['dateModified']) ? $data['dateModified'] : null;
        $this->container['dateTrained'] = isset($data['dateTrained']) ? $data['dateTrained'] : null;
        $this->container['datePublished'] = isset($data['datePublished']) ? $data['datePublished'] : null;
        $this->container['trainingStatus'] = isset($data['trainingStatus']) ? $data['trainingStatus'] : null;
        $this->container['evaluationStatus'] = isset($data['evaluationStatus']) ? $data['evaluationStatus'] : null;
        $this->container['intents'] = isset($data['intents']) ? $data['intents'] : null;
        $this->container['entityTypes'] = isset($data['entityTypes']) ? $data['entityTypes'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['language'] === null) {
            $invalid_properties[] = "'language' can't be null";
        }
        $allowed_values = array("Untrained", "Training", "Trained", "Error", "Unknown");
        if (!in_array($this->container['trainingStatus'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'trainingStatus', must be one of #{allowed_values}.";
        }

        $allowed_values = array("Unevaluated", "Evaluating", "Evaluated", "Error");
        if (!in_array($this->container['evaluationStatus'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'evaluationStatus', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['language'] === null) {
            return false;
        }
        $allowed_values = array("Untrained", "Training", "Trained", "Error", "Unknown");
        if (!in_array($this->container['trainingStatus'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("Unevaluated", "Evaluating", "Evaluated", "Error");
        if (!in_array($this->container['evaluationStatus'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets domain
     * @return \PureCloudSDK\NluDomain
     */
    public function getDomain()
    {
        return $this->container['domain'];
    }

    /**
     * Sets domain
     * @param \PureCloudSDK\NluDomain $domain The NLU domain of the version.
     * @return $this
     */
    public function setDomain($domain)
    {
        $this->container['domain'] = $domain;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description The description of the NLU domain version.
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets language
     * @return string
     */
    public function getLanguage()
    {
        return $this->container['language'];
    }

    /**
     * Sets language
     * @param string $language The language that the NLU domain version supports.
     * @return $this
     */
    public function setLanguage($language)
    {
        $this->container['language'] = $language;

        return $this;
    }

    /**
     * Gets published
     * @return bool
     */
    public function getPublished()
    {
        return $this->container['published'];
    }

    /**
     * Sets published
     * @param bool $published Whether this NLU domain version has been published.
     * @return $this
     */
    public function setPublished($published)
    {
        $this->container['published'] = $published;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param \DateTime $dateCreated The date when the NLU domain version was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets dateModified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['dateModified'];
    }

    /**
     * Sets dateModified
     * @param \DateTime $dateModified The date when the NLU domain version was updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($dateModified)
    {
        $this->container['dateModified'] = $dateModified;

        return $this;
    }

    /**
     * Gets dateTrained
     * @return \DateTime
     */
    public function getDateTrained()
    {
        return $this->container['dateTrained'];
    }

    /**
     * Sets dateTrained
     * @param \DateTime $dateTrained The date when the NLU domain version was trained. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateTrained($dateTrained)
    {
        $this->container['dateTrained'] = $dateTrained;

        return $this;
    }

    /**
     * Gets datePublished
     * @return \DateTime
     */
    public function getDatePublished()
    {
        return $this->container['datePublished'];
    }

    /**
     * Sets datePublished
     * @param \DateTime $datePublished The date when the NLU domain version was published. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDatePublished($datePublished)
    {
        $this->container['datePublished'] = $datePublished;

        return $this;
    }

    /**
     * Gets trainingStatus
     * @return string
     */
    public function getTrainingStatus()
    {
        return $this->container['trainingStatus'];
    }

    /**
     * Sets trainingStatus
     * @param string $trainingStatus The training status of the NLU domain version.
     * @return $this
     */
    public function setTrainingStatus($trainingStatus)
    {
        $allowed_values = array('Untrained', 'Training', 'Trained', 'Error', 'Unknown');
        if (!in_array($trainingStatus, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'trainingStatus', must be one of 'Untrained', 'Training', 'Trained', 'Error', 'Unknown'");
        }
        $this->container['trainingStatus'] = $trainingStatus;

        return $this;
    }

    /**
     * Gets evaluationStatus
     * @return string
     */
    public function getEvaluationStatus()
    {
        return $this->container['evaluationStatus'];
    }

    /**
     * Sets evaluationStatus
     * @param string $evaluationStatus The evaluation status of the NLU domain version.
     * @return $this
     */
    public function setEvaluationStatus($evaluationStatus)
    {
        $allowed_values = array('Unevaluated', 'Evaluating', 'Evaluated', 'Error');
        if (!in_array($evaluationStatus, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'evaluationStatus', must be one of 'Unevaluated', 'Evaluating', 'Evaluated', 'Error'");
        }
        $this->container['evaluationStatus'] = $evaluationStatus;

        return $this;
    }

    /**
     * Gets intents
     * @return \PureCloudSDK\IntentDefinition[]
     */
    public function getIntents()
    {
        return $this->container['intents'];
    }

    /**
     * Sets intents
     * @param \PureCloudSDK\IntentDefinition[] $intents The intents defined for this NLU domain version.
     * @return $this
     */
    public function setIntents($intents)
    {
        $this->container['intents'] = $intents;

        return $this;
    }

    /**
     * Gets entityTypes
     * @return \PureCloudSDK\NamedEntityTypeDefinition[]
     */
    public function getEntityTypes()
    {
        return $this->container['entityTypes'];
    }

    /**
     * Sets entityTypes
     * @param \PureCloudSDK\NamedEntityTypeDefinition[] $entityTypes The entity types defined for this NLU domain version.
     * @return $this
     */
    public function setEntityTypes($entityTypes)
    {
        $this->container['entityTypes'] = $entityTypes;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
