<?php

/**
 * OAuthClientRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * OAuthClientRequest Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class OAuthClientRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'OAuthClientRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'name' => 'string',
        'accessTokenValiditySeconds' => 'int',
        'description' => 'string',
        'registeredRedirectUri' => 'string[]',
        'roleIds' => 'string[]',
        'authorizedGrantType' => 'string',
        'scope' => 'string[]',
        'roleDivisions' => '\PureCloudSDK\RoleDivision[]',
        'state' => 'string',
        'dateToDelete' => '\DateTime'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'name' => 'name',
        'accessTokenValiditySeconds' => 'accessTokenValiditySeconds',
        'description' => 'description',
        'registeredRedirectUri' => 'registeredRedirectUri',
        'roleIds' => 'roleIds',
        'authorizedGrantType' => 'authorizedGrantType',
        'scope' => 'scope',
        'roleDivisions' => 'roleDivisions',
        'state' => 'state',
        'dateToDelete' => 'dateToDelete'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'name' => 'setName',
        'accessTokenValiditySeconds' => 'setAccessTokenValiditySeconds',
        'description' => 'setDescription',
        'registeredRedirectUri' => 'setRegisteredRedirectUri',
        'roleIds' => 'setRoleIds',
        'authorizedGrantType' => 'setAuthorizedGrantType',
        'scope' => 'setScope',
        'roleDivisions' => 'setRoleDivisions',
        'state' => 'setState',
        'dateToDelete' => 'setDateToDelete'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'name' => 'getName',
        'accessTokenValiditySeconds' => 'getAccessTokenValiditySeconds',
        'description' => 'getDescription',
        'registeredRedirectUri' => 'getRegisteredRedirectUri',
        'roleIds' => 'getRoleIds',
        'authorizedGrantType' => 'getAuthorizedGrantType',
        'scope' => 'getScope',
        'roleDivisions' => 'getRoleDivisions',
        'state' => 'getState',
        'dateToDelete' => 'getDateToDelete'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const AUTHORIZED_GRANT_TYPE_CODE = 'CODE';
    public const AUTHORIZED_GRANT_TYPE_TOKEN = 'TOKEN';
    public const AUTHORIZED_GRANT_TYPE_SAML2_BEARER = 'SAML2BEARER';
    public const AUTHORIZED_GRANT_TYPE_PASSWORD = 'PASSWORD';
    public const AUTHORIZED_GRANT_TYPE_CLIENT_CREDENTIALS = 'CLIENT_CREDENTIALS';
    public const STATE_ACTIVE = 'active';
    public const STATE_DISABLED = 'disabled';
    public const STATE_INACTIVE = 'inactive';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getAuthorizedGrantTypeAllowableValues()
    {
        return [
            self::AUTHORIZED_GRANT_TYPE_CODE,
            self::AUTHORIZED_GRANT_TYPE_TOKEN,
            self::AUTHORIZED_GRANT_TYPE_SAML2_BEARER,
            self::AUTHORIZED_GRANT_TYPE_PASSWORD,
            self::AUTHORIZED_GRANT_TYPE_CLIENT_CREDENTIALS,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ACTIVE,
            self::STATE_DISABLED,
            self::STATE_INACTIVE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['accessTokenValiditySeconds'] = isset($data['accessTokenValiditySeconds']) ? $data['accessTokenValiditySeconds'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['registeredRedirectUri'] = isset($data['registeredRedirectUri']) ? $data['registeredRedirectUri'] : null;
        $this->container['roleIds'] = isset($data['roleIds']) ? $data['roleIds'] : null;
        $this->container['authorizedGrantType'] = isset($data['authorizedGrantType']) ? $data['authorizedGrantType'] : null;
        $this->container['scope'] = isset($data['scope']) ? $data['scope'] : null;
        $this->container['roleDivisions'] = isset($data['roleDivisions']) ? $data['roleDivisions'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['dateToDelete'] = isset($data['dateToDelete']) ? $data['dateToDelete'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        if ($this->container['authorizedGrantType'] === null) {
            $invalid_properties[] = "'authorizedGrantType' can't be null";
        }
        $allowed_values = array("CODE", "TOKEN", "SAML2BEARER", "PASSWORD", "CLIENT_CREDENTIALS");
        if (!in_array($this->container['authorizedGrantType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'authorizedGrantType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("active", "disabled", "inactive");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        if ($this->container['authorizedGrantType'] === null) {
            return false;
        }
        $allowed_values = array("CODE", "TOKEN", "SAML2BEARER", "PASSWORD", "CLIENT_CREDENTIALS");
        if (!in_array($this->container['authorizedGrantType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("active", "disabled", "inactive");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The name of the OAuth client.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets accessTokenValiditySeconds
     * @return int
     */
    public function getAccessTokenValiditySeconds()
    {
        return $this->container['accessTokenValiditySeconds'];
    }

    /**
     * Sets accessTokenValiditySeconds
     * @param int $accessTokenValiditySeconds The number of seconds, between 5mins and 48hrs, until tokens created with this client expire. If this field is omitted, a default of 24 hours will be applied.
     * @return $this
     */
    public function setAccessTokenValiditySeconds($accessTokenValiditySeconds)
    {
        $this->container['accessTokenValiditySeconds'] = $accessTokenValiditySeconds;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets registeredRedirectUri
     * @return string[]
     */
    public function getRegisteredRedirectUri()
    {
        return $this->container['registeredRedirectUri'];
    }

    /**
     * Sets registeredRedirectUri
     * @param string[] $registeredRedirectUri List of allowed callbacks for this client. For example: https://myap.example.com/auth/callback
     * @return $this
     */
    public function setRegisteredRedirectUri($registeredRedirectUri)
    {
        $this->container['registeredRedirectUri'] = $registeredRedirectUri;

        return $this;
    }

    /**
     * Gets roleIds
     * @return string[]
     */
    public function getRoleIds()
    {
        return $this->container['roleIds'];
    }

    /**
     * Sets roleIds
     * @param string[] $roleIds Deprecated. Use roleDivisions instead.
     * @return $this
     */
    public function setRoleIds($roleIds)
    {
        $this->container['roleIds'] = $roleIds;

        return $this;
    }

    /**
     * Gets authorizedGrantType
     * @return string
     */
    public function getAuthorizedGrantType()
    {
        return $this->container['authorizedGrantType'];
    }

    /**
     * Sets authorizedGrantType
     * @param string $authorizedGrantType The OAuth Grant/Client type supported by this client. Code Authorization Grant/Client type - Preferred client type where the Client ID and Secret are required to create tokens. Used where the secret can be secured. Implicit grant type - Client ID only is required to create tokens. Used in browser and mobile apps where the secret can not be secured. SAML2-Bearer extension grant type - SAML2 assertion provider for user authentication at the token endpoint. Client Credential grant type - Used to created access tokens that are tied only to the client.
     * @return $this
     */
    public function setAuthorizedGrantType($authorizedGrantType)
    {
        $allowed_values = array('CODE', 'TOKEN', 'SAML2BEARER', 'PASSWORD', 'CLIENT_CREDENTIALS');
        if (!in_array($authorizedGrantType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'authorizedGrantType', must be one of 'CODE', 'TOKEN', 'SAML2BEARER', 'PASSWORD', 'CLIENT_CREDENTIALS'");
        }
        $this->container['authorizedGrantType'] = $authorizedGrantType;

        return $this;
    }

    /**
     * Gets scope
     * @return string[]
     */
    public function getScope()
    {
        return $this->container['scope'];
    }

    /**
     * Sets scope
     * @param string[] $scope The scope requested by this client. Scopes only apply to clients not using the client_credential grant
     * @return $this
     */
    public function setScope($scope)
    {
        $this->container['scope'] = $scope;

        return $this;
    }

    /**
     * Gets roleDivisions
     * @return \PureCloudSDK\RoleDivision[]
     */
    public function getRoleDivisions()
    {
        return $this->container['roleDivisions'];
    }

    /**
     * Sets roleDivisions
     * @param \PureCloudSDK\RoleDivision[] $roleDivisions Set of roles and their corresponding divisions associated with this client. Roles and divisions only apply to clients using the client_credential grant
     * @return $this
     */
    public function setRoleDivisions($roleDivisions)
    {
        $this->container['roleDivisions'] = $roleDivisions;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state The state of the OAuth client. Active: The OAuth client can be used to create access tokens. This is the default state. Disabled: Access tokens created by the client are invalid and new ones cannot be created. Inactive: Access tokens cannot be created with this OAuth client and it will be deleted.
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('active', 'disabled', 'inactive');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'active', 'disabled', 'inactive'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets dateToDelete
     * @return \DateTime
     */
    public function getDateToDelete()
    {
        return $this->container['dateToDelete'];
    }

    /**
     * Sets dateToDelete
     * @param \DateTime $dateToDelete The time at which this client will be deleted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateToDelete($dateToDelete)
    {
        $this->container['dateToDelete'] = $dateToDelete;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
