<?php

/**
 * Organization
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * Organization Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Organization implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Organization';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'defaultLanguage' => 'string',
        'defaultCountryCode' => 'string',
        'thirdPartyOrgName' => 'string',
        'thirdPartyURI' => 'string',
        'domain' => 'string',
        'version' => 'int',
        'state' => 'string',
        'defaultSiteId' => 'string',
        'supportURI' => 'string',
        'voicemailEnabled' => 'bool',
        'productPlatform' => 'string',
        'selfUri' => 'string',
        'features' => 'map[string,bool]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'defaultLanguage' => 'defaultLanguage',
        'defaultCountryCode' => 'defaultCountryCode',
        'thirdPartyOrgName' => 'thirdPartyOrgName',
        'thirdPartyURI' => 'thirdPartyURI',
        'domain' => 'domain',
        'version' => 'version',
        'state' => 'state',
        'defaultSiteId' => 'defaultSiteId',
        'supportURI' => 'supportURI',
        'voicemailEnabled' => 'voicemailEnabled',
        'productPlatform' => 'productPlatform',
        'selfUri' => 'selfUri',
        'features' => 'features'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'defaultLanguage' => 'setDefaultLanguage',
        'defaultCountryCode' => 'setDefaultCountryCode',
        'thirdPartyOrgName' => 'setThirdPartyOrgName',
        'thirdPartyURI' => 'setThirdPartyURI',
        'domain' => 'setDomain',
        'version' => 'setVersion',
        'state' => 'setState',
        'defaultSiteId' => 'setDefaultSiteId',
        'supportURI' => 'setSupportURI',
        'voicemailEnabled' => 'setVoicemailEnabled',
        'productPlatform' => 'setProductPlatform',
        'selfUri' => 'setSelfUri',
        'features' => 'setFeatures'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'defaultLanguage' => 'getDefaultLanguage',
        'defaultCountryCode' => 'getDefaultCountryCode',
        'thirdPartyOrgName' => 'getThirdPartyOrgName',
        'thirdPartyURI' => 'getThirdPartyURI',
        'domain' => 'getDomain',
        'version' => 'getVersion',
        'state' => 'getState',
        'defaultSiteId' => 'getDefaultSiteId',
        'supportURI' => 'getSupportURI',
        'voicemailEnabled' => 'getVoicemailEnabled',
        'productPlatform' => 'getProductPlatform',
        'selfUri' => 'getSelfUri',
        'features' => 'getFeatures'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const STATE_ACTIVE = 'active';
    public const STATE_INACTIVE = 'inactive';
    public const STATE_DELETED = 'deleted';
    public const PRODUCT_PLATFORM_PURE_CLOUD = 'PureCloud';
    public const PRODUCT_PLATFORM_PURE_ENGAGE = 'PureEngage';
    public const PRODUCT_PLATFORM_PURE_ENGAGE_CLOUD = 'PureEngageCloud';
    public const PRODUCT_PLATFORM_PURE_CONNECT = 'PureConnect';
    public const PRODUCT_PLATFORM_PURE_CONNECT_CLOUD = 'PureConnectCloud';
    public const PRODUCT_PLATFORM_UNKNOWN = 'Unknown';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ACTIVE,
            self::STATE_INACTIVE,
            self::STATE_DELETED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getProductPlatformAllowableValues()
    {
        return [
            self::PRODUCT_PLATFORM_PURE_CLOUD,
            self::PRODUCT_PLATFORM_PURE_ENGAGE,
            self::PRODUCT_PLATFORM_PURE_ENGAGE_CLOUD,
            self::PRODUCT_PLATFORM_PURE_CONNECT,
            self::PRODUCT_PLATFORM_PURE_CONNECT_CLOUD,
            self::PRODUCT_PLATFORM_UNKNOWN,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['defaultLanguage'] = isset($data['defaultLanguage']) ? $data['defaultLanguage'] : null;
        $this->container['defaultCountryCode'] = isset($data['defaultCountryCode']) ? $data['defaultCountryCode'] : null;
        $this->container['thirdPartyOrgName'] = isset($data['thirdPartyOrgName']) ? $data['thirdPartyOrgName'] : null;
        $this->container['thirdPartyURI'] = isset($data['thirdPartyURI']) ? $data['thirdPartyURI'] : null;
        $this->container['domain'] = isset($data['domain']) ? $data['domain'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['defaultSiteId'] = isset($data['defaultSiteId']) ? $data['defaultSiteId'] : null;
        $this->container['supportURI'] = isset($data['supportURI']) ? $data['supportURI'] : null;
        $this->container['voicemailEnabled'] = isset($data['voicemailEnabled']) ? $data['voicemailEnabled'] : null;
        $this->container['productPlatform'] = isset($data['productPlatform']) ? $data['productPlatform'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
        $this->container['features'] = isset($data['features']) ? $data['features'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['version'] === null) {
            $invalid_properties[] = "'version' can't be null";
        }
        $allowed_values = array("active", "inactive", "deleted");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        $allowed_values = array("PureCloud", "PureEngage", "PureEngageCloud", "PureConnect", "PureConnectCloud", "Unknown");
        if (!in_array($this->container['productPlatform'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'productPlatform', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['version'] === null) {
            return false;
        }
        $allowed_values = array("active", "inactive", "deleted");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("PureCloud", "PureEngage", "PureEngageCloud", "PureConnect", "PureConnectCloud", "Unknown");
        if (!in_array($this->container['productPlatform'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets defaultLanguage
     * @return string
     */
    public function getDefaultLanguage()
    {
        return $this->container['defaultLanguage'];
    }

    /**
     * Sets defaultLanguage
     * @param string $defaultLanguage The default language for this organization. Example: 'en'
     * @return $this
     */
    public function setDefaultLanguage($defaultLanguage)
    {
        $this->container['defaultLanguage'] = $defaultLanguage;

        return $this;
    }

    /**
     * Gets defaultCountryCode
     * @return string
     */
    public function getDefaultCountryCode()
    {
        return $this->container['defaultCountryCode'];
    }

    /**
     * Sets defaultCountryCode
     * @param string $defaultCountryCode The default country code for this organization. Example: 'US'
     * @return $this
     */
    public function setDefaultCountryCode($defaultCountryCode)
    {
        $this->container['defaultCountryCode'] = $defaultCountryCode;

        return $this;
    }

    /**
     * Gets thirdPartyOrgName
     * @return string
     */
    public function getThirdPartyOrgName()
    {
        return $this->container['thirdPartyOrgName'];
    }

    /**
     * Sets thirdPartyOrgName
     * @param string $thirdPartyOrgName The short name for the organization. This field is globally unique and cannot be changed.
     * @return $this
     */
    public function setThirdPartyOrgName($thirdPartyOrgName)
    {
        $this->container['thirdPartyOrgName'] = $thirdPartyOrgName;

        return $this;
    }

    /**
     * Gets thirdPartyURI
     * @return string
     */
    public function getThirdPartyURI()
    {
        return $this->container['thirdPartyURI'];
    }

    /**
     * Sets thirdPartyURI
     * @param string $thirdPartyURI
     * @return $this
     */
    public function setThirdPartyURI($thirdPartyURI)
    {
        $this->container['thirdPartyURI'] = $thirdPartyURI;

        return $this;
    }

    /**
     * Gets domain
     * @return string
     */
    public function getDomain()
    {
        return $this->container['domain'];
    }

    /**
     * Sets domain
     * @param string $domain
     * @return $this
     */
    public function setDomain($domain)
    {
        $this->container['domain'] = $domain;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version The current version of the organization.
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state The current state. Examples are active, inactive, deleted.
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('active', 'inactive', 'deleted');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'active', 'inactive', 'deleted'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets defaultSiteId
     * @return string
     */
    public function getDefaultSiteId()
    {
        return $this->container['defaultSiteId'];
    }

    /**
     * Sets defaultSiteId
     * @param string $defaultSiteId
     * @return $this
     */
    public function setDefaultSiteId($defaultSiteId)
    {
        $this->container['defaultSiteId'] = $defaultSiteId;

        return $this;
    }

    /**
     * Gets supportURI
     * @return string
     */
    public function getSupportURI()
    {
        return $this->container['supportURI'];
    }

    /**
     * Sets supportURI
     * @param string $supportURI Email address where support tickets are sent to.
     * @return $this
     */
    public function setSupportURI($supportURI)
    {
        $this->container['supportURI'] = $supportURI;

        return $this;
    }

    /**
     * Gets voicemailEnabled
     * @return bool
     */
    public function getVoicemailEnabled()
    {
        return $this->container['voicemailEnabled'];
    }

    /**
     * Sets voicemailEnabled
     * @param bool $voicemailEnabled
     * @return $this
     */
    public function setVoicemailEnabled($voicemailEnabled)
    {
        $this->container['voicemailEnabled'] = $voicemailEnabled;

        return $this;
    }

    /**
     * Gets productPlatform
     * @return string
     */
    public function getProductPlatform()
    {
        return $this->container['productPlatform'];
    }

    /**
     * Sets productPlatform
     * @param string $productPlatform Organizations Originating Platform.
     * @return $this
     */
    public function setProductPlatform($productPlatform)
    {
        $allowed_values = array('PureCloud', 'PureEngage', 'PureEngageCloud', 'PureConnect', 'PureConnectCloud', 'Unknown');
        if (!in_array($productPlatform, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'productPlatform', must be one of 'PureCloud', 'PureEngage', 'PureEngageCloud', 'PureConnect', 'PureConnectCloud', 'Unknown'");
        }
        $this->container['productPlatform'] = $productPlatform;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }

    /**
     * Gets features
     * @return map[string,bool]
     */
    public function getFeatures()
    {
        return $this->container['features'];
    }

    /**
     * Sets features
     * @param map[string,bool] $features The state of features available for the organization.
     * @return $this
     */
    public function setFeatures($features)
    {
        $this->container['features'] = $features;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
