<?php

/**
 * SegmentDetailQueryPredicate
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * SegmentDetailQueryPredicate Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class SegmentDetailQueryPredicate implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'SegmentDetailQueryPredicate';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'type' => 'string',
        'dimension' => 'string',
        'propertyType' => 'string',
        'property' => 'string',
        'metric' => 'string',
        'operator' => 'string',
        'value' => 'string',
        'range' => '\PureCloudSDK\NumericRange'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'type' => 'type',
        'dimension' => 'dimension',
        'propertyType' => 'propertyType',
        'property' => 'property',
        'metric' => 'metric',
        'operator' => 'operator',
        'value' => 'value',
        'range' => 'range'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'type' => 'setType',
        'dimension' => 'setDimension',
        'propertyType' => 'setPropertyType',
        'property' => 'setProperty',
        'metric' => 'setMetric',
        'operator' => 'setOperator',
        'value' => 'setValue',
        'range' => 'setRange'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'type' => 'getType',
        'dimension' => 'getDimension',
        'propertyType' => 'getPropertyType',
        'property' => 'getProperty',
        'metric' => 'getMetric',
        'operator' => 'getOperator',
        'value' => 'getValue',
        'range' => 'getRange'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const TYPE_DIMENSION = 'dimension';
    public const TYPE_PROPERTY = 'property';
    public const TYPE_METRIC = 'metric';
    public const DIMENSION_ADDRESS_FROM = 'addressFrom';
    public const DIMENSION_ADDRESS_OTHER = 'addressOther';
    public const DIMENSION_ADDRESS_SELF = 'addressSelf';
    public const DIMENSION_ADDRESS_TO = 'addressTo';
    public const DIMENSION_AGENT_ASSISTANT_ID = 'agentAssistantId';
    public const DIMENSION_AGENT_RANK = 'agentRank';
    public const DIMENSION_AGENT_SCORE = 'agentScore';
    public const DIMENSION_ANI = 'ani';
    public const DIMENSION_AUDIO_MUTED = 'audioMuted';
    public const DIMENSION_CALLBACK_NUMBER = 'callbackNumber';
    public const DIMENSION_CALLBACK_SCHEDULED_TIME = 'callbackScheduledTime';
    public const DIMENSION_CALLBACK_USER_NAME = 'callbackUserName';
    public const DIMENSION_COBROWSE_ROLE = 'cobrowseRole';
    public const DIMENSION_COBROWSE_ROOM_ID = 'cobrowseRoomId';
    public const DIMENSION_CONFERENCE = 'conference';
    public const DIMENSION_DESTINATION_CONVERSATION_ID = 'destinationConversationId';
    public const DIMENSION_DESTINATION_SESSION_ID = 'destinationSessionId';
    public const DIMENSION_DIRECTION = 'direction';
    public const DIMENSION_DISCONNECT_TYPE = 'disconnectType';
    public const DIMENSION_DISPOSITION_ANALYZER = 'dispositionAnalyzer';
    public const DIMENSION_DISPOSITION_NAME = 'dispositionName';
    public const DIMENSION_DNIS = 'dnis';
    public const DIMENSION_EDGE_ID = 'edgeId';
    public const DIMENSION_ENDING_LANGUAGE = 'endingLanguage';
    public const DIMENSION_ENTRY_REASON = 'entryReason';
    public const DIMENSION_ENTRY_TYPE = 'entryType';
    public const DIMENSION_ERROR_CODE = 'errorCode';
    public const DIMENSION_EXIT_REASON = 'exitReason';
    public const DIMENSION_EXTERNAL_CONTACT_ID = 'externalContactId';
    public const DIMENSION_EXTERNAL_ORGANIZATION_ID = 'externalOrganizationId';
    public const DIMENSION_FLAGGED_REASON = 'flaggedReason';
    public const DIMENSION_FLOW_ID = 'flowId';
    public const DIMENSION_FLOW_NAME = 'flowName';
    public const DIMENSION_FLOW_OUT_TYPE = 'flowOutType';
    public const DIMENSION_FLOW_OUTCOME = 'flowOutcome';
    public const DIMENSION_FLOW_OUTCOME_END_TIMESTAMP = 'flowOutcomeEndTimestamp';
    public const DIMENSION_FLOW_OUTCOME_ID = 'flowOutcomeId';
    public const DIMENSION_FLOW_OUTCOME_START_TIMESTAMP = 'flowOutcomeStartTimestamp';
    public const DIMENSION_FLOW_OUTCOME_VALUE = 'flowOutcomeValue';
    public const DIMENSION_FLOW_TYPE = 'flowType';
    public const DIMENSION_FLOW_VERSION = 'flowVersion';
    public const DIMENSION_GROUP_ID = 'groupId';
    public const DIMENSION_ISSUED_CALLBACK = 'issuedCallback';
    public const DIMENSION_JOURNEY_ACTION_ID = 'journeyActionId';
    public const DIMENSION_JOURNEY_ACTION_MAP_ID = 'journeyActionMapId';
    public const DIMENSION_JOURNEY_ACTION_MAP_VERSION = 'journeyActionMapVersion';
    public const DIMENSION_JOURNEY_CUSTOMER_ID = 'journeyCustomerId';
    public const DIMENSION_JOURNEY_CUSTOMER_ID_TYPE = 'journeyCustomerIdType';
    public const DIMENSION_JOURNEY_CUSTOMER_SESSION_ID = 'journeyCustomerSessionId';
    public const DIMENSION_JOURNEY_CUSTOMER_SESSION_ID_TYPE = 'journeyCustomerSessionIdType';
    public const DIMENSION_JOURNEY_SEGMENT_SCOPE = 'journeySegmentScope';
    public const DIMENSION_MEDIA_BRIDGE_ID = 'mediaBridgeId';
    public const DIMENSION_MEDIA_COUNT = 'mediaCount';
    public const DIMENSION_MEDIA_TYPE = 'mediaType';
    public const DIMENSION_MESSAGE_TYPE = 'messageType';
    public const DIMENSION_MONITORED_PARTICIPANT_ID = 'monitoredParticipantId';
    public const DIMENSION_OUTBOUND_CAMPAIGN_ID = 'outboundCampaignId';
    public const DIMENSION_OUTBOUND_CONTACT_ID = 'outboundContactId';
    public const DIMENSION_OUTBOUND_CONTACT_LIST_ID = 'outboundContactListId';
    public const DIMENSION_PARTICIPANT_ID = 'participantId';
    public const DIMENSION_PARTICIPANT_NAME = 'participantName';
    public const DIMENSION_PEER_ID = 'peerId';
    public const DIMENSION_PROPOSED_AGENT_ID = 'proposedAgentId';
    public const DIMENSION_PROTOCOL_CALL_ID = 'protocolCallId';
    public const DIMENSION_PROVIDER = 'provider';
    public const DIMENSION_PURPOSE = 'purpose';
    public const DIMENSION_Q850_RESPONSE_CODE = 'q850ResponseCode';
    public const DIMENSION_QUEUE_ID = 'queueId';
    public const DIMENSION_RECORDING = 'recording';
    public const DIMENSION_REMOTE = 'remote';
    public const DIMENSION_REMOTE_NAME_DISPLAYABLE = 'remoteNameDisplayable';
    public const DIMENSION_REQUESTED_LANGUAGE_ID = 'requestedLanguageId';
    public const DIMENSION_REQUESTED_ROUTING = 'requestedRouting';
    public const DIMENSION_REQUESTED_ROUTING_SKILL_ID = 'requestedRoutingSkillId';
    public const DIMENSION_REQUESTED_ROUTING_USER_ID = 'requestedRoutingUserId';
    public const DIMENSION_ROOM_ID = 'roomId';
    public const DIMENSION_SCORED_AGENT_ID = 'scoredAgentId';
    public const DIMENSION_SCREEN_SHARE_ADDRESS_SELF = 'screenShareAddressSelf';
    public const DIMENSION_SCREEN_SHARE_ROOM_ID = 'screenShareRoomId';
    public const DIMENSION_SCRIPT_ID = 'scriptId';
    public const DIMENSION_SEGMENT_END = 'segmentEnd';
    public const DIMENSION_SEGMENT_TYPE = 'segmentType';
    public const DIMENSION_SELECTED_AGENT_ID = 'selectedAgentId';
    public const DIMENSION_SELECTED_AGENT_RANK = 'selectedAgentRank';
    public const DIMENSION_SESSION_DNIS = 'sessionDnis';
    public const DIMENSION_SESSION_ID = 'sessionId';
    public const DIMENSION_SHARING_SCREEN = 'sharingScreen';
    public const DIMENSION_SIP_RESPONSE_CODE = 'sipResponseCode';
    public const DIMENSION_SKIP_ENABLED = 'skipEnabled';
    public const DIMENSION_SOURCE_CONVERSATION_ID = 'sourceConversationId';
    public const DIMENSION_SOURCE_SESSION_ID = 'sourceSessionId';
    public const DIMENSION_STARTING_LANGUAGE = 'startingLanguage';
    public const DIMENSION_SUBJECT = 'subject';
    public const DIMENSION_TEAM_ID = 'teamId';
    public const DIMENSION_TIMEOUT_SECONDS = 'timeoutSeconds';
    public const DIMENSION_TRANSFER_TARGET_ADDRESS = 'transferTargetAddress';
    public const DIMENSION_TRANSFER_TARGET_NAME = 'transferTargetName';
    public const DIMENSION_TRANSFER_TYPE = 'transferType';
    public const DIMENSION_USED_ROUTING = 'usedRouting';
    public const DIMENSION_USER_ID = 'userId';
    public const DIMENSION_VIDEO_ADDRESS_SELF = 'videoAddressSelf';
    public const DIMENSION_VIDEO_MUTED = 'videoMuted';
    public const DIMENSION_VIDEO_ROOM_ID = 'videoRoomId';
    public const DIMENSION_WRAP_UP_CODE = 'wrapUpCode';
    public const DIMENSION_WRAP_UP_NOTE = 'wrapUpNote';
    public const DIMENSION_WRAP_UP_TAG = 'wrapUpTag';
    public const PROPERTY_TYPE_BOOL = 'bool';
    public const PROPERTY_TYPE_INTEGER = 'integer';
    public const PROPERTY_TYPE_REAL = 'real';
    public const PROPERTY_TYPE_DATE = 'date';
    public const PROPERTY_TYPE_STRING = 'string';
    public const PROPERTY_TYPE_UUID = 'uuid';
    public const METRIC_T_SEGMENT_DURATION = 'tSegmentDuration';
    public const OPERATOR_MATCHES = 'matches';
    public const OPERATOR_EXISTS = 'exists';
    public const OPERATOR_NOT_EXISTS = 'notExists';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_DIMENSION,
            self::TYPE_PROPERTY,
            self::TYPE_METRIC,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDimensionAllowableValues()
    {
        return [
            self::DIMENSION_ADDRESS_FROM,
            self::DIMENSION_ADDRESS_OTHER,
            self::DIMENSION_ADDRESS_SELF,
            self::DIMENSION_ADDRESS_TO,
            self::DIMENSION_AGENT_ASSISTANT_ID,
            self::DIMENSION_AGENT_RANK,
            self::DIMENSION_AGENT_SCORE,
            self::DIMENSION_ANI,
            self::DIMENSION_AUDIO_MUTED,
            self::DIMENSION_CALLBACK_NUMBER,
            self::DIMENSION_CALLBACK_SCHEDULED_TIME,
            self::DIMENSION_CALLBACK_USER_NAME,
            self::DIMENSION_COBROWSE_ROLE,
            self::DIMENSION_COBROWSE_ROOM_ID,
            self::DIMENSION_CONFERENCE,
            self::DIMENSION_DESTINATION_CONVERSATION_ID,
            self::DIMENSION_DESTINATION_SESSION_ID,
            self::DIMENSION_DIRECTION,
            self::DIMENSION_DISCONNECT_TYPE,
            self::DIMENSION_DISPOSITION_ANALYZER,
            self::DIMENSION_DISPOSITION_NAME,
            self::DIMENSION_DNIS,
            self::DIMENSION_EDGE_ID,
            self::DIMENSION_ENDING_LANGUAGE,
            self::DIMENSION_ENTRY_REASON,
            self::DIMENSION_ENTRY_TYPE,
            self::DIMENSION_ERROR_CODE,
            self::DIMENSION_EXIT_REASON,
            self::DIMENSION_EXTERNAL_CONTACT_ID,
            self::DIMENSION_EXTERNAL_ORGANIZATION_ID,
            self::DIMENSION_FLAGGED_REASON,
            self::DIMENSION_FLOW_ID,
            self::DIMENSION_FLOW_NAME,
            self::DIMENSION_FLOW_OUT_TYPE,
            self::DIMENSION_FLOW_OUTCOME,
            self::DIMENSION_FLOW_OUTCOME_END_TIMESTAMP,
            self::DIMENSION_FLOW_OUTCOME_ID,
            self::DIMENSION_FLOW_OUTCOME_START_TIMESTAMP,
            self::DIMENSION_FLOW_OUTCOME_VALUE,
            self::DIMENSION_FLOW_TYPE,
            self::DIMENSION_FLOW_VERSION,
            self::DIMENSION_GROUP_ID,
            self::DIMENSION_ISSUED_CALLBACK,
            self::DIMENSION_JOURNEY_ACTION_ID,
            self::DIMENSION_JOURNEY_ACTION_MAP_ID,
            self::DIMENSION_JOURNEY_ACTION_MAP_VERSION,
            self::DIMENSION_JOURNEY_CUSTOMER_ID,
            self::DIMENSION_JOURNEY_CUSTOMER_ID_TYPE,
            self::DIMENSION_JOURNEY_CUSTOMER_SESSION_ID,
            self::DIMENSION_JOURNEY_CUSTOMER_SESSION_ID_TYPE,
            self::DIMENSION_JOURNEY_SEGMENT_SCOPE,
            self::DIMENSION_MEDIA_BRIDGE_ID,
            self::DIMENSION_MEDIA_COUNT,
            self::DIMENSION_MEDIA_TYPE,
            self::DIMENSION_MESSAGE_TYPE,
            self::DIMENSION_MONITORED_PARTICIPANT_ID,
            self::DIMENSION_OUTBOUND_CAMPAIGN_ID,
            self::DIMENSION_OUTBOUND_CONTACT_ID,
            self::DIMENSION_OUTBOUND_CONTACT_LIST_ID,
            self::DIMENSION_PARTICIPANT_ID,
            self::DIMENSION_PARTICIPANT_NAME,
            self::DIMENSION_PEER_ID,
            self::DIMENSION_PROPOSED_AGENT_ID,
            self::DIMENSION_PROTOCOL_CALL_ID,
            self::DIMENSION_PROVIDER,
            self::DIMENSION_PURPOSE,
            self::DIMENSION_Q850_RESPONSE_CODE,
            self::DIMENSION_QUEUE_ID,
            self::DIMENSION_RECORDING,
            self::DIMENSION_REMOTE,
            self::DIMENSION_REMOTE_NAME_DISPLAYABLE,
            self::DIMENSION_REQUESTED_LANGUAGE_ID,
            self::DIMENSION_REQUESTED_ROUTING,
            self::DIMENSION_REQUESTED_ROUTING_SKILL_ID,
            self::DIMENSION_REQUESTED_ROUTING_USER_ID,
            self::DIMENSION_ROOM_ID,
            self::DIMENSION_SCORED_AGENT_ID,
            self::DIMENSION_SCREEN_SHARE_ADDRESS_SELF,
            self::DIMENSION_SCREEN_SHARE_ROOM_ID,
            self::DIMENSION_SCRIPT_ID,
            self::DIMENSION_SEGMENT_END,
            self::DIMENSION_SEGMENT_TYPE,
            self::DIMENSION_SELECTED_AGENT_ID,
            self::DIMENSION_SELECTED_AGENT_RANK,
            self::DIMENSION_SESSION_DNIS,
            self::DIMENSION_SESSION_ID,
            self::DIMENSION_SHARING_SCREEN,
            self::DIMENSION_SIP_RESPONSE_CODE,
            self::DIMENSION_SKIP_ENABLED,
            self::DIMENSION_SOURCE_CONVERSATION_ID,
            self::DIMENSION_SOURCE_SESSION_ID,
            self::DIMENSION_STARTING_LANGUAGE,
            self::DIMENSION_SUBJECT,
            self::DIMENSION_TEAM_ID,
            self::DIMENSION_TIMEOUT_SECONDS,
            self::DIMENSION_TRANSFER_TARGET_ADDRESS,
            self::DIMENSION_TRANSFER_TARGET_NAME,
            self::DIMENSION_TRANSFER_TYPE,
            self::DIMENSION_USED_ROUTING,
            self::DIMENSION_USER_ID,
            self::DIMENSION_VIDEO_ADDRESS_SELF,
            self::DIMENSION_VIDEO_MUTED,
            self::DIMENSION_VIDEO_ROOM_ID,
            self::DIMENSION_WRAP_UP_CODE,
            self::DIMENSION_WRAP_UP_NOTE,
            self::DIMENSION_WRAP_UP_TAG,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getPropertyTypeAllowableValues()
    {
        return [
            self::PROPERTY_TYPE_BOOL,
            self::PROPERTY_TYPE_INTEGER,
            self::PROPERTY_TYPE_REAL,
            self::PROPERTY_TYPE_DATE,
            self::PROPERTY_TYPE_STRING,
            self::PROPERTY_TYPE_UUID,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMetricAllowableValues()
    {
        return [
            self::METRIC_T_SEGMENT_DURATION,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getOperatorAllowableValues()
    {
        return [
            self::OPERATOR_MATCHES,
            self::OPERATOR_EXISTS,
            self::OPERATOR_NOT_EXISTS,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['dimension'] = isset($data['dimension']) ? $data['dimension'] : null;
        $this->container['propertyType'] = isset($data['propertyType']) ? $data['propertyType'] : null;
        $this->container['property'] = isset($data['property']) ? $data['property'] : null;
        $this->container['metric'] = isset($data['metric']) ? $data['metric'] : null;
        $this->container['operator'] = isset($data['operator']) ? $data['operator'] : null;
        $this->container['value'] = isset($data['value']) ? $data['value'] : null;
        $this->container['range'] = isset($data['range']) ? $data['range'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("dimension", "property", "metric");
        if (!in_array($this->container['type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'type', must be one of #{allowed_values}.";
        }

        $allowed_values = array("addressFrom", "addressOther", "addressSelf", "addressTo", "agentAssistantId", "agentRank", "agentScore", "ani", "audioMuted", "callbackNumber", "callbackScheduledTime", "callbackUserName", "cobrowseRole", "cobrowseRoomId", "conference", "destinationConversationId", "destinationSessionId", "direction", "disconnectType", "dispositionAnalyzer", "dispositionName", "dnis", "edgeId", "endingLanguage", "entryReason", "entryType", "errorCode", "exitReason", "externalContactId", "externalOrganizationId", "flaggedReason", "flowId", "flowName", "flowOutType", "flowOutcome", "flowOutcomeEndTimestamp", "flowOutcomeId", "flowOutcomeStartTimestamp", "flowOutcomeValue", "flowType", "flowVersion", "groupId", "issuedCallback", "journeyActionId", "journeyActionMapId", "journeyActionMapVersion", "journeyCustomerId", "journeyCustomerIdType", "journeyCustomerSessionId", "journeyCustomerSessionIdType", "journeySegmentScope", "mediaBridgeId", "mediaCount", "mediaType", "messageType", "monitoredParticipantId", "outboundCampaignId", "outboundContactId", "outboundContactListId", "participantId", "participantName", "peerId", "proposedAgentId", "protocolCallId", "provider", "purpose", "q850ResponseCode", "queueId", "recording", "remote", "remoteNameDisplayable", "requestedLanguageId", "requestedRouting", "requestedRoutingSkillId", "requestedRoutingUserId", "roomId", "scoredAgentId", "screenShareAddressSelf", "screenShareRoomId", "scriptId", "segmentEnd", "segmentType", "selectedAgentId", "selectedAgentRank", "sessionDnis", "sessionId", "sharingScreen", "sipResponseCode", "skipEnabled", "sourceConversationId", "sourceSessionId", "startingLanguage", "subject", "teamId", "timeoutSeconds", "transferTargetAddress", "transferTargetName", "transferType", "usedRouting", "userId", "videoAddressSelf", "videoMuted", "videoRoomId", "wrapUpCode", "wrapUpNote", "wrapUpTag");
        if (!in_array($this->container['dimension'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'dimension', must be one of #{allowed_values}.";
        }

        $allowed_values = array("bool", "integer", "real", "date", "string", "uuid");
        if (!in_array($this->container['propertyType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'propertyType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("tSegmentDuration");
        if (!in_array($this->container['metric'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'metric', must be one of #{allowed_values}.";
        }

        $allowed_values = array("matches", "exists", "notExists");
        if (!in_array($this->container['operator'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'operator', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("dimension", "property", "metric");
        if (!in_array($this->container['type'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("addressFrom", "addressOther", "addressSelf", "addressTo", "agentAssistantId", "agentRank", "agentScore", "ani", "audioMuted", "callbackNumber", "callbackScheduledTime", "callbackUserName", "cobrowseRole", "cobrowseRoomId", "conference", "destinationConversationId", "destinationSessionId", "direction", "disconnectType", "dispositionAnalyzer", "dispositionName", "dnis", "edgeId", "endingLanguage", "entryReason", "entryType", "errorCode", "exitReason", "externalContactId", "externalOrganizationId", "flaggedReason", "flowId", "flowName", "flowOutType", "flowOutcome", "flowOutcomeEndTimestamp", "flowOutcomeId", "flowOutcomeStartTimestamp", "flowOutcomeValue", "flowType", "flowVersion", "groupId", "issuedCallback", "journeyActionId", "journeyActionMapId", "journeyActionMapVersion", "journeyCustomerId", "journeyCustomerIdType", "journeyCustomerSessionId", "journeyCustomerSessionIdType", "journeySegmentScope", "mediaBridgeId", "mediaCount", "mediaType", "messageType", "monitoredParticipantId", "outboundCampaignId", "outboundContactId", "outboundContactListId", "participantId", "participantName", "peerId", "proposedAgentId", "protocolCallId", "provider", "purpose", "q850ResponseCode", "queueId", "recording", "remote", "remoteNameDisplayable", "requestedLanguageId", "requestedRouting", "requestedRoutingSkillId", "requestedRoutingUserId", "roomId", "scoredAgentId", "screenShareAddressSelf", "screenShareRoomId", "scriptId", "segmentEnd", "segmentType", "selectedAgentId", "selectedAgentRank", "sessionDnis", "sessionId", "sharingScreen", "sipResponseCode", "skipEnabled", "sourceConversationId", "sourceSessionId", "startingLanguage", "subject", "teamId", "timeoutSeconds", "transferTargetAddress", "transferTargetName", "transferType", "usedRouting", "userId", "videoAddressSelf", "videoMuted", "videoRoomId", "wrapUpCode", "wrapUpNote", "wrapUpTag");
        if (!in_array($this->container['dimension'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("bool", "integer", "real", "date", "string", "uuid");
        if (!in_array($this->container['propertyType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("tSegmentDuration");
        if (!in_array($this->container['metric'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("matches", "exists", "notExists");
        if (!in_array($this->container['operator'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type Optional type, can usually be inferred
     * @return $this
     */
    public function setType($type)
    {
        $allowed_values = array('dimension', 'property', 'metric');
        if (!in_array($type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'type', must be one of 'dimension', 'property', 'metric'");
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets dimension
     * @return string
     */
    public function getDimension()
    {
        return $this->container['dimension'];
    }

    /**
     * Sets dimension
     * @param string $dimension Left hand side for dimension predicates
     * @return $this
     */
    public function setDimension($dimension)
    {
        $allowed_values = array('addressFrom', 'addressOther', 'addressSelf', 'addressTo', 'agentAssistantId', 'agentRank', 'agentScore', 'ani', 'audioMuted', 'callbackNumber', 'callbackScheduledTime', 'callbackUserName', 'cobrowseRole', 'cobrowseRoomId', 'conference', 'destinationConversationId', 'destinationSessionId', 'direction', 'disconnectType', 'dispositionAnalyzer', 'dispositionName', 'dnis', 'edgeId', 'endingLanguage', 'entryReason', 'entryType', 'errorCode', 'exitReason', 'externalContactId', 'externalOrganizationId', 'flaggedReason', 'flowId', 'flowName', 'flowOutType', 'flowOutcome', 'flowOutcomeEndTimestamp', 'flowOutcomeId', 'flowOutcomeStartTimestamp', 'flowOutcomeValue', 'flowType', 'flowVersion', 'groupId', 'issuedCallback', 'journeyActionId', 'journeyActionMapId', 'journeyActionMapVersion', 'journeyCustomerId', 'journeyCustomerIdType', 'journeyCustomerSessionId', 'journeyCustomerSessionIdType', 'journeySegmentScope', 'mediaBridgeId', 'mediaCount', 'mediaType', 'messageType', 'monitoredParticipantId', 'outboundCampaignId', 'outboundContactId', 'outboundContactListId', 'participantId', 'participantName', 'peerId', 'proposedAgentId', 'protocolCallId', 'provider', 'purpose', 'q850ResponseCode', 'queueId', 'recording', 'remote', 'remoteNameDisplayable', 'requestedLanguageId', 'requestedRouting', 'requestedRoutingSkillId', 'requestedRoutingUserId', 'roomId', 'scoredAgentId', 'screenShareAddressSelf', 'screenShareRoomId', 'scriptId', 'segmentEnd', 'segmentType', 'selectedAgentId', 'selectedAgentRank', 'sessionDnis', 'sessionId', 'sharingScreen', 'sipResponseCode', 'skipEnabled', 'sourceConversationId', 'sourceSessionId', 'startingLanguage', 'subject', 'teamId', 'timeoutSeconds', 'transferTargetAddress', 'transferTargetName', 'transferType', 'usedRouting', 'userId', 'videoAddressSelf', 'videoMuted', 'videoRoomId', 'wrapUpCode', 'wrapUpNote', 'wrapUpTag');
        if (!in_array($dimension, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'dimension', must be one of 'addressFrom', 'addressOther', 'addressSelf', 'addressTo', 'agentAssistantId', 'agentRank', 'agentScore', 'ani', 'audioMuted', 'callbackNumber', 'callbackScheduledTime', 'callbackUserName', 'cobrowseRole', 'cobrowseRoomId', 'conference', 'destinationConversationId', 'destinationSessionId', 'direction', 'disconnectType', 'dispositionAnalyzer', 'dispositionName', 'dnis', 'edgeId', 'endingLanguage', 'entryReason', 'entryType', 'errorCode', 'exitReason', 'externalContactId', 'externalOrganizationId', 'flaggedReason', 'flowId', 'flowName', 'flowOutType', 'flowOutcome', 'flowOutcomeEndTimestamp', 'flowOutcomeId', 'flowOutcomeStartTimestamp', 'flowOutcomeValue', 'flowType', 'flowVersion', 'groupId', 'issuedCallback', 'journeyActionId', 'journeyActionMapId', 'journeyActionMapVersion', 'journeyCustomerId', 'journeyCustomerIdType', 'journeyCustomerSessionId', 'journeyCustomerSessionIdType', 'journeySegmentScope', 'mediaBridgeId', 'mediaCount', 'mediaType', 'messageType', 'monitoredParticipantId', 'outboundCampaignId', 'outboundContactId', 'outboundContactListId', 'participantId', 'participantName', 'peerId', 'proposedAgentId', 'protocolCallId', 'provider', 'purpose', 'q850ResponseCode', 'queueId', 'recording', 'remote', 'remoteNameDisplayable', 'requestedLanguageId', 'requestedRouting', 'requestedRoutingSkillId', 'requestedRoutingUserId', 'roomId', 'scoredAgentId', 'screenShareAddressSelf', 'screenShareRoomId', 'scriptId', 'segmentEnd', 'segmentType', 'selectedAgentId', 'selectedAgentRank', 'sessionDnis', 'sessionId', 'sharingScreen', 'sipResponseCode', 'skipEnabled', 'sourceConversationId', 'sourceSessionId', 'startingLanguage', 'subject', 'teamId', 'timeoutSeconds', 'transferTargetAddress', 'transferTargetName', 'transferType', 'usedRouting', 'userId', 'videoAddressSelf', 'videoMuted', 'videoRoomId', 'wrapUpCode', 'wrapUpNote', 'wrapUpTag'");
        }
        $this->container['dimension'] = $dimension;

        return $this;
    }

    /**
     * Gets propertyType
     * @return string
     */
    public function getPropertyType()
    {
        return $this->container['propertyType'];
    }

    /**
     * Sets propertyType
     * @param string $propertyType Left hand side for property predicates
     * @return $this
     */
    public function setPropertyType($propertyType)
    {
        $allowed_values = array('bool', 'integer', 'real', 'date', 'string', 'uuid');
        if (!in_array($propertyType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'propertyType', must be one of 'bool', 'integer', 'real', 'date', 'string', 'uuid'");
        }
        $this->container['propertyType'] = $propertyType;

        return $this;
    }

    /**
     * Gets property
     * @return string
     */
    public function getProperty()
    {
        return $this->container['property'];
    }

    /**
     * Sets property
     * @param string $property Left hand side for property predicates
     * @return $this
     */
    public function setProperty($property)
    {
        $this->container['property'] = $property;

        return $this;
    }

    /**
     * Gets metric
     * @return string
     */
    public function getMetric()
    {
        return $this->container['metric'];
    }

    /**
     * Sets metric
     * @param string $metric Left hand side for metric predicates
     * @return $this
     */
    public function setMetric($metric)
    {
        $allowed_values = array('tSegmentDuration');
        if (!in_array($metric, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'metric', must be one of 'tSegmentDuration'");
        }
        $this->container['metric'] = $metric;

        return $this;
    }

    /**
     * Gets operator
     * @return string
     */
    public function getOperator()
    {
        return $this->container['operator'];
    }

    /**
     * Sets operator
     * @param string $operator Optional operator, default is matches
     * @return $this
     */
    public function setOperator($operator)
    {
        $allowed_values = array('matches', 'exists', 'notExists');
        if (!in_array($operator, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'operator', must be one of 'matches', 'exists', 'notExists'");
        }
        $this->container['operator'] = $operator;

        return $this;
    }

    /**
     * Gets value
     * @return string
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     * @param string $value Right hand side for dimension, metric, or property predicates
     * @return $this
     */
    public function setValue($value)
    {
        $this->container['value'] = $value;

        return $this;
    }

    /**
     * Gets range
     * @return \PureCloudSDK\NumericRange
     */
    public function getRange()
    {
        return $this->container['range'];
    }

    /**
     * Sets range
     * @param \PureCloudSDK\NumericRange $range Right hand side for dimension, metric, or property predicates
     * @return $this
     */
    public function setRange($range)
    {
        $this->container['range'] = $range;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
