<?php

/**
 * TrunkMetricsOptions
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * TrunkMetricsOptions Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class TrunkMetricsOptions implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'TrunkMetricsOptions';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'proxyAddress' => 'string',
        'optionState' => 'bool',
        'optionStateTime' => '\DateTime',
        'errorInfo' => '\PureCloudSDK\TrunkErrorInfo'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'proxyAddress' => 'proxyAddress',
        'optionState' => 'optionState',
        'optionStateTime' => 'optionStateTime',
        'errorInfo' => 'errorInfo'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'proxyAddress' => 'setProxyAddress',
        'optionState' => 'setOptionState',
        'optionStateTime' => 'setOptionStateTime',
        'errorInfo' => 'setErrorInfo'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'proxyAddress' => 'getProxyAddress',
        'optionState' => 'getOptionState',
        'optionStateTime' => 'getOptionStateTime',
        'errorInfo' => 'getErrorInfo'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['proxyAddress'] = isset($data['proxyAddress']) ? $data['proxyAddress'] : null;
        $this->container['optionState'] = isset($data['optionState']) ? $data['optionState'] : null;
        $this->container['optionStateTime'] = isset($data['optionStateTime']) ? $data['optionStateTime'] : null;
        $this->container['errorInfo'] = isset($data['errorInfo']) ? $data['errorInfo'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets proxyAddress
     * @return string
     */
    public function getProxyAddress()
    {
        return $this->container['proxyAddress'];
    }

    /**
     * Sets proxyAddress
     * @param string $proxyAddress Server proxy address that this options array element represents.
     * @return $this
     */
    public function setProxyAddress($proxyAddress)
    {
        $this->container['proxyAddress'] = $proxyAddress;

        return $this;
    }

    /**
     * Gets optionState
     * @return bool
     */
    public function getOptionState()
    {
        return $this->container['optionState'];
    }

    /**
     * Sets optionState
     * @param bool $optionState
     * @return $this
     */
    public function setOptionState($optionState)
    {
        $this->container['optionState'] = $optionState;

        return $this;
    }

    /**
     * Gets optionStateTime
     * @return \DateTime
     */
    public function getOptionStateTime()
    {
        return $this->container['optionStateTime'];
    }

    /**
     * Sets optionStateTime
     * @param \DateTime $optionStateTime ISO 8601 format UTC absolute date & time of the last change of the option state.
     * @return $this
     */
    public function setOptionStateTime($optionStateTime)
    {
        $this->container['optionStateTime'] = $optionStateTime;

        return $this;
    }

    /**
     * Gets errorInfo
     * @return \PureCloudSDK\TrunkErrorInfo
     */
    public function getErrorInfo()
    {
        return $this->container['errorInfo'];
    }

    /**
     * Sets errorInfo
     * @param \PureCloudSDK\TrunkErrorInfo $errorInfo
     * @return $this
     */
    public function setErrorInfo($errorInfo)
    {
        $this->container['errorInfo'] = $errorInfo;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
