<?php

/**
 * AnalyticsProperty
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * AnalyticsProperty Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AnalyticsProperty implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AnalyticsProperty';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'propertyType' => 'string',
        'property' => 'string',
        'value' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'propertyType' => 'propertyType',
        'property' => 'property',
        'value' => 'value'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'propertyType' => 'setPropertyType',
        'property' => 'setProperty',
        'value' => 'setValue'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'propertyType' => 'getPropertyType',
        'property' => 'getProperty',
        'value' => 'getValue'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const PROPERTY_TYPE_BOOL = 'bool';
    public const PROPERTY_TYPE_INTEGER = 'integer';
    public const PROPERTY_TYPE_REAL = 'real';
    public const PROPERTY_TYPE_DATE = 'date';
    public const PROPERTY_TYPE_STRING = 'string';
    public const PROPERTY_TYPE_UUID = 'uuid';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getPropertyTypeAllowableValues()
    {
        return [
            self::PROPERTY_TYPE_BOOL,
            self::PROPERTY_TYPE_INTEGER,
            self::PROPERTY_TYPE_REAL,
            self::PROPERTY_TYPE_DATE,
            self::PROPERTY_TYPE_STRING,
            self::PROPERTY_TYPE_UUID,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['propertyType'] = isset($data['propertyType']) ? $data['propertyType'] : null;
        $this->container['property'] = isset($data['property']) ? $data['property'] : null;
        $this->container['value'] = isset($data['value']) ? $data['value'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['propertyType'] === null) {
            $invalid_properties[] = "'propertyType' can't be null";
        }
        $allowed_values = array("bool", "integer", "real", "date", "string", "uuid");
        if (!in_array($this->container['propertyType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'propertyType', must be one of #{allowed_values}.";
        }

        if ($this->container['property'] === null) {
            $invalid_properties[] = "'property' can't be null";
        }
        if ($this->container['value'] === null) {
            $invalid_properties[] = "'value' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['propertyType'] === null) {
            return false;
        }
        $allowed_values = array("bool", "integer", "real", "date", "string", "uuid");
        if (!in_array($this->container['propertyType'], $allowed_values)) {
            return false;
        }
        if ($this->container['property'] === null) {
            return false;
        }
        if ($this->container['value'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets propertyType
     * @return string
     */
    public function getPropertyType()
    {
        return $this->container['propertyType'];
    }

    /**
     * Sets propertyType
     * @param string $propertyType Indicates what the data type is (e.g. integer vs string) and therefore how to evaluate what would constitute a match
     * @return $this
     */
    public function setPropertyType($propertyType)
    {
        $allowed_values = array('bool', 'integer', 'real', 'date', 'string', 'uuid');
        if (!in_array($propertyType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'propertyType', must be one of 'bool', 'integer', 'real', 'date', 'string', 'uuid'");
        }
        $this->container['propertyType'] = $propertyType;

        return $this;
    }

    /**
     * Gets property
     * @return string
     */
    public function getProperty()
    {
        return $this->container['property'];
    }

    /**
     * Sets property
     * @param string $property User-defined rather than intrinsic system-observed values. These are tagged onto segments by other components within PureCloud or by API users directly.  This is the name of the user-defined property.
     * @return $this
     */
    public function setProperty($property)
    {
        $this->container['property'] = $property;

        return $this;
    }

    /**
     * Gets value
     * @return string
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     * @param string $value What property value to match against
     * @return $this
     */
    public function setValue($value)
    {
        $this->container['value'] = $value;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
