<?php

/**
 * KnowledgeApi
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK\Api;

use PureCloudSDK\Configuration;
use PureCloudSDK\ApiClient;
use PureCloudSDK\ApiException;
use PureCloudSDK\ObjectSerializer;

/**
 * KnowledgeApi Class Doc Comment
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class KnowledgeApi
{

    /**
     * API Client
     *
     * @var \PureCloudSDK\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \PureCloudSDK\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\PureCloudSDK\ApiClient $apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://api.mypurecloud.ie');
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \PureCloudSDK\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \PureCloudSDK\ApiClient $apiClient set the API client
     *
     * @return KnowledgeApi
     */
    public function setApiClient(\PureCloudSDK\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation deleteKnowledgeKnowledgebase
     *
     * Delete knowledge base
     *
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @return \PureCloudSDK\KnowledgeBase
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteKnowledgeKnowledgebase($knowledgeBaseId)
    {
        list($response) = $this->deleteKnowledgeKnowledgebaseWithHttpInfo($knowledgeBaseId);
        return $response;
    }

    /**
     * Operation deleteKnowledgeKnowledgebaseWithHttpInfo
     *
     * Delete knowledge base
     *
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @return Array of \PureCloudSDK\KnowledgeBase, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteKnowledgeKnowledgebaseWithHttpInfo($knowledgeBaseId)
    {
        // verify the required parameter 'knowledgeBaseId' is set
        if ($knowledgeBaseId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $knowledgeBaseId when calling deleteKnowledgeKnowledgebase');
        }
        // parse inputs
        $resourcePath = "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($knowledgeBaseId !== null) {
            $resourcePath = str_replace(
                "{" . "knowledgeBaseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($knowledgeBaseId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\KnowledgeBase',
                '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\KnowledgeBase', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\KnowledgeBase', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteKnowledgeKnowledgebaseLanguageCategory
     *
     * Delete category
     *
     * @param string $categoryId Category ID (required)
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @return \PureCloudSDK\KnowledgeCategory
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteKnowledgeKnowledgebaseLanguageCategory($categoryId, $knowledgeBaseId, $languageCode)
    {
        list($response) = $this->deleteKnowledgeKnowledgebaseLanguageCategoryWithHttpInfo($categoryId, $knowledgeBaseId, $languageCode);
        return $response;
    }

    /**
     * Operation deleteKnowledgeKnowledgebaseLanguageCategoryWithHttpInfo
     *
     * Delete category
     *
     * @param string $categoryId Category ID (required)
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @return Array of \PureCloudSDK\KnowledgeCategory, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteKnowledgeKnowledgebaseLanguageCategoryWithHttpInfo($categoryId, $knowledgeBaseId, $languageCode)
    {
        // verify the required parameter 'categoryId' is set
        if ($categoryId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $categoryId when calling deleteKnowledgeKnowledgebaseLanguageCategory');
        }
        // verify the required parameter 'knowledgeBaseId' is set
        if ($knowledgeBaseId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $knowledgeBaseId when calling deleteKnowledgeKnowledgebaseLanguageCategory');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling deleteKnowledgeKnowledgebaseLanguageCategory');
        }
        // parse inputs
        $resourcePath = "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/categories/{categoryId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($categoryId !== null) {
            $resourcePath = str_replace(
                "{" . "categoryId" . "}",
                $this->apiClient->getSerializer()->toPathValue($categoryId),
                $resourcePath
            );
        }
        // path params
        if ($knowledgeBaseId !== null) {
            $resourcePath = str_replace(
                "{" . "knowledgeBaseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($knowledgeBaseId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\KnowledgeCategory',
                '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/categories/{categoryId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\KnowledgeCategory', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\KnowledgeCategory', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteKnowledgeKnowledgebaseLanguageDocument
     *
     * Delete document
     *
     * @param string $documentId Document ID (required)
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @return \PureCloudSDK\KnowledgeDocument
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteKnowledgeKnowledgebaseLanguageDocument($documentId, $knowledgeBaseId, $languageCode)
    {
        list($response) = $this->deleteKnowledgeKnowledgebaseLanguageDocumentWithHttpInfo($documentId, $knowledgeBaseId, $languageCode);
        return $response;
    }

    /**
     * Operation deleteKnowledgeKnowledgebaseLanguageDocumentWithHttpInfo
     *
     * Delete document
     *
     * @param string $documentId Document ID (required)
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @return Array of \PureCloudSDK\KnowledgeDocument, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteKnowledgeKnowledgebaseLanguageDocumentWithHttpInfo($documentId, $knowledgeBaseId, $languageCode)
    {
        // verify the required parameter 'documentId' is set
        if ($documentId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $documentId when calling deleteKnowledgeKnowledgebaseLanguageDocument');
        }
        // verify the required parameter 'knowledgeBaseId' is set
        if ($knowledgeBaseId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $knowledgeBaseId when calling deleteKnowledgeKnowledgebaseLanguageDocument');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling deleteKnowledgeKnowledgebaseLanguageDocument');
        }
        // parse inputs
        $resourcePath = "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/documents/{documentId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($documentId !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($documentId),
                $resourcePath
            );
        }
        // path params
        if ($knowledgeBaseId !== null) {
            $resourcePath = str_replace(
                "{" . "knowledgeBaseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($knowledgeBaseId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\KnowledgeDocument',
                '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/documents/{documentId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\KnowledgeDocument', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\KnowledgeDocument', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getKnowledgeKnowledgebase
     *
     * Get knowledge base
     *
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @return \PureCloudSDK\KnowledgeBase
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getKnowledgeKnowledgebase($knowledgeBaseId)
    {
        list($response) = $this->getKnowledgeKnowledgebaseWithHttpInfo($knowledgeBaseId);
        return $response;
    }

    /**
     * Operation getKnowledgeKnowledgebaseWithHttpInfo
     *
     * Get knowledge base
     *
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @return Array of \PureCloudSDK\KnowledgeBase, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getKnowledgeKnowledgebaseWithHttpInfo($knowledgeBaseId)
    {
        // verify the required parameter 'knowledgeBaseId' is set
        if ($knowledgeBaseId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $knowledgeBaseId when calling getKnowledgeKnowledgebase');
        }
        // parse inputs
        $resourcePath = "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($knowledgeBaseId !== null) {
            $resourcePath = str_replace(
                "{" . "knowledgeBaseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($knowledgeBaseId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\KnowledgeBase',
                '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\KnowledgeBase', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\KnowledgeBase', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getKnowledgeKnowledgebaseLanguageCategories
     *
     * Get categories
     *
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @param string $before The cursor that points to the start of the set of entities that has been returned. (optional)
     * @param string $after The cursor that points to the end of the set of entities that has been returned. (optional)
     * @param string $limit Number of entities to return. Maximum of 200. (optional)
     * @param string $pageSize Number of entities to return. Maximum of 200. (optional)
     * @return \PureCloudSDK\CategoryListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getKnowledgeKnowledgebaseLanguageCategories($knowledgeBaseId, $languageCode, $before = null, $after = null, $limit = null, $pageSize = null)
    {
        list($response) = $this->getKnowledgeKnowledgebaseLanguageCategoriesWithHttpInfo($knowledgeBaseId, $languageCode, $before, $after, $limit, $pageSize);
        return $response;
    }

    /**
     * Operation getKnowledgeKnowledgebaseLanguageCategoriesWithHttpInfo
     *
     * Get categories
     *
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @param string $before The cursor that points to the start of the set of entities that has been returned. (optional)
     * @param string $after The cursor that points to the end of the set of entities that has been returned. (optional)
     * @param string $limit Number of entities to return. Maximum of 200. (optional)
     * @param string $pageSize Number of entities to return. Maximum of 200. (optional)
     * @return Array of \PureCloudSDK\CategoryListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getKnowledgeKnowledgebaseLanguageCategoriesWithHttpInfo($knowledgeBaseId, $languageCode, $before = null, $after = null, $limit = null, $pageSize = null)
    {
        // verify the required parameter 'knowledgeBaseId' is set
        if ($knowledgeBaseId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $knowledgeBaseId when calling getKnowledgeKnowledgebaseLanguageCategories');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling getKnowledgeKnowledgebaseLanguageCategories');
        }
        // parse inputs
        $resourcePath = "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/categories";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($before !== null) {
            $queryParams['before'] = $this->apiClient->getSerializer()->toQueryValue($before);
        }
        // query params
        if ($after !== null) {
            $queryParams['after'] = $this->apiClient->getSerializer()->toQueryValue($after);
        }
        // query params
        if ($limit !== null) {
            $queryParams['limit'] = $this->apiClient->getSerializer()->toQueryValue($limit);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // path params
        if ($knowledgeBaseId !== null) {
            $resourcePath = str_replace(
                "{" . "knowledgeBaseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($knowledgeBaseId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\CategoryListing',
                '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/categories'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\CategoryListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\CategoryListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getKnowledgeKnowledgebaseLanguageCategory
     *
     * Get category
     *
     * @param string $categoryId Category ID (required)
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @return \PureCloudSDK\KnowledgeExtendedCategory
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getKnowledgeKnowledgebaseLanguageCategory($categoryId, $knowledgeBaseId, $languageCode)
    {
        list($response) = $this->getKnowledgeKnowledgebaseLanguageCategoryWithHttpInfo($categoryId, $knowledgeBaseId, $languageCode);
        return $response;
    }

    /**
     * Operation getKnowledgeKnowledgebaseLanguageCategoryWithHttpInfo
     *
     * Get category
     *
     * @param string $categoryId Category ID (required)
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @return Array of \PureCloudSDK\KnowledgeExtendedCategory, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getKnowledgeKnowledgebaseLanguageCategoryWithHttpInfo($categoryId, $knowledgeBaseId, $languageCode)
    {
        // verify the required parameter 'categoryId' is set
        if ($categoryId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $categoryId when calling getKnowledgeKnowledgebaseLanguageCategory');
        }
        // verify the required parameter 'knowledgeBaseId' is set
        if ($knowledgeBaseId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $knowledgeBaseId when calling getKnowledgeKnowledgebaseLanguageCategory');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling getKnowledgeKnowledgebaseLanguageCategory');
        }
        // parse inputs
        $resourcePath = "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/categories/{categoryId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($categoryId !== null) {
            $resourcePath = str_replace(
                "{" . "categoryId" . "}",
                $this->apiClient->getSerializer()->toPathValue($categoryId),
                $resourcePath
            );
        }
        // path params
        if ($knowledgeBaseId !== null) {
            $resourcePath = str_replace(
                "{" . "knowledgeBaseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($knowledgeBaseId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\KnowledgeExtendedCategory',
                '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/categories/{categoryId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\KnowledgeExtendedCategory', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\KnowledgeExtendedCategory', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getKnowledgeKnowledgebaseLanguageDocument
     *
     * Get document
     *
     * @param string $documentId Document ID (required)
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @return \PureCloudSDK\KnowledgeDocument
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getKnowledgeKnowledgebaseLanguageDocument($documentId, $knowledgeBaseId, $languageCode)
    {
        list($response) = $this->getKnowledgeKnowledgebaseLanguageDocumentWithHttpInfo($documentId, $knowledgeBaseId, $languageCode);
        return $response;
    }

    /**
     * Operation getKnowledgeKnowledgebaseLanguageDocumentWithHttpInfo
     *
     * Get document
     *
     * @param string $documentId Document ID (required)
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @return Array of \PureCloudSDK\KnowledgeDocument, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getKnowledgeKnowledgebaseLanguageDocumentWithHttpInfo($documentId, $knowledgeBaseId, $languageCode)
    {
        // verify the required parameter 'documentId' is set
        if ($documentId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $documentId when calling getKnowledgeKnowledgebaseLanguageDocument');
        }
        // verify the required parameter 'knowledgeBaseId' is set
        if ($knowledgeBaseId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $knowledgeBaseId when calling getKnowledgeKnowledgebaseLanguageDocument');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling getKnowledgeKnowledgebaseLanguageDocument');
        }
        // parse inputs
        $resourcePath = "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/documents/{documentId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($documentId !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($documentId),
                $resourcePath
            );
        }
        // path params
        if ($knowledgeBaseId !== null) {
            $resourcePath = str_replace(
                "{" . "knowledgeBaseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($knowledgeBaseId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\KnowledgeDocument',
                '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/documents/{documentId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\KnowledgeDocument', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\KnowledgeDocument', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getKnowledgeKnowledgebaseLanguageDocuments
     *
     * Get documents
     *
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @param string $before The cursor that points to the start of the set of entities that has been returned. (optional)
     * @param string $after The cursor that points to the end of the set of entities that has been returned. (optional)
     * @param string $limit Number of entities to return. Maximum of 200. (optional)
     * @param string $pageSize Number of entities to return. Maximum of 200. (optional)
     * @param string $categories Filter by categories ids, comma separated values expected. (optional)
     * @return \PureCloudSDK\DocumentListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getKnowledgeKnowledgebaseLanguageDocuments($knowledgeBaseId, $languageCode, $before = null, $after = null, $limit = null, $pageSize = null, $categories = null)
    {
        list($response) = $this->getKnowledgeKnowledgebaseLanguageDocumentsWithHttpInfo($knowledgeBaseId, $languageCode, $before, $after, $limit, $pageSize, $categories);
        return $response;
    }

    /**
     * Operation getKnowledgeKnowledgebaseLanguageDocumentsWithHttpInfo
     *
     * Get documents
     *
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @param string $before The cursor that points to the start of the set of entities that has been returned. (optional)
     * @param string $after The cursor that points to the end of the set of entities that has been returned. (optional)
     * @param string $limit Number of entities to return. Maximum of 200. (optional)
     * @param string $pageSize Number of entities to return. Maximum of 200. (optional)
     * @param string $categories Filter by categories ids, comma separated values expected. (optional)
     * @return Array of \PureCloudSDK\DocumentListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getKnowledgeKnowledgebaseLanguageDocumentsWithHttpInfo($knowledgeBaseId, $languageCode, $before = null, $after = null, $limit = null, $pageSize = null, $categories = null)
    {
        // verify the required parameter 'knowledgeBaseId' is set
        if ($knowledgeBaseId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $knowledgeBaseId when calling getKnowledgeKnowledgebaseLanguageDocuments');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling getKnowledgeKnowledgebaseLanguageDocuments');
        }
        // parse inputs
        $resourcePath = "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/documents";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($before !== null) {
            $queryParams['before'] = $this->apiClient->getSerializer()->toQueryValue($before);
        }
        // query params
        if ($after !== null) {
            $queryParams['after'] = $this->apiClient->getSerializer()->toQueryValue($after);
        }
        // query params
        if ($limit !== null) {
            $queryParams['limit'] = $this->apiClient->getSerializer()->toQueryValue($limit);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($categories !== null) {
            $queryParams['categories'] = $this->apiClient->getSerializer()->toQueryValue($categories);
        }
        // path params
        if ($knowledgeBaseId !== null) {
            $resourcePath = str_replace(
                "{" . "knowledgeBaseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($knowledgeBaseId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\DocumentListing',
                '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/documents'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\DocumentListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\DocumentListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getKnowledgeKnowledgebaseLanguageTraining
     *
     * Get training detail
     *
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @param string $trainingId Training ID (required)
     * @return \PureCloudSDK\KnowledgeTraining
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getKnowledgeKnowledgebaseLanguageTraining($knowledgeBaseId, $languageCode, $trainingId)
    {
        list($response) = $this->getKnowledgeKnowledgebaseLanguageTrainingWithHttpInfo($knowledgeBaseId, $languageCode, $trainingId);
        return $response;
    }

    /**
     * Operation getKnowledgeKnowledgebaseLanguageTrainingWithHttpInfo
     *
     * Get training detail
     *
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @param string $trainingId Training ID (required)
     * @return Array of \PureCloudSDK\KnowledgeTraining, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getKnowledgeKnowledgebaseLanguageTrainingWithHttpInfo($knowledgeBaseId, $languageCode, $trainingId)
    {
        // verify the required parameter 'knowledgeBaseId' is set
        if ($knowledgeBaseId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $knowledgeBaseId when calling getKnowledgeKnowledgebaseLanguageTraining');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling getKnowledgeKnowledgebaseLanguageTraining');
        }
        // verify the required parameter 'trainingId' is set
        if ($trainingId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $trainingId when calling getKnowledgeKnowledgebaseLanguageTraining');
        }
        // parse inputs
        $resourcePath = "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/trainings/{trainingId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($knowledgeBaseId !== null) {
            $resourcePath = str_replace(
                "{" . "knowledgeBaseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($knowledgeBaseId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // path params
        if ($trainingId !== null) {
            $resourcePath = str_replace(
                "{" . "trainingId" . "}",
                $this->apiClient->getSerializer()->toPathValue($trainingId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\KnowledgeTraining',
                '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/trainings/{trainingId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\KnowledgeTraining', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\KnowledgeTraining', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getKnowledgeKnowledgebaseLanguageTrainings
     *
     * Get All trainings information for a knowledgebase
     *
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @param string $before The cursor that points to the start of the set of entities that has been returned. (optional)
     * @param string $after The cursor that points to the end of the set of entities that has been returned. (optional)
     * @param string $limit Number of entities to return. Maximum of 200. (optional)
     * @param string $pageSize Number of entities to return. Maximum of 200. (optional)
     * @return \PureCloudSDK\TrainingListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getKnowledgeKnowledgebaseLanguageTrainings($knowledgeBaseId, $languageCode, $before = null, $after = null, $limit = null, $pageSize = null)
    {
        list($response) = $this->getKnowledgeKnowledgebaseLanguageTrainingsWithHttpInfo($knowledgeBaseId, $languageCode, $before, $after, $limit, $pageSize);
        return $response;
    }

    /**
     * Operation getKnowledgeKnowledgebaseLanguageTrainingsWithHttpInfo
     *
     * Get All trainings information for a knowledgebase
     *
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @param string $before The cursor that points to the start of the set of entities that has been returned. (optional)
     * @param string $after The cursor that points to the end of the set of entities that has been returned. (optional)
     * @param string $limit Number of entities to return. Maximum of 200. (optional)
     * @param string $pageSize Number of entities to return. Maximum of 200. (optional)
     * @return Array of \PureCloudSDK\TrainingListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getKnowledgeKnowledgebaseLanguageTrainingsWithHttpInfo($knowledgeBaseId, $languageCode, $before = null, $after = null, $limit = null, $pageSize = null)
    {
        // verify the required parameter 'knowledgeBaseId' is set
        if ($knowledgeBaseId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $knowledgeBaseId when calling getKnowledgeKnowledgebaseLanguageTrainings');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling getKnowledgeKnowledgebaseLanguageTrainings');
        }
        // parse inputs
        $resourcePath = "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/trainings";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($before !== null) {
            $queryParams['before'] = $this->apiClient->getSerializer()->toQueryValue($before);
        }
        // query params
        if ($after !== null) {
            $queryParams['after'] = $this->apiClient->getSerializer()->toQueryValue($after);
        }
        // query params
        if ($limit !== null) {
            $queryParams['limit'] = $this->apiClient->getSerializer()->toQueryValue($limit);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // path params
        if ($knowledgeBaseId !== null) {
            $resourcePath = str_replace(
                "{" . "knowledgeBaseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($knowledgeBaseId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\TrainingListing',
                '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/trainings'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\TrainingListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\TrainingListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getKnowledgeKnowledgebases
     *
     * Get knowledge bases
     *
     * @param string $before The cursor that points to the start of the set of entities that has been returned. (optional)
     * @param string $after The cursor that points to the end of the set of entities that has been returned. (optional)
     * @param string $limit Number of entities to return. Maximum of 200. (optional)
     * @param string $pageSize Number of entities to return. Maximum of 200. (optional)
     * @return \PureCloudSDK\KnowledgeBaseListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getKnowledgeKnowledgebases($before = null, $after = null, $limit = null, $pageSize = null)
    {
        list($response) = $this->getKnowledgeKnowledgebasesWithHttpInfo($before, $after, $limit, $pageSize);
        return $response;
    }

    /**
     * Operation getKnowledgeKnowledgebasesWithHttpInfo
     *
     * Get knowledge bases
     *
     * @param string $before The cursor that points to the start of the set of entities that has been returned. (optional)
     * @param string $after The cursor that points to the end of the set of entities that has been returned. (optional)
     * @param string $limit Number of entities to return. Maximum of 200. (optional)
     * @param string $pageSize Number of entities to return. Maximum of 200. (optional)
     * @return Array of \PureCloudSDK\KnowledgeBaseListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getKnowledgeKnowledgebasesWithHttpInfo($before = null, $after = null, $limit = null, $pageSize = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/knowledge/knowledgebases";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($before !== null) {
            $queryParams['before'] = $this->apiClient->getSerializer()->toQueryValue($before);
        }
        // query params
        if ($after !== null) {
            $queryParams['after'] = $this->apiClient->getSerializer()->toQueryValue($after);
        }
        // query params
        if ($limit !== null) {
            $queryParams['limit'] = $this->apiClient->getSerializer()->toQueryValue($limit);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\KnowledgeBaseListing',
                '/api/v2/knowledge/knowledgebases'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\KnowledgeBaseListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\KnowledgeBaseListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchKnowledgeKnowledgebase
     *
     * Update knowledge base
     *
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param \PureCloudSDK\KnowledgeBase $body  (required)
     * @return \PureCloudSDK\KnowledgeBase
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchKnowledgeKnowledgebase($knowledgeBaseId, $body)
    {
        list($response) = $this->patchKnowledgeKnowledgebaseWithHttpInfo($knowledgeBaseId, $body);
        return $response;
    }

    /**
     * Operation patchKnowledgeKnowledgebaseWithHttpInfo
     *
     * Update knowledge base
     *
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param \PureCloudSDK\KnowledgeBase $body  (required)
     * @return Array of \PureCloudSDK\KnowledgeBase, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchKnowledgeKnowledgebaseWithHttpInfo($knowledgeBaseId, $body)
    {
        // verify the required parameter 'knowledgeBaseId' is set
        if ($knowledgeBaseId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $knowledgeBaseId when calling patchKnowledgeKnowledgebase');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchKnowledgeKnowledgebase');
        }
        // parse inputs
        $resourcePath = "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($knowledgeBaseId !== null) {
            $resourcePath = str_replace(
                "{" . "knowledgeBaseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($knowledgeBaseId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\KnowledgeBase',
                '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\KnowledgeBase', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\KnowledgeBase', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchKnowledgeKnowledgebaseLanguageCategory
     *
     * Update category
     *
     * @param string $categoryId Category ID (required)
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @param \PureCloudSDK\KnowledgeCategoryRequest $body  (required)
     * @return \PureCloudSDK\KnowledgeExtendedCategory
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchKnowledgeKnowledgebaseLanguageCategory($categoryId, $knowledgeBaseId, $languageCode, $body)
    {
        list($response) = $this->patchKnowledgeKnowledgebaseLanguageCategoryWithHttpInfo($categoryId, $knowledgeBaseId, $languageCode, $body);
        return $response;
    }

    /**
     * Operation patchKnowledgeKnowledgebaseLanguageCategoryWithHttpInfo
     *
     * Update category
     *
     * @param string $categoryId Category ID (required)
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @param \PureCloudSDK\KnowledgeCategoryRequest $body  (required)
     * @return Array of \PureCloudSDK\KnowledgeExtendedCategory, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchKnowledgeKnowledgebaseLanguageCategoryWithHttpInfo($categoryId, $knowledgeBaseId, $languageCode, $body)
    {
        // verify the required parameter 'categoryId' is set
        if ($categoryId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $categoryId when calling patchKnowledgeKnowledgebaseLanguageCategory');
        }
        // verify the required parameter 'knowledgeBaseId' is set
        if ($knowledgeBaseId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $knowledgeBaseId when calling patchKnowledgeKnowledgebaseLanguageCategory');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling patchKnowledgeKnowledgebaseLanguageCategory');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchKnowledgeKnowledgebaseLanguageCategory');
        }
        // parse inputs
        $resourcePath = "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/categories/{categoryId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($categoryId !== null) {
            $resourcePath = str_replace(
                "{" . "categoryId" . "}",
                $this->apiClient->getSerializer()->toPathValue($categoryId),
                $resourcePath
            );
        }
        // path params
        if ($knowledgeBaseId !== null) {
            $resourcePath = str_replace(
                "{" . "knowledgeBaseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($knowledgeBaseId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\KnowledgeExtendedCategory',
                '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/categories/{categoryId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\KnowledgeExtendedCategory', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\KnowledgeExtendedCategory', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchKnowledgeKnowledgebaseLanguageDocument
     *
     * Update document
     *
     * @param string $documentId Document ID (required)
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @param \PureCloudSDK\KnowledgeDocumentRequest $body  (required)
     * @return \PureCloudSDK\KnowledgeDocument
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchKnowledgeKnowledgebaseLanguageDocument($documentId, $knowledgeBaseId, $languageCode, $body)
    {
        list($response) = $this->patchKnowledgeKnowledgebaseLanguageDocumentWithHttpInfo($documentId, $knowledgeBaseId, $languageCode, $body);
        return $response;
    }

    /**
     * Operation patchKnowledgeKnowledgebaseLanguageDocumentWithHttpInfo
     *
     * Update document
     *
     * @param string $documentId Document ID (required)
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @param \PureCloudSDK\KnowledgeDocumentRequest $body  (required)
     * @return Array of \PureCloudSDK\KnowledgeDocument, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchKnowledgeKnowledgebaseLanguageDocumentWithHttpInfo($documentId, $knowledgeBaseId, $languageCode, $body)
    {
        // verify the required parameter 'documentId' is set
        if ($documentId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $documentId when calling patchKnowledgeKnowledgebaseLanguageDocument');
        }
        // verify the required parameter 'knowledgeBaseId' is set
        if ($knowledgeBaseId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $knowledgeBaseId when calling patchKnowledgeKnowledgebaseLanguageDocument');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling patchKnowledgeKnowledgebaseLanguageDocument');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchKnowledgeKnowledgebaseLanguageDocument');
        }
        // parse inputs
        $resourcePath = "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/documents/{documentId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($documentId !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($documentId),
                $resourcePath
            );
        }
        // path params
        if ($knowledgeBaseId !== null) {
            $resourcePath = str_replace(
                "{" . "knowledgeBaseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($knowledgeBaseId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\KnowledgeDocument',
                '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/documents/{documentId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\KnowledgeDocument', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\KnowledgeDocument', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchKnowledgeKnowledgebaseLanguageDocuments
     *
     * Update documents collection
     *
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @param \PureCloudSDK\KnowledgeDocumentBulkRequest[] $body  (required)
     * @return \PureCloudSDK\DocumentListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchKnowledgeKnowledgebaseLanguageDocuments($knowledgeBaseId, $languageCode, $body)
    {
        list($response) = $this->patchKnowledgeKnowledgebaseLanguageDocumentsWithHttpInfo($knowledgeBaseId, $languageCode, $body);
        return $response;
    }

    /**
     * Operation patchKnowledgeKnowledgebaseLanguageDocumentsWithHttpInfo
     *
     * Update documents collection
     *
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @param \PureCloudSDK\KnowledgeDocumentBulkRequest[] $body  (required)
     * @return Array of \PureCloudSDK\DocumentListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchKnowledgeKnowledgebaseLanguageDocumentsWithHttpInfo($knowledgeBaseId, $languageCode, $body)
    {
        // verify the required parameter 'knowledgeBaseId' is set
        if ($knowledgeBaseId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $knowledgeBaseId when calling patchKnowledgeKnowledgebaseLanguageDocuments');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling patchKnowledgeKnowledgebaseLanguageDocuments');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchKnowledgeKnowledgebaseLanguageDocuments');
        }
        // parse inputs
        $resourcePath = "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/documents";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($knowledgeBaseId !== null) {
            $resourcePath = str_replace(
                "{" . "knowledgeBaseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($knowledgeBaseId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\DocumentListing',
                '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/documents'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\DocumentListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\DocumentListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postKnowledgeKnowledgebaseLanguageCategories
     *
     * Create new category
     *
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @param \PureCloudSDK\KnowledgeCategoryRequest $body  (required)
     * @return \PureCloudSDK\KnowledgeExtendedCategory
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postKnowledgeKnowledgebaseLanguageCategories($knowledgeBaseId, $languageCode, $body)
    {
        list($response) = $this->postKnowledgeKnowledgebaseLanguageCategoriesWithHttpInfo($knowledgeBaseId, $languageCode, $body);
        return $response;
    }

    /**
     * Operation postKnowledgeKnowledgebaseLanguageCategoriesWithHttpInfo
     *
     * Create new category
     *
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @param \PureCloudSDK\KnowledgeCategoryRequest $body  (required)
     * @return Array of \PureCloudSDK\KnowledgeExtendedCategory, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postKnowledgeKnowledgebaseLanguageCategoriesWithHttpInfo($knowledgeBaseId, $languageCode, $body)
    {
        // verify the required parameter 'knowledgeBaseId' is set
        if ($knowledgeBaseId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $knowledgeBaseId when calling postKnowledgeKnowledgebaseLanguageCategories');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling postKnowledgeKnowledgebaseLanguageCategories');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postKnowledgeKnowledgebaseLanguageCategories');
        }
        // parse inputs
        $resourcePath = "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/categories";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($knowledgeBaseId !== null) {
            $resourcePath = str_replace(
                "{" . "knowledgeBaseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($knowledgeBaseId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\KnowledgeExtendedCategory',
                '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/categories'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\KnowledgeExtendedCategory', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\KnowledgeExtendedCategory', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postKnowledgeKnowledgebaseLanguageDocuments
     *
     * Create document
     *
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @param \PureCloudSDK\KnowledgeDocumentRequest $body  (required)
     * @return \PureCloudSDK\KnowledgeDocument
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postKnowledgeKnowledgebaseLanguageDocuments($knowledgeBaseId, $languageCode, $body)
    {
        list($response) = $this->postKnowledgeKnowledgebaseLanguageDocumentsWithHttpInfo($knowledgeBaseId, $languageCode, $body);
        return $response;
    }

    /**
     * Operation postKnowledgeKnowledgebaseLanguageDocumentsWithHttpInfo
     *
     * Create document
     *
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @param \PureCloudSDK\KnowledgeDocumentRequest $body  (required)
     * @return Array of \PureCloudSDK\KnowledgeDocument, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postKnowledgeKnowledgebaseLanguageDocumentsWithHttpInfo($knowledgeBaseId, $languageCode, $body)
    {
        // verify the required parameter 'knowledgeBaseId' is set
        if ($knowledgeBaseId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $knowledgeBaseId when calling postKnowledgeKnowledgebaseLanguageDocuments');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling postKnowledgeKnowledgebaseLanguageDocuments');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postKnowledgeKnowledgebaseLanguageDocuments');
        }
        // parse inputs
        $resourcePath = "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/documents";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($knowledgeBaseId !== null) {
            $resourcePath = str_replace(
                "{" . "knowledgeBaseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($knowledgeBaseId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\KnowledgeDocument',
                '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/documents'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\KnowledgeDocument', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\KnowledgeDocument', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postKnowledgeKnowledgebaseLanguageTrainingPromote
     *
     * Promote trained documents from draft state to active.
     *
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @param string $trainingId Training ID (required)
     * @return \PureCloudSDK\KnowledgeTraining
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postKnowledgeKnowledgebaseLanguageTrainingPromote($knowledgeBaseId, $languageCode, $trainingId)
    {
        list($response) = $this->postKnowledgeKnowledgebaseLanguageTrainingPromoteWithHttpInfo($knowledgeBaseId, $languageCode, $trainingId);
        return $response;
    }

    /**
     * Operation postKnowledgeKnowledgebaseLanguageTrainingPromoteWithHttpInfo
     *
     * Promote trained documents from draft state to active.
     *
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @param string $trainingId Training ID (required)
     * @return Array of \PureCloudSDK\KnowledgeTraining, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postKnowledgeKnowledgebaseLanguageTrainingPromoteWithHttpInfo($knowledgeBaseId, $languageCode, $trainingId)
    {
        // verify the required parameter 'knowledgeBaseId' is set
        if ($knowledgeBaseId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $knowledgeBaseId when calling postKnowledgeKnowledgebaseLanguageTrainingPromote');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling postKnowledgeKnowledgebaseLanguageTrainingPromote');
        }
        // verify the required parameter 'trainingId' is set
        if ($trainingId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $trainingId when calling postKnowledgeKnowledgebaseLanguageTrainingPromote');
        }
        // parse inputs
        $resourcePath = "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/trainings/{trainingId}/promote";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($knowledgeBaseId !== null) {
            $resourcePath = str_replace(
                "{" . "knowledgeBaseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($knowledgeBaseId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // path params
        if ($trainingId !== null) {
            $resourcePath = str_replace(
                "{" . "trainingId" . "}",
                $this->apiClient->getSerializer()->toPathValue($trainingId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\KnowledgeTraining',
                '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/trainings/{trainingId}/promote'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\KnowledgeTraining', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\KnowledgeTraining', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postKnowledgeKnowledgebaseLanguageTrainings
     *
     * Trigger training
     *
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @return \PureCloudSDK\KnowledgeTraining
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postKnowledgeKnowledgebaseLanguageTrainings($knowledgeBaseId, $languageCode)
    {
        list($response) = $this->postKnowledgeKnowledgebaseLanguageTrainingsWithHttpInfo($knowledgeBaseId, $languageCode);
        return $response;
    }

    /**
     * Operation postKnowledgeKnowledgebaseLanguageTrainingsWithHttpInfo
     *
     * Trigger training
     *
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param string $languageCode Language code, format: iso2-LOCALE (required)
     * @return Array of \PureCloudSDK\KnowledgeTraining, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postKnowledgeKnowledgebaseLanguageTrainingsWithHttpInfo($knowledgeBaseId, $languageCode)
    {
        // verify the required parameter 'knowledgeBaseId' is set
        if ($knowledgeBaseId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $knowledgeBaseId when calling postKnowledgeKnowledgebaseLanguageTrainings');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling postKnowledgeKnowledgebaseLanguageTrainings');
        }
        // parse inputs
        $resourcePath = "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/trainings";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($knowledgeBaseId !== null) {
            $resourcePath = str_replace(
                "{" . "knowledgeBaseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($knowledgeBaseId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\KnowledgeTraining',
                '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/trainings'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\KnowledgeTraining', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\KnowledgeTraining', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postKnowledgeKnowledgebaseSearch
     *
     * Search Documents
     *
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param \PureCloudSDK\KnowledgeSearchRequest $body  (optional)
     * @return \PureCloudSDK\KnowledgeSearchResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postKnowledgeKnowledgebaseSearch($knowledgeBaseId, $body = null)
    {
        list($response) = $this->postKnowledgeKnowledgebaseSearchWithHttpInfo($knowledgeBaseId, $body);
        return $response;
    }

    /**
     * Operation postKnowledgeKnowledgebaseSearchWithHttpInfo
     *
     * Search Documents
     *
     * @param string $knowledgeBaseId Knowledge base ID (required)
     * @param \PureCloudSDK\KnowledgeSearchRequest $body  (optional)
     * @return Array of \PureCloudSDK\KnowledgeSearchResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postKnowledgeKnowledgebaseSearchWithHttpInfo($knowledgeBaseId, $body = null)
    {
        // verify the required parameter 'knowledgeBaseId' is set
        if ($knowledgeBaseId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $knowledgeBaseId when calling postKnowledgeKnowledgebaseSearch');
        }
        // parse inputs
        $resourcePath = "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/search";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($knowledgeBaseId !== null) {
            $resourcePath = str_replace(
                "{" . "knowledgeBaseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($knowledgeBaseId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\KnowledgeSearchResponse',
                '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/search'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\KnowledgeSearchResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\KnowledgeSearchResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postKnowledgeKnowledgebases
     *
     * Create new knowledge base
     *
     * @param \PureCloudSDK\KnowledgeBase $body  (required)
     * @return \PureCloudSDK\KnowledgeBase
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postKnowledgeKnowledgebases($body)
    {
        list($response) = $this->postKnowledgeKnowledgebasesWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postKnowledgeKnowledgebasesWithHttpInfo
     *
     * Create new knowledge base
     *
     * @param \PureCloudSDK\KnowledgeBase $body  (required)
     * @return Array of \PureCloudSDK\KnowledgeBase, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postKnowledgeKnowledgebasesWithHttpInfo($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postKnowledgeKnowledgebases');
        }
        // parse inputs
        $resourcePath = "/api/v2/knowledge/knowledgebases";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\KnowledgeBase',
                '/api/v2/knowledge/knowledgebases'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\KnowledgeBase', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\KnowledgeBase', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
