<?php

/**
 * WorkforceManagementApi
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK\Api;

use PureCloudSDK\Configuration;
use PureCloudSDK\ApiClient;
use PureCloudSDK\ApiException;
use PureCloudSDK\ObjectSerializer;

/**
 * WorkforceManagementApi Class Doc Comment
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class WorkforceManagementApi
{

    /**
     * API Client
     *
     * @var \PureCloudSDK\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \PureCloudSDK\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\PureCloudSDK\ApiClient $apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://api.mypurecloud.ie');
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \PureCloudSDK\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \PureCloudSDK\ApiClient $apiClient set the API client
     *
     * @return WorkforceManagementApi
     */
    public function setApiClient(\PureCloudSDK\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation deleteWorkforcemanagementBusinessunit
     *
     * Delete business unit
     *
     * @param string $businessUnitId The ID of the business unit, or &#39;mine&#39; for the business unit of the logged-in user. (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementBusinessunit($businessUnitId)
    {
        list($response) = $this->deleteWorkforcemanagementBusinessunitWithHttpInfo($businessUnitId);
        return $response;
    }

    /**
     * Operation deleteWorkforcemanagementBusinessunitWithHttpInfo
     *
     * Delete business unit
     *
     * @param string $businessUnitId The ID of the business unit, or &#39;mine&#39; for the business unit of the logged-in user. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementBusinessunitWithHttpInfo($businessUnitId)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling deleteWorkforcemanagementBusinessunit');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteWorkforcemanagementBusinessunitActivitycode
     *
     * Deletes an activity code
     *
     * @param string $buId The ID of the business unit, or &#39;mine&#39; for the business unit of the logged-in user. (required)
     * @param string $acId The ID of the activity code to delete (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementBusinessunitActivitycode($buId, $acId)
    {
        list($response) = $this->deleteWorkforcemanagementBusinessunitActivitycodeWithHttpInfo($buId, $acId);
        return $response;
    }

    /**
     * Operation deleteWorkforcemanagementBusinessunitActivitycodeWithHttpInfo
     *
     * Deletes an activity code
     *
     * @param string $buId The ID of the business unit, or &#39;mine&#39; for the business unit of the logged-in user. (required)
     * @param string $acId The ID of the activity code to delete (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementBusinessunitActivitycodeWithHttpInfo($buId, $acId)
    {
        // verify the required parameter 'buId' is set
        if ($buId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $buId when calling deleteWorkforcemanagementBusinessunitActivitycode');
        }
        // verify the required parameter 'acId' is set
        if ($acId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $acId when calling deleteWorkforcemanagementBusinessunitActivitycode');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{buId}/activitycodes/{acId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($buId !== null) {
            $resourcePath = str_replace(
                "{" . "buId" . "}",
                $this->apiClient->getSerializer()->toPathValue($buId),
                $resourcePath
            );
        }
        // path params
        if ($acId !== null) {
            $resourcePath = str_replace(
                "{" . "acId" . "}",
                $this->apiClient->getSerializer()->toPathValue($acId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/businessunits/{buId}/activitycodes/{acId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteWorkforcemanagementBusinessunitPlanninggroup
     *
     * Deletes the planning group
     *
     * @param string $businessUnitId The ID of the business unit. (required)
     * @param string $planningGroupId The ID of a planning group to delete (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementBusinessunitPlanninggroup($businessUnitId, $planningGroupId)
    {
        list($response) = $this->deleteWorkforcemanagementBusinessunitPlanninggroupWithHttpInfo($businessUnitId, $planningGroupId);
        return $response;
    }

    /**
     * Operation deleteWorkforcemanagementBusinessunitPlanninggroupWithHttpInfo
     *
     * Deletes the planning group
     *
     * @param string $businessUnitId The ID of the business unit. (required)
     * @param string $planningGroupId The ID of a planning group to delete (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementBusinessunitPlanninggroupWithHttpInfo($businessUnitId, $planningGroupId)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling deleteWorkforcemanagementBusinessunitPlanninggroup');
        }
        // verify the required parameter 'planningGroupId' is set
        if ($planningGroupId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $planningGroupId when calling deleteWorkforcemanagementBusinessunitPlanninggroup');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/planninggroups/{planningGroupId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($planningGroupId !== null) {
            $resourcePath = str_replace(
                "{" . "planningGroupId" . "}",
                $this->apiClient->getSerializer()->toPathValue($planningGroupId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/planninggroups/{planningGroupId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteWorkforcemanagementBusinessunitSchedulingRun
     *
     * Cancel a scheduling run
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param string $runId The ID of the schedule run (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementBusinessunitSchedulingRun($businessUnitId, $runId)
    {
        list($response) = $this->deleteWorkforcemanagementBusinessunitSchedulingRunWithHttpInfo($businessUnitId, $runId);
        return $response;
    }

    /**
     * Operation deleteWorkforcemanagementBusinessunitSchedulingRunWithHttpInfo
     *
     * Cancel a scheduling run
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param string $runId The ID of the schedule run (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementBusinessunitSchedulingRunWithHttpInfo($businessUnitId, $runId)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling deleteWorkforcemanagementBusinessunitSchedulingRun');
        }
        // verify the required parameter 'runId' is set
        if ($runId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $runId when calling deleteWorkforcemanagementBusinessunitSchedulingRun');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/scheduling/runs/{runId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($runId !== null) {
            $resourcePath = str_replace(
                "{" . "runId" . "}",
                $this->apiClient->getSerializer()->toPathValue($runId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/scheduling/runs/{runId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteWorkforcemanagementBusinessunitServicegoaltemplate
     *
     * Delete a service goal template
     *
     * @param string $businessUnitId The ID of the business unit. (required)
     * @param string $serviceGoalTemplateId The ID of the service goal template to delete (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementBusinessunitServicegoaltemplate($businessUnitId, $serviceGoalTemplateId)
    {
        list($response) = $this->deleteWorkforcemanagementBusinessunitServicegoaltemplateWithHttpInfo($businessUnitId, $serviceGoalTemplateId);
        return $response;
    }

    /**
     * Operation deleteWorkforcemanagementBusinessunitServicegoaltemplateWithHttpInfo
     *
     * Delete a service goal template
     *
     * @param string $businessUnitId The ID of the business unit. (required)
     * @param string $serviceGoalTemplateId The ID of the service goal template to delete (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementBusinessunitServicegoaltemplateWithHttpInfo($businessUnitId, $serviceGoalTemplateId)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling deleteWorkforcemanagementBusinessunitServicegoaltemplate');
        }
        // verify the required parameter 'serviceGoalTemplateId' is set
        if ($serviceGoalTemplateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $serviceGoalTemplateId when calling deleteWorkforcemanagementBusinessunitServicegoaltemplate');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/servicegoaltemplates/{serviceGoalTemplateId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($serviceGoalTemplateId !== null) {
            $resourcePath = str_replace(
                "{" . "serviceGoalTemplateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($serviceGoalTemplateId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/servicegoaltemplates/{serviceGoalTemplateId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteWorkforcemanagementBusinessunitWeekSchedule
     *
     * Delete a schedule
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param \DateTime $weekId First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param string $scheduleId The ID of the schedule (required)
     * @return \PureCloudSDK\BuAsyncScheduleResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementBusinessunitWeekSchedule($businessUnitId, $weekId, $scheduleId)
    {
        list($response) = $this->deleteWorkforcemanagementBusinessunitWeekScheduleWithHttpInfo($businessUnitId, $weekId, $scheduleId);
        return $response;
    }

    /**
     * Operation deleteWorkforcemanagementBusinessunitWeekScheduleWithHttpInfo
     *
     * Delete a schedule
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param \DateTime $weekId First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param string $scheduleId The ID of the schedule (required)
     * @return Array of \PureCloudSDK\BuAsyncScheduleResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementBusinessunitWeekScheduleWithHttpInfo($businessUnitId, $weekId, $scheduleId)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling deleteWorkforcemanagementBusinessunitWeekSchedule');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling deleteWorkforcemanagementBusinessunitWeekSchedule');
        }
        // verify the required parameter 'scheduleId' is set
        if ($scheduleId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $scheduleId when calling deleteWorkforcemanagementBusinessunitWeekSchedule');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/{scheduleId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // path params
        if ($scheduleId !== null) {
            $resourcePath = str_replace(
                "{" . "scheduleId" . "}",
                $this->apiClient->getSerializer()->toPathValue($scheduleId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BuAsyncScheduleResponse',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/{scheduleId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BuAsyncScheduleResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BuAsyncScheduleResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteWorkforcemanagementBusinessunitWeekShorttermforecast
     *
     * Delete a short term forecast
     *
     * @param string $businessUnitId The business unit ID of the business unit to which the forecast belongs (required)
     * @param \DateTime $weekDateId The week start date of the forecast in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param string $forecastId The ID of the forecast (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementBusinessunitWeekShorttermforecast($businessUnitId, $weekDateId, $forecastId)
    {
        list($response) = $this->deleteWorkforcemanagementBusinessunitWeekShorttermforecastWithHttpInfo($businessUnitId, $weekDateId, $forecastId);
        return $response;
    }

    /**
     * Operation deleteWorkforcemanagementBusinessunitWeekShorttermforecastWithHttpInfo
     *
     * Delete a short term forecast
     *
     * @param string $businessUnitId The business unit ID of the business unit to which the forecast belongs (required)
     * @param \DateTime $weekDateId The week start date of the forecast in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param string $forecastId The ID of the forecast (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementBusinessunitWeekShorttermforecastWithHttpInfo($businessUnitId, $weekDateId, $forecastId)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling deleteWorkforcemanagementBusinessunitWeekShorttermforecast');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling deleteWorkforcemanagementBusinessunitWeekShorttermforecast');
        }
        // verify the required parameter 'forecastId' is set
        if ($forecastId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $forecastId when calling deleteWorkforcemanagementBusinessunitWeekShorttermforecast');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // path params
        if ($forecastId !== null) {
            $resourcePath = str_replace(
                "{" . "forecastId" . "}",
                $this->apiClient->getSerializer()->toPathValue($forecastId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteWorkforcemanagementManagementunit
     *
     * Delete management unit
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunit($muId)
    {
        list($response) = $this->deleteWorkforcemanagementManagementunitWithHttpInfo($muId);
        return $response;
    }

    /**
     * Operation deleteWorkforcemanagementManagementunitWithHttpInfo
     *
     * Delete management unit
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunitWithHttpInfo($muId)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling deleteWorkforcemanagementManagementunit');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{muId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteWorkforcemanagementManagementunitActivitycode
     *
     * Deprecated/Gone: Use the new business unit activity code resources
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $acId The ID of the activity code to delete (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunitActivitycode($muId, $acId)
    {
        list($response) = $this->deleteWorkforcemanagementManagementunitActivitycodeWithHttpInfo($muId, $acId);
        return $response;
    }

    /**
     * Operation deleteWorkforcemanagementManagementunitActivitycodeWithHttpInfo
     *
     * Deprecated/Gone: Use the new business unit activity code resources
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $acId The ID of the activity code to delete (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunitActivitycodeWithHttpInfo($muId, $acId)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling deleteWorkforcemanagementManagementunitActivitycode');
        }
        // verify the required parameter 'acId' is set
        if ($acId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $acId when calling deleteWorkforcemanagementManagementunitActivitycode');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/activitycodes/{acId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // path params
        if ($acId !== null) {
            $resourcePath = str_replace(
                "{" . "acId" . "}",
                $this->apiClient->getSerializer()->toPathValue($acId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{muId}/activitycodes/{acId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteWorkforcemanagementManagementunitSchedulingRun
     *
     * Gone.  Scheduling has moved under business units
     *
     * @param string $managementUnitId (Deprecated/gone): The ID of the management unit. (required)
     * @param string $runId The ID of the schedule run (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunitSchedulingRun($managementUnitId, $runId)
    {
        list($response) = $this->deleteWorkforcemanagementManagementunitSchedulingRunWithHttpInfo($managementUnitId, $runId);
        return $response;
    }

    /**
     * Operation deleteWorkforcemanagementManagementunitSchedulingRunWithHttpInfo
     *
     * Gone.  Scheduling has moved under business units
     *
     * @param string $managementUnitId (Deprecated/gone): The ID of the management unit. (required)
     * @param string $runId The ID of the schedule run (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunitSchedulingRunWithHttpInfo($managementUnitId, $runId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling deleteWorkforcemanagementManagementunitSchedulingRun');
        }
        // verify the required parameter 'runId' is set
        if ($runId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $runId when calling deleteWorkforcemanagementManagementunitSchedulingRun');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/scheduling/runs/{runId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($runId !== null) {
            $resourcePath = str_replace(
                "{" . "runId" . "}",
                $this->apiClient->getSerializer()->toPathValue($runId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/scheduling/runs/{runId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteWorkforcemanagementManagementunitServicegoalgroup
     *
     * Gone. Replaced with service goal templates and planning groups under business units
     *
     * @param string $managementUnitId (Deprecated/gone): The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $serviceGoalGroupId Gone. The ID of the service goal group to delete (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunitServicegoalgroup($managementUnitId, $serviceGoalGroupId)
    {
        list($response) = $this->deleteWorkforcemanagementManagementunitServicegoalgroupWithHttpInfo($managementUnitId, $serviceGoalGroupId);
        return $response;
    }

    /**
     * Operation deleteWorkforcemanagementManagementunitServicegoalgroupWithHttpInfo
     *
     * Gone. Replaced with service goal templates and planning groups under business units
     *
     * @param string $managementUnitId (Deprecated/gone): The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $serviceGoalGroupId Gone. The ID of the service goal group to delete (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunitServicegoalgroupWithHttpInfo($managementUnitId, $serviceGoalGroupId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling deleteWorkforcemanagementManagementunitServicegoalgroup');
        }
        // verify the required parameter 'serviceGoalGroupId' is set
        if ($serviceGoalGroupId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $serviceGoalGroupId when calling deleteWorkforcemanagementManagementunitServicegoalgroup');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/servicegoalgroups/{serviceGoalGroupId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($serviceGoalGroupId !== null) {
            $resourcePath = str_replace(
                "{" . "serviceGoalGroupId" . "}",
                $this->apiClient->getSerializer()->toPathValue($serviceGoalGroupId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/servicegoalgroups/{serviceGoalGroupId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteWorkforcemanagementManagementunitWeekSchedule
     *
     * Gone.  Scheduling has moved under business units
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param string $scheduleId Gone/deprecated. The ID of the schedule to delete (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunitWeekSchedule($managementUnitId, $weekId, $scheduleId)
    {
        list($response) = $this->deleteWorkforcemanagementManagementunitWeekScheduleWithHttpInfo($managementUnitId, $weekId, $scheduleId);
        return $response;
    }

    /**
     * Operation deleteWorkforcemanagementManagementunitWeekScheduleWithHttpInfo
     *
     * Gone.  Scheduling has moved under business units
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param string $scheduleId Gone/deprecated. The ID of the schedule to delete (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunitWeekScheduleWithHttpInfo($managementUnitId, $weekId, $scheduleId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling deleteWorkforcemanagementManagementunitWeekSchedule');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling deleteWorkforcemanagementManagementunitWeekSchedule');
        }
        // verify the required parameter 'scheduleId' is set
        if ($scheduleId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $scheduleId when calling deleteWorkforcemanagementManagementunitWeekSchedule');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // path params
        if ($scheduleId !== null) {
            $resourcePath = str_replace(
                "{" . "scheduleId" . "}",
                $this->apiClient->getSerializer()->toPathValue($scheduleId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteWorkforcemanagementManagementunitWeekShorttermforecast
     *
     * Gone. Use equivalent business unit resource instead
     *
     * @param string $managementUnitId (Deprecated/gone): The id of the management unit. (required)
     * @param string $weekDateId (Deprecated/gone): The week start date of the forecast in yyyy-MM-dd format (required)
     * @param string $forecastId (Gone/Deprecated): The ID of the forecast (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunitWeekShorttermforecast($managementUnitId, $weekDateId, $forecastId)
    {
        list($response) = $this->deleteWorkforcemanagementManagementunitWeekShorttermforecastWithHttpInfo($managementUnitId, $weekDateId, $forecastId);
        return $response;
    }

    /**
     * Operation deleteWorkforcemanagementManagementunitWeekShorttermforecastWithHttpInfo
     *
     * Gone. Use equivalent business unit resource instead
     *
     * @param string $managementUnitId (Deprecated/gone): The id of the management unit. (required)
     * @param string $weekDateId (Deprecated/gone): The week start date of the forecast in yyyy-MM-dd format (required)
     * @param string $forecastId (Gone/Deprecated): The ID of the forecast (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunitWeekShorttermforecastWithHttpInfo($managementUnitId, $weekDateId, $forecastId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling deleteWorkforcemanagementManagementunitWeekShorttermforecast');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling deleteWorkforcemanagementManagementunitWeekShorttermforecast');
        }
        // verify the required parameter 'forecastId' is set
        if ($forecastId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $forecastId when calling deleteWorkforcemanagementManagementunitWeekShorttermforecast');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // path params
        if ($forecastId !== null) {
            $resourcePath = str_replace(
                "{" . "forecastId" . "}",
                $this->apiClient->getSerializer()->toPathValue($forecastId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteWorkforcemanagementManagementunitWorkplan
     *
     * Delete a work plan
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $workPlanId The ID of the work plan to delete (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunitWorkplan($managementUnitId, $workPlanId)
    {
        list($response) = $this->deleteWorkforcemanagementManagementunitWorkplanWithHttpInfo($managementUnitId, $workPlanId);
        return $response;
    }

    /**
     * Operation deleteWorkforcemanagementManagementunitWorkplanWithHttpInfo
     *
     * Delete a work plan
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $workPlanId The ID of the work plan to delete (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunitWorkplanWithHttpInfo($managementUnitId, $workPlanId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling deleteWorkforcemanagementManagementunitWorkplan');
        }
        // verify the required parameter 'workPlanId' is set
        if ($workPlanId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workPlanId when calling deleteWorkforcemanagementManagementunitWorkplan');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans/{workPlanId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($workPlanId !== null) {
            $resourcePath = str_replace(
                "{" . "workPlanId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workPlanId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans/{workPlanId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementAdherence
     *
     * Get a list of UserScheduleAdherence records for the requested users
     *
     * @param string[] $userId User Id(s) for which to fetch current schedule adherence information.  Min 1, Max of 100 userIds per request (required)
     * @return \PureCloudSDK\UserScheduleAdherence[]
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementAdherence($userId)
    {
        list($response) = $this->getWorkforcemanagementAdherenceWithHttpInfo($userId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementAdherenceWithHttpInfo
     *
     * Get a list of UserScheduleAdherence records for the requested users
     *
     * @param string[] $userId User Id(s) for which to fetch current schedule adherence information.  Min 1, Max of 100 userIds per request (required)
     * @return Array of \PureCloudSDK\UserScheduleAdherence[], HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementAdherenceWithHttpInfo($userId)
    {
        // verify the required parameter 'userId' is set
        if ($userId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $userId when calling getWorkforcemanagementAdherence');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/adherence";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if (is_array($userId)) {
            $userId = $this->apiClient->getSerializer()->serializeCollection($userId, 'multi', true);
        }
        if ($userId !== null) {
            $queryParams['userId'] = $this->apiClient->getSerializer()->toQueryValue($userId);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\UserScheduleAdherence[]',
                '/api/v2/workforcemanagement/adherence'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\UserScheduleAdherence[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\UserScheduleAdherence[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementAdhocmodelingjob
     *
     * Get status of the modeling job
     *
     * @param string $jobId The id of the modeling job (required)
     * @return \PureCloudSDK\ModelingStatusResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementAdhocmodelingjob($jobId)
    {
        list($response) = $this->getWorkforcemanagementAdhocmodelingjobWithHttpInfo($jobId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementAdhocmodelingjobWithHttpInfo
     *
     * Get status of the modeling job
     *
     * @param string $jobId The id of the modeling job (required)
     * @return Array of \PureCloudSDK\ModelingStatusResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementAdhocmodelingjobWithHttpInfo($jobId)
    {
        // verify the required parameter 'jobId' is set
        if ($jobId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $jobId when calling getWorkforcemanagementAdhocmodelingjob');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/adhocmodelingjobs/{jobId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($jobId !== null) {
            $resourcePath = str_replace(
                "{" . "jobId" . "}",
                $this->apiClient->getSerializer()->toPathValue($jobId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ModelingStatusResponse',
                '/api/v2/workforcemanagement/adhocmodelingjobs/{jobId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ModelingStatusResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ModelingStatusResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementBusinessunit
     *
     * Get business unit
     *
     * @param string $businessUnitId The ID of the business unit, or &#39;mine&#39; for the business unit of the logged-in user. (required)
     * @param string[] $expand  (optional)
     * @return \PureCloudSDK\BusinessUnit
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunit($businessUnitId, $expand = null)
    {
        list($response) = $this->getWorkforcemanagementBusinessunitWithHttpInfo($businessUnitId, $expand);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementBusinessunitWithHttpInfo
     *
     * Get business unit
     *
     * @param string $businessUnitId The ID of the business unit, or &#39;mine&#39; for the business unit of the logged-in user. (required)
     * @param string[] $expand  (optional)
     * @return Array of \PureCloudSDK\BusinessUnit, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitWithHttpInfo($businessUnitId, $expand = null)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling getWorkforcemanagementBusinessunit');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if (is_array($expand)) {
            $expand = $this->apiClient->getSerializer()->serializeCollection($expand, 'multi', true);
        }
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BusinessUnit',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BusinessUnit', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BusinessUnit', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementBusinessunitActivitycode
     *
     * Get an activity code
     *
     * @param string $buId The ID of the business unit, or &#39;mine&#39; for the business unit of the logged-in user. (required)
     * @param string $acId The ID of the activity code to fetch (required)
     * @return \PureCloudSDK\BusinessUnitActivityCode
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitActivitycode($buId, $acId)
    {
        list($response) = $this->getWorkforcemanagementBusinessunitActivitycodeWithHttpInfo($buId, $acId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementBusinessunitActivitycodeWithHttpInfo
     *
     * Get an activity code
     *
     * @param string $buId The ID of the business unit, or &#39;mine&#39; for the business unit of the logged-in user. (required)
     * @param string $acId The ID of the activity code to fetch (required)
     * @return Array of \PureCloudSDK\BusinessUnitActivityCode, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitActivitycodeWithHttpInfo($buId, $acId)
    {
        // verify the required parameter 'buId' is set
        if ($buId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $buId when calling getWorkforcemanagementBusinessunitActivitycode');
        }
        // verify the required parameter 'acId' is set
        if ($acId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $acId when calling getWorkforcemanagementBusinessunitActivitycode');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{buId}/activitycodes/{acId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($buId !== null) {
            $resourcePath = str_replace(
                "{" . "buId" . "}",
                $this->apiClient->getSerializer()->toPathValue($buId),
                $resourcePath
            );
        }
        // path params
        if ($acId !== null) {
            $resourcePath = str_replace(
                "{" . "acId" . "}",
                $this->apiClient->getSerializer()->toPathValue($acId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BusinessUnitActivityCode',
                '/api/v2/workforcemanagement/businessunits/{buId}/activitycodes/{acId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BusinessUnitActivityCode', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BusinessUnitActivityCode', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementBusinessunitActivitycodes
     *
     * Get activity codes
     *
     * @param string $buId The ID of the business unit, or &#39;mine&#39; for the business unit of the logged-in user. (required)
     * @return \PureCloudSDK\BusinessUnitActivityCodeListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitActivitycodes($buId)
    {
        list($response) = $this->getWorkforcemanagementBusinessunitActivitycodesWithHttpInfo($buId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementBusinessunitActivitycodesWithHttpInfo
     *
     * Get activity codes
     *
     * @param string $buId The ID of the business unit, or &#39;mine&#39; for the business unit of the logged-in user. (required)
     * @return Array of \PureCloudSDK\BusinessUnitActivityCodeListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitActivitycodesWithHttpInfo($buId)
    {
        // verify the required parameter 'buId' is set
        if ($buId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $buId when calling getWorkforcemanagementBusinessunitActivitycodes');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{buId}/activitycodes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($buId !== null) {
            $resourcePath = str_replace(
                "{" . "buId" . "}",
                $this->apiClient->getSerializer()->toPathValue($buId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BusinessUnitActivityCodeListing',
                '/api/v2/workforcemanagement/businessunits/{buId}/activitycodes'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BusinessUnitActivityCodeListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BusinessUnitActivityCodeListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementBusinessunitIntradayPlanninggroups
     *
     * Get intraday planning groups for the given date
     *
     * @param string $businessUnitId The business unit ID of the business unit (required)
     * @param \DateTime $date yyyy-MM-dd date string interpreted in the configured business unit time zone. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @return \PureCloudSDK\WfmIntradayPlanningGroupListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitIntradayPlanninggroups($businessUnitId, $date)
    {
        list($response) = $this->getWorkforcemanagementBusinessunitIntradayPlanninggroupsWithHttpInfo($businessUnitId, $date);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementBusinessunitIntradayPlanninggroupsWithHttpInfo
     *
     * Get intraday planning groups for the given date
     *
     * @param string $businessUnitId The business unit ID of the business unit (required)
     * @param \DateTime $date yyyy-MM-dd date string interpreted in the configured business unit time zone. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @return Array of \PureCloudSDK\WfmIntradayPlanningGroupListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitIntradayPlanninggroupsWithHttpInfo($businessUnitId, $date)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling getWorkforcemanagementBusinessunitIntradayPlanninggroups');
        }
        // verify the required parameter 'date' is set
        if ($date === null) {
            throw new \InvalidArgumentException('Missing the required parameter $date when calling getWorkforcemanagementBusinessunitIntradayPlanninggroups');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/intraday/planninggroups";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($date !== null) {
            $queryParams['date'] = $this->apiClient->getSerializer()->toQueryValue($date);
        }
        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WfmIntradayPlanningGroupListing',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/intraday/planninggroups'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WfmIntradayPlanningGroupListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WfmIntradayPlanningGroupListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementBusinessunitManagementunits
     *
     * Get all authorized management units in the business unit
     *
     * @param string $businessUnitId The ID of the business unit, or &#39;mine&#39; for the business unit of the logged-in user. (required)
     * @param string $feature  (optional)
     * @param string $divisionId  (optional)
     * @return \PureCloudSDK\ManagementUnitListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitManagementunits($businessUnitId, $feature = null, $divisionId = null)
    {
        list($response) = $this->getWorkforcemanagementBusinessunitManagementunitsWithHttpInfo($businessUnitId, $feature, $divisionId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementBusinessunitManagementunitsWithHttpInfo
     *
     * Get all authorized management units in the business unit
     *
     * @param string $businessUnitId The ID of the business unit, or &#39;mine&#39; for the business unit of the logged-in user. (required)
     * @param string $feature  (optional)
     * @param string $divisionId  (optional)
     * @return Array of \PureCloudSDK\ManagementUnitListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitManagementunitsWithHttpInfo($businessUnitId, $feature = null, $divisionId = null)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling getWorkforcemanagementBusinessunitManagementunits');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/managementunits";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($feature !== null) {
            $queryParams['feature'] = $this->apiClient->getSerializer()->toQueryValue($feature);
        }
        // query params
        if ($divisionId !== null) {
            $queryParams['divisionId'] = $this->apiClient->getSerializer()->toQueryValue($divisionId);
        }
        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ManagementUnitListing',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/managementunits'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ManagementUnitListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ManagementUnitListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementBusinessunitPlanninggroup
     *
     * Get a planning group
     *
     * @param string $businessUnitId The ID of the business unit. (required)
     * @param string $planningGroupId The ID of a planning group to fetch (required)
     * @return \PureCloudSDK\PlanningGroup
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitPlanninggroup($businessUnitId, $planningGroupId)
    {
        list($response) = $this->getWorkforcemanagementBusinessunitPlanninggroupWithHttpInfo($businessUnitId, $planningGroupId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementBusinessunitPlanninggroupWithHttpInfo
     *
     * Get a planning group
     *
     * @param string $businessUnitId The ID of the business unit. (required)
     * @param string $planningGroupId The ID of a planning group to fetch (required)
     * @return Array of \PureCloudSDK\PlanningGroup, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitPlanninggroupWithHttpInfo($businessUnitId, $planningGroupId)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling getWorkforcemanagementBusinessunitPlanninggroup');
        }
        // verify the required parameter 'planningGroupId' is set
        if ($planningGroupId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $planningGroupId when calling getWorkforcemanagementBusinessunitPlanninggroup');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/planninggroups/{planningGroupId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($planningGroupId !== null) {
            $resourcePath = str_replace(
                "{" . "planningGroupId" . "}",
                $this->apiClient->getSerializer()->toPathValue($planningGroupId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\PlanningGroup',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/planninggroups/{planningGroupId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\PlanningGroup', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\PlanningGroup', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementBusinessunitPlanninggroups
     *
     * Gets list of planning groups
     *
     * @param string $businessUnitId The ID of the business unit. (required)
     * @return \PureCloudSDK\PlanningGroupList
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitPlanninggroups($businessUnitId)
    {
        list($response) = $this->getWorkforcemanagementBusinessunitPlanninggroupsWithHttpInfo($businessUnitId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementBusinessunitPlanninggroupsWithHttpInfo
     *
     * Gets list of planning groups
     *
     * @param string $businessUnitId The ID of the business unit. (required)
     * @return Array of \PureCloudSDK\PlanningGroupList, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitPlanninggroupsWithHttpInfo($businessUnitId)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling getWorkforcemanagementBusinessunitPlanninggroups');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/planninggroups";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\PlanningGroupList',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/planninggroups'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\PlanningGroupList', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\PlanningGroupList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementBusinessunitSchedulingRun
     *
     * Get a scheduling run
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param string $runId The ID of the schedule run (required)
     * @return \PureCloudSDK\BuScheduleRun
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitSchedulingRun($businessUnitId, $runId)
    {
        list($response) = $this->getWorkforcemanagementBusinessunitSchedulingRunWithHttpInfo($businessUnitId, $runId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementBusinessunitSchedulingRunWithHttpInfo
     *
     * Get a scheduling run
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param string $runId The ID of the schedule run (required)
     * @return Array of \PureCloudSDK\BuScheduleRun, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitSchedulingRunWithHttpInfo($businessUnitId, $runId)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling getWorkforcemanagementBusinessunitSchedulingRun');
        }
        // verify the required parameter 'runId' is set
        if ($runId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $runId when calling getWorkforcemanagementBusinessunitSchedulingRun');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/scheduling/runs/{runId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($runId !== null) {
            $resourcePath = str_replace(
                "{" . "runId" . "}",
                $this->apiClient->getSerializer()->toPathValue($runId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BuScheduleRun',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/scheduling/runs/{runId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BuScheduleRun', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BuScheduleRun', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementBusinessunitSchedulingRunResult
     *
     * Get the result of a rescheduling operation
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param string $runId The ID of the schedule run (required)
     * @param string[] $managementUnitIds The IDs of the management units for which to fetch the reschedule results (required)
     * @param string[] $expand The fields to expand. Omitting will return an empty response (required)
     * @return \PureCloudSDK\BuRescheduleResult
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitSchedulingRunResult($businessUnitId, $runId, $managementUnitIds, $expand)
    {
        list($response) = $this->getWorkforcemanagementBusinessunitSchedulingRunResultWithHttpInfo($businessUnitId, $runId, $managementUnitIds, $expand);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementBusinessunitSchedulingRunResultWithHttpInfo
     *
     * Get the result of a rescheduling operation
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param string $runId The ID of the schedule run (required)
     * @param string[] $managementUnitIds The IDs of the management units for which to fetch the reschedule results (required)
     * @param string[] $expand The fields to expand. Omitting will return an empty response (required)
     * @return Array of \PureCloudSDK\BuRescheduleResult, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitSchedulingRunResultWithHttpInfo($businessUnitId, $runId, $managementUnitIds, $expand)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling getWorkforcemanagementBusinessunitSchedulingRunResult');
        }
        // verify the required parameter 'runId' is set
        if ($runId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $runId when calling getWorkforcemanagementBusinessunitSchedulingRunResult');
        }
        // verify the required parameter 'managementUnitIds' is set
        if ($managementUnitIds === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitIds when calling getWorkforcemanagementBusinessunitSchedulingRunResult');
        }
        // verify the required parameter 'expand' is set
        if ($expand === null) {
            throw new \InvalidArgumentException('Missing the required parameter $expand when calling getWorkforcemanagementBusinessunitSchedulingRunResult');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/scheduling/runs/{runId}/result";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if (is_array($managementUnitIds)) {
            $managementUnitIds = $this->apiClient->getSerializer()->serializeCollection($managementUnitIds, 'multi', true);
        }
        if ($managementUnitIds !== null) {
            $queryParams['managementUnitIds'] = $this->apiClient->getSerializer()->toQueryValue($managementUnitIds);
        }
        // query params
        if (is_array($expand)) {
            $expand = $this->apiClient->getSerializer()->serializeCollection($expand, 'multi', true);
        }
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($runId !== null) {
            $resourcePath = str_replace(
                "{" . "runId" . "}",
                $this->apiClient->getSerializer()->toPathValue($runId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BuRescheduleResult',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/scheduling/runs/{runId}/result'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BuRescheduleResult', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BuRescheduleResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementBusinessunitSchedulingRuns
     *
     * Get the list of scheduling runs
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @return \PureCloudSDK\BuScheduleRunListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitSchedulingRuns($businessUnitId)
    {
        list($response) = $this->getWorkforcemanagementBusinessunitSchedulingRunsWithHttpInfo($businessUnitId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementBusinessunitSchedulingRunsWithHttpInfo
     *
     * Get the list of scheduling runs
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @return Array of \PureCloudSDK\BuScheduleRunListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitSchedulingRunsWithHttpInfo($businessUnitId)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling getWorkforcemanagementBusinessunitSchedulingRuns');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/scheduling/runs";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BuScheduleRunListing',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/scheduling/runs'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BuScheduleRunListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BuScheduleRunListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementBusinessunitServicegoaltemplate
     *
     * Get a service goal template
     *
     * @param string $businessUnitId The ID of the business unit. (required)
     * @param string $serviceGoalTemplateId The ID of a service goal template to fetch (required)
     * @return \PureCloudSDK\ServiceGoalTemplate
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitServicegoaltemplate($businessUnitId, $serviceGoalTemplateId)
    {
        list($response) = $this->getWorkforcemanagementBusinessunitServicegoaltemplateWithHttpInfo($businessUnitId, $serviceGoalTemplateId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementBusinessunitServicegoaltemplateWithHttpInfo
     *
     * Get a service goal template
     *
     * @param string $businessUnitId The ID of the business unit. (required)
     * @param string $serviceGoalTemplateId The ID of a service goal template to fetch (required)
     * @return Array of \PureCloudSDK\ServiceGoalTemplate, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitServicegoaltemplateWithHttpInfo($businessUnitId, $serviceGoalTemplateId)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling getWorkforcemanagementBusinessunitServicegoaltemplate');
        }
        // verify the required parameter 'serviceGoalTemplateId' is set
        if ($serviceGoalTemplateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $serviceGoalTemplateId when calling getWorkforcemanagementBusinessunitServicegoaltemplate');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/servicegoaltemplates/{serviceGoalTemplateId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($serviceGoalTemplateId !== null) {
            $resourcePath = str_replace(
                "{" . "serviceGoalTemplateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($serviceGoalTemplateId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ServiceGoalTemplate',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/servicegoaltemplates/{serviceGoalTemplateId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ServiceGoalTemplate', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ServiceGoalTemplate', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementBusinessunitServicegoaltemplates
     *
     * Gets list of service goal templates
     *
     * @param string $businessUnitId The ID of the business unit. (required)
     * @return \PureCloudSDK\ServiceGoalTemplateList
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitServicegoaltemplates($businessUnitId)
    {
        list($response) = $this->getWorkforcemanagementBusinessunitServicegoaltemplatesWithHttpInfo($businessUnitId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementBusinessunitServicegoaltemplatesWithHttpInfo
     *
     * Gets list of service goal templates
     *
     * @param string $businessUnitId The ID of the business unit. (required)
     * @return Array of \PureCloudSDK\ServiceGoalTemplateList, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitServicegoaltemplatesWithHttpInfo($businessUnitId)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling getWorkforcemanagementBusinessunitServicegoaltemplates');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/servicegoaltemplates";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ServiceGoalTemplateList',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/servicegoaltemplates'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ServiceGoalTemplateList', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ServiceGoalTemplateList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementBusinessunitWeekSchedule
     *
     * Get the metadata for the schedule, describing which management units and agents are in the scheduleSchedule data can then be loaded with the query route
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param \DateTime $weekId First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param string $scheduleId The ID of the schedule (required)
     * @return \PureCloudSDK\BuScheduleMetadata
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitWeekSchedule($businessUnitId, $weekId, $scheduleId)
    {
        list($response) = $this->getWorkforcemanagementBusinessunitWeekScheduleWithHttpInfo($businessUnitId, $weekId, $scheduleId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementBusinessunitWeekScheduleWithHttpInfo
     *
     * Get the metadata for the schedule, describing which management units and agents are in the scheduleSchedule data can then be loaded with the query route
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param \DateTime $weekId First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param string $scheduleId The ID of the schedule (required)
     * @return Array of \PureCloudSDK\BuScheduleMetadata, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitWeekScheduleWithHttpInfo($businessUnitId, $weekId, $scheduleId)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling getWorkforcemanagementBusinessunitWeekSchedule');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling getWorkforcemanagementBusinessunitWeekSchedule');
        }
        // verify the required parameter 'scheduleId' is set
        if ($scheduleId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $scheduleId when calling getWorkforcemanagementBusinessunitWeekSchedule');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/{scheduleId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // path params
        if ($scheduleId !== null) {
            $resourcePath = str_replace(
                "{" . "scheduleId" . "}",
                $this->apiClient->getSerializer()->toPathValue($scheduleId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BuScheduleMetadata',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/{scheduleId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BuScheduleMetadata', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BuScheduleMetadata', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementBusinessunitWeekScheduleGenerationresults
     *
     * Get the generation results for a generated schedule
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param \DateTime $weekId First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param string $scheduleId The ID of the schedule (required)
     * @return \PureCloudSDK\ScheduleGenerationResult
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitWeekScheduleGenerationresults($businessUnitId, $weekId, $scheduleId)
    {
        list($response) = $this->getWorkforcemanagementBusinessunitWeekScheduleGenerationresultsWithHttpInfo($businessUnitId, $weekId, $scheduleId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementBusinessunitWeekScheduleGenerationresultsWithHttpInfo
     *
     * Get the generation results for a generated schedule
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param \DateTime $weekId First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param string $scheduleId The ID of the schedule (required)
     * @return Array of \PureCloudSDK\ScheduleGenerationResult, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitWeekScheduleGenerationresultsWithHttpInfo($businessUnitId, $weekId, $scheduleId)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling getWorkforcemanagementBusinessunitWeekScheduleGenerationresults');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling getWorkforcemanagementBusinessunitWeekScheduleGenerationresults');
        }
        // verify the required parameter 'scheduleId' is set
        if ($scheduleId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $scheduleId when calling getWorkforcemanagementBusinessunitWeekScheduleGenerationresults');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/{scheduleId}/generationresults";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // path params
        if ($scheduleId !== null) {
            $resourcePath = str_replace(
                "{" . "scheduleId" . "}",
                $this->apiClient->getSerializer()->toPathValue($scheduleId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ScheduleGenerationResult',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/{scheduleId}/generationresults'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ScheduleGenerationResult', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ScheduleGenerationResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementBusinessunitWeekScheduleHeadcountforecast
     *
     * Get the headcount forecast by planning group for the schedule
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param \DateTime $weekId First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param string $scheduleId The ID of the schedule (required)
     * @param bool $forceDownload Whether to force the result to come via download url.  For testing purposes only (optional)
     * @return \PureCloudSDK\BuHeadcountForecastResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitWeekScheduleHeadcountforecast($businessUnitId, $weekId, $scheduleId, $forceDownload = null)
    {
        list($response) = $this->getWorkforcemanagementBusinessunitWeekScheduleHeadcountforecastWithHttpInfo($businessUnitId, $weekId, $scheduleId, $forceDownload);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementBusinessunitWeekScheduleHeadcountforecastWithHttpInfo
     *
     * Get the headcount forecast by planning group for the schedule
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param \DateTime $weekId First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param string $scheduleId The ID of the schedule (required)
     * @param bool $forceDownload Whether to force the result to come via download url.  For testing purposes only (optional)
     * @return Array of \PureCloudSDK\BuHeadcountForecastResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitWeekScheduleHeadcountforecastWithHttpInfo($businessUnitId, $weekId, $scheduleId, $forceDownload = null)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling getWorkforcemanagementBusinessunitWeekScheduleHeadcountforecast');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling getWorkforcemanagementBusinessunitWeekScheduleHeadcountforecast');
        }
        // verify the required parameter 'scheduleId' is set
        if ($scheduleId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $scheduleId when calling getWorkforcemanagementBusinessunitWeekScheduleHeadcountforecast');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/{scheduleId}/headcountforecast";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($forceDownload !== null) {
            $queryParams['forceDownload'] = $this->apiClient->getSerializer()->toQueryValue($forceDownload);
        }
        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // path params
        if ($scheduleId !== null) {
            $resourcePath = str_replace(
                "{" . "scheduleId" . "}",
                $this->apiClient->getSerializer()->toPathValue($scheduleId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BuHeadcountForecastResponse',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/{scheduleId}/headcountforecast'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BuHeadcountForecastResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BuHeadcountForecastResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementBusinessunitWeekSchedules
     *
     * Get the list of week schedules for the specified week
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format, or &#39;recent&#39; to get recent schedules (required)
     * @param bool $includeOnlyPublished includeOnlyPublished (optional)
     * @param string $expand expand (optional)
     * @return \PureCloudSDK\BuScheduleListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitWeekSchedules($businessUnitId, $weekId, $includeOnlyPublished = null, $expand = null)
    {
        list($response) = $this->getWorkforcemanagementBusinessunitWeekSchedulesWithHttpInfo($businessUnitId, $weekId, $includeOnlyPublished, $expand);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementBusinessunitWeekSchedulesWithHttpInfo
     *
     * Get the list of week schedules for the specified week
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format, or &#39;recent&#39; to get recent schedules (required)
     * @param bool $includeOnlyPublished includeOnlyPublished (optional)
     * @param string $expand expand (optional)
     * @return Array of \PureCloudSDK\BuScheduleListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitWeekSchedulesWithHttpInfo($businessUnitId, $weekId, $includeOnlyPublished = null, $expand = null)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling getWorkforcemanagementBusinessunitWeekSchedules');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling getWorkforcemanagementBusinessunitWeekSchedules');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($includeOnlyPublished !== null) {
            $queryParams['includeOnlyPublished'] = $this->apiClient->getSerializer()->toQueryValue($includeOnlyPublished);
        }
        // query params
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BuScheduleListing',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BuScheduleListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BuScheduleListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementBusinessunitWeekShorttermforecast
     *
     * Get a short term forecast
     *
     * @param string $businessUnitId The business unit ID of the business unit to which the forecast belongs (required)
     * @param \DateTime $weekDateId The week start date of the forecast in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param string $forecastId The ID of the forecast (required)
     * @param string[] $expand  (optional)
     * @return \PureCloudSDK\BuShortTermForecast
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitWeekShorttermforecast($businessUnitId, $weekDateId, $forecastId, $expand = null)
    {
        list($response) = $this->getWorkforcemanagementBusinessunitWeekShorttermforecastWithHttpInfo($businessUnitId, $weekDateId, $forecastId, $expand);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementBusinessunitWeekShorttermforecastWithHttpInfo
     *
     * Get a short term forecast
     *
     * @param string $businessUnitId The business unit ID of the business unit to which the forecast belongs (required)
     * @param \DateTime $weekDateId The week start date of the forecast in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param string $forecastId The ID of the forecast (required)
     * @param string[] $expand  (optional)
     * @return Array of \PureCloudSDK\BuShortTermForecast, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitWeekShorttermforecastWithHttpInfo($businessUnitId, $weekDateId, $forecastId, $expand = null)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling getWorkforcemanagementBusinessunitWeekShorttermforecast');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling getWorkforcemanagementBusinessunitWeekShorttermforecast');
        }
        // verify the required parameter 'forecastId' is set
        if ($forecastId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $forecastId when calling getWorkforcemanagementBusinessunitWeekShorttermforecast');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if (is_array($expand)) {
            $expand = $this->apiClient->getSerializer()->serializeCollection($expand, 'multi', true);
        }
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // path params
        if ($forecastId !== null) {
            $resourcePath = str_replace(
                "{" . "forecastId" . "}",
                $this->apiClient->getSerializer()->toPathValue($forecastId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BuShortTermForecast',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BuShortTermForecast', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BuShortTermForecast', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementBusinessunitWeekShorttermforecastData
     *
     * Get the result of a short term forecast calculation
     *
     * @param string $businessUnitId The business unit ID of the business unit to which the forecast belongs (required)
     * @param \DateTime $weekDateId The week start date of the forecast in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param string $forecastId The ID of the forecast (required)
     * @param int $weekNumber The week number to fetch (for multi-week forecasts) (optional)
     * @param bool $forceDownloadService Force the result of this operation to be sent via download service.  For testing/app development purposes (optional)
     * @return \PureCloudSDK\BuForecastResultResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitWeekShorttermforecastData($businessUnitId, $weekDateId, $forecastId, $weekNumber = null, $forceDownloadService = null)
    {
        list($response) = $this->getWorkforcemanagementBusinessunitWeekShorttermforecastDataWithHttpInfo($businessUnitId, $weekDateId, $forecastId, $weekNumber, $forceDownloadService);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementBusinessunitWeekShorttermforecastDataWithHttpInfo
     *
     * Get the result of a short term forecast calculation
     *
     * @param string $businessUnitId The business unit ID of the business unit to which the forecast belongs (required)
     * @param \DateTime $weekDateId The week start date of the forecast in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param string $forecastId The ID of the forecast (required)
     * @param int $weekNumber The week number to fetch (for multi-week forecasts) (optional)
     * @param bool $forceDownloadService Force the result of this operation to be sent via download service.  For testing/app development purposes (optional)
     * @return Array of \PureCloudSDK\BuForecastResultResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitWeekShorttermforecastDataWithHttpInfo($businessUnitId, $weekDateId, $forecastId, $weekNumber = null, $forceDownloadService = null)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling getWorkforcemanagementBusinessunitWeekShorttermforecastData');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling getWorkforcemanagementBusinessunitWeekShorttermforecastData');
        }
        // verify the required parameter 'forecastId' is set
        if ($forecastId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $forecastId when calling getWorkforcemanagementBusinessunitWeekShorttermforecastData');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}/data";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($weekNumber !== null) {
            $queryParams['weekNumber'] = $this->apiClient->getSerializer()->toQueryValue($weekNumber);
        }
        // query params
        if ($forceDownloadService !== null) {
            $queryParams['forceDownloadService'] = $this->apiClient->getSerializer()->toQueryValue($forceDownloadService);
        }
        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // path params
        if ($forecastId !== null) {
            $resourcePath = str_replace(
                "{" . "forecastId" . "}",
                $this->apiClient->getSerializer()->toPathValue($forecastId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BuForecastResultResponse',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}/data'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BuForecastResultResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BuForecastResultResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementBusinessunitWeekShorttermforecastGenerationresults
     *
     * Gets the forecast generation results
     *
     * @param string $businessUnitId The business unit ID of the business unit to which the forecast belongs (required)
     * @param \DateTime $weekDateId The week start date of the forecast in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param string $forecastId The ID of the forecast (required)
     * @return \PureCloudSDK\BuForecastGenerationResult
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitWeekShorttermforecastGenerationresults($businessUnitId, $weekDateId, $forecastId)
    {
        list($response) = $this->getWorkforcemanagementBusinessunitWeekShorttermforecastGenerationresultsWithHttpInfo($businessUnitId, $weekDateId, $forecastId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementBusinessunitWeekShorttermforecastGenerationresultsWithHttpInfo
     *
     * Gets the forecast generation results
     *
     * @param string $businessUnitId The business unit ID of the business unit to which the forecast belongs (required)
     * @param \DateTime $weekDateId The week start date of the forecast in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param string $forecastId The ID of the forecast (required)
     * @return Array of \PureCloudSDK\BuForecastGenerationResult, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitWeekShorttermforecastGenerationresultsWithHttpInfo($businessUnitId, $weekDateId, $forecastId)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling getWorkforcemanagementBusinessunitWeekShorttermforecastGenerationresults');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling getWorkforcemanagementBusinessunitWeekShorttermforecastGenerationresults');
        }
        // verify the required parameter 'forecastId' is set
        if ($forecastId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $forecastId when calling getWorkforcemanagementBusinessunitWeekShorttermforecastGenerationresults');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}/generationresults";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // path params
        if ($forecastId !== null) {
            $resourcePath = str_replace(
                "{" . "forecastId" . "}",
                $this->apiClient->getSerializer()->toPathValue($forecastId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BuForecastGenerationResult',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}/generationresults'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BuForecastGenerationResult', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BuForecastGenerationResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementBusinessunitWeekShorttermforecastPlanninggroups
     *
     * Gets the forecast planning group snapshot
     *
     * @param string $businessUnitId The business unit ID of the business unit to which the forecast belongs (required)
     * @param \DateTime $weekDateId The week start date of the forecast in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param string $forecastId The ID of the forecast (required)
     * @return \PureCloudSDK\ForecastPlanningGroupsResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitWeekShorttermforecastPlanninggroups($businessUnitId, $weekDateId, $forecastId)
    {
        list($response) = $this->getWorkforcemanagementBusinessunitWeekShorttermforecastPlanninggroupsWithHttpInfo($businessUnitId, $weekDateId, $forecastId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementBusinessunitWeekShorttermforecastPlanninggroupsWithHttpInfo
     *
     * Gets the forecast planning group snapshot
     *
     * @param string $businessUnitId The business unit ID of the business unit to which the forecast belongs (required)
     * @param \DateTime $weekDateId The week start date of the forecast in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param string $forecastId The ID of the forecast (required)
     * @return Array of \PureCloudSDK\ForecastPlanningGroupsResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitWeekShorttermforecastPlanninggroupsWithHttpInfo($businessUnitId, $weekDateId, $forecastId)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling getWorkforcemanagementBusinessunitWeekShorttermforecastPlanninggroups');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling getWorkforcemanagementBusinessunitWeekShorttermforecastPlanninggroups');
        }
        // verify the required parameter 'forecastId' is set
        if ($forecastId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $forecastId when calling getWorkforcemanagementBusinessunitWeekShorttermforecastPlanninggroups');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}/planninggroups";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // path params
        if ($forecastId !== null) {
            $resourcePath = str_replace(
                "{" . "forecastId" . "}",
                $this->apiClient->getSerializer()->toPathValue($forecastId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ForecastPlanningGroupsResponse',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}/planninggroups'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ForecastPlanningGroupsResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ForecastPlanningGroupsResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementBusinessunitWeekShorttermforecasts
     *
     * Get short term forecasts
     *
     * @param string $businessUnitId The business unit ID of the business unit to which the forecast belongs (required)
     * @param string $weekDateId The week start date of the forecast in yyyy-MM-dd format or &#39;recent&#39; to fetch recent forecasts (required)
     * @return \PureCloudSDK\BuShortTermForecastListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitWeekShorttermforecasts($businessUnitId, $weekDateId)
    {
        list($response) = $this->getWorkforcemanagementBusinessunitWeekShorttermforecastsWithHttpInfo($businessUnitId, $weekDateId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementBusinessunitWeekShorttermforecastsWithHttpInfo
     *
     * Get short term forecasts
     *
     * @param string $businessUnitId The business unit ID of the business unit to which the forecast belongs (required)
     * @param string $weekDateId The week start date of the forecast in yyyy-MM-dd format or &#39;recent&#39; to fetch recent forecasts (required)
     * @return Array of \PureCloudSDK\BuShortTermForecastListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitWeekShorttermforecastsWithHttpInfo($businessUnitId, $weekDateId)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling getWorkforcemanagementBusinessunitWeekShorttermforecasts');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling getWorkforcemanagementBusinessunitWeekShorttermforecasts');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekDateId}/shorttermforecasts";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BuShortTermForecastListing',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekDateId}/shorttermforecasts'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BuShortTermForecastListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BuShortTermForecastListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementBusinessunits
     *
     * Get business units
     *
     * @param string $feature  (optional)
     * @param string $divisionId  (optional)
     * @return \PureCloudSDK\BusinessUnitListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunits($feature = null, $divisionId = null)
    {
        list($response) = $this->getWorkforcemanagementBusinessunitsWithHttpInfo($feature, $divisionId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementBusinessunitsWithHttpInfo
     *
     * Get business units
     *
     * @param string $feature  (optional)
     * @param string $divisionId  (optional)
     * @return Array of \PureCloudSDK\BusinessUnitListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitsWithHttpInfo($feature = null, $divisionId = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($feature !== null) {
            $queryParams['feature'] = $this->apiClient->getSerializer()->toQueryValue($feature);
        }
        // query params
        if ($divisionId !== null) {
            $queryParams['divisionId'] = $this->apiClient->getSerializer()->toQueryValue($divisionId);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BusinessUnitListing',
                '/api/v2/workforcemanagement/businessunits'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BusinessUnitListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BusinessUnitListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementBusinessunitsDivisionviews
     *
     * Get business units across divisions
     *
     * @param string[] $divisionId The divisionIds to filter by. If omitted, will return business units in all divisions (optional)
     * @return \PureCloudSDK\BusinessUnitListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitsDivisionviews($divisionId = null)
    {
        list($response) = $this->getWorkforcemanagementBusinessunitsDivisionviewsWithHttpInfo($divisionId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementBusinessunitsDivisionviewsWithHttpInfo
     *
     * Get business units across divisions
     *
     * @param string[] $divisionId The divisionIds to filter by. If omitted, will return business units in all divisions (optional)
     * @return Array of \PureCloudSDK\BusinessUnitListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementBusinessunitsDivisionviewsWithHttpInfo($divisionId = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/divisionviews";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if (is_array($divisionId)) {
            $divisionId = $this->apiClient->getSerializer()->serializeCollection($divisionId, 'multi', true);
        }
        if ($divisionId !== null) {
            $queryParams['divisionId'] = $this->apiClient->getSerializer()->toQueryValue($divisionId);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BusinessUnitListing',
                '/api/v2/workforcemanagement/businessunits/divisionviews'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BusinessUnitListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BusinessUnitListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunit
     *
     * Get management unit
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string[] $expand  (optional)
     * @return \PureCloudSDK\ManagementUnit
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunit($muId, $expand = null)
    {
        list($response) = $this->getWorkforcemanagementManagementunitWithHttpInfo($muId, $expand);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitWithHttpInfo
     *
     * Get management unit
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string[] $expand  (optional)
     * @return Array of \PureCloudSDK\ManagementUnit, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWithHttpInfo($muId, $expand = null)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling getWorkforcemanagementManagementunit');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if (is_array($expand)) {
            $expand = $this->apiClient->getSerializer()->serializeCollection($expand, 'multi', true);
        }
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ManagementUnit',
                '/api/v2/workforcemanagement/managementunits/{muId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ManagementUnit', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ManagementUnit', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitActivitycode
     *
     * Get an activity code
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $acId The ID of the activity code to fetch (required)
     * @return \PureCloudSDK\ActivityCode
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitActivitycode($muId, $acId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitActivitycodeWithHttpInfo($muId, $acId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitActivitycodeWithHttpInfo
     *
     * Get an activity code
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $acId The ID of the activity code to fetch (required)
     * @return Array of \PureCloudSDK\ActivityCode, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitActivitycodeWithHttpInfo($muId, $acId)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling getWorkforcemanagementManagementunitActivitycode');
        }
        // verify the required parameter 'acId' is set
        if ($acId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $acId when calling getWorkforcemanagementManagementunitActivitycode');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/activitycodes/{acId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // path params
        if ($acId !== null) {
            $resourcePath = str_replace(
                "{" . "acId" . "}",
                $this->apiClient->getSerializer()->toPathValue($acId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ActivityCode',
                '/api/v2/workforcemanagement/managementunits/{muId}/activitycodes/{acId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ActivityCode', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ActivityCode', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitActivitycodes
     *
     * Get activity codes
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return \PureCloudSDK\ActivityCodeContainer
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitActivitycodes($muId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitActivitycodesWithHttpInfo($muId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitActivitycodesWithHttpInfo
     *
     * Get activity codes
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return Array of \PureCloudSDK\ActivityCodeContainer, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitActivitycodesWithHttpInfo($muId)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling getWorkforcemanagementManagementunitActivitycodes');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/activitycodes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ActivityCodeContainer',
                '/api/v2/workforcemanagement/managementunits/{muId}/activitycodes'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ActivityCodeContainer', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ActivityCodeContainer', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitAdherence
     *
     * Get a list of user schedule adherence records for the requested management unit
     *
     * @param string $managementUnitId The management unit ID of the management unit. (required)
     * @param bool $forceDownloadService Force the result of this operation to be sent via download service.  For testing/app development purposes (optional)
     * @return \PureCloudSDK\UserScheduleAdherenceListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitAdherence($managementUnitId, $forceDownloadService = null)
    {
        list($response) = $this->getWorkforcemanagementManagementunitAdherenceWithHttpInfo($managementUnitId, $forceDownloadService);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitAdherenceWithHttpInfo
     *
     * Get a list of user schedule adherence records for the requested management unit
     *
     * @param string $managementUnitId The management unit ID of the management unit. (required)
     * @param bool $forceDownloadService Force the result of this operation to be sent via download service.  For testing/app development purposes (optional)
     * @return Array of \PureCloudSDK\UserScheduleAdherenceListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitAdherenceWithHttpInfo($managementUnitId, $forceDownloadService = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitAdherence');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/adherence";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($forceDownloadService !== null) {
            $queryParams['forceDownloadService'] = $this->apiClient->getSerializer()->toQueryValue($forceDownloadService);
        }
        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\UserScheduleAdherenceListing',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/adherence'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\UserScheduleAdherenceListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\UserScheduleAdherenceListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitAgent
     *
     * Get data for agent in the management unit
     *
     * @param string $managementUnitId The id of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $agentId The agent id (required)
     * @param bool $excludeCapabilities Excludes all capabilities of the agent such as queues, languages, and skills (optional)
     * @return \PureCloudSDK\WfmAgent
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitAgent($managementUnitId, $agentId, $excludeCapabilities = null)
    {
        list($response) = $this->getWorkforcemanagementManagementunitAgentWithHttpInfo($managementUnitId, $agentId, $excludeCapabilities);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitAgentWithHttpInfo
     *
     * Get data for agent in the management unit
     *
     * @param string $managementUnitId The id of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $agentId The agent id (required)
     * @param bool $excludeCapabilities Excludes all capabilities of the agent such as queues, languages, and skills (optional)
     * @return Array of \PureCloudSDK\WfmAgent, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitAgentWithHttpInfo($managementUnitId, $agentId, $excludeCapabilities = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitAgent');
        }
        // verify the required parameter 'agentId' is set
        if ($agentId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $agentId when calling getWorkforcemanagementManagementunitAgent');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/agents/{agentId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($excludeCapabilities !== null) {
            $queryParams['excludeCapabilities'] = $this->apiClient->getSerializer()->toQueryValue($excludeCapabilities);
        }
        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($agentId !== null) {
            $resourcePath = str_replace(
                "{" . "agentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($agentId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WfmAgent',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/agents/{agentId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WfmAgent', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WfmAgent', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitAgentShifttrades
     *
     * Gets all the shift trades for a given agent
     *
     * @param string $managementUnitId The id of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $agentId The agent id (required)
     * @return \PureCloudSDK\ShiftTradeListResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitAgentShifttrades($managementUnitId, $agentId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitAgentShifttradesWithHttpInfo($managementUnitId, $agentId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitAgentShifttradesWithHttpInfo
     *
     * Gets all the shift trades for a given agent
     *
     * @param string $managementUnitId The id of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $agentId The agent id (required)
     * @return Array of \PureCloudSDK\ShiftTradeListResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitAgentShifttradesWithHttpInfo($managementUnitId, $agentId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitAgentShifttrades');
        }
        // verify the required parameter 'agentId' is set
        if ($agentId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $agentId when calling getWorkforcemanagementManagementunitAgentShifttrades');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/agents/{agentId}/shifttrades";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($agentId !== null) {
            $resourcePath = str_replace(
                "{" . "agentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($agentId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ShiftTradeListResponse',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/agents/{agentId}/shifttrades'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ShiftTradeListResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ShiftTradeListResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitIntradayQueues
     *
     * Gone.  Moved under business units
     *
     * @param string $muId The management unit ID of the management unit (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitIntradayQueues($muId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitIntradayQueuesWithHttpInfo($muId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitIntradayQueuesWithHttpInfo
     *
     * Gone.  Moved under business units
     *
     * @param string $muId The management unit ID of the management unit (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitIntradayQueuesWithHttpInfo($muId)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling getWorkforcemanagementManagementunitIntradayQueues');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/intraday/queues";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{muId}/intraday/queues'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitSchedulingRun
     *
     * Gone.  Scheduling has moved under business units
     *
     * @param string $managementUnitId (Deprecated/gone): The ID of the management unit. (required)
     * @param string $runId The ID of the schedule run (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitSchedulingRun($managementUnitId, $runId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitSchedulingRunWithHttpInfo($managementUnitId, $runId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitSchedulingRunWithHttpInfo
     *
     * Gone.  Scheduling has moved under business units
     *
     * @param string $managementUnitId (Deprecated/gone): The ID of the management unit. (required)
     * @param string $runId The ID of the schedule run (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitSchedulingRunWithHttpInfo($managementUnitId, $runId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitSchedulingRun');
        }
        // verify the required parameter 'runId' is set
        if ($runId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $runId when calling getWorkforcemanagementManagementunitSchedulingRun');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/scheduling/runs/{runId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($runId !== null) {
            $resourcePath = str_replace(
                "{" . "runId" . "}",
                $this->apiClient->getSerializer()->toPathValue($runId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/scheduling/runs/{runId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitSchedulingRunResult
     *
     * Gone.  Scheduling has moved under business units
     *
     * @param string $managementUnitId (Deprecated/gone): The ID of the management unit. (required)
     * @param string $runId The ID of the schedule run (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitSchedulingRunResult($managementUnitId, $runId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitSchedulingRunResultWithHttpInfo($managementUnitId, $runId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitSchedulingRunResultWithHttpInfo
     *
     * Gone.  Scheduling has moved under business units
     *
     * @param string $managementUnitId (Deprecated/gone): The ID of the management unit. (required)
     * @param string $runId The ID of the schedule run (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitSchedulingRunResultWithHttpInfo($managementUnitId, $runId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitSchedulingRunResult');
        }
        // verify the required parameter 'runId' is set
        if ($runId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $runId when calling getWorkforcemanagementManagementunitSchedulingRunResult');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/scheduling/runs/{runId}/result";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($runId !== null) {
            $resourcePath = str_replace(
                "{" . "runId" . "}",
                $this->apiClient->getSerializer()->toPathValue($runId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/scheduling/runs/{runId}/result'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitSchedulingRuns
     *
     * Gone.  Scheduling has moved under business units
     *
     * @param string $managementUnitId (Deprecated/gone): The ID of the management unit. (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitSchedulingRuns($managementUnitId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitSchedulingRunsWithHttpInfo($managementUnitId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitSchedulingRunsWithHttpInfo
     *
     * Gone.  Scheduling has moved under business units
     *
     * @param string $managementUnitId (Deprecated/gone): The ID of the management unit. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitSchedulingRunsWithHttpInfo($managementUnitId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitSchedulingRuns');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/scheduling/runs";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/scheduling/runs'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitServicegoalgroup
     *
     * Gone. Replaced with service goal templates and planning groups under business units
     *
     * @param string $managementUnitId (Deprecated/gone): The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $serviceGoalGroupId Gone.  The ID of the service goal group to fetch (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitServicegoalgroup($managementUnitId, $serviceGoalGroupId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitServicegoalgroupWithHttpInfo($managementUnitId, $serviceGoalGroupId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitServicegoalgroupWithHttpInfo
     *
     * Gone. Replaced with service goal templates and planning groups under business units
     *
     * @param string $managementUnitId (Deprecated/gone): The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $serviceGoalGroupId Gone.  The ID of the service goal group to fetch (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitServicegoalgroupWithHttpInfo($managementUnitId, $serviceGoalGroupId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitServicegoalgroup');
        }
        // verify the required parameter 'serviceGoalGroupId' is set
        if ($serviceGoalGroupId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $serviceGoalGroupId when calling getWorkforcemanagementManagementunitServicegoalgroup');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/servicegoalgroups/{serviceGoalGroupId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($serviceGoalGroupId !== null) {
            $resourcePath = str_replace(
                "{" . "serviceGoalGroupId" . "}",
                $this->apiClient->getSerializer()->toPathValue($serviceGoalGroupId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/servicegoalgroups/{serviceGoalGroupId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitServicegoalgroups
     *
     * Gone. Replaced with service goal templates and planning groups under business units
     *
     * @param string $managementUnitId (Deprecated/gone): The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitServicegoalgroups($managementUnitId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitServicegoalgroupsWithHttpInfo($managementUnitId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitServicegoalgroupsWithHttpInfo
     *
     * Gone. Replaced with service goal templates and planning groups under business units
     *
     * @param string $managementUnitId (Deprecated/gone): The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitServicegoalgroupsWithHttpInfo($managementUnitId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitServicegoalgroups');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/servicegoalgroups";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/servicegoalgroups'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitSettings
     *
     * Gone. Get management unit settings via expand parameters on the GET management unit
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitSettings($muId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitSettingsWithHttpInfo($muId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitSettingsWithHttpInfo
     *
     * Gone. Get management unit settings via expand parameters on the GET management unit
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitSettingsWithHttpInfo($muId)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling getWorkforcemanagementManagementunitSettings');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/settings";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{muId}/settings'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitShifttradesMatched
     *
     * Gets a summary of all shift trades in the matched state
     *
     * @param string $muId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return \PureCloudSDK\ShiftTradeMatchesSummaryResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitShifttradesMatched($muId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitShifttradesMatchedWithHttpInfo($muId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitShifttradesMatchedWithHttpInfo
     *
     * Gets a summary of all shift trades in the matched state
     *
     * @param string $muId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return Array of \PureCloudSDK\ShiftTradeMatchesSummaryResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitShifttradesMatchedWithHttpInfo($muId)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling getWorkforcemanagementManagementunitShifttradesMatched');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/shifttrades/matched";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ShiftTradeMatchesSummaryResponse',
                '/api/v2/workforcemanagement/managementunits/{muId}/shifttrades/matched'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ShiftTradeMatchesSummaryResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ShiftTradeMatchesSummaryResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitShifttradesUsers
     *
     * Gets list of users available for whom you can send direct shift trade requests
     *
     * @param string $muId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return \PureCloudSDK\WfmUserEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitShifttradesUsers($muId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitShifttradesUsersWithHttpInfo($muId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitShifttradesUsersWithHttpInfo
     *
     * Gets list of users available for whom you can send direct shift trade requests
     *
     * @param string $muId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return Array of \PureCloudSDK\WfmUserEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitShifttradesUsersWithHttpInfo($muId)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling getWorkforcemanagementManagementunitShifttradesUsers');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/shifttrades/users";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WfmUserEntityListing',
                '/api/v2/workforcemanagement/managementunits/{muId}/shifttrades/users'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WfmUserEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WfmUserEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitUserTimeoffrequest
     *
     * Get a time off request
     *
     * @param string $muId The muId of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $userId The userId to whom the Time Off Request applies. (required)
     * @param string $timeOffRequestId Time Off Request Id (required)
     * @return \PureCloudSDK\TimeOffRequestResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitUserTimeoffrequest($muId, $userId, $timeOffRequestId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitUserTimeoffrequestWithHttpInfo($muId, $userId, $timeOffRequestId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitUserTimeoffrequestWithHttpInfo
     *
     * Get a time off request
     *
     * @param string $muId The muId of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $userId The userId to whom the Time Off Request applies. (required)
     * @param string $timeOffRequestId Time Off Request Id (required)
     * @return Array of \PureCloudSDK\TimeOffRequestResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitUserTimeoffrequestWithHttpInfo($muId, $userId, $timeOffRequestId)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling getWorkforcemanagementManagementunitUserTimeoffrequest');
        }
        // verify the required parameter 'userId' is set
        if ($userId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $userId when calling getWorkforcemanagementManagementunitUserTimeoffrequest');
        }
        // verify the required parameter 'timeOffRequestId' is set
        if ($timeOffRequestId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $timeOffRequestId when calling getWorkforcemanagementManagementunitUserTimeoffrequest');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/users/{userId}/timeoffrequests/{timeOffRequestId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // path params
        if ($userId !== null) {
            $resourcePath = str_replace(
                "{" . "userId" . "}",
                $this->apiClient->getSerializer()->toPathValue($userId),
                $resourcePath
            );
        }
        // path params
        if ($timeOffRequestId !== null) {
            $resourcePath = str_replace(
                "{" . "timeOffRequestId" . "}",
                $this->apiClient->getSerializer()->toPathValue($timeOffRequestId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\TimeOffRequestResponse',
                '/api/v2/workforcemanagement/managementunits/{muId}/users/{userId}/timeoffrequests/{timeOffRequestId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\TimeOffRequestResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\TimeOffRequestResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitUserTimeoffrequests
     *
     * Get a list of time off requests for a given user
     *
     * @param string $muId The muId of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $userId The userId to whom the Time Off Request applies. (required)
     * @param bool $recentlyReviewed Limit results to requests that have been reviewed within the preceding 30 days (optional, default to false)
     * @return \PureCloudSDK\TimeOffRequestList
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitUserTimeoffrequests($muId, $userId, $recentlyReviewed = null)
    {
        list($response) = $this->getWorkforcemanagementManagementunitUserTimeoffrequestsWithHttpInfo($muId, $userId, $recentlyReviewed);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitUserTimeoffrequestsWithHttpInfo
     *
     * Get a list of time off requests for a given user
     *
     * @param string $muId The muId of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $userId The userId to whom the Time Off Request applies. (required)
     * @param bool $recentlyReviewed Limit results to requests that have been reviewed within the preceding 30 days (optional, default to false)
     * @return Array of \PureCloudSDK\TimeOffRequestList, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitUserTimeoffrequestsWithHttpInfo($muId, $userId, $recentlyReviewed = null)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling getWorkforcemanagementManagementunitUserTimeoffrequests');
        }
        // verify the required parameter 'userId' is set
        if ($userId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $userId when calling getWorkforcemanagementManagementunitUserTimeoffrequests');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/users/{userId}/timeoffrequests";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($recentlyReviewed !== null) {
            $queryParams['recentlyReviewed'] = $this->apiClient->getSerializer()->toQueryValue($recentlyReviewed);
        }
        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // path params
        if ($userId !== null) {
            $resourcePath = str_replace(
                "{" . "userId" . "}",
                $this->apiClient->getSerializer()->toPathValue($userId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\TimeOffRequestList',
                '/api/v2/workforcemanagement/managementunits/{muId}/users/{userId}/timeoffrequests'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\TimeOffRequestList', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\TimeOffRequestList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitUsers
     *
     * Get users in the management unit
     *
     * @param string $muId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return \PureCloudSDK\WfmUserEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitUsers($muId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitUsersWithHttpInfo($muId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitUsersWithHttpInfo
     *
     * Get users in the management unit
     *
     * @param string $muId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return Array of \PureCloudSDK\WfmUserEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitUsersWithHttpInfo($muId)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling getWorkforcemanagementManagementunitUsers');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/users";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WfmUserEntityListing',
                '/api/v2/workforcemanagement/managementunits/{muId}/users'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WfmUserEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WfmUserEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitWeekSchedule
     *
     * Deprecated.  Use the equivalent business unit resource instead. Get a week schedule
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param string $scheduleId The ID of the schedule to fetch (required)
     * @param string $expand Which fields, if any, to expand (optional)
     * @param bool $forceDownloadService Force the result of this operation to be sent via download service.  For testing/app development purposes (optional)
     * @return \PureCloudSDK\WeekScheduleResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWeekSchedule($managementUnitId, $weekId, $scheduleId, $expand = null, $forceDownloadService = null)
    {
        list($response) = $this->getWorkforcemanagementManagementunitWeekScheduleWithHttpInfo($managementUnitId, $weekId, $scheduleId, $expand, $forceDownloadService);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitWeekScheduleWithHttpInfo
     *
     * Deprecated.  Use the equivalent business unit resource instead. Get a week schedule
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param string $scheduleId The ID of the schedule to fetch (required)
     * @param string $expand Which fields, if any, to expand (optional)
     * @param bool $forceDownloadService Force the result of this operation to be sent via download service.  For testing/app development purposes (optional)
     * @return Array of \PureCloudSDK\WeekScheduleResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWeekScheduleWithHttpInfo($managementUnitId, $weekId, $scheduleId, $expand = null, $forceDownloadService = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitWeekSchedule');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling getWorkforcemanagementManagementunitWeekSchedule');
        }
        // verify the required parameter 'scheduleId' is set
        if ($scheduleId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $scheduleId when calling getWorkforcemanagementManagementunitWeekSchedule');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // query params
        if ($forceDownloadService !== null) {
            $queryParams['forceDownloadService'] = $this->apiClient->getSerializer()->toQueryValue($forceDownloadService);
        }
        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // path params
        if ($scheduleId !== null) {
            $resourcePath = str_replace(
                "{" . "scheduleId" . "}",
                $this->apiClient->getSerializer()->toPathValue($scheduleId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WeekScheduleResponse',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WeekScheduleResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WeekScheduleResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitWeekScheduleGenerationresults
     *
     * Gone.  Scheduling has moved under business units
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param string $scheduleId Gone/deprecated. The ID of the schedule to fetch generation results (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWeekScheduleGenerationresults($managementUnitId, $weekId, $scheduleId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitWeekScheduleGenerationresultsWithHttpInfo($managementUnitId, $weekId, $scheduleId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitWeekScheduleGenerationresultsWithHttpInfo
     *
     * Gone.  Scheduling has moved under business units
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param string $scheduleId Gone/deprecated. The ID of the schedule to fetch generation results (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWeekScheduleGenerationresultsWithHttpInfo($managementUnitId, $weekId, $scheduleId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitWeekScheduleGenerationresults');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling getWorkforcemanagementManagementunitWeekScheduleGenerationresults');
        }
        // verify the required parameter 'scheduleId' is set
        if ($scheduleId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $scheduleId when calling getWorkforcemanagementManagementunitWeekScheduleGenerationresults');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}/generationresults";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // path params
        if ($scheduleId !== null) {
            $resourcePath = str_replace(
                "{" . "scheduleId" . "}",
                $this->apiClient->getSerializer()->toPathValue($scheduleId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}/generationresults'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitWeekSchedules
     *
     * Deprecated.  Use the equivalent business unit resource instead. Get the list of schedules in a week in management unit
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param bool $includeOnlyPublished Return only published schedules (optional)
     * @param string $earliestWeekDate The start date of the earliest week to query in yyyy-MM-dd format (optional)
     * @param string $latestWeekDate The start date of the latest week to query in yyyy-MM-dd format (optional)
     * @return \PureCloudSDK\WeekScheduleListResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWeekSchedules($managementUnitId, $weekId, $includeOnlyPublished = null, $earliestWeekDate = null, $latestWeekDate = null)
    {
        list($response) = $this->getWorkforcemanagementManagementunitWeekSchedulesWithHttpInfo($managementUnitId, $weekId, $includeOnlyPublished, $earliestWeekDate, $latestWeekDate);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitWeekSchedulesWithHttpInfo
     *
     * Deprecated.  Use the equivalent business unit resource instead. Get the list of schedules in a week in management unit
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param bool $includeOnlyPublished Return only published schedules (optional)
     * @param string $earliestWeekDate The start date of the earliest week to query in yyyy-MM-dd format (optional)
     * @param string $latestWeekDate The start date of the latest week to query in yyyy-MM-dd format (optional)
     * @return Array of \PureCloudSDK\WeekScheduleListResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWeekSchedulesWithHttpInfo($managementUnitId, $weekId, $includeOnlyPublished = null, $earliestWeekDate = null, $latestWeekDate = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitWeekSchedules');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling getWorkforcemanagementManagementunitWeekSchedules');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($includeOnlyPublished !== null) {
            $queryParams['includeOnlyPublished'] = $this->apiClient->getSerializer()->toQueryValue($includeOnlyPublished);
        }
        // query params
        if ($earliestWeekDate !== null) {
            $queryParams['earliestWeekDate'] = $this->apiClient->getSerializer()->toQueryValue($earliestWeekDate);
        }
        // query params
        if ($latestWeekDate !== null) {
            $queryParams['latestWeekDate'] = $this->apiClient->getSerializer()->toQueryValue($latestWeekDate);
        }
        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WeekScheduleListResponse',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WeekScheduleListResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WeekScheduleListResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitWeekShifttrades
     *
     * Gets all the shift trades for a given week
     *
     * @param string $managementUnitId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \DateTime $weekDateId The start date of the week schedule in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param bool $evaluateMatches Whether to evaluate the matches for violations (optional, default to true)
     * @return \PureCloudSDK\WeekShiftTradeListResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWeekShifttrades($managementUnitId, $weekDateId, $evaluateMatches = null)
    {
        list($response) = $this->getWorkforcemanagementManagementunitWeekShifttradesWithHttpInfo($managementUnitId, $weekDateId, $evaluateMatches);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitWeekShifttradesWithHttpInfo
     *
     * Gets all the shift trades for a given week
     *
     * @param string $managementUnitId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \DateTime $weekDateId The start date of the week schedule in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param bool $evaluateMatches Whether to evaluate the matches for violations (optional, default to true)
     * @return Array of \PureCloudSDK\WeekShiftTradeListResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWeekShifttradesWithHttpInfo($managementUnitId, $weekDateId, $evaluateMatches = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitWeekShifttrades');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling getWorkforcemanagementManagementunitWeekShifttrades');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shifttrades";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($evaluateMatches !== null) {
            $queryParams['evaluateMatches'] = $this->apiClient->getSerializer()->toQueryValue($evaluateMatches);
        }
        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WeekShiftTradeListResponse',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shifttrades'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WeekShiftTradeListResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WeekShiftTradeListResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitWeekShorttermforecastFinal
     *
     * Gone. Use equivalent business unit resource instead
     *
     * @param string $managementUnitId (Deprecated/gone): The id of the management unit. (required)
     * @param string $weekDateId (Deprecated/gone): The week start date of the forecast in yyyy-MM-dd format (required)
     * @param string $forecastId (Gone/Deprecated): The ID of the forecast (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWeekShorttermforecastFinal($managementUnitId, $weekDateId, $forecastId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitWeekShorttermforecastFinalWithHttpInfo($managementUnitId, $weekDateId, $forecastId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitWeekShorttermforecastFinalWithHttpInfo
     *
     * Gone. Use equivalent business unit resource instead
     *
     * @param string $managementUnitId (Deprecated/gone): The id of the management unit. (required)
     * @param string $weekDateId (Deprecated/gone): The week start date of the forecast in yyyy-MM-dd format (required)
     * @param string $forecastId (Gone/Deprecated): The ID of the forecast (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWeekShorttermforecastFinalWithHttpInfo($managementUnitId, $weekDateId, $forecastId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitWeekShorttermforecastFinal');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling getWorkforcemanagementManagementunitWeekShorttermforecastFinal');
        }
        // verify the required parameter 'forecastId' is set
        if ($forecastId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $forecastId when calling getWorkforcemanagementManagementunitWeekShorttermforecastFinal');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}/final";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // path params
        if ($forecastId !== null) {
            $resourcePath = str_replace(
                "{" . "forecastId" . "}",
                $this->apiClient->getSerializer()->toPathValue($forecastId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}/final'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitWeekShorttermforecasts
     *
     * Gone. Use equivalent business unit resource instead
     *
     * @param string $managementUnitId (Deprecated/gone): The id of the management unit. (required)
     * @param string $weekDateId (Deprecated/gone): The week start date of the forecast in yyyy-MM-dd format (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWeekShorttermforecasts($managementUnitId, $weekDateId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitWeekShorttermforecastsWithHttpInfo($managementUnitId, $weekDateId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitWeekShorttermforecastsWithHttpInfo
     *
     * Gone. Use equivalent business unit resource instead
     *
     * @param string $managementUnitId (Deprecated/gone): The id of the management unit. (required)
     * @param string $weekDateId (Deprecated/gone): The week start date of the forecast in yyyy-MM-dd format (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWeekShorttermforecastsWithHttpInfo($managementUnitId, $weekDateId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitWeekShorttermforecasts');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling getWorkforcemanagementManagementunitWeekShorttermforecasts');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitWorkplan
     *
     * Get a work plan
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $workPlanId The ID of the work plan to fetch (required)
     * @return \PureCloudSDK\WorkPlan
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWorkplan($managementUnitId, $workPlanId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitWorkplanWithHttpInfo($managementUnitId, $workPlanId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitWorkplanWithHttpInfo
     *
     * Get a work plan
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $workPlanId The ID of the work plan to fetch (required)
     * @return Array of \PureCloudSDK\WorkPlan, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWorkplanWithHttpInfo($managementUnitId, $workPlanId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitWorkplan');
        }
        // verify the required parameter 'workPlanId' is set
        if ($workPlanId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workPlanId when calling getWorkforcemanagementManagementunitWorkplan');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans/{workPlanId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($workPlanId !== null) {
            $resourcePath = str_replace(
                "{" . "workPlanId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workPlanId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WorkPlan',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans/{workPlanId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WorkPlan', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WorkPlan', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitWorkplans
     *
     * Get work plans
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string[] $expand  (optional)
     * @return \PureCloudSDK\WorkPlanListResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWorkplans($managementUnitId, $expand = null)
    {
        list($response) = $this->getWorkforcemanagementManagementunitWorkplansWithHttpInfo($managementUnitId, $expand);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitWorkplansWithHttpInfo
     *
     * Get work plans
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string[] $expand  (optional)
     * @return Array of \PureCloudSDK\WorkPlanListResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWorkplansWithHttpInfo($managementUnitId, $expand = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitWorkplans');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if (is_array($expand)) {
            $expand = $this->apiClient->getSerializer()->serializeCollection($expand, 'multi', true);
        }
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WorkPlanListResponse',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WorkPlanListResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WorkPlanListResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunits
     *
     * Get management units
     *
     * @param int $pageSize  (optional)
     * @param int $pageNumber  (optional)
     * @param string $expand  (optional)
     * @param string $feature  (optional)
     * @param string $divisionId  (optional)
     * @return \PureCloudSDK\ManagementUnitListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunits($pageSize = null, $pageNumber = null, $expand = null, $feature = null, $divisionId = null)
    {
        list($response) = $this->getWorkforcemanagementManagementunitsWithHttpInfo($pageSize, $pageNumber, $expand, $feature, $divisionId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitsWithHttpInfo
     *
     * Get management units
     *
     * @param int $pageSize  (optional)
     * @param int $pageNumber  (optional)
     * @param string $expand  (optional)
     * @param string $feature  (optional)
     * @param string $divisionId  (optional)
     * @return Array of \PureCloudSDK\ManagementUnitListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitsWithHttpInfo($pageSize = null, $pageNumber = null, $expand = null, $feature = null, $divisionId = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // query params
        if ($feature !== null) {
            $queryParams['feature'] = $this->apiClient->getSerializer()->toQueryValue($feature);
        }
        // query params
        if ($divisionId !== null) {
            $queryParams['divisionId'] = $this->apiClient->getSerializer()->toQueryValue($divisionId);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ManagementUnitListing',
                '/api/v2/workforcemanagement/managementunits'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ManagementUnitListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ManagementUnitListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitsDivisionviews
     *
     * Get management units across divisions
     *
     * @param string[] $divisionId The divisionIds to filter by. If omitted, will return all divisions (optional)
     * @return \PureCloudSDK\ManagementUnitListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitsDivisionviews($divisionId = null)
    {
        list($response) = $this->getWorkforcemanagementManagementunitsDivisionviewsWithHttpInfo($divisionId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitsDivisionviewsWithHttpInfo
     *
     * Get management units across divisions
     *
     * @param string[] $divisionId The divisionIds to filter by. If omitted, will return all divisions (optional)
     * @return Array of \PureCloudSDK\ManagementUnitListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitsDivisionviewsWithHttpInfo($divisionId = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/divisionviews";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if (is_array($divisionId)) {
            $divisionId = $this->apiClient->getSerializer()->serializeCollection($divisionId, 'multi', true);
        }
        if ($divisionId !== null) {
            $queryParams['divisionId'] = $this->apiClient->getSerializer()->toQueryValue($divisionId);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ManagementUnitListing',
                '/api/v2/workforcemanagement/managementunits/divisionviews'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ManagementUnitListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ManagementUnitListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementNotifications
     *
     * Get a list of notifications for the current user
     *
     * @return \PureCloudSDK\NotificationsResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementNotifications()
    {
        list($response) = $this->getWorkforcemanagementNotificationsWithHttpInfo();
        return $response;
    }

    /**
     * Operation getWorkforcemanagementNotificationsWithHttpInfo
     *
     * Get a list of notifications for the current user
     *
     * @return Array of \PureCloudSDK\NotificationsResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementNotificationsWithHttpInfo()
    {
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/notifications";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\NotificationsResponse',
                '/api/v2/workforcemanagement/notifications'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\NotificationsResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\NotificationsResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementSchedulingjob
     *
     * Get status of the scheduling job
     *
     * @param string $jobId The id of the scheduling job (required)
     * @return \PureCloudSDK\SchedulingStatusResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementSchedulingjob($jobId)
    {
        list($response) = $this->getWorkforcemanagementSchedulingjobWithHttpInfo($jobId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementSchedulingjobWithHttpInfo
     *
     * Get status of the scheduling job
     *
     * @param string $jobId The id of the scheduling job (required)
     * @return Array of \PureCloudSDK\SchedulingStatusResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementSchedulingjobWithHttpInfo($jobId)
    {
        // verify the required parameter 'jobId' is set
        if ($jobId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $jobId when calling getWorkforcemanagementSchedulingjob');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/schedulingjobs/{jobId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($jobId !== null) {
            $resourcePath = str_replace(
                "{" . "jobId" . "}",
                $this->apiClient->getSerializer()->toPathValue($jobId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\SchedulingStatusResponse',
                '/api/v2/workforcemanagement/schedulingjobs/{jobId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\SchedulingStatusResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\SchedulingStatusResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementShifttrades
     *
     * Gets all of my shift trades
     *
     * @return \PureCloudSDK\ShiftTradeListResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementShifttrades()
    {
        list($response) = $this->getWorkforcemanagementShifttradesWithHttpInfo();
        return $response;
    }

    /**
     * Operation getWorkforcemanagementShifttradesWithHttpInfo
     *
     * Gets all of my shift trades
     *
     * @return Array of \PureCloudSDK\ShiftTradeListResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementShifttradesWithHttpInfo()
    {
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/shifttrades";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ShiftTradeListResponse',
                '/api/v2/workforcemanagement/shifttrades'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ShiftTradeListResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ShiftTradeListResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementTimeoffrequest
     *
     * Get a time off request for the current user
     *
     * @param string $timeOffRequestId Time Off Request Id (required)
     * @return \PureCloudSDK\TimeOffRequestResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementTimeoffrequest($timeOffRequestId)
    {
        list($response) = $this->getWorkforcemanagementTimeoffrequestWithHttpInfo($timeOffRequestId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementTimeoffrequestWithHttpInfo
     *
     * Get a time off request for the current user
     *
     * @param string $timeOffRequestId Time Off Request Id (required)
     * @return Array of \PureCloudSDK\TimeOffRequestResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementTimeoffrequestWithHttpInfo($timeOffRequestId)
    {
        // verify the required parameter 'timeOffRequestId' is set
        if ($timeOffRequestId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $timeOffRequestId when calling getWorkforcemanagementTimeoffrequest');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/timeoffrequests/{timeOffRequestId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($timeOffRequestId !== null) {
            $resourcePath = str_replace(
                "{" . "timeOffRequestId" . "}",
                $this->apiClient->getSerializer()->toPathValue($timeOffRequestId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\TimeOffRequestResponse',
                '/api/v2/workforcemanagement/timeoffrequests/{timeOffRequestId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\TimeOffRequestResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\TimeOffRequestResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementTimeoffrequests
     *
     * Get a list of time off requests for the current user
     *
     * @param bool $recentlyReviewed Limit results to requests that have been reviewed within the preceding 30 days (optional, default to false)
     * @return \PureCloudSDK\TimeOffRequestList
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementTimeoffrequests($recentlyReviewed = null)
    {
        list($response) = $this->getWorkforcemanagementTimeoffrequestsWithHttpInfo($recentlyReviewed);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementTimeoffrequestsWithHttpInfo
     *
     * Get a list of time off requests for the current user
     *
     * @param bool $recentlyReviewed Limit results to requests that have been reviewed within the preceding 30 days (optional, default to false)
     * @return Array of \PureCloudSDK\TimeOffRequestList, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementTimeoffrequestsWithHttpInfo($recentlyReviewed = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/timeoffrequests";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($recentlyReviewed !== null) {
            $queryParams['recentlyReviewed'] = $this->apiClient->getSerializer()->toQueryValue($recentlyReviewed);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\TimeOffRequestList',
                '/api/v2/workforcemanagement/timeoffrequests'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\TimeOffRequestList', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\TimeOffRequestList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchWorkforcemanagementBusinessunit
     *
     * Update business unit
     *
     * @param string $businessUnitId The ID of the business unit, or &#39;mine&#39; for the business unit of the logged-in user. (required)
     * @param \PureCloudSDK\UpdateBusinessUnitRequest $body body (optional)
     * @return \PureCloudSDK\BusinessUnit
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementBusinessunit($businessUnitId, $body = null)
    {
        list($response) = $this->patchWorkforcemanagementBusinessunitWithHttpInfo($businessUnitId, $body);
        return $response;
    }

    /**
     * Operation patchWorkforcemanagementBusinessunitWithHttpInfo
     *
     * Update business unit
     *
     * @param string $businessUnitId The ID of the business unit, or &#39;mine&#39; for the business unit of the logged-in user. (required)
     * @param \PureCloudSDK\UpdateBusinessUnitRequest $body body (optional)
     * @return Array of \PureCloudSDK\BusinessUnit, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementBusinessunitWithHttpInfo($businessUnitId, $body = null)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling patchWorkforcemanagementBusinessunit');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BusinessUnit',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BusinessUnit', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BusinessUnit', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchWorkforcemanagementBusinessunitActivitycode
     *
     * Update an activity code
     *
     * @param string $buId The ID of the business unit, or &#39;mine&#39; for the business unit of the logged-in user. (required)
     * @param string $acId The ID of the activity code to update (required)
     * @param \PureCloudSDK\UpdateActivityCodeRequest $body body (optional)
     * @return \PureCloudSDK\BusinessUnitActivityCode
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementBusinessunitActivitycode($buId, $acId, $body = null)
    {
        list($response) = $this->patchWorkforcemanagementBusinessunitActivitycodeWithHttpInfo($buId, $acId, $body);
        return $response;
    }

    /**
     * Operation patchWorkforcemanagementBusinessunitActivitycodeWithHttpInfo
     *
     * Update an activity code
     *
     * @param string $buId The ID of the business unit, or &#39;mine&#39; for the business unit of the logged-in user. (required)
     * @param string $acId The ID of the activity code to update (required)
     * @param \PureCloudSDK\UpdateActivityCodeRequest $body body (optional)
     * @return Array of \PureCloudSDK\BusinessUnitActivityCode, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementBusinessunitActivitycodeWithHttpInfo($buId, $acId, $body = null)
    {
        // verify the required parameter 'buId' is set
        if ($buId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $buId when calling patchWorkforcemanagementBusinessunitActivitycode');
        }
        // verify the required parameter 'acId' is set
        if ($acId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $acId when calling patchWorkforcemanagementBusinessunitActivitycode');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{buId}/activitycodes/{acId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($buId !== null) {
            $resourcePath = str_replace(
                "{" . "buId" . "}",
                $this->apiClient->getSerializer()->toPathValue($buId),
                $resourcePath
            );
        }
        // path params
        if ($acId !== null) {
            $resourcePath = str_replace(
                "{" . "acId" . "}",
                $this->apiClient->getSerializer()->toPathValue($acId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BusinessUnitActivityCode',
                '/api/v2/workforcemanagement/businessunits/{buId}/activitycodes/{acId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BusinessUnitActivityCode', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BusinessUnitActivityCode', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchWorkforcemanagementBusinessunitPlanninggroup
     *
     * Updates the planning group
     *
     * @param string $businessUnitId The ID of the business unit. (required)
     * @param string $planningGroupId The ID of a planning group to update (required)
     * @param \PureCloudSDK\UpdatePlanningGroupRequest $body body (optional)
     * @return \PureCloudSDK\PlanningGroup
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementBusinessunitPlanninggroup($businessUnitId, $planningGroupId, $body = null)
    {
        list($response) = $this->patchWorkforcemanagementBusinessunitPlanninggroupWithHttpInfo($businessUnitId, $planningGroupId, $body);
        return $response;
    }

    /**
     * Operation patchWorkforcemanagementBusinessunitPlanninggroupWithHttpInfo
     *
     * Updates the planning group
     *
     * @param string $businessUnitId The ID of the business unit. (required)
     * @param string $planningGroupId The ID of a planning group to update (required)
     * @param \PureCloudSDK\UpdatePlanningGroupRequest $body body (optional)
     * @return Array of \PureCloudSDK\PlanningGroup, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementBusinessunitPlanninggroupWithHttpInfo($businessUnitId, $planningGroupId, $body = null)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling patchWorkforcemanagementBusinessunitPlanninggroup');
        }
        // verify the required parameter 'planningGroupId' is set
        if ($planningGroupId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $planningGroupId when calling patchWorkforcemanagementBusinessunitPlanninggroup');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/planninggroups/{planningGroupId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($planningGroupId !== null) {
            $resourcePath = str_replace(
                "{" . "planningGroupId" . "}",
                $this->apiClient->getSerializer()->toPathValue($planningGroupId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\PlanningGroup',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/planninggroups/{planningGroupId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\PlanningGroup', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\PlanningGroup', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchWorkforcemanagementBusinessunitSchedulingRun
     *
     * Mark a schedule run as applied
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param string $runId The ID of the schedule run (required)
     * @param \PureCloudSDK\PatchBuScheduleRunRequest $body body (optional)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementBusinessunitSchedulingRun($businessUnitId, $runId, $body = null)
    {
        list($response) = $this->patchWorkforcemanagementBusinessunitSchedulingRunWithHttpInfo($businessUnitId, $runId, $body);
        return $response;
    }

    /**
     * Operation patchWorkforcemanagementBusinessunitSchedulingRunWithHttpInfo
     *
     * Mark a schedule run as applied
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param string $runId The ID of the schedule run (required)
     * @param \PureCloudSDK\PatchBuScheduleRunRequest $body body (optional)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementBusinessunitSchedulingRunWithHttpInfo($businessUnitId, $runId, $body = null)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling patchWorkforcemanagementBusinessunitSchedulingRun');
        }
        // verify the required parameter 'runId' is set
        if ($runId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $runId when calling patchWorkforcemanagementBusinessunitSchedulingRun');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/scheduling/runs/{runId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($runId !== null) {
            $resourcePath = str_replace(
                "{" . "runId" . "}",
                $this->apiClient->getSerializer()->toPathValue($runId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/scheduling/runs/{runId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchWorkforcemanagementBusinessunitServicegoaltemplate
     *
     * Updates a service goal template
     *
     * @param string $businessUnitId The ID of the business unit. (required)
     * @param string $serviceGoalTemplateId The ID of a service goal template to update (required)
     * @param \PureCloudSDK\UpdateServiceGoalTemplate $body body (optional)
     * @return \PureCloudSDK\ServiceGoalTemplate
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementBusinessunitServicegoaltemplate($businessUnitId, $serviceGoalTemplateId, $body = null)
    {
        list($response) = $this->patchWorkforcemanagementBusinessunitServicegoaltemplateWithHttpInfo($businessUnitId, $serviceGoalTemplateId, $body);
        return $response;
    }

    /**
     * Operation patchWorkforcemanagementBusinessunitServicegoaltemplateWithHttpInfo
     *
     * Updates a service goal template
     *
     * @param string $businessUnitId The ID of the business unit. (required)
     * @param string $serviceGoalTemplateId The ID of a service goal template to update (required)
     * @param \PureCloudSDK\UpdateServiceGoalTemplate $body body (optional)
     * @return Array of \PureCloudSDK\ServiceGoalTemplate, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementBusinessunitServicegoaltemplateWithHttpInfo($businessUnitId, $serviceGoalTemplateId, $body = null)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling patchWorkforcemanagementBusinessunitServicegoaltemplate');
        }
        // verify the required parameter 'serviceGoalTemplateId' is set
        if ($serviceGoalTemplateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $serviceGoalTemplateId when calling patchWorkforcemanagementBusinessunitServicegoaltemplate');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/servicegoaltemplates/{serviceGoalTemplateId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($serviceGoalTemplateId !== null) {
            $resourcePath = str_replace(
                "{" . "serviceGoalTemplateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($serviceGoalTemplateId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ServiceGoalTemplate',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/servicegoaltemplates/{serviceGoalTemplateId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ServiceGoalTemplate', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ServiceGoalTemplate', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchWorkforcemanagementManagementunit
     *
     * Update the requested management unit
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\UpdateManagementUnitRequest $body body (optional)
     * @return \PureCloudSDK\ManagementUnit
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunit($muId, $body = null)
    {
        list($response) = $this->patchWorkforcemanagementManagementunitWithHttpInfo($muId, $body);
        return $response;
    }

    /**
     * Operation patchWorkforcemanagementManagementunitWithHttpInfo
     *
     * Update the requested management unit
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\UpdateManagementUnitRequest $body body (optional)
     * @return Array of \PureCloudSDK\ManagementUnit, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitWithHttpInfo($muId, $body = null)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling patchWorkforcemanagementManagementunit');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ManagementUnit',
                '/api/v2/workforcemanagement/managementunits/{muId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ManagementUnit', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ManagementUnit', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchWorkforcemanagementManagementunitActivitycode
     *
     * Deprecated/Gone: Use the new business unit activity code resources
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $acId The ID of the activity code to update (required)
     * @param \PureCloudSDK\UpdateActivityCodeRequest $body body (optional)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitActivitycode($muId, $acId, $body = null)
    {
        list($response) = $this->patchWorkforcemanagementManagementunitActivitycodeWithHttpInfo($muId, $acId, $body);
        return $response;
    }

    /**
     * Operation patchWorkforcemanagementManagementunitActivitycodeWithHttpInfo
     *
     * Deprecated/Gone: Use the new business unit activity code resources
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $acId The ID of the activity code to update (required)
     * @param \PureCloudSDK\UpdateActivityCodeRequest $body body (optional)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitActivitycodeWithHttpInfo($muId, $acId, $body = null)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling patchWorkforcemanagementManagementunitActivitycode');
        }
        // verify the required parameter 'acId' is set
        if ($acId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $acId when calling patchWorkforcemanagementManagementunitActivitycode');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/activitycodes/{acId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // path params
        if ($acId !== null) {
            $resourcePath = str_replace(
                "{" . "acId" . "}",
                $this->apiClient->getSerializer()->toPathValue($acId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{muId}/activitycodes/{acId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchWorkforcemanagementManagementunitSchedulingRun
     *
     * Gone.  Scheduling has moved under business units
     *
     * @param string $managementUnitId (Deprecated/gone): The ID of the management unit. (required)
     * @param string $runId The ID of the schedule run (required)
     * @param \PureCloudSDK\UpdateSchedulingRunRequest $body body (optional)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitSchedulingRun($managementUnitId, $runId, $body = null)
    {
        list($response) = $this->patchWorkforcemanagementManagementunitSchedulingRunWithHttpInfo($managementUnitId, $runId, $body);
        return $response;
    }

    /**
     * Operation patchWorkforcemanagementManagementunitSchedulingRunWithHttpInfo
     *
     * Gone.  Scheduling has moved under business units
     *
     * @param string $managementUnitId (Deprecated/gone): The ID of the management unit. (required)
     * @param string $runId The ID of the schedule run (required)
     * @param \PureCloudSDK\UpdateSchedulingRunRequest $body body (optional)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitSchedulingRunWithHttpInfo($managementUnitId, $runId, $body = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling patchWorkforcemanagementManagementunitSchedulingRun');
        }
        // verify the required parameter 'runId' is set
        if ($runId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $runId when calling patchWorkforcemanagementManagementunitSchedulingRun');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/scheduling/runs/{runId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($runId !== null) {
            $resourcePath = str_replace(
                "{" . "runId" . "}",
                $this->apiClient->getSerializer()->toPathValue($runId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/scheduling/runs/{runId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchWorkforcemanagementManagementunitServicegoalgroup
     *
     * Gone. Replaced with service goal templates and planning groups under business units
     *
     * @param string $managementUnitId (Deprecated/gone): The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $serviceGoalGroupId Gone. The ID of the service goal group to update (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitServicegoalgroup($managementUnitId, $serviceGoalGroupId)
    {
        list($response) = $this->patchWorkforcemanagementManagementunitServicegoalgroupWithHttpInfo($managementUnitId, $serviceGoalGroupId);
        return $response;
    }

    /**
     * Operation patchWorkforcemanagementManagementunitServicegoalgroupWithHttpInfo
     *
     * Gone. Replaced with service goal templates and planning groups under business units
     *
     * @param string $managementUnitId (Deprecated/gone): The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $serviceGoalGroupId Gone. The ID of the service goal group to update (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitServicegoalgroupWithHttpInfo($managementUnitId, $serviceGoalGroupId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling patchWorkforcemanagementManagementunitServicegoalgroup');
        }
        // verify the required parameter 'serviceGoalGroupId' is set
        if ($serviceGoalGroupId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $serviceGoalGroupId when calling patchWorkforcemanagementManagementunitServicegoalgroup');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/servicegoalgroups/{serviceGoalGroupId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($serviceGoalGroupId !== null) {
            $resourcePath = str_replace(
                "{" . "serviceGoalGroupId" . "}",
                $this->apiClient->getSerializer()->toPathValue($serviceGoalGroupId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/servicegoalgroups/{serviceGoalGroupId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchWorkforcemanagementManagementunitSettings
     *
     * Gone. Update settings by PATCHing the management unit
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitSettings($muId)
    {
        list($response) = $this->patchWorkforcemanagementManagementunitSettingsWithHttpInfo($muId);
        return $response;
    }

    /**
     * Operation patchWorkforcemanagementManagementunitSettingsWithHttpInfo
     *
     * Gone. Update settings by PATCHing the management unit
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitSettingsWithHttpInfo($muId)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling patchWorkforcemanagementManagementunitSettings');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/settings";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{muId}/settings'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchWorkforcemanagementManagementunitUserTimeoffrequest
     *
     * Update a time off request
     *
     * @param string $muId The muId of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $userId The id of the user the requested time off request belongs to (required)
     * @param string $timeOffRequestId The id of the time off request to update (required)
     * @param \PureCloudSDK\AdminTimeOffRequestPatch $body body (optional)
     * @return \PureCloudSDK\TimeOffRequestResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitUserTimeoffrequest($muId, $userId, $timeOffRequestId, $body = null)
    {
        list($response) = $this->patchWorkforcemanagementManagementunitUserTimeoffrequestWithHttpInfo($muId, $userId, $timeOffRequestId, $body);
        return $response;
    }

    /**
     * Operation patchWorkforcemanagementManagementunitUserTimeoffrequestWithHttpInfo
     *
     * Update a time off request
     *
     * @param string $muId The muId of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $userId The id of the user the requested time off request belongs to (required)
     * @param string $timeOffRequestId The id of the time off request to update (required)
     * @param \PureCloudSDK\AdminTimeOffRequestPatch $body body (optional)
     * @return Array of \PureCloudSDK\TimeOffRequestResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitUserTimeoffrequestWithHttpInfo($muId, $userId, $timeOffRequestId, $body = null)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling patchWorkforcemanagementManagementunitUserTimeoffrequest');
        }
        // verify the required parameter 'userId' is set
        if ($userId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $userId when calling patchWorkforcemanagementManagementunitUserTimeoffrequest');
        }
        // verify the required parameter 'timeOffRequestId' is set
        if ($timeOffRequestId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $timeOffRequestId when calling patchWorkforcemanagementManagementunitUserTimeoffrequest');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/users/{userId}/timeoffrequests/{timeOffRequestId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // path params
        if ($userId !== null) {
            $resourcePath = str_replace(
                "{" . "userId" . "}",
                $this->apiClient->getSerializer()->toPathValue($userId),
                $resourcePath
            );
        }
        // path params
        if ($timeOffRequestId !== null) {
            $resourcePath = str_replace(
                "{" . "timeOffRequestId" . "}",
                $this->apiClient->getSerializer()->toPathValue($timeOffRequestId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\TimeOffRequestResponse',
                '/api/v2/workforcemanagement/managementunits/{muId}/users/{userId}/timeoffrequests/{timeOffRequestId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\TimeOffRequestResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\TimeOffRequestResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchWorkforcemanagementManagementunitWeekSchedule
     *
     * Gone.  Scheduling has moved under business units
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param string $scheduleId Gone/deprecated. The ID of the schedule to update. Use partial uploads of user schedules if activity count in schedule is greater than 17500 (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitWeekSchedule($managementUnitId, $weekId, $scheduleId)
    {
        list($response) = $this->patchWorkforcemanagementManagementunitWeekScheduleWithHttpInfo($managementUnitId, $weekId, $scheduleId);
        return $response;
    }

    /**
     * Operation patchWorkforcemanagementManagementunitWeekScheduleWithHttpInfo
     *
     * Gone.  Scheduling has moved under business units
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param string $scheduleId Gone/deprecated. The ID of the schedule to update. Use partial uploads of user schedules if activity count in schedule is greater than 17500 (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitWeekScheduleWithHttpInfo($managementUnitId, $weekId, $scheduleId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling patchWorkforcemanagementManagementunitWeekSchedule');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling patchWorkforcemanagementManagementunitWeekSchedule');
        }
        // verify the required parameter 'scheduleId' is set
        if ($scheduleId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $scheduleId when calling patchWorkforcemanagementManagementunitWeekSchedule');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // path params
        if ($scheduleId !== null) {
            $resourcePath = str_replace(
                "{" . "scheduleId" . "}",
                $this->apiClient->getSerializer()->toPathValue($scheduleId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchWorkforcemanagementManagementunitWeekShifttrade
     *
     * Updates a shift trade. This route can only be called by the initiating agent
     *
     * @param string $managementUnitId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \DateTime $weekDateId The start date of the week schedule in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param \PureCloudSDK\PatchShiftTradeRequest $body body (required)
     * @param string $tradeId The ID of the shift trade to update (required)
     * @return \PureCloudSDK\ShiftTradeResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitWeekShifttrade($managementUnitId, $weekDateId, $body, $tradeId)
    {
        list($response) = $this->patchWorkforcemanagementManagementunitWeekShifttradeWithHttpInfo($managementUnitId, $weekDateId, $body, $tradeId);
        return $response;
    }

    /**
     * Operation patchWorkforcemanagementManagementunitWeekShifttradeWithHttpInfo
     *
     * Updates a shift trade. This route can only be called by the initiating agent
     *
     * @param string $managementUnitId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \DateTime $weekDateId The start date of the week schedule in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param \PureCloudSDK\PatchShiftTradeRequest $body body (required)
     * @param string $tradeId The ID of the shift trade to update (required)
     * @return Array of \PureCloudSDK\ShiftTradeResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitWeekShifttradeWithHttpInfo($managementUnitId, $weekDateId, $body, $tradeId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling patchWorkforcemanagementManagementunitWeekShifttrade');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling patchWorkforcemanagementManagementunitWeekShifttrade');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchWorkforcemanagementManagementunitWeekShifttrade');
        }
        // verify the required parameter 'tradeId' is set
        if ($tradeId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $tradeId when calling patchWorkforcemanagementManagementunitWeekShifttrade');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shifttrades/{tradeId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // path params
        if ($tradeId !== null) {
            $resourcePath = str_replace(
                "{" . "tradeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($tradeId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ShiftTradeResponse',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shifttrades/{tradeId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ShiftTradeResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ShiftTradeResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchWorkforcemanagementManagementunitWorkplan
     *
     * Update a work plan
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $workPlanId The ID of the work plan to update (required)
     * @param \PureCloudSDK\WorkPlan $body body (optional)
     * @return \PureCloudSDK\WorkPlan
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitWorkplan($managementUnitId, $workPlanId, $body = null)
    {
        list($response) = $this->patchWorkforcemanagementManagementunitWorkplanWithHttpInfo($managementUnitId, $workPlanId, $body);
        return $response;
    }

    /**
     * Operation patchWorkforcemanagementManagementunitWorkplanWithHttpInfo
     *
     * Update a work plan
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $workPlanId The ID of the work plan to update (required)
     * @param \PureCloudSDK\WorkPlan $body body (optional)
     * @return Array of \PureCloudSDK\WorkPlan, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitWorkplanWithHttpInfo($managementUnitId, $workPlanId, $body = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling patchWorkforcemanagementManagementunitWorkplan');
        }
        // verify the required parameter 'workPlanId' is set
        if ($workPlanId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workPlanId when calling patchWorkforcemanagementManagementunitWorkplan');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans/{workPlanId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($workPlanId !== null) {
            $resourcePath = str_replace(
                "{" . "workPlanId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workPlanId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WorkPlan',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans/{workPlanId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WorkPlan', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WorkPlan', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchWorkforcemanagementTimeoffrequest
     *
     * Update a time off request for the current user
     *
     * @param string $timeOffRequestId Time Off Request Id (required)
     * @param \PureCloudSDK\AgentTimeOffRequestPatch $body body (optional)
     * @return \PureCloudSDK\TimeOffRequestResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementTimeoffrequest($timeOffRequestId, $body = null)
    {
        list($response) = $this->patchWorkforcemanagementTimeoffrequestWithHttpInfo($timeOffRequestId, $body);
        return $response;
    }

    /**
     * Operation patchWorkforcemanagementTimeoffrequestWithHttpInfo
     *
     * Update a time off request for the current user
     *
     * @param string $timeOffRequestId Time Off Request Id (required)
     * @param \PureCloudSDK\AgentTimeOffRequestPatch $body body (optional)
     * @return Array of \PureCloudSDK\TimeOffRequestResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementTimeoffrequestWithHttpInfo($timeOffRequestId, $body = null)
    {
        // verify the required parameter 'timeOffRequestId' is set
        if ($timeOffRequestId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $timeOffRequestId when calling patchWorkforcemanagementTimeoffrequest');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/timeoffrequests/{timeOffRequestId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($timeOffRequestId !== null) {
            $resourcePath = str_replace(
                "{" . "timeOffRequestId" . "}",
                $this->apiClient->getSerializer()->toPathValue($timeOffRequestId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\TimeOffRequestResponse',
                '/api/v2/workforcemanagement/timeoffrequests/{timeOffRequestId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\TimeOffRequestResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\TimeOffRequestResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementAdherenceHistorical
     *
     * Request a historical adherence report for users across management units
     *
     * @param \PureCloudSDK\WfmHistoricalAdherenceQueryForUsers $body body (optional)
     * @return \PureCloudSDK\WfmHistoricalAdherenceResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementAdherenceHistorical($body = null)
    {
        list($response) = $this->postWorkforcemanagementAdherenceHistoricalWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementAdherenceHistoricalWithHttpInfo
     *
     * Request a historical adherence report for users across management units
     *
     * @param \PureCloudSDK\WfmHistoricalAdherenceQueryForUsers $body body (optional)
     * @return Array of \PureCloudSDK\WfmHistoricalAdherenceResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementAdherenceHistoricalWithHttpInfo($body = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/adherence/historical";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WfmHistoricalAdherenceResponse',
                '/api/v2/workforcemanagement/adherence/historical'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WfmHistoricalAdherenceResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 202:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WfmHistoricalAdherenceResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementAgentschedulesMine
     *
     * Get published schedule for the current user
     *
     * @param \PureCloudSDK\BuGetCurrentAgentScheduleRequest $body body (optional)
     * @return \PureCloudSDK\BuCurrentAgentScheduleSearchResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementAgentschedulesMine($body = null)
    {
        list($response) = $this->postWorkforcemanagementAgentschedulesMineWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementAgentschedulesMineWithHttpInfo
     *
     * Get published schedule for the current user
     *
     * @param \PureCloudSDK\BuGetCurrentAgentScheduleRequest $body body (optional)
     * @return Array of \PureCloudSDK\BuCurrentAgentScheduleSearchResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementAgentschedulesMineWithHttpInfo($body = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/agentschedules/mine";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BuCurrentAgentScheduleSearchResponse',
                '/api/v2/workforcemanagement/agentschedules/mine'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BuCurrentAgentScheduleSearchResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BuCurrentAgentScheduleSearchResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementBusinessunitActivitycodes
     *
     * Create a new activity code
     *
     * @param string $buId The ID of the business unit, or &#39;mine&#39; for the business unit of the logged-in user. (required)
     * @param \PureCloudSDK\CreateActivityCodeRequest $body body (optional)
     * @return \PureCloudSDK\BusinessUnitActivityCode
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementBusinessunitActivitycodes($buId, $body = null)
    {
        list($response) = $this->postWorkforcemanagementBusinessunitActivitycodesWithHttpInfo($buId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementBusinessunitActivitycodesWithHttpInfo
     *
     * Create a new activity code
     *
     * @param string $buId The ID of the business unit, or &#39;mine&#39; for the business unit of the logged-in user. (required)
     * @param \PureCloudSDK\CreateActivityCodeRequest $body body (optional)
     * @return Array of \PureCloudSDK\BusinessUnitActivityCode, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementBusinessunitActivitycodesWithHttpInfo($buId, $body = null)
    {
        // verify the required parameter 'buId' is set
        if ($buId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $buId when calling postWorkforcemanagementBusinessunitActivitycodes');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{buId}/activitycodes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($buId !== null) {
            $resourcePath = str_replace(
                "{" . "buId" . "}",
                $this->apiClient->getSerializer()->toPathValue($buId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BusinessUnitActivityCode',
                '/api/v2/workforcemanagement/businessunits/{buId}/activitycodes'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BusinessUnitActivityCode', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BusinessUnitActivityCode', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementBusinessunitAgentschedulesSearch
     *
     * Search published schedules
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param \PureCloudSDK\BuSearchAgentSchedulesRequest $body body (optional)
     * @param bool $forceAsync Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes (optional)
     * @param bool $forceDownloadService Force the result of this operation to be sent via download service.  For testing/app development purposes (optional)
     * @return \PureCloudSDK\BuAsyncAgentSchedulesSearchResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementBusinessunitAgentschedulesSearch($businessUnitId, $body = null, $forceAsync = null, $forceDownloadService = null)
    {
        list($response) = $this->postWorkforcemanagementBusinessunitAgentschedulesSearchWithHttpInfo($businessUnitId, $body, $forceAsync, $forceDownloadService);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementBusinessunitAgentschedulesSearchWithHttpInfo
     *
     * Search published schedules
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param \PureCloudSDK\BuSearchAgentSchedulesRequest $body body (optional)
     * @param bool $forceAsync Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes (optional)
     * @param bool $forceDownloadService Force the result of this operation to be sent via download service.  For testing/app development purposes (optional)
     * @return Array of \PureCloudSDK\BuAsyncAgentSchedulesSearchResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementBusinessunitAgentschedulesSearchWithHttpInfo($businessUnitId, $body = null, $forceAsync = null, $forceDownloadService = null)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling postWorkforcemanagementBusinessunitAgentschedulesSearch');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/agentschedules/search";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($forceAsync !== null) {
            $queryParams['forceAsync'] = $this->apiClient->getSerializer()->toQueryValue($forceAsync);
        }
        // query params
        if ($forceDownloadService !== null) {
            $queryParams['forceDownloadService'] = $this->apiClient->getSerializer()->toQueryValue($forceDownloadService);
        }
        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BuAsyncAgentSchedulesSearchResponse',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/agentschedules/search'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BuAsyncAgentSchedulesSearchResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BuAsyncAgentSchedulesSearchResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementBusinessunitIntraday
     *
     * Get intraday data for the given date for the requested planningGroupIds
     *
     * @param string $businessUnitId The business unit ID of the business unit (required)
     * @param bool $forceAsync Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes (optional)
     * @param \PureCloudSDK\IntradayPlanningGroupRequest $body body (optional)
     * @return \PureCloudSDK\AsyncIntradayResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementBusinessunitIntraday($businessUnitId, $forceAsync = null, $body = null)
    {
        list($response) = $this->postWorkforcemanagementBusinessunitIntradayWithHttpInfo($businessUnitId, $forceAsync, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementBusinessunitIntradayWithHttpInfo
     *
     * Get intraday data for the given date for the requested planningGroupIds
     *
     * @param string $businessUnitId The business unit ID of the business unit (required)
     * @param bool $forceAsync Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes (optional)
     * @param \PureCloudSDK\IntradayPlanningGroupRequest $body body (optional)
     * @return Array of \PureCloudSDK\AsyncIntradayResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementBusinessunitIntradayWithHttpInfo($businessUnitId, $forceAsync = null, $body = null)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling postWorkforcemanagementBusinessunitIntraday');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/intraday";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($forceAsync !== null) {
            $queryParams['forceAsync'] = $this->apiClient->getSerializer()->toQueryValue($forceAsync);
        }
        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\AsyncIntradayResponse',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/intraday'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\AsyncIntradayResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\AsyncIntradayResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementBusinessunitPlanninggroups
     *
     * Adds a new planning group
     *
     * @param string $businessUnitId The ID of the business unit. (required)
     * @param \PureCloudSDK\CreatePlanningGroupRequest $body body (optional)
     * @return \PureCloudSDK\PlanningGroup
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementBusinessunitPlanninggroups($businessUnitId, $body = null)
    {
        list($response) = $this->postWorkforcemanagementBusinessunitPlanninggroupsWithHttpInfo($businessUnitId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementBusinessunitPlanninggroupsWithHttpInfo
     *
     * Adds a new planning group
     *
     * @param string $businessUnitId The ID of the business unit. (required)
     * @param \PureCloudSDK\CreatePlanningGroupRequest $body body (optional)
     * @return Array of \PureCloudSDK\PlanningGroup, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementBusinessunitPlanninggroupsWithHttpInfo($businessUnitId, $body = null)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling postWorkforcemanagementBusinessunitPlanninggroups');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/planninggroups";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\PlanningGroup',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/planninggroups'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\PlanningGroup', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\PlanningGroup', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementBusinessunitServicegoaltemplates
     *
     * Adds a new service goal template
     *
     * @param string $businessUnitId The ID of the business unit. (required)
     * @param \PureCloudSDK\CreateServiceGoalTemplate $body body (optional)
     * @return \PureCloudSDK\ServiceGoalTemplate
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementBusinessunitServicegoaltemplates($businessUnitId, $body = null)
    {
        list($response) = $this->postWorkforcemanagementBusinessunitServicegoaltemplatesWithHttpInfo($businessUnitId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementBusinessunitServicegoaltemplatesWithHttpInfo
     *
     * Adds a new service goal template
     *
     * @param string $businessUnitId The ID of the business unit. (required)
     * @param \PureCloudSDK\CreateServiceGoalTemplate $body body (optional)
     * @return Array of \PureCloudSDK\ServiceGoalTemplate, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementBusinessunitServicegoaltemplatesWithHttpInfo($businessUnitId, $body = null)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling postWorkforcemanagementBusinessunitServicegoaltemplates');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/servicegoaltemplates";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ServiceGoalTemplate',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/servicegoaltemplates'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ServiceGoalTemplate', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ServiceGoalTemplate', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementBusinessunitWeekScheduleAgentschedulesQuery
     *
     * Loads agent schedule data from the schedule. Used in combination with the metadata route
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param \DateTime $weekId First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param string $scheduleId The ID of the schedule (required)
     * @param \PureCloudSDK\BuQueryAgentSchedulesRequest $body body (required)
     * @param bool $forceAsync Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes (optional)
     * @param bool $forceDownloadService Force the result of this operation to be sent via download service.  For testing/app development purposes (optional)
     * @return \PureCloudSDK\BuAsyncAgentSchedulesQueryResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementBusinessunitWeekScheduleAgentschedulesQuery($businessUnitId, $weekId, $scheduleId, $body, $forceAsync = null, $forceDownloadService = null)
    {
        list($response) = $this->postWorkforcemanagementBusinessunitWeekScheduleAgentschedulesQueryWithHttpInfo($businessUnitId, $weekId, $scheduleId, $body, $forceAsync, $forceDownloadService);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementBusinessunitWeekScheduleAgentschedulesQueryWithHttpInfo
     *
     * Loads agent schedule data from the schedule. Used in combination with the metadata route
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param \DateTime $weekId First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param string $scheduleId The ID of the schedule (required)
     * @param \PureCloudSDK\BuQueryAgentSchedulesRequest $body body (required)
     * @param bool $forceAsync Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes (optional)
     * @param bool $forceDownloadService Force the result of this operation to be sent via download service.  For testing/app development purposes (optional)
     * @return Array of \PureCloudSDK\BuAsyncAgentSchedulesQueryResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementBusinessunitWeekScheduleAgentschedulesQueryWithHttpInfo($businessUnitId, $weekId, $scheduleId, $body, $forceAsync = null, $forceDownloadService = null)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling postWorkforcemanagementBusinessunitWeekScheduleAgentschedulesQuery');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling postWorkforcemanagementBusinessunitWeekScheduleAgentschedulesQuery');
        }
        // verify the required parameter 'scheduleId' is set
        if ($scheduleId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $scheduleId when calling postWorkforcemanagementBusinessunitWeekScheduleAgentschedulesQuery');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postWorkforcemanagementBusinessunitWeekScheduleAgentschedulesQuery');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/{scheduleId}/agentschedules/query";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($forceAsync !== null) {
            $queryParams['forceAsync'] = $this->apiClient->getSerializer()->toQueryValue($forceAsync);
        }
        // query params
        if ($forceDownloadService !== null) {
            $queryParams['forceDownloadService'] = $this->apiClient->getSerializer()->toQueryValue($forceDownloadService);
        }
        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // path params
        if ($scheduleId !== null) {
            $resourcePath = str_replace(
                "{" . "scheduleId" . "}",
                $this->apiClient->getSerializer()->toPathValue($scheduleId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BuAsyncAgentSchedulesQueryResponse',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/{scheduleId}/agentschedules/query'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BuAsyncAgentSchedulesQueryResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BuAsyncAgentSchedulesQueryResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementBusinessunitWeekScheduleCopy
     *
     * Copy a schedule
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param \DateTime $weekId First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param string $scheduleId The ID of the schedule to copy (required)
     * @param \PureCloudSDK\BuCopyScheduleRequest $body body (required)
     * @return \PureCloudSDK\BuAsyncScheduleResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementBusinessunitWeekScheduleCopy($businessUnitId, $weekId, $scheduleId, $body)
    {
        list($response) = $this->postWorkforcemanagementBusinessunitWeekScheduleCopyWithHttpInfo($businessUnitId, $weekId, $scheduleId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementBusinessunitWeekScheduleCopyWithHttpInfo
     *
     * Copy a schedule
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param \DateTime $weekId First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param string $scheduleId The ID of the schedule to copy (required)
     * @param \PureCloudSDK\BuCopyScheduleRequest $body body (required)
     * @return Array of \PureCloudSDK\BuAsyncScheduleResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementBusinessunitWeekScheduleCopyWithHttpInfo($businessUnitId, $weekId, $scheduleId, $body)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling postWorkforcemanagementBusinessunitWeekScheduleCopy');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling postWorkforcemanagementBusinessunitWeekScheduleCopy');
        }
        // verify the required parameter 'scheduleId' is set
        if ($scheduleId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $scheduleId when calling postWorkforcemanagementBusinessunitWeekScheduleCopy');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postWorkforcemanagementBusinessunitWeekScheduleCopy');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/{scheduleId}/copy";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // path params
        if ($scheduleId !== null) {
            $resourcePath = str_replace(
                "{" . "scheduleId" . "}",
                $this->apiClient->getSerializer()->toPathValue($scheduleId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BuAsyncScheduleResponse',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/{scheduleId}/copy'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BuAsyncScheduleResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BuAsyncScheduleResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementBusinessunitWeekScheduleReschedule
     *
     * Start a rescheduling run
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param \DateTime $weekId First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param string $scheduleId The ID of the schedule (required)
     * @param \PureCloudSDK\BuRescheduleRequest $body body (required)
     * @return \PureCloudSDK\BuAsyncScheduleRunResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementBusinessunitWeekScheduleReschedule($businessUnitId, $weekId, $scheduleId, $body)
    {
        list($response) = $this->postWorkforcemanagementBusinessunitWeekScheduleRescheduleWithHttpInfo($businessUnitId, $weekId, $scheduleId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementBusinessunitWeekScheduleRescheduleWithHttpInfo
     *
     * Start a rescheduling run
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param \DateTime $weekId First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param string $scheduleId The ID of the schedule (required)
     * @param \PureCloudSDK\BuRescheduleRequest $body body (required)
     * @return Array of \PureCloudSDK\BuAsyncScheduleRunResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementBusinessunitWeekScheduleRescheduleWithHttpInfo($businessUnitId, $weekId, $scheduleId, $body)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling postWorkforcemanagementBusinessunitWeekScheduleReschedule');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling postWorkforcemanagementBusinessunitWeekScheduleReschedule');
        }
        // verify the required parameter 'scheduleId' is set
        if ($scheduleId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $scheduleId when calling postWorkforcemanagementBusinessunitWeekScheduleReschedule');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postWorkforcemanagementBusinessunitWeekScheduleReschedule');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/{scheduleId}/reschedule";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // path params
        if ($scheduleId !== null) {
            $resourcePath = str_replace(
                "{" . "scheduleId" . "}",
                $this->apiClient->getSerializer()->toPathValue($scheduleId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BuAsyncScheduleRunResponse',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/{scheduleId}/reschedule'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BuAsyncScheduleRunResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BuAsyncScheduleRunResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementBusinessunitWeekSchedules
     *
     * Create a blank schedule
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param \DateTime $weekId First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param \PureCloudSDK\BuCreateBlankScheduleRequest $body body (required)
     * @return \PureCloudSDK\BuScheduleMetadata
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementBusinessunitWeekSchedules($businessUnitId, $weekId, $body)
    {
        list($response) = $this->postWorkforcemanagementBusinessunitWeekSchedulesWithHttpInfo($businessUnitId, $weekId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementBusinessunitWeekSchedulesWithHttpInfo
     *
     * Create a blank schedule
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param \DateTime $weekId First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param \PureCloudSDK\BuCreateBlankScheduleRequest $body body (required)
     * @return Array of \PureCloudSDK\BuScheduleMetadata, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementBusinessunitWeekSchedulesWithHttpInfo($businessUnitId, $weekId, $body)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling postWorkforcemanagementBusinessunitWeekSchedules');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling postWorkforcemanagementBusinessunitWeekSchedules');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postWorkforcemanagementBusinessunitWeekSchedules');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BuScheduleMetadata',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BuScheduleMetadata', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BuScheduleMetadata', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementBusinessunitWeekSchedulesGenerate
     *
     * Generate a schedule
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param \DateTime $weekId First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param \PureCloudSDK\BuGenerateScheduleRequest $body body (required)
     * @return \PureCloudSDK\BuAsyncScheduleRunResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementBusinessunitWeekSchedulesGenerate($businessUnitId, $weekId, $body)
    {
        list($response) = $this->postWorkforcemanagementBusinessunitWeekSchedulesGenerateWithHttpInfo($businessUnitId, $weekId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementBusinessunitWeekSchedulesGenerateWithHttpInfo
     *
     * Generate a schedule
     *
     * @param string $businessUnitId The ID of the business unit (required)
     * @param \DateTime $weekId First day of schedule week in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param \PureCloudSDK\BuGenerateScheduleRequest $body body (required)
     * @return Array of \PureCloudSDK\BuAsyncScheduleRunResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementBusinessunitWeekSchedulesGenerateWithHttpInfo($businessUnitId, $weekId, $body)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling postWorkforcemanagementBusinessunitWeekSchedulesGenerate');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling postWorkforcemanagementBusinessunitWeekSchedulesGenerate');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postWorkforcemanagementBusinessunitWeekSchedulesGenerate');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/generate";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BuAsyncScheduleRunResponse',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/generate'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BuAsyncScheduleRunResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BuAsyncScheduleRunResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementBusinessunitWeekShorttermforecastCopy
     *
     * Copy a short term forecast
     *
     * @param string $businessUnitId The business unit ID of the business unit to which the forecast belongs (required)
     * @param \DateTime $weekDateId The week start date of the forecast in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param string $forecastId The ID of the forecast to copy (required)
     * @param \PureCloudSDK\CopyBuForecastRequest $body body (required)
     * @param bool $forceAsync Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes (optional)
     * @return \PureCloudSDK\AsyncForecastOperationResult
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementBusinessunitWeekShorttermforecastCopy($businessUnitId, $weekDateId, $forecastId, $body, $forceAsync = null)
    {
        list($response) = $this->postWorkforcemanagementBusinessunitWeekShorttermforecastCopyWithHttpInfo($businessUnitId, $weekDateId, $forecastId, $body, $forceAsync);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementBusinessunitWeekShorttermforecastCopyWithHttpInfo
     *
     * Copy a short term forecast
     *
     * @param string $businessUnitId The business unit ID of the business unit to which the forecast belongs (required)
     * @param \DateTime $weekDateId The week start date of the forecast in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param string $forecastId The ID of the forecast to copy (required)
     * @param \PureCloudSDK\CopyBuForecastRequest $body body (required)
     * @param bool $forceAsync Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes (optional)
     * @return Array of \PureCloudSDK\AsyncForecastOperationResult, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementBusinessunitWeekShorttermforecastCopyWithHttpInfo($businessUnitId, $weekDateId, $forecastId, $body, $forceAsync = null)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling postWorkforcemanagementBusinessunitWeekShorttermforecastCopy');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling postWorkforcemanagementBusinessunitWeekShorttermforecastCopy');
        }
        // verify the required parameter 'forecastId' is set
        if ($forecastId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $forecastId when calling postWorkforcemanagementBusinessunitWeekShorttermforecastCopy');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postWorkforcemanagementBusinessunitWeekShorttermforecastCopy');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}/copy";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($forceAsync !== null) {
            $queryParams['forceAsync'] = $this->apiClient->getSerializer()->toQueryValue($forceAsync);
        }
        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // path params
        if ($forecastId !== null) {
            $resourcePath = str_replace(
                "{" . "forecastId" . "}",
                $this->apiClient->getSerializer()->toPathValue($forecastId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\AsyncForecastOperationResult',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}/copy'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\AsyncForecastOperationResult', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\AsyncForecastOperationResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\AsyncForecastOperationResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 202:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\AsyncForecastOperationResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementBusinessunitWeekShorttermforecastsGenerate
     *
     * Generate a short term forecast
     *
     * @param string $businessUnitId The business unit ID of the business unit to which the forecast belongs (required)
     * @param \DateTime $weekDateId The week start date of the forecast in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param \PureCloudSDK\GenerateBuForecastRequest $body  (required)
     * @param bool $forceAsync Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes (optional)
     * @return \PureCloudSDK\AsyncForecastOperationResult
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementBusinessunitWeekShorttermforecastsGenerate($businessUnitId, $weekDateId, $body, $forceAsync = null)
    {
        list($response) = $this->postWorkforcemanagementBusinessunitWeekShorttermforecastsGenerateWithHttpInfo($businessUnitId, $weekDateId, $body, $forceAsync);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementBusinessunitWeekShorttermforecastsGenerateWithHttpInfo
     *
     * Generate a short term forecast
     *
     * @param string $businessUnitId The business unit ID of the business unit to which the forecast belongs (required)
     * @param \DateTime $weekDateId The week start date of the forecast in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param \PureCloudSDK\GenerateBuForecastRequest $body  (required)
     * @param bool $forceAsync Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes (optional)
     * @return Array of \PureCloudSDK\AsyncForecastOperationResult, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementBusinessunitWeekShorttermforecastsGenerateWithHttpInfo($businessUnitId, $weekDateId, $body, $forceAsync = null)
    {
        // verify the required parameter 'businessUnitId' is set
        if ($businessUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $businessUnitId when calling postWorkforcemanagementBusinessunitWeekShorttermforecastsGenerate');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling postWorkforcemanagementBusinessunitWeekShorttermforecastsGenerate');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postWorkforcemanagementBusinessunitWeekShorttermforecastsGenerate');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekDateId}/shorttermforecasts/generate";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($forceAsync !== null) {
            $queryParams['forceAsync'] = $this->apiClient->getSerializer()->toQueryValue($forceAsync);
        }
        // path params
        if ($businessUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "businessUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($businessUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\AsyncForecastOperationResult',
                '/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekDateId}/shorttermforecasts/generate'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\AsyncForecastOperationResult', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\AsyncForecastOperationResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\AsyncForecastOperationResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 202:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\AsyncForecastOperationResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementBusinessunits
     *
     * Add a new business unit
     *
     * @param \PureCloudSDK\CreateBusinessUnitRequest $body body (optional)
     * @return \PureCloudSDK\BusinessUnit
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementBusinessunits($body = null)
    {
        list($response) = $this->postWorkforcemanagementBusinessunitsWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementBusinessunitsWithHttpInfo
     *
     * Add a new business unit
     *
     * @param \PureCloudSDK\CreateBusinessUnitRequest $body body (optional)
     * @return Array of \PureCloudSDK\BusinessUnit, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementBusinessunitsWithHttpInfo($body = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/businessunits";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BusinessUnit',
                '/api/v2/workforcemanagement/businessunits'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BusinessUnit', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BusinessUnit', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BusinessUnit', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitActivitycodes
     *
     * Deprecated/Gone: Use the new business unit activity code resources
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitActivitycodes($muId)
    {
        list($response) = $this->postWorkforcemanagementManagementunitActivitycodesWithHttpInfo($muId);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitActivitycodesWithHttpInfo
     *
     * Deprecated/Gone: Use the new business unit activity code resources
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitActivitycodesWithHttpInfo($muId)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling postWorkforcemanagementManagementunitActivitycodes');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/activitycodes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{muId}/activitycodes'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitAgentschedulesSearch
     *
     * Query published schedules for given given time range for set of users
     *
     * @param string $muId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\BuSearchAgentSchedulesRequest $body body (optional)
     * @param bool $forceAsync Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes (optional)
     * @param bool $forceDownloadService Force the result of this operation to be sent via download service.  For testing/app development purposes (optional)
     * @return \PureCloudSDK\BuAsyncAgentSchedulesSearchResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitAgentschedulesSearch($muId, $body = null, $forceAsync = null, $forceDownloadService = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitAgentschedulesSearchWithHttpInfo($muId, $body, $forceAsync, $forceDownloadService);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitAgentschedulesSearchWithHttpInfo
     *
     * Query published schedules for given given time range for set of users
     *
     * @param string $muId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\BuSearchAgentSchedulesRequest $body body (optional)
     * @param bool $forceAsync Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes (optional)
     * @param bool $forceDownloadService Force the result of this operation to be sent via download service.  For testing/app development purposes (optional)
     * @return Array of \PureCloudSDK\BuAsyncAgentSchedulesSearchResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitAgentschedulesSearchWithHttpInfo($muId, $body = null, $forceAsync = null, $forceDownloadService = null)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling postWorkforcemanagementManagementunitAgentschedulesSearch');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/agentschedules/search";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($forceAsync !== null) {
            $queryParams['forceAsync'] = $this->apiClient->getSerializer()->toQueryValue($forceAsync);
        }
        // query params
        if ($forceDownloadService !== null) {
            $queryParams['forceDownloadService'] = $this->apiClient->getSerializer()->toQueryValue($forceDownloadService);
        }
        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BuAsyncAgentSchedulesSearchResponse',
                '/api/v2/workforcemanagement/managementunits/{muId}/agentschedules/search'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BuAsyncAgentSchedulesSearchResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BuAsyncAgentSchedulesSearchResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitHistoricaladherencequery
     *
     * Request a historical adherence report
     *
     * @param string $muId The management unit ID of the management unit (required)
     * @param \PureCloudSDK\WfmHistoricalAdherenceQuery $body body (optional)
     * @return \PureCloudSDK\WfmHistoricalAdherenceResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitHistoricaladherencequery($muId, $body = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitHistoricaladherencequeryWithHttpInfo($muId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitHistoricaladherencequeryWithHttpInfo
     *
     * Request a historical adherence report
     *
     * @param string $muId The management unit ID of the management unit (required)
     * @param \PureCloudSDK\WfmHistoricalAdherenceQuery $body body (optional)
     * @return Array of \PureCloudSDK\WfmHistoricalAdherenceResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitHistoricaladherencequeryWithHttpInfo($muId, $body = null)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling postWorkforcemanagementManagementunitHistoricaladherencequery');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/historicaladherencequery";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WfmHistoricalAdherenceResponse',
                '/api/v2/workforcemanagement/managementunits/{muId}/historicaladherencequery'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WfmHistoricalAdherenceResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 202:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WfmHistoricalAdherenceResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitIntraday
     *
     * Gone.  Moved under business units
     *
     * @param string $muId The management unit ID of the management unit (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitIntraday($muId)
    {
        list($response) = $this->postWorkforcemanagementManagementunitIntradayWithHttpInfo($muId);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitIntradayWithHttpInfo
     *
     * Gone.  Moved under business units
     *
     * @param string $muId The management unit ID of the management unit (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitIntradayWithHttpInfo($muId)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling postWorkforcemanagementManagementunitIntraday');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/intraday";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{muId}/intraday'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitMove
     *
     * Move the requested management unit to a new business unit
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\MoveManagementUnitRequest $body body (optional)
     * @return \PureCloudSDK\MoveManagementUnitResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitMove($muId, $body = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitMoveWithHttpInfo($muId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitMoveWithHttpInfo
     *
     * Move the requested management unit to a new business unit
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\MoveManagementUnitRequest $body body (optional)
     * @return Array of \PureCloudSDK\MoveManagementUnitResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitMoveWithHttpInfo($muId, $body = null)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling postWorkforcemanagementManagementunitMove');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/move";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\MoveManagementUnitResponse',
                '/api/v2/workforcemanagement/managementunits/{muId}/move'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\MoveManagementUnitResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\MoveManagementUnitResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 202:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\MoveManagementUnitResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitSchedulesSearch
     *
     * Query published schedules for given given time range for set of users
     *
     * @param string $muId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\UserListScheduleRequestBody $body body (optional)
     * @return \PureCloudSDK\UserScheduleContainer
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitSchedulesSearch($muId, $body = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitSchedulesSearchWithHttpInfo($muId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitSchedulesSearchWithHttpInfo
     *
     * Query published schedules for given given time range for set of users
     *
     * @param string $muId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\UserListScheduleRequestBody $body body (optional)
     * @return Array of \PureCloudSDK\UserScheduleContainer, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitSchedulesSearchWithHttpInfo($muId, $body = null)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling postWorkforcemanagementManagementunitSchedulesSearch');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/schedules/search";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\UserScheduleContainer',
                '/api/v2/workforcemanagement/managementunits/{muId}/schedules/search'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\UserScheduleContainer', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\UserScheduleContainer', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 408:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitServicegoalgroups
     *
     * Gone. Replaced with service goal templates and planning groups under business units
     *
     * @param string $managementUnitId (Deprecated/gone): The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitServicegoalgroups($managementUnitId)
    {
        list($response) = $this->postWorkforcemanagementManagementunitServicegoalgroupsWithHttpInfo($managementUnitId);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitServicegoalgroupsWithHttpInfo
     *
     * Gone. Replaced with service goal templates and planning groups under business units
     *
     * @param string $managementUnitId (Deprecated/gone): The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitServicegoalgroupsWithHttpInfo($managementUnitId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitServicegoalgroups');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/servicegoalgroups";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/servicegoalgroups'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitTimeoffrequests
     *
     * Create a new time off request
     *
     * @param string $muId The muId of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\CreateAdminTimeOffRequest $body body (optional)
     * @return \PureCloudSDK\TimeOffRequestList
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitTimeoffrequests($muId, $body = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitTimeoffrequestsWithHttpInfo($muId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitTimeoffrequestsWithHttpInfo
     *
     * Create a new time off request
     *
     * @param string $muId The muId of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\CreateAdminTimeOffRequest $body body (optional)
     * @return Array of \PureCloudSDK\TimeOffRequestList, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitTimeoffrequestsWithHttpInfo($muId, $body = null)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling postWorkforcemanagementManagementunitTimeoffrequests');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/timeoffrequests";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\TimeOffRequestList',
                '/api/v2/workforcemanagement/managementunits/{muId}/timeoffrequests'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\TimeOffRequestList', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\TimeOffRequestList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitTimeoffrequestsFetchdetails
     *
     * Gone.  All data is now returned in the query route
     *
     * @param string $muId The muId of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\TimeOffRequestListing $body body (optional)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitTimeoffrequestsFetchdetails($muId, $body = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitTimeoffrequestsFetchdetailsWithHttpInfo($muId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitTimeoffrequestsFetchdetailsWithHttpInfo
     *
     * Gone.  All data is now returned in the query route
     *
     * @param string $muId The muId of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\TimeOffRequestListing $body body (optional)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitTimeoffrequestsFetchdetailsWithHttpInfo($muId, $body = null)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling postWorkforcemanagementManagementunitTimeoffrequestsFetchdetails');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/timeoffrequests/fetchdetails";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{muId}/timeoffrequests/fetchdetails'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitTimeoffrequestsQuery
     *
     * Gets the lookup ids to fetch the specified set of requests
     *
     * @param string $muId The muId of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\TimeOffRequestQueryBody $body body (optional)
     * @return \PureCloudSDK\TimeOffRequestListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitTimeoffrequestsQuery($muId, $body = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitTimeoffrequestsQueryWithHttpInfo($muId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitTimeoffrequestsQueryWithHttpInfo
     *
     * Gets the lookup ids to fetch the specified set of requests
     *
     * @param string $muId The muId of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\TimeOffRequestQueryBody $body body (optional)
     * @return Array of \PureCloudSDK\TimeOffRequestListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitTimeoffrequestsQueryWithHttpInfo($muId, $body = null)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling postWorkforcemanagementManagementunitTimeoffrequestsQuery');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/timeoffrequests/query";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\TimeOffRequestListing',
                '/api/v2/workforcemanagement/managementunits/{muId}/timeoffrequests/query'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\TimeOffRequestListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\TimeOffRequestListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekScheduleCopy
     *
     * Gone.  Scheduling has moved under business units
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param string $scheduleId Gone/deprecated. The ID of the schedule to copy from (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekScheduleCopy($managementUnitId, $weekId, $scheduleId)
    {
        list($response) = $this->postWorkforcemanagementManagementunitWeekScheduleCopyWithHttpInfo($managementUnitId, $weekId, $scheduleId);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekScheduleCopyWithHttpInfo
     *
     * Gone.  Scheduling has moved under business units
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param string $scheduleId Gone/deprecated. The ID of the schedule to copy from (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekScheduleCopyWithHttpInfo($managementUnitId, $weekId, $scheduleId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitWeekScheduleCopy');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling postWorkforcemanagementManagementunitWeekScheduleCopy');
        }
        // verify the required parameter 'scheduleId' is set
        if ($scheduleId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $scheduleId when calling postWorkforcemanagementManagementunitWeekScheduleCopy');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}/copy";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // path params
        if ($scheduleId !== null) {
            $resourcePath = str_replace(
                "{" . "scheduleId" . "}",
                $this->apiClient->getSerializer()->toPathValue($scheduleId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}/copy'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekScheduleReschedule
     *
     * Gone.  Scheduling has moved under business units
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param string $scheduleId Gone/deprecated. The ID of the schedule to re-optimize (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekScheduleReschedule($managementUnitId, $weekId, $scheduleId)
    {
        list($response) = $this->postWorkforcemanagementManagementunitWeekScheduleRescheduleWithHttpInfo($managementUnitId, $weekId, $scheduleId);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekScheduleRescheduleWithHttpInfo
     *
     * Gone.  Scheduling has moved under business units
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param string $scheduleId Gone/deprecated. The ID of the schedule to re-optimize (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekScheduleRescheduleWithHttpInfo($managementUnitId, $weekId, $scheduleId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitWeekScheduleReschedule');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling postWorkforcemanagementManagementunitWeekScheduleReschedule');
        }
        // verify the required parameter 'scheduleId' is set
        if ($scheduleId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $scheduleId when calling postWorkforcemanagementManagementunitWeekScheduleReschedule');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}/reschedule";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // path params
        if ($scheduleId !== null) {
            $resourcePath = str_replace(
                "{" . "scheduleId" . "}",
                $this->apiClient->getSerializer()->toPathValue($scheduleId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}/reschedule'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekSchedules
     *
     * Gone.  Scheduling has moved under business units
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekSchedules($managementUnitId, $weekId)
    {
        list($response) = $this->postWorkforcemanagementManagementunitWeekSchedulesWithHttpInfo($managementUnitId, $weekId);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekSchedulesWithHttpInfo
     *
     * Gone.  Scheduling has moved under business units
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekSchedulesWithHttpInfo($managementUnitId, $weekId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitWeekSchedules');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling postWorkforcemanagementManagementunitWeekSchedules');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekSchedulesGenerate
     *
     * Gone.  Scheduling has moved under business units
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekSchedulesGenerate($managementUnitId, $weekId)
    {
        list($response) = $this->postWorkforcemanagementManagementunitWeekSchedulesGenerateWithHttpInfo($managementUnitId, $weekId);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekSchedulesGenerateWithHttpInfo
     *
     * Gone.  Scheduling has moved under business units
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekSchedulesGenerateWithHttpInfo($managementUnitId, $weekId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitWeekSchedulesGenerate');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling postWorkforcemanagementManagementunitWeekSchedulesGenerate');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/generate";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/generate'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekSchedulesPartialupload
     *
     * Gone.  Scheduling has moved under business units
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekSchedulesPartialupload($managementUnitId, $weekId)
    {
        list($response) = $this->postWorkforcemanagementManagementunitWeekSchedulesPartialuploadWithHttpInfo($managementUnitId, $weekId);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekSchedulesPartialuploadWithHttpInfo
     *
     * Gone.  Scheduling has moved under business units
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekSchedulesPartialuploadWithHttpInfo($managementUnitId, $weekId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitWeekSchedulesPartialupload');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling postWorkforcemanagementManagementunitWeekSchedulesPartialupload');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/partialupload";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/partialupload'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekShifttradeMatch
     *
     * Matches a shift trade. This route can only be called by the receiving agent
     *
     * @param string $managementUnitId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \DateTime $weekDateId The start date of the week schedule in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param \PureCloudSDK\MatchShiftTradeRequest $body body (required)
     * @param string $tradeId The ID of the shift trade to update (required)
     * @return \PureCloudSDK\MatchShiftTradeResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekShifttradeMatch($managementUnitId, $weekDateId, $body, $tradeId)
    {
        list($response) = $this->postWorkforcemanagementManagementunitWeekShifttradeMatchWithHttpInfo($managementUnitId, $weekDateId, $body, $tradeId);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekShifttradeMatchWithHttpInfo
     *
     * Matches a shift trade. This route can only be called by the receiving agent
     *
     * @param string $managementUnitId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \DateTime $weekDateId The start date of the week schedule in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param \PureCloudSDK\MatchShiftTradeRequest $body body (required)
     * @param string $tradeId The ID of the shift trade to update (required)
     * @return Array of \PureCloudSDK\MatchShiftTradeResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekShifttradeMatchWithHttpInfo($managementUnitId, $weekDateId, $body, $tradeId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitWeekShifttradeMatch');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling postWorkforcemanagementManagementunitWeekShifttradeMatch');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postWorkforcemanagementManagementunitWeekShifttradeMatch');
        }
        // verify the required parameter 'tradeId' is set
        if ($tradeId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $tradeId when calling postWorkforcemanagementManagementunitWeekShifttradeMatch');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shifttrades/{tradeId}/match";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // path params
        if ($tradeId !== null) {
            $resourcePath = str_replace(
                "{" . "tradeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($tradeId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\MatchShiftTradeResponse',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shifttrades/{tradeId}/match'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\MatchShiftTradeResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\MatchShiftTradeResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekShifttrades
     *
     * Adds a shift trade
     *
     * @param string $managementUnitId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \DateTime $weekDateId The start date of the week schedule in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param \PureCloudSDK\AddShiftTradeRequest $body body (required)
     * @return \PureCloudSDK\ShiftTradeResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekShifttrades($managementUnitId, $weekDateId, $body)
    {
        list($response) = $this->postWorkforcemanagementManagementunitWeekShifttradesWithHttpInfo($managementUnitId, $weekDateId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekShifttradesWithHttpInfo
     *
     * Adds a shift trade
     *
     * @param string $managementUnitId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \DateTime $weekDateId The start date of the week schedule in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param \PureCloudSDK\AddShiftTradeRequest $body body (required)
     * @return Array of \PureCloudSDK\ShiftTradeResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekShifttradesWithHttpInfo($managementUnitId, $weekDateId, $body)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitWeekShifttrades');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling postWorkforcemanagementManagementunitWeekShifttrades');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postWorkforcemanagementManagementunitWeekShifttrades');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shifttrades";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ShiftTradeResponse',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shifttrades'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ShiftTradeResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ShiftTradeResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekShifttradesSearch
     *
     * Searches for potential shift trade matches for the current agent
     *
     * @param string $managementUnitId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \DateTime $weekDateId The start date of the week schedule in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param \PureCloudSDK\SearchShiftTradesRequest $body body (required)
     * @return \PureCloudSDK\SearchShiftTradesResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekShifttradesSearch($managementUnitId, $weekDateId, $body)
    {
        list($response) = $this->postWorkforcemanagementManagementunitWeekShifttradesSearchWithHttpInfo($managementUnitId, $weekDateId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekShifttradesSearchWithHttpInfo
     *
     * Searches for potential shift trade matches for the current agent
     *
     * @param string $managementUnitId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \DateTime $weekDateId The start date of the week schedule in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param \PureCloudSDK\SearchShiftTradesRequest $body body (required)
     * @return Array of \PureCloudSDK\SearchShiftTradesResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekShifttradesSearchWithHttpInfo($managementUnitId, $weekDateId, $body)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitWeekShifttradesSearch');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling postWorkforcemanagementManagementunitWeekShifttradesSearch');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postWorkforcemanagementManagementunitWeekShifttradesSearch');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shifttrades/search";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\SearchShiftTradesResponse',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shifttrades/search'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\SearchShiftTradesResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\SearchShiftTradesResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekShifttradesStateBulk
     *
     * Updates the state of a batch of shift trades
     *
     * @param string $managementUnitId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \DateTime $weekDateId The start date of the week schedule in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param \PureCloudSDK\BulkShiftTradeStateUpdateRequest $body body (required)
     * @param bool $forceAsync Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes (optional)
     * @return \PureCloudSDK\BulkUpdateShiftTradeStateResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekShifttradesStateBulk($managementUnitId, $weekDateId, $body, $forceAsync = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitWeekShifttradesStateBulkWithHttpInfo($managementUnitId, $weekDateId, $body, $forceAsync);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekShifttradesStateBulkWithHttpInfo
     *
     * Updates the state of a batch of shift trades
     *
     * @param string $managementUnitId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \DateTime $weekDateId The start date of the week schedule in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd (required)
     * @param \PureCloudSDK\BulkShiftTradeStateUpdateRequest $body body (required)
     * @param bool $forceAsync Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes (optional)
     * @return Array of \PureCloudSDK\BulkUpdateShiftTradeStateResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekShifttradesStateBulkWithHttpInfo($managementUnitId, $weekDateId, $body, $forceAsync = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitWeekShifttradesStateBulk');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling postWorkforcemanagementManagementunitWeekShifttradesStateBulk');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postWorkforcemanagementManagementunitWeekShifttradesStateBulk');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shifttrades/state/bulk";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($forceAsync !== null) {
            $queryParams['forceAsync'] = $this->apiClient->getSerializer()->toQueryValue($forceAsync);
        }
        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\BulkUpdateShiftTradeStateResponse',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shifttrades/state/bulk'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\BulkUpdateShiftTradeStateResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\BulkUpdateShiftTradeStateResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekShorttermforecastCopy
     *
     * Gone. Use equivalent business unit resource instead
     *
     * @param string $managementUnitId (Deprecated/gone): The id of the management unit. (required)
     * @param string $weekDateId (Deprecated/gone): The week start date of the forecast in yyyy-MM-dd format (required)
     * @param string $forecastId (Gone/Deprecated): The ID of the forecast (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekShorttermforecastCopy($managementUnitId, $weekDateId, $forecastId)
    {
        list($response) = $this->postWorkforcemanagementManagementunitWeekShorttermforecastCopyWithHttpInfo($managementUnitId, $weekDateId, $forecastId);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekShorttermforecastCopyWithHttpInfo
     *
     * Gone. Use equivalent business unit resource instead
     *
     * @param string $managementUnitId (Deprecated/gone): The id of the management unit. (required)
     * @param string $weekDateId (Deprecated/gone): The week start date of the forecast in yyyy-MM-dd format (required)
     * @param string $forecastId (Gone/Deprecated): The ID of the forecast (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekShorttermforecastCopyWithHttpInfo($managementUnitId, $weekDateId, $forecastId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitWeekShorttermforecastCopy');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling postWorkforcemanagementManagementunitWeekShorttermforecastCopy');
        }
        // verify the required parameter 'forecastId' is set
        if ($forecastId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $forecastId when calling postWorkforcemanagementManagementunitWeekShorttermforecastCopy');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}/copy";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // path params
        if ($forecastId !== null) {
            $resourcePath = str_replace(
                "{" . "forecastId" . "}",
                $this->apiClient->getSerializer()->toPathValue($forecastId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}/copy'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekShorttermforecasts
     *
     * Gone. Use equivalent business unit resource instead
     *
     * @param string $managementUnitId (Deprecated/gone): The id of the management unit. (required)
     * @param string $weekDateId (Deprecated/gone): The week start date of the forecast in yyyy-MM-dd format (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekShorttermforecasts($managementUnitId, $weekDateId)
    {
        list($response) = $this->postWorkforcemanagementManagementunitWeekShorttermforecastsWithHttpInfo($managementUnitId, $weekDateId);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekShorttermforecastsWithHttpInfo
     *
     * Gone. Use equivalent business unit resource instead
     *
     * @param string $managementUnitId (Deprecated/gone): The id of the management unit. (required)
     * @param string $weekDateId (Deprecated/gone): The week start date of the forecast in yyyy-MM-dd format (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekShorttermforecastsWithHttpInfo($managementUnitId, $weekDateId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitWeekShorttermforecasts');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling postWorkforcemanagementManagementunitWeekShorttermforecasts');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekShorttermforecastsGenerate
     *
     * Gone. Use equivalent business unit resource instead
     *
     * @param string $managementUnitId (Deprecated/gone): The id of the management unit. (required)
     * @param string $weekDateId (Deprecated/gone): The week start date of the forecast in yyyy-MM-dd format (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekShorttermforecastsGenerate($managementUnitId, $weekDateId)
    {
        list($response) = $this->postWorkforcemanagementManagementunitWeekShorttermforecastsGenerateWithHttpInfo($managementUnitId, $weekDateId);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekShorttermforecastsGenerateWithHttpInfo
     *
     * Gone. Use equivalent business unit resource instead
     *
     * @param string $managementUnitId (Deprecated/gone): The id of the management unit. (required)
     * @param string $weekDateId (Deprecated/gone): The week start date of the forecast in yyyy-MM-dd format (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekShorttermforecastsGenerateWithHttpInfo($managementUnitId, $weekDateId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitWeekShorttermforecastsGenerate');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling postWorkforcemanagementManagementunitWeekShorttermforecastsGenerate');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts/generate";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts/generate'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekShorttermforecastsPartialupload
     *
     * Gone. Use equivalent business unit resource instead
     *
     * @param string $managementUnitId (Deprecated/gone): The id of the management unit. (required)
     * @param string $weekDateId (Deprecated/gone): The week start date of the forecast in yyyy-MM-dd format (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekShorttermforecastsPartialupload($managementUnitId, $weekDateId)
    {
        list($response) = $this->postWorkforcemanagementManagementunitWeekShorttermforecastsPartialuploadWithHttpInfo($managementUnitId, $weekDateId);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekShorttermforecastsPartialuploadWithHttpInfo
     *
     * Gone. Use equivalent business unit resource instead
     *
     * @param string $managementUnitId (Deprecated/gone): The id of the management unit. (required)
     * @param string $weekDateId (Deprecated/gone): The week start date of the forecast in yyyy-MM-dd format (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekShorttermforecastsPartialuploadWithHttpInfo($managementUnitId, $weekDateId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitWeekShorttermforecastsPartialupload');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling postWorkforcemanagementManagementunitWeekShorttermforecastsPartialupload');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts/partialupload";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts/partialupload'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitWorkplanCopy
     *
     * Create a copy of work plan
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $workPlanId The ID of the work plan to create a copy (required)
     * @param \PureCloudSDK\CopyWorkPlan $body body (optional)
     * @return \PureCloudSDK\WorkPlan
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWorkplanCopy($managementUnitId, $workPlanId, $body = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitWorkplanCopyWithHttpInfo($managementUnitId, $workPlanId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitWorkplanCopyWithHttpInfo
     *
     * Create a copy of work plan
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $workPlanId The ID of the work plan to create a copy (required)
     * @param \PureCloudSDK\CopyWorkPlan $body body (optional)
     * @return Array of \PureCloudSDK\WorkPlan, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWorkplanCopyWithHttpInfo($managementUnitId, $workPlanId, $body = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitWorkplanCopy');
        }
        // verify the required parameter 'workPlanId' is set
        if ($workPlanId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workPlanId when calling postWorkforcemanagementManagementunitWorkplanCopy');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans/{workPlanId}/copy";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($workPlanId !== null) {
            $resourcePath = str_replace(
                "{" . "workPlanId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workPlanId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WorkPlan',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans/{workPlanId}/copy'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WorkPlan', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WorkPlan', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitWorkplans
     *
     * Create a new work plan
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\CreateWorkPlan $body body (optional)
     * @return \PureCloudSDK\WorkPlan
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWorkplans($managementUnitId, $body = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitWorkplansWithHttpInfo($managementUnitId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitWorkplansWithHttpInfo
     *
     * Create a new work plan
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\CreateWorkPlan $body body (optional)
     * @return Array of \PureCloudSDK\WorkPlan, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWorkplansWithHttpInfo($managementUnitId, $body = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitWorkplans');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WorkPlan',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WorkPlan', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WorkPlan', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunits
     *
     * Add a management unit
     *
     * @param \PureCloudSDK\CreateManagementUnitApiRequest $body body (optional)
     * @return \PureCloudSDK\ManagementUnit
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunits($body = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitsWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitsWithHttpInfo
     *
     * Add a management unit
     *
     * @param \PureCloudSDK\CreateManagementUnitApiRequest $body body (optional)
     * @return Array of \PureCloudSDK\ManagementUnit, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitsWithHttpInfo($body = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ManagementUnit',
                '/api/v2/workforcemanagement/managementunits'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ManagementUnit', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ManagementUnit', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ManagementUnit', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementNotificationsUpdate
     *
     * Mark a list of notifications as read or unread
     *
     * @param \PureCloudSDK\UpdateNotificationsRequest $body body (optional)
     * @return \PureCloudSDK\UpdateNotificationsResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementNotificationsUpdate($body = null)
    {
        list($response) = $this->postWorkforcemanagementNotificationsUpdateWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementNotificationsUpdateWithHttpInfo
     *
     * Mark a list of notifications as read or unread
     *
     * @param \PureCloudSDK\UpdateNotificationsRequest $body body (optional)
     * @return Array of \PureCloudSDK\UpdateNotificationsResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementNotificationsUpdateWithHttpInfo($body = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/notifications/update";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\UpdateNotificationsResponse',
                '/api/v2/workforcemanagement/notifications/update'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\UpdateNotificationsResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\UpdateNotificationsResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementSchedules
     *
     * Get published schedule for the current user
     *
     * @param \PureCloudSDK\CurrentUserScheduleRequestBody $body body (optional)
     * @return \PureCloudSDK\UserScheduleContainer
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementSchedules($body = null)
    {
        list($response) = $this->postWorkforcemanagementSchedulesWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementSchedulesWithHttpInfo
     *
     * Get published schedule for the current user
     *
     * @param \PureCloudSDK\CurrentUserScheduleRequestBody $body body (optional)
     * @return Array of \PureCloudSDK\UserScheduleContainer, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementSchedulesWithHttpInfo($body = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/schedules";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\UserScheduleContainer',
                '/api/v2/workforcemanagement/schedules'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\UserScheduleContainer', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\UserScheduleContainer', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementTimeoffrequests
     *
     * Create a time off request for the current user
     *
     * @param \PureCloudSDK\CreateAgentTimeOffRequest $body body (optional)
     * @return \PureCloudSDK\TimeOffRequestResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementTimeoffrequests($body = null)
    {
        list($response) = $this->postWorkforcemanagementTimeoffrequestsWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementTimeoffrequestsWithHttpInfo
     *
     * Create a time off request for the current user
     *
     * @param \PureCloudSDK\CreateAgentTimeOffRequest $body body (optional)
     * @return Array of \PureCloudSDK\TimeOffRequestResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementTimeoffrequestsWithHttpInfo($body = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/timeoffrequests";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\TimeOffRequestResponse',
                '/api/v2/workforcemanagement/timeoffrequests'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\TimeOffRequestResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\TimeOffRequestResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
