<?php

/**
 * ApiUsageRow
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ApiUsageRow Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ApiUsageRow implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ApiUsageRow';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'clientId' => 'string',
        'clientName' => 'string',
        'organizationId' => 'string',
        'userId' => 'string',
        'templateUri' => 'string',
        'httpMethod' => 'string',
        'status200' => 'int',
        'status300' => 'int',
        'status400' => 'int',
        'status500' => 'int',
        'status429' => 'int',
        'requests' => 'int',
        'date' => '\DateTime'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'clientId' => 'clientId',
        'clientName' => 'clientName',
        'organizationId' => 'organizationId',
        'userId' => 'userId',
        'templateUri' => 'templateUri',
        'httpMethod' => 'httpMethod',
        'status200' => 'status200',
        'status300' => 'status300',
        'status400' => 'status400',
        'status500' => 'status500',
        'status429' => 'status429',
        'requests' => 'requests',
        'date' => 'date'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'clientId' => 'setClientId',
        'clientName' => 'setClientName',
        'organizationId' => 'setOrganizationId',
        'userId' => 'setUserId',
        'templateUri' => 'setTemplateUri',
        'httpMethod' => 'setHttpMethod',
        'status200' => 'setStatus200',
        'status300' => 'setStatus300',
        'status400' => 'setStatus400',
        'status500' => 'setStatus500',
        'status429' => 'setStatus429',
        'requests' => 'setRequests',
        'date' => 'setDate'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'clientId' => 'getClientId',
        'clientName' => 'getClientName',
        'organizationId' => 'getOrganizationId',
        'userId' => 'getUserId',
        'templateUri' => 'getTemplateUri',
        'httpMethod' => 'getHttpMethod',
        'status200' => 'getStatus200',
        'status300' => 'getStatus300',
        'status400' => 'getStatus400',
        'status500' => 'getStatus500',
        'status429' => 'getStatus429',
        'requests' => 'getRequests',
        'date' => 'getDate'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['clientId'] = isset($data['clientId']) ? $data['clientId'] : null;
        $this->container['clientName'] = isset($data['clientName']) ? $data['clientName'] : null;
        $this->container['organizationId'] = isset($data['organizationId']) ? $data['organizationId'] : null;
        $this->container['userId'] = isset($data['userId']) ? $data['userId'] : null;
        $this->container['templateUri'] = isset($data['templateUri']) ? $data['templateUri'] : null;
        $this->container['httpMethod'] = isset($data['httpMethod']) ? $data['httpMethod'] : null;
        $this->container['status200'] = isset($data['status200']) ? $data['status200'] : null;
        $this->container['status300'] = isset($data['status300']) ? $data['status300'] : null;
        $this->container['status400'] = isset($data['status400']) ? $data['status400'] : null;
        $this->container['status500'] = isset($data['status500']) ? $data['status500'] : null;
        $this->container['status429'] = isset($data['status429']) ? $data['status429'] : null;
        $this->container['requests'] = isset($data['requests']) ? $data['requests'] : null;
        $this->container['date'] = isset($data['date']) ? $data['date'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets clientId
     * @return string
     */
    public function getClientId()
    {
        return $this->container['clientId'];
    }

    /**
     * Sets clientId
     * @param string $clientId Client Id associated with this query result
     * @return $this
     */
    public function setClientId($clientId)
    {
        $this->container['clientId'] = $clientId;

        return $this;
    }

    /**
     * Gets clientName
     * @return string
     */
    public function getClientName()
    {
        return $this->container['clientName'];
    }

    /**
     * Sets clientName
     * @param string $clientName Client Name associated with this query result
     * @return $this
     */
    public function setClientName($clientName)
    {
        $this->container['clientName'] = $clientName;

        return $this;
    }

    /**
     * Gets organizationId
     * @return string
     */
    public function getOrganizationId()
    {
        return $this->container['organizationId'];
    }

    /**
     * Sets organizationId
     * @param string $organizationId Organization Id associated with this query result
     * @return $this
     */
    public function setOrganizationId($organizationId)
    {
        $this->container['organizationId'] = $organizationId;

        return $this;
    }

    /**
     * Gets userId
     * @return string
     */
    public function getUserId()
    {
        return $this->container['userId'];
    }

    /**
     * Sets userId
     * @param string $userId User Id associated with this query result
     * @return $this
     */
    public function setUserId($userId)
    {
        $this->container['userId'] = $userId;

        return $this;
    }

    /**
     * Gets templateUri
     * @return string
     */
    public function getTemplateUri()
    {
        return $this->container['templateUri'];
    }

    /**
     * Sets templateUri
     * @param string $templateUri Template Uri associated with this query result
     * @return $this
     */
    public function setTemplateUri($templateUri)
    {
        $this->container['templateUri'] = $templateUri;

        return $this;
    }

    /**
     * Gets httpMethod
     * @return string
     */
    public function getHttpMethod()
    {
        return $this->container['httpMethod'];
    }

    /**
     * Sets httpMethod
     * @param string $httpMethod HTTP Method associated with this query result
     * @return $this
     */
    public function setHttpMethod($httpMethod)
    {
        $this->container['httpMethod'] = $httpMethod;

        return $this;
    }

    /**
     * Gets status200
     * @return int
     */
    public function getStatus200()
    {
        return $this->container['status200'];
    }

    /**
     * Sets status200
     * @param int $status200 Number of requests resulting in a 2xx HTTP status code
     * @return $this
     */
    public function setStatus200($status200)
    {
        $this->container['status200'] = $status200;

        return $this;
    }

    /**
     * Gets status300
     * @return int
     */
    public function getStatus300()
    {
        return $this->container['status300'];
    }

    /**
     * Sets status300
     * @param int $status300 Number of requests resulting in a 3xx HTTP status code
     * @return $this
     */
    public function setStatus300($status300)
    {
        $this->container['status300'] = $status300;

        return $this;
    }

    /**
     * Gets status400
     * @return int
     */
    public function getStatus400()
    {
        return $this->container['status400'];
    }

    /**
     * Sets status400
     * @param int $status400 Number of requests resulting in a 4xx HTTP status code
     * @return $this
     */
    public function setStatus400($status400)
    {
        $this->container['status400'] = $status400;

        return $this;
    }

    /**
     * Gets status500
     * @return int
     */
    public function getStatus500()
    {
        return $this->container['status500'];
    }

    /**
     * Sets status500
     * @param int $status500 Number of requests resulting in a 5xx HTTP status code
     * @return $this
     */
    public function setStatus500($status500)
    {
        $this->container['status500'] = $status500;

        return $this;
    }

    /**
     * Gets status429
     * @return int
     */
    public function getStatus429()
    {
        return $this->container['status429'];
    }

    /**
     * Sets status429
     * @param int $status429 Number of requests resulting in a 429 HTTP status code, this is a subset of the count returned with status400
     * @return $this
     */
    public function setStatus429($status429)
    {
        $this->container['status429'] = $status429;

        return $this;
    }

    /**
     * Gets requests
     * @return int
     */
    public function getRequests()
    {
        return $this->container['requests'];
    }

    /**
     * Sets requests
     * @param int $requests Total number of requests
     * @return $this
     */
    public function setRequests($requests)
    {
        $this->container['requests'] = $requests;

        return $this;
    }

    /**
     * Gets date
     * @return \DateTime
     */
    public function getDate()
    {
        return $this->container['date'];
    }

    /**
     * Sets date
     * @param \DateTime $date Date of requests, based on granularity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDate($date)
    {
        $this->container['date'] = $date;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
