<?php

/**
 * BuAgentSchedulesSearchResponse
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * BuAgentSchedulesSearchResponse Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class BuAgentSchedulesSearchResponse implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'BuAgentSchedulesSearchResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'agentSchedules' => '\PureCloudSDK\BuAgentScheduleSearchResponse[]',
        'businessUnitTimeZone' => 'string',
        'publishedSchedules' => '\PureCloudSDK\BuAgentSchedulePublishedScheduleReference[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'agentSchedules' => 'agentSchedules',
        'businessUnitTimeZone' => 'businessUnitTimeZone',
        'publishedSchedules' => 'publishedSchedules'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'agentSchedules' => 'setAgentSchedules',
        'businessUnitTimeZone' => 'setBusinessUnitTimeZone',
        'publishedSchedules' => 'setPublishedSchedules'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'agentSchedules' => 'getAgentSchedules',
        'businessUnitTimeZone' => 'getBusinessUnitTimeZone',
        'publishedSchedules' => 'getPublishedSchedules'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['agentSchedules'] = isset($data['agentSchedules']) ? $data['agentSchedules'] : null;
        $this->container['businessUnitTimeZone'] = isset($data['businessUnitTimeZone']) ? $data['businessUnitTimeZone'] : null;
        $this->container['publishedSchedules'] = isset($data['publishedSchedules']) ? $data['publishedSchedules'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets agentSchedules
     * @return \PureCloudSDK\BuAgentScheduleSearchResponse[]
     */
    public function getAgentSchedules()
    {
        return $this->container['agentSchedules'];
    }

    /**
     * Sets agentSchedules
     * @param \PureCloudSDK\BuAgentScheduleSearchResponse[] $agentSchedules The requested agent schedules
     * @return $this
     */
    public function setAgentSchedules($agentSchedules)
    {
        $this->container['agentSchedules'] = $agentSchedules;

        return $this;
    }

    /**
     * Gets businessUnitTimeZone
     * @return string
     */
    public function getBusinessUnitTimeZone()
    {
        return $this->container['businessUnitTimeZone'];
    }

    /**
     * Sets businessUnitTimeZone
     * @param string $businessUnitTimeZone The time zone configured for the business unit to which this schedule applies
     * @return $this
     */
    public function setBusinessUnitTimeZone($businessUnitTimeZone)
    {
        $this->container['businessUnitTimeZone'] = $businessUnitTimeZone;

        return $this;
    }

    /**
     * Gets publishedSchedules
     * @return \PureCloudSDK\BuAgentSchedulePublishedScheduleReference[]
     */
    public function getPublishedSchedules()
    {
        return $this->container['publishedSchedules'];
    }

    /**
     * Sets publishedSchedules
     * @param \PureCloudSDK\BuAgentSchedulePublishedScheduleReference[] $publishedSchedules References to all published week schedules overlapping the start/end date query parameters
     * @return $this
     */
    public function setPublishedSchedules($publishedSchedules)
    {
        $this->container['publishedSchedules'] = $publishedSchedules;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
