<?php

/**
 * BulkUpdateShiftTradeStateResultItem
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * BulkUpdateShiftTradeStateResultItem Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class BulkUpdateShiftTradeStateResultItem implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'BulkUpdateShiftTradeStateResultItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'state' => 'string',
        'reviewedBy' => '\PureCloudSDK\UserReference',
        'reviewedDate' => '\DateTime',
        'failureReason' => 'string',
        'metadata' => '\PureCloudSDK\WfmVersionedEntityMetadata'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'state' => 'state',
        'reviewedBy' => 'reviewedBy',
        'reviewedDate' => 'reviewedDate',
        'failureReason' => 'failureReason',
        'metadata' => 'metadata'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'state' => 'setState',
        'reviewedBy' => 'setReviewedBy',
        'reviewedDate' => 'setReviewedDate',
        'failureReason' => 'setFailureReason',
        'metadata' => 'setMetadata'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'state' => 'getState',
        'reviewedBy' => 'getReviewedBy',
        'reviewedDate' => 'getReviewedDate',
        'failureReason' => 'getFailureReason',
        'metadata' => 'getMetadata'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const STATE_UNMATCHED = 'Unmatched';
    public const STATE_MATCHED = 'Matched';
    public const STATE_APPROVED = 'Approved';
    public const STATE_DENIED = 'Denied';
    public const STATE_EXPIRED = 'Expired';
    public const STATE_CANCELED = 'Canceled';
    public const FAILURE_REASON_INITIATING_AGENT_SCHEDULE_NOT_FOUND = 'InitiatingAgentScheduleNotFound';
    public const FAILURE_REASON_INITIATING_AGENT_SHIFT_HAS_EXTERNAL_ACTIVITIES = 'InitiatingAgentShiftHasExternalActivities';
    public const FAILURE_REASON_INITIATING_AGENT_SHIFT_NOT_FOUND = 'InitiatingAgentShiftNotFound';
    public const FAILURE_REASON_RECEIVING_AGENT_NOT_FOUND = 'ReceivingAgentNotFound';
    public const FAILURE_REASON_RECEIVING_AGENT_SCHEDULE_NOT_FOUND = 'ReceivingAgentScheduleNotFound';
    public const FAILURE_REASON_RECEIVING_AGENT_SHIFT_HAS_EXTERNAL_ACTIVITIES = 'ReceivingAgentShiftHasExternalActivities';
    public const FAILURE_REASON_RECEIVING_AGENT_SHIFT_NOT_FOUND = 'ReceivingAgentShiftNotFound';
    public const FAILURE_REASON_SCHEDULE_NOT_PUBLISHED = 'ScheduleNotPublished';
    public const FAILURE_REASON_TRANSITION_NOT_ALLOWED = 'TransitionNotAllowed';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_UNMATCHED,
            self::STATE_MATCHED,
            self::STATE_APPROVED,
            self::STATE_DENIED,
            self::STATE_EXPIRED,
            self::STATE_CANCELED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getFailureReasonAllowableValues()
    {
        return [
            self::FAILURE_REASON_INITIATING_AGENT_SCHEDULE_NOT_FOUND,
            self::FAILURE_REASON_INITIATING_AGENT_SHIFT_HAS_EXTERNAL_ACTIVITIES,
            self::FAILURE_REASON_INITIATING_AGENT_SHIFT_NOT_FOUND,
            self::FAILURE_REASON_RECEIVING_AGENT_NOT_FOUND,
            self::FAILURE_REASON_RECEIVING_AGENT_SCHEDULE_NOT_FOUND,
            self::FAILURE_REASON_RECEIVING_AGENT_SHIFT_HAS_EXTERNAL_ACTIVITIES,
            self::FAILURE_REASON_RECEIVING_AGENT_SHIFT_NOT_FOUND,
            self::FAILURE_REASON_SCHEDULE_NOT_PUBLISHED,
            self::FAILURE_REASON_TRANSITION_NOT_ALLOWED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['reviewedBy'] = isset($data['reviewedBy']) ? $data['reviewedBy'] : null;
        $this->container['reviewedDate'] = isset($data['reviewedDate']) ? $data['reviewedDate'] : null;
        $this->container['failureReason'] = isset($data['failureReason']) ? $data['failureReason'] : null;
        $this->container['metadata'] = isset($data['metadata']) ? $data['metadata'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("Unmatched", "Matched", "Approved", "Denied", "Expired", "Canceled");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        $allowed_values = array("InitiatingAgentScheduleNotFound", "InitiatingAgentShiftHasExternalActivities", "InitiatingAgentShiftNotFound", "ReceivingAgentNotFound", "ReceivingAgentScheduleNotFound", "ReceivingAgentShiftHasExternalActivities", "ReceivingAgentShiftNotFound", "ScheduleNotPublished", "TransitionNotAllowed");
        if (!in_array($this->container['failureReason'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'failureReason', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("Unmatched", "Matched", "Approved", "Denied", "Expired", "Canceled");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("InitiatingAgentScheduleNotFound", "InitiatingAgentShiftHasExternalActivities", "InitiatingAgentShiftNotFound", "ReceivingAgentNotFound", "ReceivingAgentScheduleNotFound", "ReceivingAgentShiftHasExternalActivities", "ReceivingAgentShiftNotFound", "ScheduleNotPublished", "TransitionNotAllowed");
        if (!in_array($this->container['failureReason'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state The state of the shift trade after the update request is processed
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('Unmatched', 'Matched', 'Approved', 'Denied', 'Expired', 'Canceled');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'Unmatched', 'Matched', 'Approved', 'Denied', 'Expired', 'Canceled'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets reviewedBy
     * @return \PureCloudSDK\UserReference
     */
    public function getReviewedBy()
    {
        return $this->container['reviewedBy'];
    }

    /**
     * Sets reviewedBy
     * @param \PureCloudSDK\UserReference $reviewedBy The user who reviewed the request, if applicable
     * @return $this
     */
    public function setReviewedBy($reviewedBy)
    {
        $this->container['reviewedBy'] = $reviewedBy;

        return $this;
    }

    /**
     * Gets reviewedDate
     * @return \DateTime
     */
    public function getReviewedDate()
    {
        return $this->container['reviewedDate'];
    }

    /**
     * Sets reviewedDate
     * @param \DateTime $reviewedDate The date the request was reviewed, if applicable. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setReviewedDate($reviewedDate)
    {
        $this->container['reviewedDate'] = $reviewedDate;

        return $this;
    }

    /**
     * Gets failureReason
     * @return string
     */
    public function getFailureReason()
    {
        return $this->container['failureReason'];
    }

    /**
     * Sets failureReason
     * @param string $failureReason The reason the update failed, if applicable
     * @return $this
     */
    public function setFailureReason($failureReason)
    {
        $allowed_values = array('InitiatingAgentScheduleNotFound', 'InitiatingAgentShiftHasExternalActivities', 'InitiatingAgentShiftNotFound', 'ReceivingAgentNotFound', 'ReceivingAgentScheduleNotFound', 'ReceivingAgentShiftHasExternalActivities', 'ReceivingAgentShiftNotFound', 'ScheduleNotPublished', 'TransitionNotAllowed');
        if (!in_array($failureReason, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'failureReason', must be one of 'InitiatingAgentScheduleNotFound', 'InitiatingAgentShiftHasExternalActivities', 'InitiatingAgentShiftNotFound', 'ReceivingAgentNotFound', 'ReceivingAgentScheduleNotFound', 'ReceivingAgentShiftHasExternalActivities', 'ReceivingAgentShiftNotFound', 'ScheduleNotPublished', 'TransitionNotAllowed'");
        }
        $this->container['failureReason'] = $failureReason;

        return $this;
    }

    /**
     * Gets metadata
     * @return \PureCloudSDK\WfmVersionedEntityMetadata
     */
    public function getMetadata()
    {
        return $this->container['metadata'];
    }

    /**
     * Sets metadata
     * @param \PureCloudSDK\WfmVersionedEntityMetadata $metadata Version metadata for the shift trade
     * @return $this
     */
    public function setMetadata($metadata)
    {
        $this->container['metadata'] = $metadata;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
