<?php

/**
 * CallHistoryConversation
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * CallHistoryConversation Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CallHistoryConversation implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CallHistoryConversation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'participants' => '\PureCloudSDK\CallHistoryParticipant[]',
        'direction' => 'string',
        'wentToVoicemail' => 'bool',
        'missedCall' => 'bool',
        'startTime' => '\DateTime',
        'wasConference' => 'bool',
        'wasCallback' => 'bool',
        'hadScreenShare' => 'bool',
        'hadCobrowse' => 'bool',
        'wasOutboundCampaign' => 'bool',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'participants' => 'participants',
        'direction' => 'direction',
        'wentToVoicemail' => 'wentToVoicemail',
        'missedCall' => 'missedCall',
        'startTime' => 'startTime',
        'wasConference' => 'wasConference',
        'wasCallback' => 'wasCallback',
        'hadScreenShare' => 'hadScreenShare',
        'hadCobrowse' => 'hadCobrowse',
        'wasOutboundCampaign' => 'wasOutboundCampaign',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'participants' => 'setParticipants',
        'direction' => 'setDirection',
        'wentToVoicemail' => 'setWentToVoicemail',
        'missedCall' => 'setMissedCall',
        'startTime' => 'setStartTime',
        'wasConference' => 'setWasConference',
        'wasCallback' => 'setWasCallback',
        'hadScreenShare' => 'setHadScreenShare',
        'hadCobrowse' => 'setHadCobrowse',
        'wasOutboundCampaign' => 'setWasOutboundCampaign',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'participants' => 'getParticipants',
        'direction' => 'getDirection',
        'wentToVoicemail' => 'getWentToVoicemail',
        'missedCall' => 'getMissedCall',
        'startTime' => 'getStartTime',
        'wasConference' => 'getWasConference',
        'wasCallback' => 'getWasCallback',
        'hadScreenShare' => 'getHadScreenShare',
        'hadCobrowse' => 'getHadCobrowse',
        'wasOutboundCampaign' => 'getWasOutboundCampaign',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const DIRECTION_INBOUND = 'inbound';
    public const DIRECTION_OUTBOUND = 'outbound';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDirectionAllowableValues()
    {
        return [
            self::DIRECTION_INBOUND,
            self::DIRECTION_OUTBOUND,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['participants'] = isset($data['participants']) ? $data['participants'] : null;
        $this->container['direction'] = isset($data['direction']) ? $data['direction'] : null;
        $this->container['wentToVoicemail'] = isset($data['wentToVoicemail']) ? $data['wentToVoicemail'] : null;
        $this->container['missedCall'] = isset($data['missedCall']) ? $data['missedCall'] : null;
        $this->container['startTime'] = isset($data['startTime']) ? $data['startTime'] : null;
        $this->container['wasConference'] = isset($data['wasConference']) ? $data['wasConference'] : null;
        $this->container['wasCallback'] = isset($data['wasCallback']) ? $data['wasCallback'] : null;
        $this->container['hadScreenShare'] = isset($data['hadScreenShare']) ? $data['hadScreenShare'] : null;
        $this->container['hadCobrowse'] = isset($data['hadCobrowse']) ? $data['hadCobrowse'] : null;
        $this->container['wasOutboundCampaign'] = isset($data['wasOutboundCampaign']) ? $data['wasOutboundCampaign'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("inbound", "outbound");
        if (!in_array($this->container['direction'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'direction', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("inbound", "outbound");
        if (!in_array($this->container['direction'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets participants
     * @return \PureCloudSDK\CallHistoryParticipant[]
     */
    public function getParticipants()
    {
        return $this->container['participants'];
    }

    /**
     * Sets participants
     * @param \PureCloudSDK\CallHistoryParticipant[] $participants The list of participants involved in the conversation.
     * @return $this
     */
    public function setParticipants($participants)
    {
        $this->container['participants'] = $participants;

        return $this;
    }

    /**
     * Gets direction
     * @return string
     */
    public function getDirection()
    {
        return $this->container['direction'];
    }

    /**
     * Sets direction
     * @param string $direction The direction of the call relating to the current user
     * @return $this
     */
    public function setDirection($direction)
    {
        $allowed_values = array('inbound', 'outbound');
        if (!in_array($direction, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'direction', must be one of 'inbound', 'outbound'");
        }
        $this->container['direction'] = $direction;

        return $this;
    }

    /**
     * Gets wentToVoicemail
     * @return bool
     */
    public function getWentToVoicemail()
    {
        return $this->container['wentToVoicemail'];
    }

    /**
     * Sets wentToVoicemail
     * @param bool $wentToVoicemail Did the call end in the current user's voicemail
     * @return $this
     */
    public function setWentToVoicemail($wentToVoicemail)
    {
        $this->container['wentToVoicemail'] = $wentToVoicemail;

        return $this;
    }

    /**
     * Gets missedCall
     * @return bool
     */
    public function getMissedCall()
    {
        return $this->container['missedCall'];
    }

    /**
     * Sets missedCall
     * @param bool $missedCall Did the user not answer this conversation
     * @return $this
     */
    public function setMissedCall($missedCall)
    {
        $this->container['missedCall'] = $missedCall;

        return $this;
    }

    /**
     * Gets startTime
     * @return \DateTime
     */
    public function getStartTime()
    {
        return $this->container['startTime'];
    }

    /**
     * Sets startTime
     * @param \DateTime $startTime The time the user joined the conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setStartTime($startTime)
    {
        $this->container['startTime'] = $startTime;

        return $this;
    }

    /**
     * Gets wasConference
     * @return bool
     */
    public function getWasConference()
    {
        return $this->container['wasConference'];
    }

    /**
     * Sets wasConference
     * @param bool $wasConference Was this conversation a conference
     * @return $this
     */
    public function setWasConference($wasConference)
    {
        $this->container['wasConference'] = $wasConference;

        return $this;
    }

    /**
     * Gets wasCallback
     * @return bool
     */
    public function getWasCallback()
    {
        return $this->container['wasCallback'];
    }

    /**
     * Sets wasCallback
     * @param bool $wasCallback Was this conversation a callback
     * @return $this
     */
    public function setWasCallback($wasCallback)
    {
        $this->container['wasCallback'] = $wasCallback;

        return $this;
    }

    /**
     * Gets hadScreenShare
     * @return bool
     */
    public function getHadScreenShare()
    {
        return $this->container['hadScreenShare'];
    }

    /**
     * Sets hadScreenShare
     * @param bool $hadScreenShare Did this conversation have a screen share session
     * @return $this
     */
    public function setHadScreenShare($hadScreenShare)
    {
        $this->container['hadScreenShare'] = $hadScreenShare;

        return $this;
    }

    /**
     * Gets hadCobrowse
     * @return bool
     */
    public function getHadCobrowse()
    {
        return $this->container['hadCobrowse'];
    }

    /**
     * Sets hadCobrowse
     * @param bool $hadCobrowse Did this conversation have a cobrowse session
     * @return $this
     */
    public function setHadCobrowse($hadCobrowse)
    {
        $this->container['hadCobrowse'] = $hadCobrowse;

        return $this;
    }

    /**
     * Gets wasOutboundCampaign
     * @return bool
     */
    public function getWasOutboundCampaign()
    {
        return $this->container['wasOutboundCampaign'];
    }

    /**
     * Sets wasOutboundCampaign
     * @param bool $wasOutboundCampaign Was this conversation associated with an outbound campaign
     * @return $this
     */
    public function setWasOutboundCampaign($wasOutboundCampaign)
    {
        $this->container['wasOutboundCampaign'] = $wasOutboundCampaign;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
