<?php

/**
 * ChatMessage
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ChatMessage Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ChatMessage implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ChatMessage';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'body' => 'string',
        'id' => 'string',
        'to' => 'string',
        'from' => 'string',
        'utc' => 'string',
        'chat' => 'string',
        'message' => 'string',
        'type' => 'string',
        'bodyType' => 'string',
        'senderCommunicationId' => 'string',
        'participantPurpose' => 'string',
        'user' => '\PureCloudSDK\ChatMessageUser'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'body' => 'body',
        'id' => 'id',
        'to' => 'to',
        'from' => 'from',
        'utc' => 'utc',
        'chat' => 'chat',
        'message' => 'message',
        'type' => 'type',
        'bodyType' => 'bodyType',
        'senderCommunicationId' => 'senderCommunicationId',
        'participantPurpose' => 'participantPurpose',
        'user' => 'user'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'body' => 'setBody',
        'id' => 'setId',
        'to' => 'setTo',
        'from' => 'setFrom',
        'utc' => 'setUtc',
        'chat' => 'setChat',
        'message' => 'setMessage',
        'type' => 'setType',
        'bodyType' => 'setBodyType',
        'senderCommunicationId' => 'setSenderCommunicationId',
        'participantPurpose' => 'setParticipantPurpose',
        'user' => 'setUser'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'body' => 'getBody',
        'id' => 'getId',
        'to' => 'getTo',
        'from' => 'getFrom',
        'utc' => 'getUtc',
        'chat' => 'getChat',
        'message' => 'getMessage',
        'type' => 'getType',
        'bodyType' => 'getBodyType',
        'senderCommunicationId' => 'getSenderCommunicationId',
        'participantPurpose' => 'getParticipantPurpose',
        'user' => 'getUser'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const BODY_TYPE_STANDARD = 'STANDARD';
    public const BODY_TYPE_ACTIVITY = 'ACTIVITY';
    public const BODY_TYPE_TYPING = 'TYPING';
    public const BODY_TYPE_NOTICE = 'NOTICE';
    public const BODY_TYPE_MEMBERJOIN = 'MEMBERJOIN';
    public const BODY_TYPE_MEMBERLEAVE = 'MEMBERLEAVE';
    public const BODY_TYPE_MEDIAREQUEST = 'MEDIAREQUEST';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getBodyTypeAllowableValues()
    {
        return [
            self::BODY_TYPE_STANDARD,
            self::BODY_TYPE_ACTIVITY,
            self::BODY_TYPE_TYPING,
            self::BODY_TYPE_NOTICE,
            self::BODY_TYPE_MEMBERJOIN,
            self::BODY_TYPE_MEMBERLEAVE,
            self::BODY_TYPE_MEDIAREQUEST,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['body'] = isset($data['body']) ? $data['body'] : null;
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['to'] = isset($data['to']) ? $data['to'] : null;
        $this->container['from'] = isset($data['from']) ? $data['from'] : null;
        $this->container['utc'] = isset($data['utc']) ? $data['utc'] : null;
        $this->container['chat'] = isset($data['chat']) ? $data['chat'] : null;
        $this->container['message'] = isset($data['message']) ? $data['message'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['bodyType'] = isset($data['bodyType']) ? $data['bodyType'] : null;
        $this->container['senderCommunicationId'] = isset($data['senderCommunicationId']) ? $data['senderCommunicationId'] : null;
        $this->container['participantPurpose'] = isset($data['participantPurpose']) ? $data['participantPurpose'] : null;
        $this->container['user'] = isset($data['user']) ? $data['user'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("STANDARD", "ACTIVITY", "TYPING", "NOTICE", "MEMBERJOIN", "MEMBERLEAVE", "MEDIAREQUEST");
        if (!in_array($this->container['bodyType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'bodyType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("STANDARD", "ACTIVITY", "TYPING", "NOTICE", "MEMBERJOIN", "MEMBERLEAVE", "MEDIAREQUEST");
        if (!in_array($this->container['bodyType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets body
     * @return string
     */
    public function getBody()
    {
        return $this->container['body'];
    }

    /**
     * Sets body
     * @param string $body The message body
     * @return $this
     */
    public function setBody($body)
    {
        $this->container['body'] = $body;

        return $this;
    }

    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets to
     * @return string
     */
    public function getTo()
    {
        return $this->container['to'];
    }

    /**
     * Sets to
     * @param string $to The message recipient
     * @return $this
     */
    public function setTo($to)
    {
        $this->container['to'] = $to;

        return $this;
    }

    /**
     * Gets from
     * @return string
     */
    public function getFrom()
    {
        return $this->container['from'];
    }

    /**
     * Sets from
     * @param string $from The message sender
     * @return $this
     */
    public function setFrom($from)
    {
        $this->container['from'] = $from;

        return $this;
    }

    /**
     * Gets utc
     * @return string
     */
    public function getUtc()
    {
        return $this->container['utc'];
    }

    /**
     * Sets utc
     * @param string $utc
     * @return $this
     */
    public function setUtc($utc)
    {
        $this->container['utc'] = $utc;

        return $this;
    }

    /**
     * Gets chat
     * @return string
     */
    public function getChat()
    {
        return $this->container['chat'];
    }

    /**
     * Sets chat
     * @param string $chat The interaction id (if available)
     * @return $this
     */
    public function setChat($chat)
    {
        $this->container['chat'] = $chat;

        return $this;
    }

    /**
     * Gets message
     * @return string
     */
    public function getMessage()
    {
        return $this->container['message'];
    }

    /**
     * Sets message
     * @param string $message The message id
     * @return $this
     */
    public function setMessage($message)
    {
        $this->container['message'] = $message;

        return $this;
    }

    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type
     * @return $this
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets bodyType
     * @return string
     */
    public function getBodyType()
    {
        return $this->container['bodyType'];
    }

    /**
     * Sets bodyType
     * @param string $bodyType Type of the message body (v2 chats only)
     * @return $this
     */
    public function setBodyType($bodyType)
    {
        $allowed_values = array('STANDARD', 'ACTIVITY', 'TYPING', 'NOTICE', 'MEMBERJOIN', 'MEMBERLEAVE', 'MEDIAREQUEST');
        if (!in_array($bodyType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'bodyType', must be one of 'STANDARD', 'ACTIVITY', 'TYPING', 'NOTICE', 'MEMBERJOIN', 'MEMBERLEAVE', 'MEDIAREQUEST'");
        }
        $this->container['bodyType'] = $bodyType;

        return $this;
    }

    /**
     * Gets senderCommunicationId
     * @return string
     */
    public function getSenderCommunicationId()
    {
        return $this->container['senderCommunicationId'];
    }

    /**
     * Sets senderCommunicationId
     * @param string $senderCommunicationId Communication of sender (v2 chats only)
     * @return $this
     */
    public function setSenderCommunicationId($senderCommunicationId)
    {
        $this->container['senderCommunicationId'] = $senderCommunicationId;

        return $this;
    }

    /**
     * Gets participantPurpose
     * @return string
     */
    public function getParticipantPurpose()
    {
        return $this->container['participantPurpose'];
    }

    /**
     * Sets participantPurpose
     * @param string $participantPurpose Participant purpose of sender (v2 chats only)
     * @return $this
     */
    public function setParticipantPurpose($participantPurpose)
    {
        $this->container['participantPurpose'] = $participantPurpose;

        return $this;
    }

    /**
     * Gets user
     * @return \PureCloudSDK\ChatMessageUser
     */
    public function getUser()
    {
        return $this->container['user'];
    }

    /**
     * Sets user
     * @param \PureCloudSDK\ChatMessageUser $user The user information for the sender (if available)
     * @return $this
     */
    public function setUser($user)
    {
        $this->container['user'] = $user;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
