<?php

/**
 * ContentAttachment
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ContentAttachment Class Doc Comment
 *
 * @category    Class */
 // @description Attachment object
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ContentAttachment implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ContentAttachment';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'mediaType' => 'string',
        'url' => 'string',
        'mime' => 'string',
        'text' => 'string',
        'sha256' => 'string',
        'filename' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'mediaType' => 'mediaType',
        'url' => 'url',
        'mime' => 'mime',
        'text' => 'text',
        'sha256' => 'sha256',
        'filename' => 'filename'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'mediaType' => 'setMediaType',
        'url' => 'setUrl',
        'mime' => 'setMime',
        'text' => 'setText',
        'sha256' => 'setSha256',
        'filename' => 'setFilename'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'mediaType' => 'getMediaType',
        'url' => 'getUrl',
        'mime' => 'getMime',
        'text' => 'getText',
        'sha256' => 'getSha256',
        'filename' => 'getFilename'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const MEDIA_TYPE_IMAGE = 'Image';
    public const MEDIA_TYPE_VIDEO = 'Video';
    public const MEDIA_TYPE_AUDIO = 'Audio';
    public const MEDIA_TYPE_FILE = 'File';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMediaTypeAllowableValues()
    {
        return [
            self::MEDIA_TYPE_IMAGE,
            self::MEDIA_TYPE_VIDEO,
            self::MEDIA_TYPE_AUDIO,
            self::MEDIA_TYPE_FILE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['mediaType'] = isset($data['mediaType']) ? $data['mediaType'] : null;
        $this->container['url'] = isset($data['url']) ? $data['url'] : null;
        $this->container['mime'] = isset($data['mime']) ? $data['mime'] : null;
        $this->container['text'] = isset($data['text']) ? $data['text'] : null;
        $this->container['sha256'] = isset($data['sha256']) ? $data['sha256'] : null;
        $this->container['filename'] = isset($data['filename']) ? $data['filename'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['mediaType'] === null) {
            $invalid_properties[] = "'mediaType' can't be null";
        }
        $allowed_values = array("Image", "Video", "Audio", "File");
        if (!in_array($this->container['mediaType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'mediaType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['mediaType'] === null) {
            return false;
        }
        $allowed_values = array("Image", "Video", "Audio", "File");
        if (!in_array($this->container['mediaType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id Vendor specific ID for media. For example, a LINE sticker ID
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets mediaType
     * @return string
     */
    public function getMediaType()
    {
        return $this->container['mediaType'];
    }

    /**
     * Sets mediaType
     * @param string $mediaType The type of media this instance represents
     * @return $this
     */
    public function setMediaType($mediaType)
    {
        $allowed_values = array('Image', 'Video', 'Audio', 'File');
        if (!in_array($mediaType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'mediaType', must be one of 'Image', 'Video', 'Audio', 'File'");
        }
        $this->container['mediaType'] = $mediaType;

        return $this;
    }

    /**
     * Gets url
     * @return string
     */
    public function getUrl()
    {
        return $this->container['url'];
    }

    /**
     * Sets url
     * @param string $url Content element url
     * @return $this
     */
    public function setUrl($url)
    {
        $this->container['url'] = $url;

        return $this;
    }

    /**
     * Gets mime
     * @return string
     */
    public function getMime()
    {
        return $this->container['mime'];
    }

    /**
     * Sets mime
     * @param string $mime Content mime type from https://www.iana.org/assignments/media-types/media-types.xhtml
     * @return $this
     */
    public function setMime($mime)
    {
        $this->container['mime'] = $mime;

        return $this;
    }

    /**
     * Gets text
     * @return string
     */
    public function getText()
    {
        return $this->container['text'];
    }

    /**
     * Sets text
     * @param string $text Text message associated with media element: e.g. caption in case of image.
     * @return $this
     */
    public function setText($text)
    {
        $this->container['text'] = $text;

        return $this;
    }

    /**
     * Gets sha256
     * @return string
     */
    public function getSha256()
    {
        return $this->container['sha256'];
    }

    /**
     * Sets sha256
     * @param string $sha256 Secure hash of the media content
     * @return $this
     */
    public function setSha256($sha256)
    {
        $this->container['sha256'] = $sha256;

        return $this;
    }

    /**
     * Gets filename
     * @return string
     */
    public function getFilename()
    {
        return $this->container['filename'];
    }

    /**
     * Sets filename
     * @param string $filename Suggested file name for media file
     * @return $this
     */
    public function setFilename($filename)
    {
        $this->container['filename'] = $filename;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
