<?php

/**
 * MessagingCampaign
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * MessagingCampaign Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class MessagingCampaign implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'MessagingCampaign';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'dateCreated' => '\DateTime',
        'dateModified' => '\DateTime',
        'version' => 'int',
        'division' => '\PureCloudSDK\DomainEntityRef',
        'campaignStatus' => 'string',
        'callableTimeSet' => '\PureCloudSDK\DomainEntityRef',
        'contactList' => '\PureCloudSDK\DomainEntityRef',
        'dncLists' => '\PureCloudSDK\DomainEntityRef[]',
        'alwaysRunning' => 'bool',
        'contactSorts' => '\PureCloudSDK\ContactSort[]',
        'messagesPerMinute' => 'int',
        'errors' => '\PureCloudSDK\RestErrorDetail[]',
        'smsConfig' => '\PureCloudSDK\SmsConfig',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'dateCreated' => 'dateCreated',
        'dateModified' => 'dateModified',
        'version' => 'version',
        'division' => 'division',
        'campaignStatus' => 'campaignStatus',
        'callableTimeSet' => 'callableTimeSet',
        'contactList' => 'contactList',
        'dncLists' => 'dncLists',
        'alwaysRunning' => 'alwaysRunning',
        'contactSorts' => 'contactSorts',
        'messagesPerMinute' => 'messagesPerMinute',
        'errors' => 'errors',
        'smsConfig' => 'smsConfig',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'dateCreated' => 'setDateCreated',
        'dateModified' => 'setDateModified',
        'version' => 'setVersion',
        'division' => 'setDivision',
        'campaignStatus' => 'setCampaignStatus',
        'callableTimeSet' => 'setCallableTimeSet',
        'contactList' => 'setContactList',
        'dncLists' => 'setDncLists',
        'alwaysRunning' => 'setAlwaysRunning',
        'contactSorts' => 'setContactSorts',
        'messagesPerMinute' => 'setMessagesPerMinute',
        'errors' => 'setErrors',
        'smsConfig' => 'setSmsConfig',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'dateCreated' => 'getDateCreated',
        'dateModified' => 'getDateModified',
        'version' => 'getVersion',
        'division' => 'getDivision',
        'campaignStatus' => 'getCampaignStatus',
        'callableTimeSet' => 'getCallableTimeSet',
        'contactList' => 'getContactList',
        'dncLists' => 'getDncLists',
        'alwaysRunning' => 'getAlwaysRunning',
        'contactSorts' => 'getContactSorts',
        'messagesPerMinute' => 'getMessagesPerMinute',
        'errors' => 'getErrors',
        'smsConfig' => 'getSmsConfig',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const CAMPAIGN_STATUS_ON = 'on';
    public const CAMPAIGN_STATUS_STOPPING = 'stopping';
    public const CAMPAIGN_STATUS_OFF = 'off';
    public const CAMPAIGN_STATUS_COMPLETE = 'complete';
    public const CAMPAIGN_STATUS_INVALID = 'invalid';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getCampaignStatusAllowableValues()
    {
        return [
            self::CAMPAIGN_STATUS_ON,
            self::CAMPAIGN_STATUS_STOPPING,
            self::CAMPAIGN_STATUS_OFF,
            self::CAMPAIGN_STATUS_COMPLETE,
            self::CAMPAIGN_STATUS_INVALID,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['dateModified'] = isset($data['dateModified']) ? $data['dateModified'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['division'] = isset($data['division']) ? $data['division'] : null;
        $this->container['campaignStatus'] = isset($data['campaignStatus']) ? $data['campaignStatus'] : null;
        $this->container['callableTimeSet'] = isset($data['callableTimeSet']) ? $data['callableTimeSet'] : null;
        $this->container['contactList'] = isset($data['contactList']) ? $data['contactList'] : null;
        $this->container['dncLists'] = isset($data['dncLists']) ? $data['dncLists'] : null;
        $this->container['alwaysRunning'] = isset($data['alwaysRunning']) ? $data['alwaysRunning'] : null;
        $this->container['contactSorts'] = isset($data['contactSorts']) ? $data['contactSorts'] : null;
        $this->container['messagesPerMinute'] = isset($data['messagesPerMinute']) ? $data['messagesPerMinute'] : null;
        $this->container['errors'] = isset($data['errors']) ? $data['errors'] : null;
        $this->container['smsConfig'] = isset($data['smsConfig']) ? $data['smsConfig'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("on", "stopping", "off", "complete", "invalid");
        if (!in_array($this->container['campaignStatus'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'campaignStatus', must be one of #{allowed_values}.";
        }

        if ($this->container['contactList'] === null) {
            $invalid_properties[] = "'contactList' can't be null";
        }
        if ($this->container['messagesPerMinute'] === null) {
            $invalid_properties[] = "'messagesPerMinute' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("on", "stopping", "off", "complete", "invalid");
        if (!in_array($this->container['campaignStatus'], $allowed_values)) {
            return false;
        }
        if ($this->container['contactList'] === null) {
            return false;
        }
        if ($this->container['messagesPerMinute'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param \DateTime $dateCreated Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets dateModified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['dateModified'];
    }

    /**
     * Sets dateModified
     * @param \DateTime $dateModified Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($dateModified)
    {
        $this->container['dateModified'] = $dateModified;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version Required for updates, must match the version number of the most recent update
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets division
     * @return \PureCloudSDK\DomainEntityRef
     */
    public function getDivision()
    {
        return $this->container['division'];
    }

    /**
     * Sets division
     * @param \PureCloudSDK\DomainEntityRef $division The division this entity belongs to.
     * @return $this
     */
    public function setDivision($division)
    {
        $this->container['division'] = $division;

        return $this;
    }

    /**
     * Gets campaignStatus
     * @return string
     */
    public function getCampaignStatus()
    {
        return $this->container['campaignStatus'];
    }

    /**
     * Sets campaignStatus
     * @param string $campaignStatus The current status of the messaging campaign. A messaging campaign may be turned 'on' or 'off'.
     * @return $this
     */
    public function setCampaignStatus($campaignStatus)
    {
        $allowed_values = array('on', 'stopping', 'off', 'complete', 'invalid');
        if (!in_array($campaignStatus, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'campaignStatus', must be one of 'on', 'stopping', 'off', 'complete', 'invalid'");
        }
        $this->container['campaignStatus'] = $campaignStatus;

        return $this;
    }

    /**
     * Gets callableTimeSet
     * @return \PureCloudSDK\DomainEntityRef
     */
    public function getCallableTimeSet()
    {
        return $this->container['callableTimeSet'];
    }

    /**
     * Sets callableTimeSet
     * @param \PureCloudSDK\DomainEntityRef $callableTimeSet The callable time set for this messaging campaign.
     * @return $this
     */
    public function setCallableTimeSet($callableTimeSet)
    {
        $this->container['callableTimeSet'] = $callableTimeSet;

        return $this;
    }

    /**
     * Gets contactList
     * @return \PureCloudSDK\DomainEntityRef
     */
    public function getContactList()
    {
        return $this->container['contactList'];
    }

    /**
     * Sets contactList
     * @param \PureCloudSDK\DomainEntityRef $contactList The contact list that this messaging campaign will send messages for.
     * @return $this
     */
    public function setContactList($contactList)
    {
        $this->container['contactList'] = $contactList;

        return $this;
    }

    /**
     * Gets dncLists
     * @return \PureCloudSDK\DomainEntityRef[]
     */
    public function getDncLists()
    {
        return $this->container['dncLists'];
    }

    /**
     * Sets dncLists
     * @param \PureCloudSDK\DomainEntityRef[] $dncLists The dnc lists to check before sending a message for this messaging campaign.
     * @return $this
     */
    public function setDncLists($dncLists)
    {
        $this->container['dncLists'] = $dncLists;

        return $this;
    }

    /**
     * Gets alwaysRunning
     * @return bool
     */
    public function getAlwaysRunning()
    {
        return $this->container['alwaysRunning'];
    }

    /**
     * Sets alwaysRunning
     * @param bool $alwaysRunning Whether this messaging campaign is always running
     * @return $this
     */
    public function setAlwaysRunning($alwaysRunning)
    {
        $this->container['alwaysRunning'] = $alwaysRunning;

        return $this;
    }

    /**
     * Gets contactSorts
     * @return \PureCloudSDK\ContactSort[]
     */
    public function getContactSorts()
    {
        return $this->container['contactSorts'];
    }

    /**
     * Sets contactSorts
     * @param \PureCloudSDK\ContactSort[] $contactSorts The order in which to sort contacts for dialing, based on up to four columns.
     * @return $this
     */
    public function setContactSorts($contactSorts)
    {
        $this->container['contactSorts'] = $contactSorts;

        return $this;
    }

    /**
     * Gets messagesPerMinute
     * @return int
     */
    public function getMessagesPerMinute()
    {
        return $this->container['messagesPerMinute'];
    }

    /**
     * Sets messagesPerMinute
     * @param int $messagesPerMinute How many messages this messaging campaign will send per minute.
     * @return $this
     */
    public function setMessagesPerMinute($messagesPerMinute)
    {
        $this->container['messagesPerMinute'] = $messagesPerMinute;

        return $this;
    }

    /**
     * Gets errors
     * @return \PureCloudSDK\RestErrorDetail[]
     */
    public function getErrors()
    {
        return $this->container['errors'];
    }

    /**
     * Sets errors
     * @param \PureCloudSDK\RestErrorDetail[] $errors A list of current error conditions associated with this messaging campaign.
     * @return $this
     */
    public function setErrors($errors)
    {
        $this->container['errors'] = $errors;

        return $this;
    }

    /**
     * Gets smsConfig
     * @return \PureCloudSDK\SmsConfig
     */
    public function getSmsConfig()
    {
        return $this->container['smsConfig'];
    }

    /**
     * Sets smsConfig
     * @param \PureCloudSDK\SmsConfig $smsConfig Configuration for this messaging campaign to send SMS messages.
     * @return $this
     */
    public function setSmsConfig($smsConfig)
    {
        $this->container['smsConfig'] = $smsConfig;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
