<?php

/**
 * RecordingMessagingMessage
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * RecordingMessagingMessage Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class RecordingMessagingMessage implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'RecordingMessagingMessage';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'from' => 'string',
        'fromUser' => '\PureCloudSDK\User',
        'fromExternalContact' => '\PureCloudSDK\ExternalContact',
        'to' => 'string',
        'timestamp' => '\DateTime',
        'id' => 'string',
        'messageText' => 'string',
        'messageMediaAttachments' => '\PureCloudSDK\MessageMediaAttachment[]',
        'messageStickerAttachments' => '\PureCloudSDK\MessageStickerAttachment[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'from' => 'from',
        'fromUser' => 'fromUser',
        'fromExternalContact' => 'fromExternalContact',
        'to' => 'to',
        'timestamp' => 'timestamp',
        'id' => 'id',
        'messageText' => 'messageText',
        'messageMediaAttachments' => 'messageMediaAttachments',
        'messageStickerAttachments' => 'messageStickerAttachments'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'from' => 'setFrom',
        'fromUser' => 'setFromUser',
        'fromExternalContact' => 'setFromExternalContact',
        'to' => 'setTo',
        'timestamp' => 'setTimestamp',
        'id' => 'setId',
        'messageText' => 'setMessageText',
        'messageMediaAttachments' => 'setMessageMediaAttachments',
        'messageStickerAttachments' => 'setMessageStickerAttachments'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'from' => 'getFrom',
        'fromUser' => 'getFromUser',
        'fromExternalContact' => 'getFromExternalContact',
        'to' => 'getTo',
        'timestamp' => 'getTimestamp',
        'id' => 'getId',
        'messageText' => 'getMessageText',
        'messageMediaAttachments' => 'getMessageMediaAttachments',
        'messageStickerAttachments' => 'getMessageStickerAttachments'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['from'] = isset($data['from']) ? $data['from'] : null;
        $this->container['fromUser'] = isset($data['fromUser']) ? $data['fromUser'] : null;
        $this->container['fromExternalContact'] = isset($data['fromExternalContact']) ? $data['fromExternalContact'] : null;
        $this->container['to'] = isset($data['to']) ? $data['to'] : null;
        $this->container['timestamp'] = isset($data['timestamp']) ? $data['timestamp'] : null;
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['messageText'] = isset($data['messageText']) ? $data['messageText'] : null;
        $this->container['messageMediaAttachments'] = isset($data['messageMediaAttachments']) ? $data['messageMediaAttachments'] : null;
        $this->container['messageStickerAttachments'] = isset($data['messageStickerAttachments']) ? $data['messageStickerAttachments'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets from
     * @return string
     */
    public function getFrom()
    {
        return $this->container['from'];
    }

    /**
     * Sets from
     * @param string $from
     * @return $this
     */
    public function setFrom($from)
    {
        $this->container['from'] = $from;

        return $this;
    }

    /**
     * Gets fromUser
     * @return \PureCloudSDK\User
     */
    public function getFromUser()
    {
        return $this->container['fromUser'];
    }

    /**
     * Sets fromUser
     * @param \PureCloudSDK\User $fromUser
     * @return $this
     */
    public function setFromUser($fromUser)
    {
        $this->container['fromUser'] = $fromUser;

        return $this;
    }

    /**
     * Gets fromExternalContact
     * @return \PureCloudSDK\ExternalContact
     */
    public function getFromExternalContact()
    {
        return $this->container['fromExternalContact'];
    }

    /**
     * Sets fromExternalContact
     * @param \PureCloudSDK\ExternalContact $fromExternalContact
     * @return $this
     */
    public function setFromExternalContact($fromExternalContact)
    {
        $this->container['fromExternalContact'] = $fromExternalContact;

        return $this;
    }

    /**
     * Gets to
     * @return string
     */
    public function getTo()
    {
        return $this->container['to'];
    }

    /**
     * Sets to
     * @param string $to
     * @return $this
     */
    public function setTo($to)
    {
        $this->container['to'] = $to;

        return $this;
    }

    /**
     * Gets timestamp
     * @return \DateTime
     */
    public function getTimestamp()
    {
        return $this->container['timestamp'];
    }

    /**
     * Sets timestamp
     * @param \DateTime $timestamp Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setTimestamp($timestamp)
    {
        $this->container['timestamp'] = $timestamp;

        return $this;
    }

    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets messageText
     * @return string
     */
    public function getMessageText()
    {
        return $this->container['messageText'];
    }

    /**
     * Sets messageText
     * @param string $messageText
     * @return $this
     */
    public function setMessageText($messageText)
    {
        $this->container['messageText'] = $messageText;

        return $this;
    }

    /**
     * Gets messageMediaAttachments
     * @return \PureCloudSDK\MessageMediaAttachment[]
     */
    public function getMessageMediaAttachments()
    {
        return $this->container['messageMediaAttachments'];
    }

    /**
     * Sets messageMediaAttachments
     * @param \PureCloudSDK\MessageMediaAttachment[] $messageMediaAttachments
     * @return $this
     */
    public function setMessageMediaAttachments($messageMediaAttachments)
    {
        $this->container['messageMediaAttachments'] = $messageMediaAttachments;

        return $this;
    }

    /**
     * Gets messageStickerAttachments
     * @return \PureCloudSDK\MessageStickerAttachment[]
     */
    public function getMessageStickerAttachments()
    {
        return $this->container['messageStickerAttachments'];
    }

    /**
     * Sets messageStickerAttachments
     * @param \PureCloudSDK\MessageStickerAttachment[] $messageStickerAttachments
     * @return $this
     */
    public function setMessageStickerAttachments($messageStickerAttachments)
    {
        $this->container['messageStickerAttachments'] = $messageStickerAttachments;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
