<?php

/**
 * ContactCallbackRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ContactCallbackRequest Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ContactCallbackRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ContactCallbackRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'campaignId' => 'string',
        'contactListId' => 'string',
        'contactId' => 'string',
        'phoneColumn' => 'string',
        'schedule' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'campaignId' => 'campaignId',
        'contactListId' => 'contactListId',
        'contactId' => 'contactId',
        'phoneColumn' => 'phoneColumn',
        'schedule' => 'schedule'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'campaignId' => 'setCampaignId',
        'contactListId' => 'setContactListId',
        'contactId' => 'setContactId',
        'phoneColumn' => 'setPhoneColumn',
        'schedule' => 'setSchedule'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'campaignId' => 'getCampaignId',
        'contactListId' => 'getContactListId',
        'contactId' => 'getContactId',
        'phoneColumn' => 'getPhoneColumn',
        'schedule' => 'getSchedule'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['campaignId'] = isset($data['campaignId']) ? $data['campaignId'] : null;
        $this->container['contactListId'] = isset($data['contactListId']) ? $data['contactListId'] : null;
        $this->container['contactId'] = isset($data['contactId']) ? $data['contactId'] : null;
        $this->container['phoneColumn'] = isset($data['phoneColumn']) ? $data['phoneColumn'] : null;
        $this->container['schedule'] = isset($data['schedule']) ? $data['schedule'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['campaignId'] === null) {
            $invalid_properties[] = "'campaignId' can't be null";
        }
        if ($this->container['contactListId'] === null) {
            $invalid_properties[] = "'contactListId' can't be null";
        }
        if ($this->container['contactId'] === null) {
            $invalid_properties[] = "'contactId' can't be null";
        }
        if ($this->container['phoneColumn'] === null) {
            $invalid_properties[] = "'phoneColumn' can't be null";
        }
        if ($this->container['schedule'] === null) {
            $invalid_properties[] = "'schedule' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['campaignId'] === null) {
            return false;
        }
        if ($this->container['contactListId'] === null) {
            return false;
        }
        if ($this->container['contactId'] === null) {
            return false;
        }
        if ($this->container['phoneColumn'] === null) {
            return false;
        }
        if ($this->container['schedule'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets campaignId
     * @return string
     */
    public function getCampaignId()
    {
        return $this->container['campaignId'];
    }

    /**
     * Sets campaignId
     * @param string $campaignId Campaign identifier
     * @return $this
     */
    public function setCampaignId($campaignId)
    {
        $this->container['campaignId'] = $campaignId;

        return $this;
    }

    /**
     * Gets contactListId
     * @return string
     */
    public function getContactListId()
    {
        return $this->container['contactListId'];
    }

    /**
     * Sets contactListId
     * @param string $contactListId Contact list identifier
     * @return $this
     */
    public function setContactListId($contactListId)
    {
        $this->container['contactListId'] = $contactListId;

        return $this;
    }

    /**
     * Gets contactId
     * @return string
     */
    public function getContactId()
    {
        return $this->container['contactId'];
    }

    /**
     * Sets contactId
     * @param string $contactId Contact identifier
     * @return $this
     */
    public function setContactId($contactId)
    {
        $this->container['contactId'] = $contactId;

        return $this;
    }

    /**
     * Gets phoneColumn
     * @return string
     */
    public function getPhoneColumn()
    {
        return $this->container['phoneColumn'];
    }

    /**
     * Sets phoneColumn
     * @param string $phoneColumn Name of the phone column containing the number to be called
     * @return $this
     */
    public function setPhoneColumn($phoneColumn)
    {
        $this->container['phoneColumn'] = $phoneColumn;

        return $this;
    }

    /**
     * Gets schedule
     * @return string
     */
    public function getSchedule()
    {
        return $this->container['schedule'];
    }

    /**
     * Sets schedule
     * @param string $schedule The scheduled time for the callback as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ\", example = \"2016-01-02T16:59:59\"
     * @return $this
     */
    public function setSchedule($schedule)
    {
        $this->container['schedule'] = $schedule;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


