<?php

/**
 * EventLog
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * EventLog Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class EventLog implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'EventLog';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'errorEntity' => '\PureCloudSDK\UriReference',
        'relatedEntity' => '\PureCloudSDK\UriReference',
        'timestamp' => '\DateTime',
        'level' => 'string',
        'category' => 'string',
        'correlationId' => 'string',
        'eventMessage' => '\PureCloudSDK\EventMessage',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'errorEntity' => 'errorEntity',
        'relatedEntity' => 'relatedEntity',
        'timestamp' => 'timestamp',
        'level' => 'level',
        'category' => 'category',
        'correlationId' => 'correlationId',
        'eventMessage' => 'eventMessage',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'errorEntity' => 'setErrorEntity',
        'relatedEntity' => 'setRelatedEntity',
        'timestamp' => 'setTimestamp',
        'level' => 'setLevel',
        'category' => 'setCategory',
        'correlationId' => 'setCorrelationId',
        'eventMessage' => 'setEventMessage',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'errorEntity' => 'getErrorEntity',
        'relatedEntity' => 'getRelatedEntity',
        'timestamp' => 'getTimestamp',
        'level' => 'getLevel',
        'category' => 'getCategory',
        'correlationId' => 'getCorrelationId',
        'eventMessage' => 'getEventMessage',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const LEVEL_INFO = 'INFO';
    public const LEVEL_WARNING = 'WARNING';
    public const LEVEL_ERROR = 'ERROR';
    public const CATEGORY_CALLBACK = 'CALLBACK';
    public const CATEGORY_CALL_RESTRICTION = 'CALL_RESTRICTION';
    public const CATEGORY_CALL_RULE = 'CALL_RULE';
    public const CATEGORY_CAMPAIGN = 'CAMPAIGN';
    public const CATEGORY_CAMPAIGN_RULE = 'CAMPAIGN_RULE';
    public const CATEGORY_CONTACT = 'CONTACT';
    public const CATEGORY_CONTACT_LIST_FILTER = 'CONTACT_LIST_FILTER';
    public const CATEGORY_DNC_LIST = 'DNC_LIST';
    public const CATEGORY_ENTITY_LIMIT = 'ENTITY_LIMIT';
    public const CATEGORY_IMPORT_ERROR = 'IMPORT_ERROR';
    public const CATEGORY_ORGANIZATION_CONFIGURATION = 'ORGANIZATION_CONFIGURATION';
    public const CATEGORY_SCHEDULE = 'SCHEDULE';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getLevelAllowableValues()
    {
        return [
            self::LEVEL_INFO,
            self::LEVEL_WARNING,
            self::LEVEL_ERROR,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getCategoryAllowableValues()
    {
        return [
            self::CATEGORY_CALLBACK,
            self::CATEGORY_CALL_RESTRICTION,
            self::CATEGORY_CALL_RULE,
            self::CATEGORY_CAMPAIGN,
            self::CATEGORY_CAMPAIGN_RULE,
            self::CATEGORY_CONTACT,
            self::CATEGORY_CONTACT_LIST_FILTER,
            self::CATEGORY_DNC_LIST,
            self::CATEGORY_ENTITY_LIMIT,
            self::CATEGORY_IMPORT_ERROR,
            self::CATEGORY_ORGANIZATION_CONFIGURATION,
            self::CATEGORY_SCHEDULE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['errorEntity'] = isset($data['errorEntity']) ? $data['errorEntity'] : null;
        $this->container['relatedEntity'] = isset($data['relatedEntity']) ? $data['relatedEntity'] : null;
        $this->container['timestamp'] = isset($data['timestamp']) ? $data['timestamp'] : null;
        $this->container['level'] = isset($data['level']) ? $data['level'] : null;
        $this->container['category'] = isset($data['category']) ? $data['category'] : null;
        $this->container['correlationId'] = isset($data['correlationId']) ? $data['correlationId'] : null;
        $this->container['eventMessage'] = isset($data['eventMessage']) ? $data['eventMessage'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("INFO", "WARNING", "ERROR");
        if (!in_array($this->container['level'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'level', must be one of #{allowed_values}.";
        }

        $allowed_values = array("CALLBACK", "CALL_RESTRICTION", "CALL_RULE", "CAMPAIGN", "CAMPAIGN_RULE", "CONTACT", "CONTACT_LIST_FILTER", "DNC_LIST", "ENTITY_LIMIT", "IMPORT_ERROR", "ORGANIZATION_CONFIGURATION", "SCHEDULE");
        if (!in_array($this->container['category'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'category', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("INFO", "WARNING", "ERROR");
        if (!in_array($this->container['level'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("CALLBACK", "CALL_RESTRICTION", "CALL_RULE", "CAMPAIGN", "CAMPAIGN_RULE", "CONTACT", "CONTACT_LIST_FILTER", "DNC_LIST", "ENTITY_LIMIT", "IMPORT_ERROR", "ORGANIZATION_CONFIGURATION", "SCHEDULE");
        if (!in_array($this->container['category'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets errorEntity
     * @return \PureCloudSDK\UriReference
     */
    public function getErrorEntity()
    {
        return $this->container['errorEntity'];
    }

    /**
     * Sets errorEntity
     * @param \PureCloudSDK\UriReference $errorEntity
     * @return $this
     */
    public function setErrorEntity($errorEntity)
    {
        $this->container['errorEntity'] = $errorEntity;

        return $this;
    }

    /**
     * Gets relatedEntity
     * @return \PureCloudSDK\UriReference
     */
    public function getRelatedEntity()
    {
        return $this->container['relatedEntity'];
    }

    /**
     * Sets relatedEntity
     * @param \PureCloudSDK\UriReference $relatedEntity
     * @return $this
     */
    public function setRelatedEntity($relatedEntity)
    {
        $this->container['relatedEntity'] = $relatedEntity;

        return $this;
    }

    /**
     * Gets timestamp
     * @return \DateTime
     */
    public function getTimestamp()
    {
        return $this->container['timestamp'];
    }

    /**
     * Sets timestamp
     * @param \DateTime $timestamp Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setTimestamp($timestamp)
    {
        $this->container['timestamp'] = $timestamp;

        return $this;
    }

    /**
     * Gets level
     * @return string
     */
    public function getLevel()
    {
        return $this->container['level'];
    }

    /**
     * Sets level
     * @param string $level
     * @return $this
     */
    public function setLevel($level)
    {
        $allowed_values = array('INFO', 'WARNING', 'ERROR');
        if (!in_array($level, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'level', must be one of 'INFO', 'WARNING', 'ERROR'");
        }
        $this->container['level'] = $level;

        return $this;
    }

    /**
     * Gets category
     * @return string
     */
    public function getCategory()
    {
        return $this->container['category'];
    }

    /**
     * Sets category
     * @param string $category
     * @return $this
     */
    public function setCategory($category)
    {
        $allowed_values = array('CALLBACK', 'CALL_RESTRICTION', 'CALL_RULE', 'CAMPAIGN', 'CAMPAIGN_RULE', 'CONTACT', 'CONTACT_LIST_FILTER', 'DNC_LIST', 'ENTITY_LIMIT', 'IMPORT_ERROR', 'ORGANIZATION_CONFIGURATION', 'SCHEDULE');
        if (!in_array($category, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'category', must be one of 'CALLBACK', 'CALL_RESTRICTION', 'CALL_RULE', 'CAMPAIGN', 'CAMPAIGN_RULE', 'CONTACT', 'CONTACT_LIST_FILTER', 'DNC_LIST', 'ENTITY_LIMIT', 'IMPORT_ERROR', 'ORGANIZATION_CONFIGURATION', 'SCHEDULE'");
        }
        $this->container['category'] = $category;

        return $this;
    }

    /**
     * Gets correlationId
     * @return string
     */
    public function getCorrelationId()
    {
        return $this->container['correlationId'];
    }

    /**
     * Sets correlationId
     * @param string $correlationId
     * @return $this
     */
    public function setCorrelationId($correlationId)
    {
        $this->container['correlationId'] = $correlationId;

        return $this;
    }

    /**
     * Gets eventMessage
     * @return \PureCloudSDK\EventMessage
     */
    public function getEventMessage()
    {
        return $this->container['eventMessage'];
    }

    /**
     * Sets eventMessage
     * @param \PureCloudSDK\EventMessage $eventMessage
     * @return $this
     */
    public function setEventMessage($eventMessage)
    {
        $this->container['eventMessage'] = $eventMessage;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


