<?php

/**
 * ForecastTimeSeriesResult
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ForecastTimeSeriesResult Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ForecastTimeSeriesResult implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ForecastTimeSeriesResult';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'metric' => 'string',
        'forecastingMethod' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'metric' => 'metric',
        'forecastingMethod' => 'forecastingMethod'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'metric' => 'setMetric',
        'forecastingMethod' => 'setForecastingMethod'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'metric' => 'getMetric',
        'forecastingMethod' => 'getForecastingMethod'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const METRIC_OFFERED = 'Offered';
    public const METRIC_AVERAGE_TALK_TIME_SECONDS = 'AverageTalkTimeSeconds';
    public const METRIC_AVERAGE_AFTER_CALL_WORK_TIME_SECONDS = 'AverageAfterCallWorkTimeSeconds';
    public const METRIC_AVERAGE_HANDLE_TIME_SECONDS = 'AverageHandleTimeSeconds';
    public const FORECASTING_METHOD_AUTO_REGRESSIVE_INTEGRATED_MOVING_AVERAGE = 'AutoRegressiveIntegratedMovingAverage';
    public const FORECASTING_METHOD_MOVING_AVERAGE = 'MovingAverage';
    public const FORECASTING_METHOD_SINGLE_EXPONENTIAL_SMOOTHING = 'SingleExponentialSmoothing';
    public const FORECASTING_METHOD_RANDOM_WALK = 'RandomWalk';
    public const FORECASTING_METHOD_DECOMPOSITION_USING_ADDITIVE_SEASONALITY = 'DecompositionUsingAdditiveSeasonality';
    public const FORECASTING_METHOD_DECOMPOSITION_USING_MULTIPLICATIVE_SEASONALITY = 'DecompositionUsingMultiplicativeSeasonality';
    public const FORECASTING_METHOD_HOLT_WINTERS_ADDITIVE_SEASONALITY = 'HoltWintersAdditiveSeasonality';
    public const FORECASTING_METHOD_HOLT_WINTERS_ADDITIVE_SEASONALITY_WITH_DAMPED_TREND = 'HoltWintersAdditiveSeasonalityWithDampedTrend';
    public const FORECASTING_METHOD_HOLT_WINTERS_MULTIPLICATIVE_SEASONALITY = 'HoltWintersMultiplicativeSeasonality';
    public const FORECASTING_METHOD_HOLT_WINTERS_MULTIPLICATIVE_SEASONALITY_WITH_DAMPED_TREND = 'HoltWintersMultiplicativeSeasonalityWithDampedTrend';
    public const FORECASTING_METHOD_DAMPED_LINEAR_EXPONENTIAL_SMOOTHING = 'DampedLinearExponentialSmoothing';
    public const FORECASTING_METHOD_DOUBLE_EXPONENTIAL_SMOOTHING = 'DoubleExponentialSmoothing';
    public const FORECASTING_METHOD_DOUBLE_MOVING_AVERAGE = 'DoubleMovingAverage';
    public const FORECASTING_METHOD_LINEAR_EXPONENTIAL_SMOOTHING = 'LinearExponentialSmoothing';
    public const FORECASTING_METHOD_LINEAR_WEIGHTED_MOVING_AVERAGE = 'LinearWeightedMovingAverage';
    public const FORECASTING_METHOD_POINT_ESTIMATE_USING_DAMPED_LINEAR_EXPONENTIAL_SMOOTHING = 'PointEstimateUsingDampedLinearExponentialSmoothing';
    public const FORECASTING_METHOD_POINT_ESTIMATE_USING_DOUBLE_EXPONENTIAL_SMOOTHING = 'PointEstimateUsingDoubleExponentialSmoothing';
    public const FORECASTING_METHOD_POINT_ESTIMATE_USING_LATEST_WEEK = 'PointEstimateUsingLatestWeek';
    public const FORECASTING_METHOD_POINT_ESTIMATE_USING_LINEAR_EXPONENTIAL_SMOOTHING = 'PointEstimateUsingLinearExponentialSmoothing';
    public const FORECASTING_METHOD_POINT_ESTIMATE_USING_WEIGHTED_AVERAGE = 'PointEstimateUsingWeightedAverage';
    public const FORECASTING_METHOD_CURVE_FIT = 'CurveFit';
    public const FORECASTING_METHOD_MULTI_LINEAR_REGRESSION = 'MultiLinearRegression';
    public const FORECASTING_METHOD_DYNAMIC_HARMONIC_REGRESSION = 'DynamicHarmonicRegression';
    public const FORECASTING_METHOD_OTHER = 'Other';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMetricAllowableValues()
    {
        return [
            self::METRIC_OFFERED,
            self::METRIC_AVERAGE_TALK_TIME_SECONDS,
            self::METRIC_AVERAGE_AFTER_CALL_WORK_TIME_SECONDS,
            self::METRIC_AVERAGE_HANDLE_TIME_SECONDS,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getForecastingMethodAllowableValues()
    {
        return [
            self::FORECASTING_METHOD_AUTO_REGRESSIVE_INTEGRATED_MOVING_AVERAGE,
            self::FORECASTING_METHOD_MOVING_AVERAGE,
            self::FORECASTING_METHOD_SINGLE_EXPONENTIAL_SMOOTHING,
            self::FORECASTING_METHOD_RANDOM_WALK,
            self::FORECASTING_METHOD_DECOMPOSITION_USING_ADDITIVE_SEASONALITY,
            self::FORECASTING_METHOD_DECOMPOSITION_USING_MULTIPLICATIVE_SEASONALITY,
            self::FORECASTING_METHOD_HOLT_WINTERS_ADDITIVE_SEASONALITY,
            self::FORECASTING_METHOD_HOLT_WINTERS_ADDITIVE_SEASONALITY_WITH_DAMPED_TREND,
            self::FORECASTING_METHOD_HOLT_WINTERS_MULTIPLICATIVE_SEASONALITY,
            self::FORECASTING_METHOD_HOLT_WINTERS_MULTIPLICATIVE_SEASONALITY_WITH_DAMPED_TREND,
            self::FORECASTING_METHOD_DAMPED_LINEAR_EXPONENTIAL_SMOOTHING,
            self::FORECASTING_METHOD_DOUBLE_EXPONENTIAL_SMOOTHING,
            self::FORECASTING_METHOD_DOUBLE_MOVING_AVERAGE,
            self::FORECASTING_METHOD_LINEAR_EXPONENTIAL_SMOOTHING,
            self::FORECASTING_METHOD_LINEAR_WEIGHTED_MOVING_AVERAGE,
            self::FORECASTING_METHOD_POINT_ESTIMATE_USING_DAMPED_LINEAR_EXPONENTIAL_SMOOTHING,
            self::FORECASTING_METHOD_POINT_ESTIMATE_USING_DOUBLE_EXPONENTIAL_SMOOTHING,
            self::FORECASTING_METHOD_POINT_ESTIMATE_USING_LATEST_WEEK,
            self::FORECASTING_METHOD_POINT_ESTIMATE_USING_LINEAR_EXPONENTIAL_SMOOTHING,
            self::FORECASTING_METHOD_POINT_ESTIMATE_USING_WEIGHTED_AVERAGE,
            self::FORECASTING_METHOD_CURVE_FIT,
            self::FORECASTING_METHOD_MULTI_LINEAR_REGRESSION,
            self::FORECASTING_METHOD_DYNAMIC_HARMONIC_REGRESSION,
            self::FORECASTING_METHOD_OTHER,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['metric'] = isset($data['metric']) ? $data['metric'] : null;
        $this->container['forecastingMethod'] = isset($data['forecastingMethod']) ? $data['forecastingMethod'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("Offered", "AverageTalkTimeSeconds", "AverageAfterCallWorkTimeSeconds", "AverageHandleTimeSeconds");
        if (!in_array($this->container['metric'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'metric', must be one of #{allowed_values}.";
        }

        $allowed_values = array("AutoRegressiveIntegratedMovingAverage", "MovingAverage", "SingleExponentialSmoothing", "RandomWalk", "DecompositionUsingAdditiveSeasonality", "DecompositionUsingMultiplicativeSeasonality", "HoltWintersAdditiveSeasonality", "HoltWintersAdditiveSeasonalityWithDampedTrend", "HoltWintersMultiplicativeSeasonality", "HoltWintersMultiplicativeSeasonalityWithDampedTrend", "DampedLinearExponentialSmoothing", "DoubleExponentialSmoothing", "DoubleMovingAverage", "LinearExponentialSmoothing", "LinearWeightedMovingAverage", "PointEstimateUsingDampedLinearExponentialSmoothing", "PointEstimateUsingDoubleExponentialSmoothing", "PointEstimateUsingLatestWeek", "PointEstimateUsingLinearExponentialSmoothing", "PointEstimateUsingWeightedAverage", "CurveFit", "MultiLinearRegression", "DynamicHarmonicRegression", "Other");
        if (!in_array($this->container['forecastingMethod'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'forecastingMethod', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("Offered", "AverageTalkTimeSeconds", "AverageAfterCallWorkTimeSeconds", "AverageHandleTimeSeconds");
        if (!in_array($this->container['metric'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("AutoRegressiveIntegratedMovingAverage", "MovingAverage", "SingleExponentialSmoothing", "RandomWalk", "DecompositionUsingAdditiveSeasonality", "DecompositionUsingMultiplicativeSeasonality", "HoltWintersAdditiveSeasonality", "HoltWintersAdditiveSeasonalityWithDampedTrend", "HoltWintersMultiplicativeSeasonality", "HoltWintersMultiplicativeSeasonalityWithDampedTrend", "DampedLinearExponentialSmoothing", "DoubleExponentialSmoothing", "DoubleMovingAverage", "LinearExponentialSmoothing", "LinearWeightedMovingAverage", "PointEstimateUsingDampedLinearExponentialSmoothing", "PointEstimateUsingDoubleExponentialSmoothing", "PointEstimateUsingLatestWeek", "PointEstimateUsingLinearExponentialSmoothing", "PointEstimateUsingWeightedAverage", "CurveFit", "MultiLinearRegression", "DynamicHarmonicRegression", "Other");
        if (!in_array($this->container['forecastingMethod'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets metric
     * @return string
     */
    public function getMetric()
    {
        return $this->container['metric'];
    }

    /**
     * Sets metric
     * @param string $metric The metric this result applies to
     * @return $this
     */
    public function setMetric($metric)
    {
        $allowed_values = array('Offered', 'AverageTalkTimeSeconds', 'AverageAfterCallWorkTimeSeconds', 'AverageHandleTimeSeconds');
        if (!in_array($metric, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'metric', must be one of 'Offered', 'AverageTalkTimeSeconds', 'AverageAfterCallWorkTimeSeconds', 'AverageHandleTimeSeconds'");
        }
        $this->container['metric'] = $metric;

        return $this;
    }

    /**
     * Gets forecastingMethod
     * @return string
     */
    public function getForecastingMethod()
    {
        return $this->container['forecastingMethod'];
    }

    /**
     * Sets forecastingMethod
     * @param string $forecastingMethod The forecasting method that was used for this metric
     * @return $this
     */
    public function setForecastingMethod($forecastingMethod)
    {
        $allowed_values = array('AutoRegressiveIntegratedMovingAverage', 'MovingAverage', 'SingleExponentialSmoothing', 'RandomWalk', 'DecompositionUsingAdditiveSeasonality', 'DecompositionUsingMultiplicativeSeasonality', 'HoltWintersAdditiveSeasonality', 'HoltWintersAdditiveSeasonalityWithDampedTrend', 'HoltWintersMultiplicativeSeasonality', 'HoltWintersMultiplicativeSeasonalityWithDampedTrend', 'DampedLinearExponentialSmoothing', 'DoubleExponentialSmoothing', 'DoubleMovingAverage', 'LinearExponentialSmoothing', 'LinearWeightedMovingAverage', 'PointEstimateUsingDampedLinearExponentialSmoothing', 'PointEstimateUsingDoubleExponentialSmoothing', 'PointEstimateUsingLatestWeek', 'PointEstimateUsingLinearExponentialSmoothing', 'PointEstimateUsingWeightedAverage', 'CurveFit', 'MultiLinearRegression', 'DynamicHarmonicRegression', 'Other');
        if (!in_array($forecastingMethod, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'forecastingMethod', must be one of 'AutoRegressiveIntegratedMovingAverage', 'MovingAverage', 'SingleExponentialSmoothing', 'RandomWalk', 'DecompositionUsingAdditiveSeasonality', 'DecompositionUsingMultiplicativeSeasonality', 'HoltWintersAdditiveSeasonality', 'HoltWintersAdditiveSeasonalityWithDampedTrend', 'HoltWintersMultiplicativeSeasonality', 'HoltWintersMultiplicativeSeasonalityWithDampedTrend', 'DampedLinearExponentialSmoothing', 'DoubleExponentialSmoothing', 'DoubleMovingAverage', 'LinearExponentialSmoothing', 'LinearWeightedMovingAverage', 'PointEstimateUsingDampedLinearExponentialSmoothing', 'PointEstimateUsingDoubleExponentialSmoothing', 'PointEstimateUsingLatestWeek', 'PointEstimateUsingLinearExponentialSmoothing', 'PointEstimateUsingWeightedAverage', 'CurveFit', 'MultiLinearRegression', 'DynamicHarmonicRegression', 'Other'");
        }
        $this->container['forecastingMethod'] = $forecastingMethod;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


