<?php

/**
 * ObservationMetricData
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ObservationMetricData Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ObservationMetricData implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ObservationMetricData';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'metric' => 'string',
        'qualifier' => 'string',
        'stats' => '\PureCloudSDK\StatisticalSummary',
        'truncated' => 'bool',
        'observations' => '\PureCloudSDK\ObservationValue[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'metric' => 'metric',
        'qualifier' => 'qualifier',
        'stats' => 'stats',
        'truncated' => 'truncated',
        'observations' => 'observations'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'metric' => 'setMetric',
        'qualifier' => 'setQualifier',
        'stats' => 'setStats',
        'truncated' => 'setTruncated',
        'observations' => 'setObservations'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'metric' => 'getMetric',
        'qualifier' => 'getQualifier',
        'stats' => 'getStats',
        'truncated' => 'getTruncated',
        'observations' => 'getObservations'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const METRIC_T_SEGMENT_DURATION = 'tSegmentDuration';
    public const METRIC_T_CONVERSATION_DURATION = 'tConversationDuration';
    public const METRIC_O_TOTAL_CRITICAL_SCORE = 'oTotalCriticalScore';
    public const METRIC_O_TOTAL_SCORE = 'oTotalScore';
    public const METRIC_N_EVALUATIONS = 'nEvaluations';
    public const METRIC_T_ABANDON = 'tAbandon';
    public const METRIC_T_IVR = 'tIvr';
    public const METRIC_T_ANSWERED = 'tAnswered';
    public const METRIC_T_FLOW_OUT = 'tFlowOut';
    public const METRIC_T_ACD = 'tAcd';
    public const METRIC_T_TALK = 'tTalk';
    public const METRIC_T_HELD = 'tHeld';
    public const METRIC_T_TALK_COMPLETE = 'tTalkComplete';
    public const METRIC_T_HELD_COMPLETE = 'tHeldComplete';
    public const METRIC_T_ACW = 'tAcw';
    public const METRIC_T_HANDLE = 'tHandle';
    public const METRIC_T_CONTACTING = 'tContacting';
    public const METRIC_T_DIALING = 'tDialing';
    public const METRIC_T_WAIT = 'tWait';
    public const METRIC_T_AGENT_ROUTING_STATUS = 'tAgentRoutingStatus';
    public const METRIC_T_ORGANIZATION_PRESENCE = 'tOrganizationPresence';
    public const METRIC_T_SYSTEM_PRESENCE = 'tSystemPresence';
    public const METRIC_T_USER_RESPONSE_TIME = 'tUserResponseTime';
    public const METRIC_T_AGENT_RESPONSE_TIME = 'tAgentResponseTime';
    public const METRIC_T_VOICEMAIL = 'tVoicemail';
    public const METRIC_N_STATE_TRANSITION_ERROR = 'nStateTransitionError';
    public const METRIC_N_OFFERED = 'nOffered';
    public const METRIC_N_OVER_SLA = 'nOverSla';
    public const METRIC_N_TRANSFERRED = 'nTransferred';
    public const METRIC_N_BLIND_TRANSFERRED = 'nBlindTransferred';
    public const METRIC_N_CONSULT_TRANSFERRED = 'nConsultTransferred';
    public const METRIC_N_CONSULT = 'nConsult';
    public const METRIC_N_CONNECTED = 'nConnected';
    public const METRIC_T_ALERT = 'tAlert';
    public const METRIC_T_NOT_RESPONDING = 'tNotResponding';
    public const METRIC_N_OUTBOUND = 'nOutbound';
    public const METRIC_N_OUTBOUND_ATTEMPTED = 'nOutboundAttempted';
    public const METRIC_N_OUTBOUND_CONNECTED = 'nOutboundConnected';
    public const METRIC_N_OUTBOUND_ABANDONED = 'nOutboundAbandoned';
    public const METRIC_N_ERROR = 'nError';
    public const METRIC_O_SERVICE_TARGET = 'oServiceTarget';
    public const METRIC_O_SERVICE_LEVEL = 'oServiceLevel';
    public const METRIC_T_ACTIVE = 'tActive';
    public const METRIC_T_INACTIVE = 'tInactive';
    public const METRIC_O_ACTIVE_USERS = 'oActiveUsers';
    public const METRIC_O_MEMBER_USERS = 'oMemberUsers';
    public const METRIC_O_ACTIVE_QUEUES = 'oActiveQueues';
    public const METRIC_O_MEMBER_QUEUES = 'oMemberQueues';
    public const METRIC_O_INTERACTING = 'oInteracting';
    public const METRIC_O_WAITING = 'oWaiting';
    public const METRIC_O_ON_QUEUE_USERS = 'oOnQueueUsers';
    public const METRIC_O_OFF_QUEUE_USERS = 'oOffQueueUsers';
    public const METRIC_O_USER_PRESENCES = 'oUserPresences';
    public const METRIC_O_USER_ROUTING_STATUSES = 'oUserRoutingStatuses';
    public const METRIC_N_SURVEYS_SENT = 'nSurveysSent';
    public const METRIC_N_SURVEYS_STARTED = 'nSurveysStarted';
    public const METRIC_N_SURVEYS_ABANDONED = 'nSurveysAbandoned';
    public const METRIC_N_SURVEYS_EXPIRED = 'nSurveysExpired';
    public const METRIC_N_SURVEY_ERRORS = 'nSurveyErrors';
    public const METRIC_N_SURVEY_RESPONSES = 'nSurveyResponses';
    public const METRIC_N_SURVEY_ANSWER_RESPONSES = 'nSurveyAnswerResponses';
    public const METRIC_O_SURVEY_TOTAL_SCORE = 'oSurveyTotalScore';
    public const METRIC_O_SURVEY_QUESTION_GROUP_SCORE = 'oSurveyQuestionGroupScore';
    public const METRIC_N_SURVEY_QUESTION_GROUP_RESPONSES = 'nSurveyQuestionGroupResponses';
    public const METRIC_O_SURVEY_QUESTION_SCORE = 'oSurveyQuestionScore';
    public const METRIC_N_SURVEY_QUESTION_RESPONSES = 'nSurveyQuestionResponses';
    public const METRIC_N_SURVEY_NPS_RESPONSES = 'nSurveyNpsResponses';
    public const METRIC_N_SURVEY_NPS_PROMOTERS = 'nSurveyNpsPromoters';
    public const METRIC_N_SURVEY_NPS_DETRACTORS = 'nSurveyNpsDetractors';
    public const METRIC_N_FLOW = 'nFlow';
    public const METRIC_T_FLOW_DISCONNECT = 'tFlowDisconnect';
    public const METRIC_T_FLOW_EXIT = 'tFlowExit';
    public const METRIC_T_FLOW = 'tFlow';
    public const METRIC_O_FLOW = 'oFlow';
    public const METRIC_T_FLOW_OUTCOME = 'tFlowOutcome';
    public const METRIC_N_FLOW_OUTCOME = 'nFlowOutcome';
    public const METRIC_N_FLOW_OUTCOME_FAILED = 'nFlowOutcomeFailed';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMetricAllowableValues()
    {
        return [
            self::METRIC_T_SEGMENT_DURATION,
            self::METRIC_T_CONVERSATION_DURATION,
            self::METRIC_O_TOTAL_CRITICAL_SCORE,
            self::METRIC_O_TOTAL_SCORE,
            self::METRIC_N_EVALUATIONS,
            self::METRIC_T_ABANDON,
            self::METRIC_T_IVR,
            self::METRIC_T_ANSWERED,
            self::METRIC_T_FLOW_OUT,
            self::METRIC_T_ACD,
            self::METRIC_T_TALK,
            self::METRIC_T_HELD,
            self::METRIC_T_TALK_COMPLETE,
            self::METRIC_T_HELD_COMPLETE,
            self::METRIC_T_ACW,
            self::METRIC_T_HANDLE,
            self::METRIC_T_CONTACTING,
            self::METRIC_T_DIALING,
            self::METRIC_T_WAIT,
            self::METRIC_T_AGENT_ROUTING_STATUS,
            self::METRIC_T_ORGANIZATION_PRESENCE,
            self::METRIC_T_SYSTEM_PRESENCE,
            self::METRIC_T_USER_RESPONSE_TIME,
            self::METRIC_T_AGENT_RESPONSE_TIME,
            self::METRIC_T_VOICEMAIL,
            self::METRIC_N_STATE_TRANSITION_ERROR,
            self::METRIC_N_OFFERED,
            self::METRIC_N_OVER_SLA,
            self::METRIC_N_TRANSFERRED,
            self::METRIC_N_BLIND_TRANSFERRED,
            self::METRIC_N_CONSULT_TRANSFERRED,
            self::METRIC_N_CONSULT,
            self::METRIC_N_CONNECTED,
            self::METRIC_T_ALERT,
            self::METRIC_T_NOT_RESPONDING,
            self::METRIC_N_OUTBOUND,
            self::METRIC_N_OUTBOUND_ATTEMPTED,
            self::METRIC_N_OUTBOUND_CONNECTED,
            self::METRIC_N_OUTBOUND_ABANDONED,
            self::METRIC_N_ERROR,
            self::METRIC_O_SERVICE_TARGET,
            self::METRIC_O_SERVICE_LEVEL,
            self::METRIC_T_ACTIVE,
            self::METRIC_T_INACTIVE,
            self::METRIC_O_ACTIVE_USERS,
            self::METRIC_O_MEMBER_USERS,
            self::METRIC_O_ACTIVE_QUEUES,
            self::METRIC_O_MEMBER_QUEUES,
            self::METRIC_O_INTERACTING,
            self::METRIC_O_WAITING,
            self::METRIC_O_ON_QUEUE_USERS,
            self::METRIC_O_OFF_QUEUE_USERS,
            self::METRIC_O_USER_PRESENCES,
            self::METRIC_O_USER_ROUTING_STATUSES,
            self::METRIC_N_SURVEYS_SENT,
            self::METRIC_N_SURVEYS_STARTED,
            self::METRIC_N_SURVEYS_ABANDONED,
            self::METRIC_N_SURVEYS_EXPIRED,
            self::METRIC_N_SURVEY_ERRORS,
            self::METRIC_N_SURVEY_RESPONSES,
            self::METRIC_N_SURVEY_ANSWER_RESPONSES,
            self::METRIC_O_SURVEY_TOTAL_SCORE,
            self::METRIC_O_SURVEY_QUESTION_GROUP_SCORE,
            self::METRIC_N_SURVEY_QUESTION_GROUP_RESPONSES,
            self::METRIC_O_SURVEY_QUESTION_SCORE,
            self::METRIC_N_SURVEY_QUESTION_RESPONSES,
            self::METRIC_N_SURVEY_NPS_RESPONSES,
            self::METRIC_N_SURVEY_NPS_PROMOTERS,
            self::METRIC_N_SURVEY_NPS_DETRACTORS,
            self::METRIC_N_FLOW,
            self::METRIC_T_FLOW_DISCONNECT,
            self::METRIC_T_FLOW_EXIT,
            self::METRIC_T_FLOW,
            self::METRIC_O_FLOW,
            self::METRIC_T_FLOW_OUTCOME,
            self::METRIC_N_FLOW_OUTCOME,
            self::METRIC_N_FLOW_OUTCOME_FAILED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['metric'] = isset($data['metric']) ? $data['metric'] : null;
        $this->container['qualifier'] = isset($data['qualifier']) ? $data['qualifier'] : null;
        $this->container['stats'] = isset($data['stats']) ? $data['stats'] : null;
        $this->container['truncated'] = isset($data['truncated']) ? $data['truncated'] : null;
        $this->container['observations'] = isset($data['observations']) ? $data['observations'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("tSegmentDuration", "tConversationDuration", "oTotalCriticalScore", "oTotalScore", "nEvaluations", "tAbandon", "tIvr", "tAnswered", "tFlowOut", "tAcd", "tTalk", "tHeld", "tTalkComplete", "tHeldComplete", "tAcw", "tHandle", "tContacting", "tDialing", "tWait", "tAgentRoutingStatus", "tOrganizationPresence", "tSystemPresence", "tUserResponseTime", "tAgentResponseTime", "tVoicemail", "nStateTransitionError", "nOffered", "nOverSla", "nTransferred", "nBlindTransferred", "nConsultTransferred", "nConsult", "nConnected", "tAlert", "tNotResponding", "nOutbound", "nOutboundAttempted", "nOutboundConnected", "nOutboundAbandoned", "nError", "oServiceTarget", "oServiceLevel", "tActive", "tInactive", "oActiveUsers", "oMemberUsers", "oActiveQueues", "oMemberQueues", "oInteracting", "oWaiting", "oOnQueueUsers", "oOffQueueUsers", "oUserPresences", "oUserRoutingStatuses", "nSurveysSent", "nSurveysStarted", "nSurveysAbandoned", "nSurveysExpired", "nSurveyErrors", "nSurveyResponses", "nSurveyAnswerResponses", "oSurveyTotalScore", "oSurveyQuestionGroupScore", "nSurveyQuestionGroupResponses", "oSurveyQuestionScore", "nSurveyQuestionResponses", "nSurveyNpsResponses", "nSurveyNpsPromoters", "nSurveyNpsDetractors", "nFlow", "tFlowDisconnect", "tFlowExit", "tFlow", "oFlow", "tFlowOutcome", "nFlowOutcome", "nFlowOutcomeFailed");
        if (!in_array($this->container['metric'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'metric', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("tSegmentDuration", "tConversationDuration", "oTotalCriticalScore", "oTotalScore", "nEvaluations", "tAbandon", "tIvr", "tAnswered", "tFlowOut", "tAcd", "tTalk", "tHeld", "tTalkComplete", "tHeldComplete", "tAcw", "tHandle", "tContacting", "tDialing", "tWait", "tAgentRoutingStatus", "tOrganizationPresence", "tSystemPresence", "tUserResponseTime", "tAgentResponseTime", "tVoicemail", "nStateTransitionError", "nOffered", "nOverSla", "nTransferred", "nBlindTransferred", "nConsultTransferred", "nConsult", "nConnected", "tAlert", "tNotResponding", "nOutbound", "nOutboundAttempted", "nOutboundConnected", "nOutboundAbandoned", "nError", "oServiceTarget", "oServiceLevel", "tActive", "tInactive", "oActiveUsers", "oMemberUsers", "oActiveQueues", "oMemberQueues", "oInteracting", "oWaiting", "oOnQueueUsers", "oOffQueueUsers", "oUserPresences", "oUserRoutingStatuses", "nSurveysSent", "nSurveysStarted", "nSurveysAbandoned", "nSurveysExpired", "nSurveyErrors", "nSurveyResponses", "nSurveyAnswerResponses", "oSurveyTotalScore", "oSurveyQuestionGroupScore", "nSurveyQuestionGroupResponses", "oSurveyQuestionScore", "nSurveyQuestionResponses", "nSurveyNpsResponses", "nSurveyNpsPromoters", "nSurveyNpsDetractors", "nFlow", "tFlowDisconnect", "tFlowExit", "tFlow", "oFlow", "tFlowOutcome", "nFlowOutcome", "nFlowOutcomeFailed");
        if (!in_array($this->container['metric'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets metric
     * @return string
     */
    public function getMetric()
    {
        return $this->container['metric'];
    }

    /**
     * Sets metric
     * @param string $metric
     * @return $this
     */
    public function setMetric($metric)
    {
        $allowed_values = array('tSegmentDuration', 'tConversationDuration', 'oTotalCriticalScore', 'oTotalScore', 'nEvaluations', 'tAbandon', 'tIvr', 'tAnswered', 'tFlowOut', 'tAcd', 'tTalk', 'tHeld', 'tTalkComplete', 'tHeldComplete', 'tAcw', 'tHandle', 'tContacting', 'tDialing', 'tWait', 'tAgentRoutingStatus', 'tOrganizationPresence', 'tSystemPresence', 'tUserResponseTime', 'tAgentResponseTime', 'tVoicemail', 'nStateTransitionError', 'nOffered', 'nOverSla', 'nTransferred', 'nBlindTransferred', 'nConsultTransferred', 'nConsult', 'nConnected', 'tAlert', 'tNotResponding', 'nOutbound', 'nOutboundAttempted', 'nOutboundConnected', 'nOutboundAbandoned', 'nError', 'oServiceTarget', 'oServiceLevel', 'tActive', 'tInactive', 'oActiveUsers', 'oMemberUsers', 'oActiveQueues', 'oMemberQueues', 'oInteracting', 'oWaiting', 'oOnQueueUsers', 'oOffQueueUsers', 'oUserPresences', 'oUserRoutingStatuses', 'nSurveysSent', 'nSurveysStarted', 'nSurveysAbandoned', 'nSurveysExpired', 'nSurveyErrors', 'nSurveyResponses', 'nSurveyAnswerResponses', 'oSurveyTotalScore', 'oSurveyQuestionGroupScore', 'nSurveyQuestionGroupResponses', 'oSurveyQuestionScore', 'nSurveyQuestionResponses', 'nSurveyNpsResponses', 'nSurveyNpsPromoters', 'nSurveyNpsDetractors', 'nFlow', 'tFlowDisconnect', 'tFlowExit', 'tFlow', 'oFlow', 'tFlowOutcome', 'nFlowOutcome', 'nFlowOutcomeFailed');
        if (!in_array($metric, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'metric', must be one of 'tSegmentDuration', 'tConversationDuration', 'oTotalCriticalScore', 'oTotalScore', 'nEvaluations', 'tAbandon', 'tIvr', 'tAnswered', 'tFlowOut', 'tAcd', 'tTalk', 'tHeld', 'tTalkComplete', 'tHeldComplete', 'tAcw', 'tHandle', 'tContacting', 'tDialing', 'tWait', 'tAgentRoutingStatus', 'tOrganizationPresence', 'tSystemPresence', 'tUserResponseTime', 'tAgentResponseTime', 'tVoicemail', 'nStateTransitionError', 'nOffered', 'nOverSla', 'nTransferred', 'nBlindTransferred', 'nConsultTransferred', 'nConsult', 'nConnected', 'tAlert', 'tNotResponding', 'nOutbound', 'nOutboundAttempted', 'nOutboundConnected', 'nOutboundAbandoned', 'nError', 'oServiceTarget', 'oServiceLevel', 'tActive', 'tInactive', 'oActiveUsers', 'oMemberUsers', 'oActiveQueues', 'oMemberQueues', 'oInteracting', 'oWaiting', 'oOnQueueUsers', 'oOffQueueUsers', 'oUserPresences', 'oUserRoutingStatuses', 'nSurveysSent', 'nSurveysStarted', 'nSurveysAbandoned', 'nSurveysExpired', 'nSurveyErrors', 'nSurveyResponses', 'nSurveyAnswerResponses', 'oSurveyTotalScore', 'oSurveyQuestionGroupScore', 'nSurveyQuestionGroupResponses', 'oSurveyQuestionScore', 'nSurveyQuestionResponses', 'nSurveyNpsResponses', 'nSurveyNpsPromoters', 'nSurveyNpsDetractors', 'nFlow', 'tFlowDisconnect', 'tFlowExit', 'tFlow', 'oFlow', 'tFlowOutcome', 'nFlowOutcome', 'nFlowOutcomeFailed'");
        }
        $this->container['metric'] = $metric;

        return $this;
    }

    /**
     * Gets qualifier
     * @return string
     */
    public function getQualifier()
    {
        return $this->container['qualifier'];
    }

    /**
     * Sets qualifier
     * @param string $qualifier
     * @return $this
     */
    public function setQualifier($qualifier)
    {
        $this->container['qualifier'] = $qualifier;

        return $this;
    }

    /**
     * Gets stats
     * @return \PureCloudSDK\StatisticalSummary
     */
    public function getStats()
    {
        return $this->container['stats'];
    }

    /**
     * Sets stats
     * @param \PureCloudSDK\StatisticalSummary $stats
     * @return $this
     */
    public function setStats($stats)
    {
        $this->container['stats'] = $stats;

        return $this;
    }

    /**
     * Gets truncated
     * @return bool
     */
    public function getTruncated()
    {
        return $this->container['truncated'];
    }

    /**
     * Sets truncated
     * @param bool $truncated Flag for a truncated list of observations. If truncated, the first half of the list of observations will contain the oldest observations and the second half the newest observations.
     * @return $this
     */
    public function setTruncated($truncated)
    {
        $this->container['truncated'] = $truncated;

        return $this;
    }

    /**
     * Gets observations
     * @return \PureCloudSDK\ObservationValue[]
     */
    public function getObservations()
    {
        return $this->container['observations'];
    }

    /**
     * Sets observations
     * @param \PureCloudSDK\ObservationValue[] $observations List of observations sorted by timestamp in ascending order. This list may be truncated.
     * @return $this
     */
    public function setObservations($observations)
    {
        $this->container['observations'] = $observations;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


