<?php

/**
 * PolicyErrorMessage
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * PolicyErrorMessage Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class PolicyErrorMessage implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'PolicyErrorMessage';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'statusCode' => 'int',
        'userMessage' => 'object',
        'userParamsMessage' => 'string',
        'errorCode' => 'string',
        'correlationId' => 'string',
        'userParams' => '\PureCloudSDK\UserParam[]',
        'insertDate' => '\DateTime'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'statusCode' => 'statusCode',
        'userMessage' => 'userMessage',
        'userParamsMessage' => 'userParamsMessage',
        'errorCode' => 'errorCode',
        'correlationId' => 'correlationId',
        'userParams' => 'userParams',
        'insertDate' => 'insertDate'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'statusCode' => 'setStatusCode',
        'userMessage' => 'setUserMessage',
        'userParamsMessage' => 'setUserParamsMessage',
        'errorCode' => 'setErrorCode',
        'correlationId' => 'setCorrelationId',
        'userParams' => 'setUserParams',
        'insertDate' => 'setInsertDate'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'statusCode' => 'getStatusCode',
        'userMessage' => 'getUserMessage',
        'userParamsMessage' => 'getUserParamsMessage',
        'errorCode' => 'getErrorCode',
        'correlationId' => 'getCorrelationId',
        'userParams' => 'getUserParams',
        'insertDate' => 'getInsertDate'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['statusCode'] = isset($data['statusCode']) ? $data['statusCode'] : null;
        $this->container['userMessage'] = isset($data['userMessage']) ? $data['userMessage'] : null;
        $this->container['userParamsMessage'] = isset($data['userParamsMessage']) ? $data['userParamsMessage'] : null;
        $this->container['errorCode'] = isset($data['errorCode']) ? $data['errorCode'] : null;
        $this->container['correlationId'] = isset($data['correlationId']) ? $data['correlationId'] : null;
        $this->container['userParams'] = isset($data['userParams']) ? $data['userParams'] : null;
        $this->container['insertDate'] = isset($data['insertDate']) ? $data['insertDate'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets statusCode
     * @return int
     */
    public function getStatusCode()
    {
        return $this->container['statusCode'];
    }

    /**
     * Sets statusCode
     * @param int $statusCode
     * @return $this
     */
    public function setStatusCode($statusCode)
    {
        $this->container['statusCode'] = $statusCode;

        return $this;
    }

    /**
     * Gets userMessage
     * @return object
     */
    public function getUserMessage()
    {
        return $this->container['userMessage'];
    }

    /**
     * Sets userMessage
     * @param object $userMessage
     * @return $this
     */
    public function setUserMessage($userMessage)
    {
        $this->container['userMessage'] = $userMessage;

        return $this;
    }

    /**
     * Gets userParamsMessage
     * @return string
     */
    public function getUserParamsMessage()
    {
        return $this->container['userParamsMessage'];
    }

    /**
     * Sets userParamsMessage
     * @param string $userParamsMessage
     * @return $this
     */
    public function setUserParamsMessage($userParamsMessage)
    {
        $this->container['userParamsMessage'] = $userParamsMessage;

        return $this;
    }

    /**
     * Gets errorCode
     * @return string
     */
    public function getErrorCode()
    {
        return $this->container['errorCode'];
    }

    /**
     * Sets errorCode
     * @param string $errorCode
     * @return $this
     */
    public function setErrorCode($errorCode)
    {
        $this->container['errorCode'] = $errorCode;

        return $this;
    }

    /**
     * Gets correlationId
     * @return string
     */
    public function getCorrelationId()
    {
        return $this->container['correlationId'];
    }

    /**
     * Sets correlationId
     * @param string $correlationId
     * @return $this
     */
    public function setCorrelationId($correlationId)
    {
        $this->container['correlationId'] = $correlationId;

        return $this;
    }

    /**
     * Gets userParams
     * @return \PureCloudSDK\UserParam[]
     */
    public function getUserParams()
    {
        return $this->container['userParams'];
    }

    /**
     * Sets userParams
     * @param \PureCloudSDK\UserParam[] $userParams
     * @return $this
     */
    public function setUserParams($userParams)
    {
        $this->container['userParams'] = $userParams;

        return $this;
    }

    /**
     * Gets insertDate
     * @return \DateTime
     */
    public function getInsertDate()
    {
        return $this->container['insertDate'];
    }

    /**
     * Sets insertDate
     * @param \DateTime $insertDate Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setInsertDate($insertDate)
    {
        $this->container['insertDate'] = $insertDate;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


