<?php

/**
 * AnalyticsQueryPredicate
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * AnalyticsQueryPredicate Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AnalyticsQueryPredicate implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AnalyticsQueryPredicate';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'type' => 'string',
        'dimension' => 'string',
        'propertyType' => 'string',
        'property' => 'string',
        'metric' => 'string',
        'operator' => 'string',
        'value' => 'string',
        'range' => '\PureCloudSDK\NumericRange'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'type' => 'type',
        'dimension' => 'dimension',
        'propertyType' => 'propertyType',
        'property' => 'property',
        'metric' => 'metric',
        'operator' => 'operator',
        'value' => 'value',
        'range' => 'range'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'type' => 'setType',
        'dimension' => 'setDimension',
        'propertyType' => 'setPropertyType',
        'property' => 'setProperty',
        'metric' => 'setMetric',
        'operator' => 'setOperator',
        'value' => 'setValue',
        'range' => 'setRange'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'type' => 'getType',
        'dimension' => 'getDimension',
        'propertyType' => 'getPropertyType',
        'property' => 'getProperty',
        'metric' => 'getMetric',
        'operator' => 'getOperator',
        'value' => 'getValue',
        'range' => 'getRange'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const TYPE_DIMENSION = 'dimension';
    public const TYPE_PROPERTY = 'property';
    public const TYPE_METRIC = 'metric';
    public const DIMENSION_CONVERSATION_ID = 'conversationId';
    public const DIMENSION_SESSION_ID = 'sessionId';
    public const DIMENSION_MEDIA_TYPE = 'mediaType';
    public const DIMENSION_QUEUE_ID = 'queueId';
    public const DIMENSION_USER_ID = 'userId';
    public const DIMENSION_PARTICIPANT_ID = 'participantId';
    public const DIMENSION_PARTICIPANT_NAME = 'participantName';
    public const DIMENSION_DIRECTION = 'direction';
    public const DIMENSION_ORIGINATING_DIRECTION = 'originatingDirection';
    public const DIMENSION_WRAP_UP_CODE = 'wrapUpCode';
    public const DIMENSION_WRAP_UP_NOTE = 'wrapUpNote';
    public const DIMENSION_INTERACTION_TYPE = 'interactionType';
    public const DIMENSION_REQUESTED_ROUTING_SKILL_ID = 'requestedRoutingSkillId';
    public const DIMENSION_REQUESTED_LANGUAGE_ID = 'requestedLanguageId';
    public const DIMENSION_REQUESTED_ROUTING_USER_IDS = 'requestedRoutingUserIds';
    public const DIMENSION_ROUTING_PRIORITY = 'routingPriority';
    public const DIMENSION_PURPOSE = 'purpose';
    public const DIMENSION_PARTICIPANT_TYPE = 'participantType';
    public const DIMENSION_SEGMENT_TYPE = 'segmentType';
    public const DIMENSION_DISCONNECT_TYPE = 'disconnectType';
    public const DIMENSION_ERROR_CODE = 'errorCode';
    public const DIMENSION_CONVERSATION_END = 'conversationEnd';
    public const DIMENSION_SEGMENT_END = 'segmentEnd';
    public const DIMENSION_EXTERNAL_CONTACT_ID = 'externalContactId';
    public const DIMENSION_EXTERNAL_ORGANIZATION_ID = 'externalOrganizationId';
    public const DIMENSION_CONVERTED_FROM = 'convertedFrom';
    public const DIMENSION_CONVERTED_TO = 'convertedTo';
    public const DIMENSION_DIVISION_ID = 'divisionId';
    public const DIMENSION_FLAGGED_REASON = 'flaggedReason';
    public const DIMENSION_STATION_ID = 'stationId';
    public const DIMENSION_EDGE_ID = 'edgeId';
    public const DIMENSION_DNIS = 'dnis';
    public const DIMENSION_ANI = 'ani';
    public const DIMENSION_SESSION_DNIS = 'sessionDnis';
    public const DIMENSION_OUTBOUND_CAMPAIGN_ID = 'outboundCampaignId';
    public const DIMENSION_OUTBOUND_CONTACT_ID = 'outboundContactId';
    public const DIMENSION_OUTBOUND_CONTACT_LIST_ID = 'outboundContactListId';
    public const DIMENSION_MONITORED_PARTICIPANT_ID = 'monitoredParticipantId';
    public const DIMENSION_SOURCE_SESSION_ID = 'sourceSessionId';
    public const DIMENSION_DESTINATION_SESSION_ID = 'destinationSessionId';
    public const DIMENSION_SOURCE_CONVERSATION_ID = 'sourceConversationId';
    public const DIMENSION_DESTINATION_CONVERSATION_ID = 'destinationConversationId';
    public const DIMENSION_REMOTE_NAME_DISPLAYABLE = 'remoteNameDisplayable';
    public const DIMENSION_SIP_RESPONSE_CODE = 'sipResponseCode';
    public const DIMENSION_Q850_RESPONSE_CODE = 'q850ResponseCode';
    public const DIMENSION_CONFERENCE = 'conference';
    public const DIMENSION_GROUP_ID = 'groupId';
    public const DIMENSION_PROTOCOL_CALL_ID = 'protocolCallId';
    public const DIMENSION_ROOM_ID = 'roomId';
    public const DIMENSION_ADDRESS_FROM = 'addressFrom';
    public const DIMENSION_ADDRESS_TO = 'addressTo';
    public const DIMENSION_ADDRESS_SELF = 'addressSelf';
    public const DIMENSION_ADDRESS_OTHER = 'addressOther';
    public const DIMENSION_SUBJECT = 'subject';
    public const DIMENSION_MESSAGE_TYPE = 'messageType';
    public const DIMENSION_PEER_ID = 'peerId';
    public const DIMENSION_SCRIPT_ID = 'scriptId';
    public const DIMENSION_EVALUATION_ID = 'evaluationId';
    public const DIMENSION_EVALUATOR_ID = 'evaluatorId';
    public const DIMENSION_CONTEXT_ID = 'contextId';
    public const DIMENSION_FORM_ID = 'formId';
    public const DIMENSION_FORM_NAME = 'formName';
    public const DIMENSION_EVENT_TIME = 'eventTime';
    public const DIMENSION_CALIBRATION_ID = 'calibrationId';
    public const DIMENSION_SURVEY_ID = 'surveyId';
    public const DIMENSION_SURVEY_FORM_CONTEXT_ID = 'surveyFormContextId';
    public const DIMENSION_SURVEY_FORM_ID = 'surveyFormId';
    public const DIMENSION_SURVEY_FORM_NAME = 'surveyFormName';
    public const DIMENSION_SURVEY_ANSWER_ID = 'surveyAnswerId';
    public const DIMENSION_SURVEY_QUESTION_ID = 'surveyQuestionId';
    public const DIMENSION_SURVEY_QUESTION_GROUP_ID = 'surveyQuestionGroupId';
    public const DIMENSION_SURVEY_PROMOTER_SCORE = 'surveyPromoterScore';
    public const DIMENSION_SURVEY_COMPLETED_DATE = 'surveyCompletedDate';
    public const DIMENSION_SURVEY_ERROR_REASON = 'surveyErrorReason';
    public const DIMENSION_SURVEY_PREVIOUS_STATUS = 'surveyPreviousStatus';
    public const DIMENSION_SURVEY_STATUS = 'surveyStatus';
    public const DIMENSION_SYSTEM_PRESENCE = 'systemPresence';
    public const DIMENSION_ORGANIZATION_PRESENCE_ID = 'organizationPresenceId';
    public const DIMENSION_ROUTING_STATUS = 'routingStatus';
    public const DIMENSION_FLOW_ID = 'flowId';
    public const DIMENSION_FLOW_NAME = 'flowName';
    public const DIMENSION_FLOW_VERSION = 'flowVersion';
    public const DIMENSION_FLOW_TYPE = 'flowType';
    public const DIMENSION_EXIT_REASON = 'exitReason';
    public const DIMENSION_ENTRY_REASON = 'entryReason';
    public const DIMENSION_ENTRY_TYPE = 'entryType';
    public const DIMENSION_TRANSFER_TYPE = 'transferType';
    public const DIMENSION_TRANSFER_TARGET_NAME = 'transferTargetName';
    public const DIMENSION_TRANSFER_TARGET_ADDRESS = 'transferTargetAddress';
    public const DIMENSION_ISSUED_CALLBACK = 'issuedCallback';
    public const DIMENSION_STARTING_LANGUAGE = 'startingLanguage';
    public const DIMENSION_ENDING_LANGUAGE = 'endingLanguage';
    public const DIMENSION_FLOW_OUTCOME_ID = 'flowOutcomeId';
    public const DIMENSION_FLOW_OUTCOME_VALUE = 'flowOutcomeValue';
    public const DIMENSION_FLOW_OUTCOME = 'flowOutcome';
    public const DIMENSION_JOURNEY_CUSTOMER_ID = 'journeyCustomerId';
    public const DIMENSION_JOURNEY_CUSTOMER_ID_TYPE = 'journeyCustomerIdType';
    public const DIMENSION_JOURNEY_CUSTOMER_SESSION_ID = 'journeyCustomerSessionId';
    public const DIMENSION_JOURNEY_CUSTOMER_SESSION_ID_TYPE = 'journeyCustomerSessionIdType';
    public const DIMENSION_JOURNEY_ACTION_ID = 'journeyActionId';
    public const DIMENSION_JOURNEY_ACTION_MAP_ID = 'journeyActionMapId';
    public const DIMENSION_JOURNEY_ACTION_MAP_VERSION = 'journeyActionMapVersion';
    public const DIMENSION_MIN_MOS = 'minMos';
    public const DIMENSION_MEDIA_STATS_MIN_CONVERSATION_MOS = 'mediaStatsMinConversationMos';
    public const DIMENSION_MIN_R_FACTOR = 'minRFactor';
    public const DIMENSION_MEDIA_STATS_MIN_CONVERSATION_R_FACTOR = 'mediaStatsMinConversationRFactor';
    public const PROPERTY_TYPE_BOOL = 'bool';
    public const PROPERTY_TYPE_INTEGER = 'integer';
    public const PROPERTY_TYPE_REAL = 'real';
    public const PROPERTY_TYPE_DATE = 'date';
    public const PROPERTY_TYPE_STRING = 'string';
    public const PROPERTY_TYPE_UUID = 'uuid';
    public const METRIC_T_SEGMENT_DURATION = 'tSegmentDuration';
    public const METRIC_T_CONVERSATION_DURATION = 'tConversationDuration';
    public const METRIC_O_TOTAL_CRITICAL_SCORE = 'oTotalCriticalScore';
    public const METRIC_O_TOTAL_SCORE = 'oTotalScore';
    public const METRIC_N_EVALUATIONS = 'nEvaluations';
    public const METRIC_T_ABANDON = 'tAbandon';
    public const METRIC_T_IVR = 'tIvr';
    public const METRIC_T_ANSWERED = 'tAnswered';
    public const METRIC_T_FLOW_OUT = 'tFlowOut';
    public const METRIC_T_ACD = 'tAcd';
    public const METRIC_T_TALK = 'tTalk';
    public const METRIC_T_HELD = 'tHeld';
    public const METRIC_T_TALK_COMPLETE = 'tTalkComplete';
    public const METRIC_T_HELD_COMPLETE = 'tHeldComplete';
    public const METRIC_T_ACW = 'tAcw';
    public const METRIC_T_HANDLE = 'tHandle';
    public const METRIC_T_CONTACTING = 'tContacting';
    public const METRIC_T_DIALING = 'tDialing';
    public const METRIC_T_WAIT = 'tWait';
    public const METRIC_T_AGENT_ROUTING_STATUS = 'tAgentRoutingStatus';
    public const METRIC_T_ORGANIZATION_PRESENCE = 'tOrganizationPresence';
    public const METRIC_T_SYSTEM_PRESENCE = 'tSystemPresence';
    public const METRIC_T_USER_RESPONSE_TIME = 'tUserResponseTime';
    public const METRIC_T_AGENT_RESPONSE_TIME = 'tAgentResponseTime';
    public const METRIC_T_VOICEMAIL = 'tVoicemail';
    public const METRIC_N_STATE_TRANSITION_ERROR = 'nStateTransitionError';
    public const METRIC_N_OFFERED = 'nOffered';
    public const METRIC_N_OVER_SLA = 'nOverSla';
    public const METRIC_N_TRANSFERRED = 'nTransferred';
    public const METRIC_N_BLIND_TRANSFERRED = 'nBlindTransferred';
    public const METRIC_N_CONSULT_TRANSFERRED = 'nConsultTransferred';
    public const METRIC_N_CONSULT = 'nConsult';
    public const METRIC_N_CONNECTED = 'nConnected';
    public const METRIC_T_ALERT = 'tAlert';
    public const METRIC_T_NOT_RESPONDING = 'tNotResponding';
    public const METRIC_N_OUTBOUND = 'nOutbound';
    public const METRIC_N_OUTBOUND_ATTEMPTED = 'nOutboundAttempted';
    public const METRIC_N_OUTBOUND_CONNECTED = 'nOutboundConnected';
    public const METRIC_N_OUTBOUND_ABANDONED = 'nOutboundAbandoned';
    public const METRIC_N_ERROR = 'nError';
    public const METRIC_O_SERVICE_TARGET = 'oServiceTarget';
    public const METRIC_O_SERVICE_LEVEL = 'oServiceLevel';
    public const METRIC_T_ACTIVE = 'tActive';
    public const METRIC_T_INACTIVE = 'tInactive';
    public const METRIC_O_ACTIVE_USERS = 'oActiveUsers';
    public const METRIC_O_MEMBER_USERS = 'oMemberUsers';
    public const METRIC_O_ACTIVE_QUEUES = 'oActiveQueues';
    public const METRIC_O_MEMBER_QUEUES = 'oMemberQueues';
    public const METRIC_O_INTERACTING = 'oInteracting';
    public const METRIC_O_WAITING = 'oWaiting';
    public const METRIC_O_ON_QUEUE_USERS = 'oOnQueueUsers';
    public const METRIC_O_OFF_QUEUE_USERS = 'oOffQueueUsers';
    public const METRIC_O_USER_PRESENCES = 'oUserPresences';
    public const METRIC_O_USER_ROUTING_STATUSES = 'oUserRoutingStatuses';
    public const METRIC_N_SURVEYS_SENT = 'nSurveysSent';
    public const METRIC_N_SURVEYS_STARTED = 'nSurveysStarted';
    public const METRIC_N_SURVEYS_ABANDONED = 'nSurveysAbandoned';
    public const METRIC_N_SURVEYS_EXPIRED = 'nSurveysExpired';
    public const METRIC_N_SURVEY_ERRORS = 'nSurveyErrors';
    public const METRIC_N_SURVEY_RESPONSES = 'nSurveyResponses';
    public const METRIC_N_SURVEY_ANSWER_RESPONSES = 'nSurveyAnswerResponses';
    public const METRIC_O_SURVEY_TOTAL_SCORE = 'oSurveyTotalScore';
    public const METRIC_O_SURVEY_QUESTION_GROUP_SCORE = 'oSurveyQuestionGroupScore';
    public const METRIC_N_SURVEY_QUESTION_GROUP_RESPONSES = 'nSurveyQuestionGroupResponses';
    public const METRIC_O_SURVEY_QUESTION_SCORE = 'oSurveyQuestionScore';
    public const METRIC_N_SURVEY_QUESTION_RESPONSES = 'nSurveyQuestionResponses';
    public const METRIC_N_SURVEY_NPS_RESPONSES = 'nSurveyNpsResponses';
    public const METRIC_N_SURVEY_NPS_PROMOTERS = 'nSurveyNpsPromoters';
    public const METRIC_N_SURVEY_NPS_DETRACTORS = 'nSurveyNpsDetractors';
    public const METRIC_N_FLOW = 'nFlow';
    public const METRIC_T_FLOW_DISCONNECT = 'tFlowDisconnect';
    public const METRIC_T_FLOW_EXIT = 'tFlowExit';
    public const METRIC_T_FLOW = 'tFlow';
    public const METRIC_O_FLOW = 'oFlow';
    public const METRIC_T_FLOW_OUTCOME = 'tFlowOutcome';
    public const METRIC_N_FLOW_OUTCOME = 'nFlowOutcome';
    public const METRIC_N_FLOW_OUTCOME_FAILED = 'nFlowOutcomeFailed';
    public const OPERATOR_MATCHES = 'matches';
    public const OPERATOR_EXISTS = 'exists';
    public const OPERATOR_NOT_EXISTS = 'notExists';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_DIMENSION,
            self::TYPE_PROPERTY,
            self::TYPE_METRIC,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDimensionAllowableValues()
    {
        return [
            self::DIMENSION_CONVERSATION_ID,
            self::DIMENSION_SESSION_ID,
            self::DIMENSION_MEDIA_TYPE,
            self::DIMENSION_QUEUE_ID,
            self::DIMENSION_USER_ID,
            self::DIMENSION_PARTICIPANT_ID,
            self::DIMENSION_PARTICIPANT_NAME,
            self::DIMENSION_DIRECTION,
            self::DIMENSION_ORIGINATING_DIRECTION,
            self::DIMENSION_WRAP_UP_CODE,
            self::DIMENSION_WRAP_UP_NOTE,
            self::DIMENSION_INTERACTION_TYPE,
            self::DIMENSION_REQUESTED_ROUTING_SKILL_ID,
            self::DIMENSION_REQUESTED_LANGUAGE_ID,
            self::DIMENSION_REQUESTED_ROUTING_USER_IDS,
            self::DIMENSION_ROUTING_PRIORITY,
            self::DIMENSION_PURPOSE,
            self::DIMENSION_PARTICIPANT_TYPE,
            self::DIMENSION_SEGMENT_TYPE,
            self::DIMENSION_DISCONNECT_TYPE,
            self::DIMENSION_ERROR_CODE,
            self::DIMENSION_CONVERSATION_END,
            self::DIMENSION_SEGMENT_END,
            self::DIMENSION_EXTERNAL_CONTACT_ID,
            self::DIMENSION_EXTERNAL_ORGANIZATION_ID,
            self::DIMENSION_CONVERTED_FROM,
            self::DIMENSION_CONVERTED_TO,
            self::DIMENSION_DIVISION_ID,
            self::DIMENSION_FLAGGED_REASON,
            self::DIMENSION_STATION_ID,
            self::DIMENSION_EDGE_ID,
            self::DIMENSION_DNIS,
            self::DIMENSION_ANI,
            self::DIMENSION_SESSION_DNIS,
            self::DIMENSION_OUTBOUND_CAMPAIGN_ID,
            self::DIMENSION_OUTBOUND_CONTACT_ID,
            self::DIMENSION_OUTBOUND_CONTACT_LIST_ID,
            self::DIMENSION_MONITORED_PARTICIPANT_ID,
            self::DIMENSION_SOURCE_SESSION_ID,
            self::DIMENSION_DESTINATION_SESSION_ID,
            self::DIMENSION_SOURCE_CONVERSATION_ID,
            self::DIMENSION_DESTINATION_CONVERSATION_ID,
            self::DIMENSION_REMOTE_NAME_DISPLAYABLE,
            self::DIMENSION_SIP_RESPONSE_CODE,
            self::DIMENSION_Q850_RESPONSE_CODE,
            self::DIMENSION_CONFERENCE,
            self::DIMENSION_GROUP_ID,
            self::DIMENSION_PROTOCOL_CALL_ID,
            self::DIMENSION_ROOM_ID,
            self::DIMENSION_ADDRESS_FROM,
            self::DIMENSION_ADDRESS_TO,
            self::DIMENSION_ADDRESS_SELF,
            self::DIMENSION_ADDRESS_OTHER,
            self::DIMENSION_SUBJECT,
            self::DIMENSION_MESSAGE_TYPE,
            self::DIMENSION_PEER_ID,
            self::DIMENSION_SCRIPT_ID,
            self::DIMENSION_EVALUATION_ID,
            self::DIMENSION_EVALUATOR_ID,
            self::DIMENSION_CONTEXT_ID,
            self::DIMENSION_FORM_ID,
            self::DIMENSION_FORM_NAME,
            self::DIMENSION_EVENT_TIME,
            self::DIMENSION_CALIBRATION_ID,
            self::DIMENSION_SURVEY_ID,
            self::DIMENSION_SURVEY_FORM_CONTEXT_ID,
            self::DIMENSION_SURVEY_FORM_ID,
            self::DIMENSION_SURVEY_FORM_NAME,
            self::DIMENSION_SURVEY_ANSWER_ID,
            self::DIMENSION_SURVEY_QUESTION_ID,
            self::DIMENSION_SURVEY_QUESTION_GROUP_ID,
            self::DIMENSION_SURVEY_PROMOTER_SCORE,
            self::DIMENSION_SURVEY_COMPLETED_DATE,
            self::DIMENSION_SURVEY_ERROR_REASON,
            self::DIMENSION_SURVEY_PREVIOUS_STATUS,
            self::DIMENSION_SURVEY_STATUS,
            self::DIMENSION_SYSTEM_PRESENCE,
            self::DIMENSION_ORGANIZATION_PRESENCE_ID,
            self::DIMENSION_ROUTING_STATUS,
            self::DIMENSION_FLOW_ID,
            self::DIMENSION_FLOW_NAME,
            self::DIMENSION_FLOW_VERSION,
            self::DIMENSION_FLOW_TYPE,
            self::DIMENSION_EXIT_REASON,
            self::DIMENSION_ENTRY_REASON,
            self::DIMENSION_ENTRY_TYPE,
            self::DIMENSION_TRANSFER_TYPE,
            self::DIMENSION_TRANSFER_TARGET_NAME,
            self::DIMENSION_TRANSFER_TARGET_ADDRESS,
            self::DIMENSION_ISSUED_CALLBACK,
            self::DIMENSION_STARTING_LANGUAGE,
            self::DIMENSION_ENDING_LANGUAGE,
            self::DIMENSION_FLOW_OUTCOME_ID,
            self::DIMENSION_FLOW_OUTCOME_VALUE,
            self::DIMENSION_FLOW_OUTCOME,
            self::DIMENSION_JOURNEY_CUSTOMER_ID,
            self::DIMENSION_JOURNEY_CUSTOMER_ID_TYPE,
            self::DIMENSION_JOURNEY_CUSTOMER_SESSION_ID,
            self::DIMENSION_JOURNEY_CUSTOMER_SESSION_ID_TYPE,
            self::DIMENSION_JOURNEY_ACTION_ID,
            self::DIMENSION_JOURNEY_ACTION_MAP_ID,
            self::DIMENSION_JOURNEY_ACTION_MAP_VERSION,
            self::DIMENSION_MIN_MOS,
            self::DIMENSION_MEDIA_STATS_MIN_CONVERSATION_MOS,
            self::DIMENSION_MIN_R_FACTOR,
            self::DIMENSION_MEDIA_STATS_MIN_CONVERSATION_R_FACTOR,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getPropertyTypeAllowableValues()
    {
        return [
            self::PROPERTY_TYPE_BOOL,
            self::PROPERTY_TYPE_INTEGER,
            self::PROPERTY_TYPE_REAL,
            self::PROPERTY_TYPE_DATE,
            self::PROPERTY_TYPE_STRING,
            self::PROPERTY_TYPE_UUID,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMetricAllowableValues()
    {
        return [
            self::METRIC_T_SEGMENT_DURATION,
            self::METRIC_T_CONVERSATION_DURATION,
            self::METRIC_O_TOTAL_CRITICAL_SCORE,
            self::METRIC_O_TOTAL_SCORE,
            self::METRIC_N_EVALUATIONS,
            self::METRIC_T_ABANDON,
            self::METRIC_T_IVR,
            self::METRIC_T_ANSWERED,
            self::METRIC_T_FLOW_OUT,
            self::METRIC_T_ACD,
            self::METRIC_T_TALK,
            self::METRIC_T_HELD,
            self::METRIC_T_TALK_COMPLETE,
            self::METRIC_T_HELD_COMPLETE,
            self::METRIC_T_ACW,
            self::METRIC_T_HANDLE,
            self::METRIC_T_CONTACTING,
            self::METRIC_T_DIALING,
            self::METRIC_T_WAIT,
            self::METRIC_T_AGENT_ROUTING_STATUS,
            self::METRIC_T_ORGANIZATION_PRESENCE,
            self::METRIC_T_SYSTEM_PRESENCE,
            self::METRIC_T_USER_RESPONSE_TIME,
            self::METRIC_T_AGENT_RESPONSE_TIME,
            self::METRIC_T_VOICEMAIL,
            self::METRIC_N_STATE_TRANSITION_ERROR,
            self::METRIC_N_OFFERED,
            self::METRIC_N_OVER_SLA,
            self::METRIC_N_TRANSFERRED,
            self::METRIC_N_BLIND_TRANSFERRED,
            self::METRIC_N_CONSULT_TRANSFERRED,
            self::METRIC_N_CONSULT,
            self::METRIC_N_CONNECTED,
            self::METRIC_T_ALERT,
            self::METRIC_T_NOT_RESPONDING,
            self::METRIC_N_OUTBOUND,
            self::METRIC_N_OUTBOUND_ATTEMPTED,
            self::METRIC_N_OUTBOUND_CONNECTED,
            self::METRIC_N_OUTBOUND_ABANDONED,
            self::METRIC_N_ERROR,
            self::METRIC_O_SERVICE_TARGET,
            self::METRIC_O_SERVICE_LEVEL,
            self::METRIC_T_ACTIVE,
            self::METRIC_T_INACTIVE,
            self::METRIC_O_ACTIVE_USERS,
            self::METRIC_O_MEMBER_USERS,
            self::METRIC_O_ACTIVE_QUEUES,
            self::METRIC_O_MEMBER_QUEUES,
            self::METRIC_O_INTERACTING,
            self::METRIC_O_WAITING,
            self::METRIC_O_ON_QUEUE_USERS,
            self::METRIC_O_OFF_QUEUE_USERS,
            self::METRIC_O_USER_PRESENCES,
            self::METRIC_O_USER_ROUTING_STATUSES,
            self::METRIC_N_SURVEYS_SENT,
            self::METRIC_N_SURVEYS_STARTED,
            self::METRIC_N_SURVEYS_ABANDONED,
            self::METRIC_N_SURVEYS_EXPIRED,
            self::METRIC_N_SURVEY_ERRORS,
            self::METRIC_N_SURVEY_RESPONSES,
            self::METRIC_N_SURVEY_ANSWER_RESPONSES,
            self::METRIC_O_SURVEY_TOTAL_SCORE,
            self::METRIC_O_SURVEY_QUESTION_GROUP_SCORE,
            self::METRIC_N_SURVEY_QUESTION_GROUP_RESPONSES,
            self::METRIC_O_SURVEY_QUESTION_SCORE,
            self::METRIC_N_SURVEY_QUESTION_RESPONSES,
            self::METRIC_N_SURVEY_NPS_RESPONSES,
            self::METRIC_N_SURVEY_NPS_PROMOTERS,
            self::METRIC_N_SURVEY_NPS_DETRACTORS,
            self::METRIC_N_FLOW,
            self::METRIC_T_FLOW_DISCONNECT,
            self::METRIC_T_FLOW_EXIT,
            self::METRIC_T_FLOW,
            self::METRIC_O_FLOW,
            self::METRIC_T_FLOW_OUTCOME,
            self::METRIC_N_FLOW_OUTCOME,
            self::METRIC_N_FLOW_OUTCOME_FAILED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getOperatorAllowableValues()
    {
        return [
            self::OPERATOR_MATCHES,
            self::OPERATOR_EXISTS,
            self::OPERATOR_NOT_EXISTS,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['dimension'] = isset($data['dimension']) ? $data['dimension'] : null;
        $this->container['propertyType'] = isset($data['propertyType']) ? $data['propertyType'] : null;
        $this->container['property'] = isset($data['property']) ? $data['property'] : null;
        $this->container['metric'] = isset($data['metric']) ? $data['metric'] : null;
        $this->container['operator'] = isset($data['operator']) ? $data['operator'] : null;
        $this->container['value'] = isset($data['value']) ? $data['value'] : null;
        $this->container['range'] = isset($data['range']) ? $data['range'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("dimension", "property", "metric");
        if (!in_array($this->container['type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'type', must be one of #{allowed_values}.";
        }

        $allowed_values = array("conversationId", "sessionId", "mediaType", "queueId", "userId", "participantId", "participantName", "direction", "originatingDirection", "wrapUpCode", "wrapUpNote", "interactionType", "requestedRoutingSkillId", "requestedLanguageId", "requestedRoutingUserIds", "routingPriority", "purpose", "participantType", "segmentType", "disconnectType", "errorCode", "conversationEnd", "segmentEnd", "externalContactId", "externalOrganizationId", "convertedFrom", "convertedTo", "divisionId", "flaggedReason", "stationId", "edgeId", "dnis", "ani", "sessionDnis", "outboundCampaignId", "outboundContactId", "outboundContactListId", "monitoredParticipantId", "sourceSessionId", "destinationSessionId", "sourceConversationId", "destinationConversationId", "remoteNameDisplayable", "sipResponseCode", "q850ResponseCode", "conference", "groupId", "protocolCallId", "roomId", "addressFrom", "addressTo", "addressSelf", "addressOther", "subject", "messageType", "peerId", "scriptId", "evaluationId", "evaluatorId", "contextId", "formId", "formName", "eventTime", "calibrationId", "surveyId", "surveyFormContextId", "surveyFormId", "surveyFormName", "surveyAnswerId", "surveyQuestionId", "surveyQuestionGroupId", "surveyPromoterScore", "surveyCompletedDate", "surveyErrorReason", "surveyPreviousStatus", "surveyStatus", "systemPresence", "organizationPresenceId", "routingStatus", "flowId", "flowName", "flowVersion", "flowType", "exitReason", "entryReason", "entryType", "transferType", "transferTargetName", "transferTargetAddress", "issuedCallback", "startingLanguage", "endingLanguage", "flowOutcomeId", "flowOutcomeValue", "flowOutcome", "journeyCustomerId", "journeyCustomerIdType", "journeyCustomerSessionId", "journeyCustomerSessionIdType", "journeyActionId", "journeyActionMapId", "journeyActionMapVersion", "minMos", "mediaStatsMinConversationMos", "minRFactor", "mediaStatsMinConversationRFactor");
        if (!in_array($this->container['dimension'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'dimension', must be one of #{allowed_values}.";
        }

        $allowed_values = array("bool", "integer", "real", "date", "string", "uuid");
        if (!in_array($this->container['propertyType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'propertyType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("tSegmentDuration", "tConversationDuration", "oTotalCriticalScore", "oTotalScore", "nEvaluations", "tAbandon", "tIvr", "tAnswered", "tFlowOut", "tAcd", "tTalk", "tHeld", "tTalkComplete", "tHeldComplete", "tAcw", "tHandle", "tContacting", "tDialing", "tWait", "tAgentRoutingStatus", "tOrganizationPresence", "tSystemPresence", "tUserResponseTime", "tAgentResponseTime", "tVoicemail", "nStateTransitionError", "nOffered", "nOverSla", "nTransferred", "nBlindTransferred", "nConsultTransferred", "nConsult", "nConnected", "tAlert", "tNotResponding", "nOutbound", "nOutboundAttempted", "nOutboundConnected", "nOutboundAbandoned", "nError", "oServiceTarget", "oServiceLevel", "tActive", "tInactive", "oActiveUsers", "oMemberUsers", "oActiveQueues", "oMemberQueues", "oInteracting", "oWaiting", "oOnQueueUsers", "oOffQueueUsers", "oUserPresences", "oUserRoutingStatuses", "nSurveysSent", "nSurveysStarted", "nSurveysAbandoned", "nSurveysExpired", "nSurveyErrors", "nSurveyResponses", "nSurveyAnswerResponses", "oSurveyTotalScore", "oSurveyQuestionGroupScore", "nSurveyQuestionGroupResponses", "oSurveyQuestionScore", "nSurveyQuestionResponses", "nSurveyNpsResponses", "nSurveyNpsPromoters", "nSurveyNpsDetractors", "nFlow", "tFlowDisconnect", "tFlowExit", "tFlow", "oFlow", "tFlowOutcome", "nFlowOutcome", "nFlowOutcomeFailed");
        if (!in_array($this->container['metric'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'metric', must be one of #{allowed_values}.";
        }

        $allowed_values = array("matches", "exists", "notExists");
        if (!in_array($this->container['operator'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'operator', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("dimension", "property", "metric");
        if (!in_array($this->container['type'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("conversationId", "sessionId", "mediaType", "queueId", "userId", "participantId", "participantName", "direction", "originatingDirection", "wrapUpCode", "wrapUpNote", "interactionType", "requestedRoutingSkillId", "requestedLanguageId", "requestedRoutingUserIds", "routingPriority", "purpose", "participantType", "segmentType", "disconnectType", "errorCode", "conversationEnd", "segmentEnd", "externalContactId", "externalOrganizationId", "convertedFrom", "convertedTo", "divisionId", "flaggedReason", "stationId", "edgeId", "dnis", "ani", "sessionDnis", "outboundCampaignId", "outboundContactId", "outboundContactListId", "monitoredParticipantId", "sourceSessionId", "destinationSessionId", "sourceConversationId", "destinationConversationId", "remoteNameDisplayable", "sipResponseCode", "q850ResponseCode", "conference", "groupId", "protocolCallId", "roomId", "addressFrom", "addressTo", "addressSelf", "addressOther", "subject", "messageType", "peerId", "scriptId", "evaluationId", "evaluatorId", "contextId", "formId", "formName", "eventTime", "calibrationId", "surveyId", "surveyFormContextId", "surveyFormId", "surveyFormName", "surveyAnswerId", "surveyQuestionId", "surveyQuestionGroupId", "surveyPromoterScore", "surveyCompletedDate", "surveyErrorReason", "surveyPreviousStatus", "surveyStatus", "systemPresence", "organizationPresenceId", "routingStatus", "flowId", "flowName", "flowVersion", "flowType", "exitReason", "entryReason", "entryType", "transferType", "transferTargetName", "transferTargetAddress", "issuedCallback", "startingLanguage", "endingLanguage", "flowOutcomeId", "flowOutcomeValue", "flowOutcome", "journeyCustomerId", "journeyCustomerIdType", "journeyCustomerSessionId", "journeyCustomerSessionIdType", "journeyActionId", "journeyActionMapId", "journeyActionMapVersion", "minMos", "mediaStatsMinConversationMos", "minRFactor", "mediaStatsMinConversationRFactor");
        if (!in_array($this->container['dimension'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("bool", "integer", "real", "date", "string", "uuid");
        if (!in_array($this->container['propertyType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("tSegmentDuration", "tConversationDuration", "oTotalCriticalScore", "oTotalScore", "nEvaluations", "tAbandon", "tIvr", "tAnswered", "tFlowOut", "tAcd", "tTalk", "tHeld", "tTalkComplete", "tHeldComplete", "tAcw", "tHandle", "tContacting", "tDialing", "tWait", "tAgentRoutingStatus", "tOrganizationPresence", "tSystemPresence", "tUserResponseTime", "tAgentResponseTime", "tVoicemail", "nStateTransitionError", "nOffered", "nOverSla", "nTransferred", "nBlindTransferred", "nConsultTransferred", "nConsult", "nConnected", "tAlert", "tNotResponding", "nOutbound", "nOutboundAttempted", "nOutboundConnected", "nOutboundAbandoned", "nError", "oServiceTarget", "oServiceLevel", "tActive", "tInactive", "oActiveUsers", "oMemberUsers", "oActiveQueues", "oMemberQueues", "oInteracting", "oWaiting", "oOnQueueUsers", "oOffQueueUsers", "oUserPresences", "oUserRoutingStatuses", "nSurveysSent", "nSurveysStarted", "nSurveysAbandoned", "nSurveysExpired", "nSurveyErrors", "nSurveyResponses", "nSurveyAnswerResponses", "oSurveyTotalScore", "oSurveyQuestionGroupScore", "nSurveyQuestionGroupResponses", "oSurveyQuestionScore", "nSurveyQuestionResponses", "nSurveyNpsResponses", "nSurveyNpsPromoters", "nSurveyNpsDetractors", "nFlow", "tFlowDisconnect", "tFlowExit", "tFlow", "oFlow", "tFlowOutcome", "nFlowOutcome", "nFlowOutcomeFailed");
        if (!in_array($this->container['metric'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("matches", "exists", "notExists");
        if (!in_array($this->container['operator'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type Optional type, can usually be inferred
     * @return $this
     */
    public function setType($type)
    {
        $allowed_values = array('dimension', 'property', 'metric');
        if (!in_array($type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'type', must be one of 'dimension', 'property', 'metric'");
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets dimension
     * @return string
     */
    public function getDimension()
    {
        return $this->container['dimension'];
    }

    /**
     * Sets dimension
     * @param string $dimension Left hand side for dimension predicates
     * @return $this
     */
    public function setDimension($dimension)
    {
        $allowed_values = array('conversationId', 'sessionId', 'mediaType', 'queueId', 'userId', 'participantId', 'participantName', 'direction', 'originatingDirection', 'wrapUpCode', 'wrapUpNote', 'interactionType', 'requestedRoutingSkillId', 'requestedLanguageId', 'requestedRoutingUserIds', 'routingPriority', 'purpose', 'participantType', 'segmentType', 'disconnectType', 'errorCode', 'conversationEnd', 'segmentEnd', 'externalContactId', 'externalOrganizationId', 'convertedFrom', 'convertedTo', 'divisionId', 'flaggedReason', 'stationId', 'edgeId', 'dnis', 'ani', 'sessionDnis', 'outboundCampaignId', 'outboundContactId', 'outboundContactListId', 'monitoredParticipantId', 'sourceSessionId', 'destinationSessionId', 'sourceConversationId', 'destinationConversationId', 'remoteNameDisplayable', 'sipResponseCode', 'q850ResponseCode', 'conference', 'groupId', 'protocolCallId', 'roomId', 'addressFrom', 'addressTo', 'addressSelf', 'addressOther', 'subject', 'messageType', 'peerId', 'scriptId', 'evaluationId', 'evaluatorId', 'contextId', 'formId', 'formName', 'eventTime', 'calibrationId', 'surveyId', 'surveyFormContextId', 'surveyFormId', 'surveyFormName', 'surveyAnswerId', 'surveyQuestionId', 'surveyQuestionGroupId', 'surveyPromoterScore', 'surveyCompletedDate', 'surveyErrorReason', 'surveyPreviousStatus', 'surveyStatus', 'systemPresence', 'organizationPresenceId', 'routingStatus', 'flowId', 'flowName', 'flowVersion', 'flowType', 'exitReason', 'entryReason', 'entryType', 'transferType', 'transferTargetName', 'transferTargetAddress', 'issuedCallback', 'startingLanguage', 'endingLanguage', 'flowOutcomeId', 'flowOutcomeValue', 'flowOutcome', 'journeyCustomerId', 'journeyCustomerIdType', 'journeyCustomerSessionId', 'journeyCustomerSessionIdType', 'journeyActionId', 'journeyActionMapId', 'journeyActionMapVersion', 'minMos', 'mediaStatsMinConversationMos', 'minRFactor', 'mediaStatsMinConversationRFactor');
        if (!in_array($dimension, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'dimension', must be one of 'conversationId', 'sessionId', 'mediaType', 'queueId', 'userId', 'participantId', 'participantName', 'direction', 'originatingDirection', 'wrapUpCode', 'wrapUpNote', 'interactionType', 'requestedRoutingSkillId', 'requestedLanguageId', 'requestedRoutingUserIds', 'routingPriority', 'purpose', 'participantType', 'segmentType', 'disconnectType', 'errorCode', 'conversationEnd', 'segmentEnd', 'externalContactId', 'externalOrganizationId', 'convertedFrom', 'convertedTo', 'divisionId', 'flaggedReason', 'stationId', 'edgeId', 'dnis', 'ani', 'sessionDnis', 'outboundCampaignId', 'outboundContactId', 'outboundContactListId', 'monitoredParticipantId', 'sourceSessionId', 'destinationSessionId', 'sourceConversationId', 'destinationConversationId', 'remoteNameDisplayable', 'sipResponseCode', 'q850ResponseCode', 'conference', 'groupId', 'protocolCallId', 'roomId', 'addressFrom', 'addressTo', 'addressSelf', 'addressOther', 'subject', 'messageType', 'peerId', 'scriptId', 'evaluationId', 'evaluatorId', 'contextId', 'formId', 'formName', 'eventTime', 'calibrationId', 'surveyId', 'surveyFormContextId', 'surveyFormId', 'surveyFormName', 'surveyAnswerId', 'surveyQuestionId', 'surveyQuestionGroupId', 'surveyPromoterScore', 'surveyCompletedDate', 'surveyErrorReason', 'surveyPreviousStatus', 'surveyStatus', 'systemPresence', 'organizationPresenceId', 'routingStatus', 'flowId', 'flowName', 'flowVersion', 'flowType', 'exitReason', 'entryReason', 'entryType', 'transferType', 'transferTargetName', 'transferTargetAddress', 'issuedCallback', 'startingLanguage', 'endingLanguage', 'flowOutcomeId', 'flowOutcomeValue', 'flowOutcome', 'journeyCustomerId', 'journeyCustomerIdType', 'journeyCustomerSessionId', 'journeyCustomerSessionIdType', 'journeyActionId', 'journeyActionMapId', 'journeyActionMapVersion', 'minMos', 'mediaStatsMinConversationMos', 'minRFactor', 'mediaStatsMinConversationRFactor'");
        }
        $this->container['dimension'] = $dimension;

        return $this;
    }

    /**
     * Gets propertyType
     * @return string
     */
    public function getPropertyType()
    {
        return $this->container['propertyType'];
    }

    /**
     * Sets propertyType
     * @param string $propertyType Left hand side for property predicates
     * @return $this
     */
    public function setPropertyType($propertyType)
    {
        $allowed_values = array('bool', 'integer', 'real', 'date', 'string', 'uuid');
        if (!in_array($propertyType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'propertyType', must be one of 'bool', 'integer', 'real', 'date', 'string', 'uuid'");
        }
        $this->container['propertyType'] = $propertyType;

        return $this;
    }

    /**
     * Gets property
     * @return string
     */
    public function getProperty()
    {
        return $this->container['property'];
    }

    /**
     * Sets property
     * @param string $property Left hand side for property predicates
     * @return $this
     */
    public function setProperty($property)
    {
        $this->container['property'] = $property;

        return $this;
    }

    /**
     * Gets metric
     * @return string
     */
    public function getMetric()
    {
        return $this->container['metric'];
    }

    /**
     * Sets metric
     * @param string $metric Left hand side for metric predicates
     * @return $this
     */
    public function setMetric($metric)
    {
        $allowed_values = array('tSegmentDuration', 'tConversationDuration', 'oTotalCriticalScore', 'oTotalScore', 'nEvaluations', 'tAbandon', 'tIvr', 'tAnswered', 'tFlowOut', 'tAcd', 'tTalk', 'tHeld', 'tTalkComplete', 'tHeldComplete', 'tAcw', 'tHandle', 'tContacting', 'tDialing', 'tWait', 'tAgentRoutingStatus', 'tOrganizationPresence', 'tSystemPresence', 'tUserResponseTime', 'tAgentResponseTime', 'tVoicemail', 'nStateTransitionError', 'nOffered', 'nOverSla', 'nTransferred', 'nBlindTransferred', 'nConsultTransferred', 'nConsult', 'nConnected', 'tAlert', 'tNotResponding', 'nOutbound', 'nOutboundAttempted', 'nOutboundConnected', 'nOutboundAbandoned', 'nError', 'oServiceTarget', 'oServiceLevel', 'tActive', 'tInactive', 'oActiveUsers', 'oMemberUsers', 'oActiveQueues', 'oMemberQueues', 'oInteracting', 'oWaiting', 'oOnQueueUsers', 'oOffQueueUsers', 'oUserPresences', 'oUserRoutingStatuses', 'nSurveysSent', 'nSurveysStarted', 'nSurveysAbandoned', 'nSurveysExpired', 'nSurveyErrors', 'nSurveyResponses', 'nSurveyAnswerResponses', 'oSurveyTotalScore', 'oSurveyQuestionGroupScore', 'nSurveyQuestionGroupResponses', 'oSurveyQuestionScore', 'nSurveyQuestionResponses', 'nSurveyNpsResponses', 'nSurveyNpsPromoters', 'nSurveyNpsDetractors', 'nFlow', 'tFlowDisconnect', 'tFlowExit', 'tFlow', 'oFlow', 'tFlowOutcome', 'nFlowOutcome', 'nFlowOutcomeFailed');
        if (!in_array($metric, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'metric', must be one of 'tSegmentDuration', 'tConversationDuration', 'oTotalCriticalScore', 'oTotalScore', 'nEvaluations', 'tAbandon', 'tIvr', 'tAnswered', 'tFlowOut', 'tAcd', 'tTalk', 'tHeld', 'tTalkComplete', 'tHeldComplete', 'tAcw', 'tHandle', 'tContacting', 'tDialing', 'tWait', 'tAgentRoutingStatus', 'tOrganizationPresence', 'tSystemPresence', 'tUserResponseTime', 'tAgentResponseTime', 'tVoicemail', 'nStateTransitionError', 'nOffered', 'nOverSla', 'nTransferred', 'nBlindTransferred', 'nConsultTransferred', 'nConsult', 'nConnected', 'tAlert', 'tNotResponding', 'nOutbound', 'nOutboundAttempted', 'nOutboundConnected', 'nOutboundAbandoned', 'nError', 'oServiceTarget', 'oServiceLevel', 'tActive', 'tInactive', 'oActiveUsers', 'oMemberUsers', 'oActiveQueues', 'oMemberQueues', 'oInteracting', 'oWaiting', 'oOnQueueUsers', 'oOffQueueUsers', 'oUserPresences', 'oUserRoutingStatuses', 'nSurveysSent', 'nSurveysStarted', 'nSurveysAbandoned', 'nSurveysExpired', 'nSurveyErrors', 'nSurveyResponses', 'nSurveyAnswerResponses', 'oSurveyTotalScore', 'oSurveyQuestionGroupScore', 'nSurveyQuestionGroupResponses', 'oSurveyQuestionScore', 'nSurveyQuestionResponses', 'nSurveyNpsResponses', 'nSurveyNpsPromoters', 'nSurveyNpsDetractors', 'nFlow', 'tFlowDisconnect', 'tFlowExit', 'tFlow', 'oFlow', 'tFlowOutcome', 'nFlowOutcome', 'nFlowOutcomeFailed'");
        }
        $this->container['metric'] = $metric;

        return $this;
    }

    /**
     * Gets operator
     * @return string
     */
    public function getOperator()
    {
        return $this->container['operator'];
    }

    /**
     * Sets operator
     * @param string $operator Optional operator, default is matches
     * @return $this
     */
    public function setOperator($operator)
    {
        $allowed_values = array('matches', 'exists', 'notExists');
        if (!in_array($operator, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'operator', must be one of 'matches', 'exists', 'notExists'");
        }
        $this->container['operator'] = $operator;

        return $this;
    }

    /**
     * Gets value
     * @return string
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     * @param string $value Right hand side for dimension, property, or metric predicates
     * @return $this
     */
    public function setValue($value)
    {
        $this->container['value'] = $value;

        return $this;
    }

    /**
     * Gets range
     * @return \PureCloudSDK\NumericRange
     */
    public function getRange()
    {
        return $this->container['range'];
    }

    /**
     * Sets range
     * @param \PureCloudSDK\NumericRange $range Right hand side for property or metric predicates
     * @return $this
     */
    public function setRange($range)
    {
        $this->container['range'] = $range;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


