<?php

/**
 * ObservationValue
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ObservationValue Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ObservationValue implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ObservationValue';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'observationDate' => '\DateTime',
        'conversationId' => 'string',
        'sessionId' => 'string',
        'requestedRoutingSkillIds' => 'string[]',
        'requestedLanguageId' => 'string',
        'routingPriority' => 'int',
        'participantName' => 'string',
        'userId' => 'string',
        'direction' => 'string',
        'convertedFrom' => 'string',
        'convertedTo' => 'string',
        'addressFrom' => 'string',
        'addressTo' => 'string',
        'ani' => 'string',
        'dnis' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'observationDate' => 'observationDate',
        'conversationId' => 'conversationId',
        'sessionId' => 'sessionId',
        'requestedRoutingSkillIds' => 'requestedRoutingSkillIds',
        'requestedLanguageId' => 'requestedLanguageId',
        'routingPriority' => 'routingPriority',
        'participantName' => 'participantName',
        'userId' => 'userId',
        'direction' => 'direction',
        'convertedFrom' => 'convertedFrom',
        'convertedTo' => 'convertedTo',
        'addressFrom' => 'addressFrom',
        'addressTo' => 'addressTo',
        'ani' => 'ani',
        'dnis' => 'dnis'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'observationDate' => 'setObservationDate',
        'conversationId' => 'setConversationId',
        'sessionId' => 'setSessionId',
        'requestedRoutingSkillIds' => 'setRequestedRoutingSkillIds',
        'requestedLanguageId' => 'setRequestedLanguageId',
        'routingPriority' => 'setRoutingPriority',
        'participantName' => 'setParticipantName',
        'userId' => 'setUserId',
        'direction' => 'setDirection',
        'convertedFrom' => 'setConvertedFrom',
        'convertedTo' => 'setConvertedTo',
        'addressFrom' => 'setAddressFrom',
        'addressTo' => 'setAddressTo',
        'ani' => 'setAni',
        'dnis' => 'setDnis'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'observationDate' => 'getObservationDate',
        'conversationId' => 'getConversationId',
        'sessionId' => 'getSessionId',
        'requestedRoutingSkillIds' => 'getRequestedRoutingSkillIds',
        'requestedLanguageId' => 'getRequestedLanguageId',
        'routingPriority' => 'getRoutingPriority',
        'participantName' => 'getParticipantName',
        'userId' => 'getUserId',
        'direction' => 'getDirection',
        'convertedFrom' => 'getConvertedFrom',
        'convertedTo' => 'getConvertedTo',
        'addressFrom' => 'getAddressFrom',
        'addressTo' => 'getAddressTo',
        'ani' => 'getAni',
        'dnis' => 'getDnis'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const DIRECTION_INBOUND = 'inbound';
    public const DIRECTION_OUTBOUND = 'outbound';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDirectionAllowableValues()
    {
        return [
            self::DIRECTION_INBOUND,
            self::DIRECTION_OUTBOUND,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['observationDate'] = isset($data['observationDate']) ? $data['observationDate'] : null;
        $this->container['conversationId'] = isset($data['conversationId']) ? $data['conversationId'] : null;
        $this->container['sessionId'] = isset($data['sessionId']) ? $data['sessionId'] : null;
        $this->container['requestedRoutingSkillIds'] = isset($data['requestedRoutingSkillIds']) ? $data['requestedRoutingSkillIds'] : null;
        $this->container['requestedLanguageId'] = isset($data['requestedLanguageId']) ? $data['requestedLanguageId'] : null;
        $this->container['routingPriority'] = isset($data['routingPriority']) ? $data['routingPriority'] : null;
        $this->container['participantName'] = isset($data['participantName']) ? $data['participantName'] : null;
        $this->container['userId'] = isset($data['userId']) ? $data['userId'] : null;
        $this->container['direction'] = isset($data['direction']) ? $data['direction'] : null;
        $this->container['convertedFrom'] = isset($data['convertedFrom']) ? $data['convertedFrom'] : null;
        $this->container['convertedTo'] = isset($data['convertedTo']) ? $data['convertedTo'] : null;
        $this->container['addressFrom'] = isset($data['addressFrom']) ? $data['addressFrom'] : null;
        $this->container['addressTo'] = isset($data['addressTo']) ? $data['addressTo'] : null;
        $this->container['ani'] = isset($data['ani']) ? $data['ani'] : null;
        $this->container['dnis'] = isset($data['dnis']) ? $data['dnis'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['observationDate'] === null) {
            $invalid_properties[] = "'observationDate' can't be null";
        }
        $allowed_values = array("inbound", "outbound");
        if (!in_array($this->container['direction'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'direction', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['observationDate'] === null) {
            return false;
        }
        $allowed_values = array("inbound", "outbound");
        if (!in_array($this->container['direction'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets observationDate
     * @return \DateTime
     */
    public function getObservationDate()
    {
        return $this->container['observationDate'];
    }

    /**
     * Sets observationDate
     * @param \DateTime $observationDate The time at which the observation occurred. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setObservationDate($observationDate)
    {
        $this->container['observationDate'] = $observationDate;

        return $this;
    }

    /**
     * Gets conversationId
     * @return string
     */
    public function getConversationId()
    {
        return $this->container['conversationId'];
    }

    /**
     * Sets conversationId
     * @param string $conversationId Unique identifier for the conversation
     * @return $this
     */
    public function setConversationId($conversationId)
    {
        $this->container['conversationId'] = $conversationId;

        return $this;
    }

    /**
     * Gets sessionId
     * @return string
     */
    public function getSessionId()
    {
        return $this->container['sessionId'];
    }

    /**
     * Sets sessionId
     * @param string $sessionId The unique identifier of this session
     * @return $this
     */
    public function setSessionId($sessionId)
    {
        $this->container['sessionId'] = $sessionId;

        return $this;
    }

    /**
     * Gets requestedRoutingSkillIds
     * @return string[]
     */
    public function getRequestedRoutingSkillIds()
    {
        return $this->container['requestedRoutingSkillIds'];
    }

    /**
     * Sets requestedRoutingSkillIds
     * @param string[] $requestedRoutingSkillIds Unique identifier for a skill requested for an interaction
     * @return $this
     */
    public function setRequestedRoutingSkillIds($requestedRoutingSkillIds)
    {
        $this->container['requestedRoutingSkillIds'] = $requestedRoutingSkillIds;

        return $this;
    }

    /**
     * Gets requestedLanguageId
     * @return string
     */
    public function getRequestedLanguageId()
    {
        return $this->container['requestedLanguageId'];
    }

    /**
     * Sets requestedLanguageId
     * @param string $requestedLanguageId Unique identifier for the language requested for an interaction
     * @return $this
     */
    public function setRequestedLanguageId($requestedLanguageId)
    {
        $this->container['requestedLanguageId'] = $requestedLanguageId;

        return $this;
    }

    /**
     * Gets routingPriority
     * @return int
     */
    public function getRoutingPriority()
    {
        return $this->container['routingPriority'];
    }

    /**
     * Sets routingPriority
     * @param int $routingPriority Routing priority for the current interaction
     * @return $this
     */
    public function setRoutingPriority($routingPriority)
    {
        $this->container['routingPriority'] = $routingPriority;

        return $this;
    }

    /**
     * Gets participantName
     * @return string
     */
    public function getParticipantName()
    {
        return $this->container['participantName'];
    }

    /**
     * Sets participantName
     * @param string $participantName A human readable name identifying the participant
     * @return $this
     */
    public function setParticipantName($participantName)
    {
        $this->container['participantName'] = $participantName;

        return $this;
    }

    /**
     * Gets userId
     * @return string
     */
    public function getUserId()
    {
        return $this->container['userId'];
    }

    /**
     * Sets userId
     * @param string $userId Unique identifier for the user
     * @return $this
     */
    public function setUserId($userId)
    {
        $this->container['userId'] = $userId;

        return $this;
    }

    /**
     * Gets direction
     * @return string
     */
    public function getDirection()
    {
        return $this->container['direction'];
    }

    /**
     * Sets direction
     * @param string $direction The direction of the communication
     * @return $this
     */
    public function setDirection($direction)
    {
        $allowed_values = array('inbound', 'outbound');
        if (!in_array($direction, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'direction', must be one of 'inbound', 'outbound'");
        }
        $this->container['direction'] = $direction;

        return $this;
    }

    /**
     * Gets convertedFrom
     * @return string
     */
    public function getConvertedFrom()
    {
        return $this->container['convertedFrom'];
    }

    /**
     * Sets convertedFrom
     * @param string $convertedFrom Session media type that was converted from in case of a media type conversion
     * @return $this
     */
    public function setConvertedFrom($convertedFrom)
    {
        $this->container['convertedFrom'] = $convertedFrom;

        return $this;
    }

    /**
     * Gets convertedTo
     * @return string
     */
    public function getConvertedTo()
    {
        return $this->container['convertedTo'];
    }

    /**
     * Sets convertedTo
     * @param string $convertedTo Session media type that was converted to in case of a media type conversion
     * @return $this
     */
    public function setConvertedTo($convertedTo)
    {
        $this->container['convertedTo'] = $convertedTo;

        return $this;
    }

    /**
     * Gets addressFrom
     * @return string
     */
    public function getAddressFrom()
    {
        return $this->container['addressFrom'];
    }

    /**
     * Sets addressFrom
     * @param string $addressFrom The address that initiated an action
     * @return $this
     */
    public function setAddressFrom($addressFrom)
    {
        $this->container['addressFrom'] = $addressFrom;

        return $this;
    }

    /**
     * Gets addressTo
     * @return string
     */
    public function getAddressTo()
    {
        return $this->container['addressTo'];
    }

    /**
     * Sets addressTo
     * @param string $addressTo The address receiving an action
     * @return $this
     */
    public function setAddressTo($addressTo)
    {
        $this->container['addressTo'] = $addressTo;

        return $this;
    }

    /**
     * Gets ani
     * @return string
     */
    public function getAni()
    {
        return $this->container['ani'];
    }

    /**
     * Sets ani
     * @param string $ani Automatic Number Identification (caller's number)
     * @return $this
     */
    public function setAni($ani)
    {
        $this->container['ani'] = $ani;

        return $this;
    }

    /**
     * Gets dnis
     * @return string
     */
    public function getDnis()
    {
        return $this->container['dnis'];
    }

    /**
     * Sets dnis
     * @param string $dnis Dialed number identification service (number dialed by the calling party)
     * @return $this
     */
    public function setDnis($dnis)
    {
        $this->container['dnis'] = $dnis;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


