<?php

/**
 * RouteGroup
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * RouteGroup Class Doc Comment
 *
 * @category    Class */
 // @description Route group for calculated forecasts
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class RouteGroup implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'RouteGroup';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'attributes' => '\PureCloudSDK\RouteGroupAttributes',
        'offeredPerInterval' => 'double[]',
        'averageTalkTimeSecondsPerInterval' => 'double[]',
        'averageAfterCallWorkSecondsPerInterval' => 'double[]',
        'completedPerInterval' => 'double[]',
        'abandonedPerInterval' => 'double[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'attributes' => 'attributes',
        'offeredPerInterval' => 'offeredPerInterval',
        'averageTalkTimeSecondsPerInterval' => 'averageTalkTimeSecondsPerInterval',
        'averageAfterCallWorkSecondsPerInterval' => 'averageAfterCallWorkSecondsPerInterval',
        'completedPerInterval' => 'completedPerInterval',
        'abandonedPerInterval' => 'abandonedPerInterval'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'attributes' => 'setAttributes',
        'offeredPerInterval' => 'setOfferedPerInterval',
        'averageTalkTimeSecondsPerInterval' => 'setAverageTalkTimeSecondsPerInterval',
        'averageAfterCallWorkSecondsPerInterval' => 'setAverageAfterCallWorkSecondsPerInterval',
        'completedPerInterval' => 'setCompletedPerInterval',
        'abandonedPerInterval' => 'setAbandonedPerInterval'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'attributes' => 'getAttributes',
        'offeredPerInterval' => 'getOfferedPerInterval',
        'averageTalkTimeSecondsPerInterval' => 'getAverageTalkTimeSecondsPerInterval',
        'averageAfterCallWorkSecondsPerInterval' => 'getAverageAfterCallWorkSecondsPerInterval',
        'completedPerInterval' => 'getCompletedPerInterval',
        'abandonedPerInterval' => 'getAbandonedPerInterval'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['attributes'] = isset($data['attributes']) ? $data['attributes'] : null;
        $this->container['offeredPerInterval'] = isset($data['offeredPerInterval']) ? $data['offeredPerInterval'] : null;
        $this->container['averageTalkTimeSecondsPerInterval'] = isset($data['averageTalkTimeSecondsPerInterval']) ? $data['averageTalkTimeSecondsPerInterval'] : null;
        $this->container['averageAfterCallWorkSecondsPerInterval'] = isset($data['averageAfterCallWorkSecondsPerInterval']) ? $data['averageAfterCallWorkSecondsPerInterval'] : null;
        $this->container['completedPerInterval'] = isset($data['completedPerInterval']) ? $data['completedPerInterval'] : null;
        $this->container['abandonedPerInterval'] = isset($data['abandonedPerInterval']) ? $data['abandonedPerInterval'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['attributes'] === null) {
            $invalid_properties[] = "'attributes' can't be null";
        }
        if ($this->container['offeredPerInterval'] === null) {
            $invalid_properties[] = "'offeredPerInterval' can't be null";
        }
        if ($this->container['averageTalkTimeSecondsPerInterval'] === null) {
            $invalid_properties[] = "'averageTalkTimeSecondsPerInterval' can't be null";
        }
        if ($this->container['averageAfterCallWorkSecondsPerInterval'] === null) {
            $invalid_properties[] = "'averageAfterCallWorkSecondsPerInterval' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['attributes'] === null) {
            return false;
        }
        if ($this->container['offeredPerInterval'] === null) {
            return false;
        }
        if ($this->container['averageTalkTimeSecondsPerInterval'] === null) {
            return false;
        }
        if ($this->container['averageAfterCallWorkSecondsPerInterval'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets attributes
     * @return \PureCloudSDK\RouteGroupAttributes
     */
    public function getAttributes()
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes
     * @param \PureCloudSDK\RouteGroupAttributes $attributes The attributes that describe this route group
     * @return $this
     */
    public function setAttributes($attributes)
    {
        $this->container['attributes'] = $attributes;

        return $this;
    }

    /**
     * Gets offeredPerInterval
     * @return double[]
     */
    public function getOfferedPerInterval()
    {
        return $this->container['offeredPerInterval'];
    }

    /**
     * Sets offeredPerInterval
     * @param double[] $offeredPerInterval Interactions offered per 15 minute interval
     * @return $this
     */
    public function setOfferedPerInterval($offeredPerInterval)
    {
        $this->container['offeredPerInterval'] = $offeredPerInterval;

        return $this;
    }

    /**
     * Gets averageTalkTimeSecondsPerInterval
     * @return double[]
     */
    public function getAverageTalkTimeSecondsPerInterval()
    {
        return $this->container['averageTalkTimeSecondsPerInterval'];
    }

    /**
     * Sets averageTalkTimeSecondsPerInterval
     * @param double[] $averageTalkTimeSecondsPerInterval Average talk time in seconds per 15 minute interval
     * @return $this
     */
    public function setAverageTalkTimeSecondsPerInterval($averageTalkTimeSecondsPerInterval)
    {
        $this->container['averageTalkTimeSecondsPerInterval'] = $averageTalkTimeSecondsPerInterval;

        return $this;
    }

    /**
     * Gets averageAfterCallWorkSecondsPerInterval
     * @return double[]
     */
    public function getAverageAfterCallWorkSecondsPerInterval()
    {
        return $this->container['averageAfterCallWorkSecondsPerInterval'];
    }

    /**
     * Sets averageAfterCallWorkSecondsPerInterval
     * @param double[] $averageAfterCallWorkSecondsPerInterval Average after call work in seconds per 15 minute interval
     * @return $this
     */
    public function setAverageAfterCallWorkSecondsPerInterval($averageAfterCallWorkSecondsPerInterval)
    {
        $this->container['averageAfterCallWorkSecondsPerInterval'] = $averageAfterCallWorkSecondsPerInterval;

        return $this;
    }

    /**
     * Gets completedPerInterval
     * @return double[]
     */
    public function getCompletedPerInterval()
    {
        return $this->container['completedPerInterval'];
    }

    /**
     * Sets completedPerInterval
     * @param double[] $completedPerInterval Interactions completed per 15 minute interval
     * @return $this
     */
    public function setCompletedPerInterval($completedPerInterval)
    {
        $this->container['completedPerInterval'] = $completedPerInterval;

        return $this;
    }

    /**
     * Gets abandonedPerInterval
     * @return double[]
     */
    public function getAbandonedPerInterval()
    {
        return $this->container['abandonedPerInterval'];
    }

    /**
     * Sets abandonedPerInterval
     * @param double[] $abandonedPerInterval Interactions abandoned per 15 minute interval
     * @return $this
     */
    public function setAbandonedPerInterval($abandonedPerInterval)
    {
        $this->container['abandonedPerInterval'] = $abandonedPerInterval;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


