<?php

/**
 * WebChatGuestMediaRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * WebChatGuestMediaRequest Class Doc Comment
 *
 * @category    Class */
 // @description Object representing the guest model of a media request of a chat conversation.
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class WebChatGuestMediaRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'WebChatGuestMediaRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'types' => 'string[]',
        'state' => 'string',
        'communicationId' => 'string',
        'securityKey' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'types' => 'types',
        'state' => 'state',
        'communicationId' => 'communicationId',
        'securityKey' => 'securityKey',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'types' => 'setTypes',
        'state' => 'setState',
        'communicationId' => 'setCommunicationId',
        'securityKey' => 'setSecurityKey',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'types' => 'getTypes',
        'state' => 'getState',
        'communicationId' => 'getCommunicationId',
        'securityKey' => 'getSecurityKey',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const TYPES_COBROWSE = 'COBROWSE';
    public const TYPES_SCREENSHARE = 'SCREENSHARE';
    public const STATE_PENDING = 'PENDING';
    public const STATE_ACCEPTED = 'ACCEPTED';
    public const STATE_DECLINED = 'DECLINED';
    public const STATE_TIMEDOUT = 'TIMEDOUT';
    public const STATE_CANCELLED = 'CANCELLED';
    public const STATE_ERRORED = 'ERRORED';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTypesAllowableValues()
    {
        return [
            self::TYPES_COBROWSE,
            self::TYPES_SCREENSHARE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_PENDING,
            self::STATE_ACCEPTED,
            self::STATE_DECLINED,
            self::STATE_TIMEDOUT,
            self::STATE_CANCELLED,
            self::STATE_ERRORED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['types'] = isset($data['types']) ? $data['types'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['communicationId'] = isset($data['communicationId']) ? $data['communicationId'] : null;
        $this->container['securityKey'] = isset($data['securityKey']) ? $data['securityKey'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['types'] === null) {
            $invalid_properties[] = "'types' can't be null";
        }
        if ($this->container['state'] === null) {
            $invalid_properties[] = "'state' can't be null";
        }
        $allowed_values = array("PENDING", "ACCEPTED", "DECLINED", "TIMEDOUT", "CANCELLED", "ERRORED");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['types'] === null) {
            return false;
        }
        if ($this->container['state'] === null) {
            return false;
        }
        $allowed_values = array("PENDING", "ACCEPTED", "DECLINED", "TIMEDOUT", "CANCELLED", "ERRORED");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets types
     * @return string[]
     */
    public function getTypes()
    {
        return $this->container['types'];
    }

    /**
     * Sets types
     * @param string[] $types The types of media being requested.
     * @return $this
     */
    public function setTypes($types)
    {
        $allowed_values = array('COBROWSE', 'SCREENSHARE');
        if (!in_array($types, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'types', must be one of 'COBROWSE', 'SCREENSHARE'");
        }
        $this->container['types'] = $types;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state The state of the media request, one of PENDING|ACCEPTED|DECLINED|TIMEDOUT|CANCELLED|ERRORED.
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('PENDING', 'ACCEPTED', 'DECLINED', 'TIMEDOUT', 'CANCELLED', 'ERRORED');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'PENDING', 'ACCEPTED', 'DECLINED', 'TIMEDOUT', 'CANCELLED', 'ERRORED'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets communicationId
     * @return string
     */
    public function getCommunicationId()
    {
        return $this->container['communicationId'];
    }

    /**
     * Sets communicationId
     * @param string $communicationId The ID of the new media communication, if applicable.
     * @return $this
     */
    public function setCommunicationId($communicationId)
    {
        $this->container['communicationId'] = $communicationId;

        return $this;
    }

    /**
     * Gets securityKey
     * @return string
     */
    public function getSecurityKey()
    {
        return $this->container['securityKey'];
    }

    /**
     * Sets securityKey
     * @param string $securityKey The security information related to a media request.
     * @return $this
     */
    public function setSecurityKey($securityKey)
    {
        $this->container['securityKey'] = $securityKey;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


