<?php
/**
 * DncList
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * DncList Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class DncList implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'DncList';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'dateCreated' => '\DateTime',
        'dateModified' => '\DateTime',
        'version' => 'int',
        'importStatus' => '\PureCloudSDK\ImportStatus',
        'size' => 'int',
        'dncSourceType' => 'string',
        'loginId' => 'string',
        'dncCodes' => 'string[]',
        'licenseId' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'dateCreated' => 'dateCreated',
        'dateModified' => 'dateModified',
        'version' => 'version',
        'importStatus' => 'importStatus',
        'size' => 'size',
        'dncSourceType' => 'dncSourceType',
        'loginId' => 'loginId',
        'dncCodes' => 'dncCodes',
        'licenseId' => 'licenseId',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'dateCreated' => 'setDateCreated',
        'dateModified' => 'setDateModified',
        'version' => 'setVersion',
        'importStatus' => 'setImportStatus',
        'size' => 'setSize',
        'dncSourceType' => 'setDncSourceType',
        'loginId' => 'setLoginId',
        'dncCodes' => 'setDncCodes',
        'licenseId' => 'setLicenseId',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'dateCreated' => 'getDateCreated',
        'dateModified' => 'getDateModified',
        'version' => 'getVersion',
        'importStatus' => 'getImportStatus',
        'size' => 'getSize',
        'dncSourceType' => 'getDncSourceType',
        'loginId' => 'getLoginId',
        'dncCodes' => 'getDncCodes',
        'licenseId' => 'getLicenseId',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const DNC_SOURCE_TYPE_RDS = 'rds';
    const DNC_SOURCE_TYPE_DNC_DOT_COM = 'dnc_dot_com';
    const DNC_SOURCE_TYPE_GRYPHON = 'gryphon';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDncSourceTypeAllowableValues()
    {
        return [
            self::DNC_SOURCE_TYPE_RDS,
            self::DNC_SOURCE_TYPE_DNC_DOT_COM,
            self::DNC_SOURCE_TYPE_GRYPHON,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['dateModified'] = isset($data['dateModified']) ? $data['dateModified'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['importStatus'] = isset($data['importStatus']) ? $data['importStatus'] : null;
        $this->container['size'] = isset($data['size']) ? $data['size'] : null;
        $this->container['dncSourceType'] = isset($data['dncSourceType']) ? $data['dncSourceType'] : null;
        $this->container['loginId'] = isset($data['loginId']) ? $data['loginId'] : null;
        $this->container['dncCodes'] = isset($data['dncCodes']) ? $data['dncCodes'] : null;
        $this->container['licenseId'] = isset($data['licenseId']) ? $data['licenseId'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        $allowed_values = array("rds", "dnc_dot_com", "gryphon");
        if (!in_array($this->container['dncSourceType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'dncSourceType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        $allowed_values = array("rds", "dnc_dot_com", "gryphon");
        if (!in_array($this->container['dncSourceType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The name of the list.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param \DateTime $dateCreated Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets dateModified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['dateModified'];
    }

    /**
     * Sets dateModified
     * @param \DateTime $dateModified Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($dateModified)
    {
        $this->container['dateModified'] = $dateModified;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version Required for updates, must match the version number of the most recent update
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets importStatus
     * @return \PureCloudSDK\ImportStatus
     */
    public function getImportStatus()
    {
        return $this->container['importStatus'];
    }

    /**
     * Sets importStatus
     * @param \PureCloudSDK\ImportStatus $importStatus the status of the import process
     * @return $this
     */
    public function setImportStatus($importStatus)
    {
        $this->container['importStatus'] = $importStatus;

        return $this;
    }

    /**
     * Gets size
     * @return int
     */
    public function getSize()
    {
        return $this->container['size'];
    }

    /**
     * Sets size
     * @param int $size the number of phone numbers in the do not call list
     * @return $this
     */
    public function setSize($size)
    {
        $this->container['size'] = $size;

        return $this;
    }

    /**
     * Gets dncSourceType
     * @return string
     */
    public function getDncSourceType()
    {
        return $this->container['dncSourceType'];
    }

    /**
     * Sets dncSourceType
     * @param string $dncSourceType the type of dnc list being created, rds (csv file), gryphon, or dnc.com
     * @return $this
     */
    public function setDncSourceType($dncSourceType)
    {
        $allowed_values = array('rds', 'dnc_dot_com', 'gryphon');
        if (!in_array($dncSourceType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'dncSourceType', must be one of 'rds', 'dnc_dot_com', 'gryphon'");
        }
        $this->container['dncSourceType'] = $dncSourceType;

        return $this;
    }

    /**
     * Gets loginId
     * @return string
     */
    public function getLoginId()
    {
        return $this->container['loginId'];
    }

    /**
     * Sets loginId
     * @param string $loginId the loginId if the dncSourceType is dnc.com
     * @return $this
     */
    public function setLoginId($loginId)
    {
        $this->container['loginId'] = $loginId;

        return $this;
    }

    /**
     * Gets dncCodes
     * @return string[]
     */
    public function getDncCodes()
    {
        return $this->container['dncCodes'];
    }

    /**
     * Sets dncCodes
     * @param string[] $dncCodes the list of dnc.com codes to be treated as DNC
     * @return $this
     */
    public function setDncCodes($dncCodes)
    {
        $this->container['dncCodes'] = $dncCodes;

        return $this;
    }

    /**
     * Gets licenseId
     * @return string
     */
    public function getLicenseId()
    {
        return $this->container['licenseId'];
    }

    /**
     * Sets licenseId
     * @param string $licenseId the license number if the dncSourceType is gryphon
     * @return $this
     */
    public function setLicenseId($licenseId)
    {
        $this->container['licenseId'] = $licenseId;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


