<?php
/**
 * ImportStatus
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ImportStatus Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ImportStatus implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ImportStatus';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'state' => 'string',
        'totalRecords' => 'int',
        'completedRecords' => 'int',
        'percentComplete' => 'int',
        'failureReason' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'state' => 'state',
        'totalRecords' => 'totalRecords',
        'completedRecords' => 'completedRecords',
        'percentComplete' => 'percentComplete',
        'failureReason' => 'failureReason'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'state' => 'setState',
        'totalRecords' => 'setTotalRecords',
        'completedRecords' => 'setCompletedRecords',
        'percentComplete' => 'setPercentComplete',
        'failureReason' => 'setFailureReason'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'state' => 'getState',
        'totalRecords' => 'getTotalRecords',
        'completedRecords' => 'getCompletedRecords',
        'percentComplete' => 'getPercentComplete',
        'failureReason' => 'getFailureReason'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATE_IN_PROGRESS = 'in_progress';
    const STATE_FAILED = 'failed';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_IN_PROGRESS,
            self::STATE_FAILED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['totalRecords'] = isset($data['totalRecords']) ? $data['totalRecords'] : null;
        $this->container['completedRecords'] = isset($data['completedRecords']) ? $data['completedRecords'] : null;
        $this->container['percentComplete'] = isset($data['percentComplete']) ? $data['percentComplete'] : null;
        $this->container['failureReason'] = isset($data['failureReason']) ? $data['failureReason'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['state'] === null) {
            $invalid_properties[] = "'state' can't be null";
        }
        $allowed_values = array("in_progress", "failed");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        if ($this->container['totalRecords'] === null) {
            $invalid_properties[] = "'totalRecords' can't be null";
        }
        if ($this->container['completedRecords'] === null) {
            $invalid_properties[] = "'completedRecords' can't be null";
        }
        if ($this->container['percentComplete'] === null) {
            $invalid_properties[] = "'percentComplete' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['state'] === null) {
            return false;
        }
        $allowed_values = array("in_progress", "failed");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        if ($this->container['totalRecords'] === null) {
            return false;
        }
        if ($this->container['completedRecords'] === null) {
            return false;
        }
        if ($this->container['percentComplete'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state current status of the import
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('in_progress', 'failed');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'in_progress', 'failed'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets totalRecords
     * @return int
     */
    public function getTotalRecords()
    {
        return $this->container['totalRecords'];
    }

    /**
     * Sets totalRecords
     * @param int $totalRecords total number of records to be imported
     * @return $this
     */
    public function setTotalRecords($totalRecords)
    {
        $this->container['totalRecords'] = $totalRecords;

        return $this;
    }

    /**
     * Gets completedRecords
     * @return int
     */
    public function getCompletedRecords()
    {
        return $this->container['completedRecords'];
    }

    /**
     * Sets completedRecords
     * @param int $completedRecords number of records finished importing
     * @return $this
     */
    public function setCompletedRecords($completedRecords)
    {
        $this->container['completedRecords'] = $completedRecords;

        return $this;
    }

    /**
     * Gets percentComplete
     * @return int
     */
    public function getPercentComplete()
    {
        return $this->container['percentComplete'];
    }

    /**
     * Sets percentComplete
     * @param int $percentComplete percentage of records finished importing
     * @return $this
     */
    public function setPercentComplete($percentComplete)
    {
        $this->container['percentComplete'] = $percentComplete;

        return $this;
    }

    /**
     * Gets failureReason
     * @return string
     */
    public function getFailureReason()
    {
        return $this->container['failureReason'];
    }

    /**
     * Sets failureReason
     * @param string $failureReason if the import has failed, the reason for the failure
     * @return $this
     */
    public function setFailureReason($failureReason)
    {
        $this->container['failureReason'] = $failureReason;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


