<?php
/**
 * VoicemailMessage
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * VoicemailMessage Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class VoicemailMessage implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'VoicemailMessage';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'conversation' => '\PureCloudSDK\Conversation',
        'read' => 'bool',
        'audioRecordingDurationSeconds' => 'int',
        'audioRecordingSizeBytes' => 'int',
        'createdDate' => '\DateTime',
        'modifiedDate' => '\DateTime',
        'callerAddress' => 'string',
        'callerName' => 'string',
        'callerUser' => '\PureCloudSDK\User',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'conversation' => 'conversation',
        'read' => 'read',
        'audioRecordingDurationSeconds' => 'audioRecordingDurationSeconds',
        'audioRecordingSizeBytes' => 'audioRecordingSizeBytes',
        'createdDate' => 'createdDate',
        'modifiedDate' => 'modifiedDate',
        'callerAddress' => 'callerAddress',
        'callerName' => 'callerName',
        'callerUser' => 'callerUser',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'conversation' => 'setConversation',
        'read' => 'setRead',
        'audioRecordingDurationSeconds' => 'setAudioRecordingDurationSeconds',
        'audioRecordingSizeBytes' => 'setAudioRecordingSizeBytes',
        'createdDate' => 'setCreatedDate',
        'modifiedDate' => 'setModifiedDate',
        'callerAddress' => 'setCallerAddress',
        'callerName' => 'setCallerName',
        'callerUser' => 'setCallerUser',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'conversation' => 'getConversation',
        'read' => 'getRead',
        'audioRecordingDurationSeconds' => 'getAudioRecordingDurationSeconds',
        'audioRecordingSizeBytes' => 'getAudioRecordingSizeBytes',
        'createdDate' => 'getCreatedDate',
        'modifiedDate' => 'getModifiedDate',
        'callerAddress' => 'getCallerAddress',
        'callerName' => 'getCallerName',
        'callerUser' => 'getCallerUser',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['conversation'] = isset($data['conversation']) ? $data['conversation'] : null;
        $this->container['read'] = isset($data['read']) ? $data['read'] : false;
        $this->container['audioRecordingDurationSeconds'] = isset($data['audioRecordingDurationSeconds']) ? $data['audioRecordingDurationSeconds'] : null;
        $this->container['audioRecordingSizeBytes'] = isset($data['audioRecordingSizeBytes']) ? $data['audioRecordingSizeBytes'] : null;
        $this->container['createdDate'] = isset($data['createdDate']) ? $data['createdDate'] : null;
        $this->container['modifiedDate'] = isset($data['modifiedDate']) ? $data['modifiedDate'] : null;
        $this->container['callerAddress'] = isset($data['callerAddress']) ? $data['callerAddress'] : null;
        $this->container['callerName'] = isset($data['callerName']) ? $data['callerName'] : null;
        $this->container['callerUser'] = isset($data['callerUser']) ? $data['callerUser'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets conversation
     * @return \PureCloudSDK\Conversation
     */
    public function getConversation()
    {
        return $this->container['conversation'];
    }

    /**
     * Sets conversation
     * @param \PureCloudSDK\Conversation $conversation
     * @return $this
     */
    public function setConversation($conversation)
    {
        $this->container['conversation'] = $conversation;

        return $this;
    }

    /**
     * Gets read
     * @return bool
     */
    public function getRead()
    {
        return $this->container['read'];
    }

    /**
     * Sets read
     * @param bool $read
     * @return $this
     */
    public function setRead($read)
    {
        $this->container['read'] = $read;

        return $this;
    }

    /**
     * Gets audioRecordingDurationSeconds
     * @return int
     */
    public function getAudioRecordingDurationSeconds()
    {
        return $this->container['audioRecordingDurationSeconds'];
    }

    /**
     * Sets audioRecordingDurationSeconds
     * @param int $audioRecordingDurationSeconds
     * @return $this
     */
    public function setAudioRecordingDurationSeconds($audioRecordingDurationSeconds)
    {
        $this->container['audioRecordingDurationSeconds'] = $audioRecordingDurationSeconds;

        return $this;
    }

    /**
     * Gets audioRecordingSizeBytes
     * @return int
     */
    public function getAudioRecordingSizeBytes()
    {
        return $this->container['audioRecordingSizeBytes'];
    }

    /**
     * Sets audioRecordingSizeBytes
     * @param int $audioRecordingSizeBytes
     * @return $this
     */
    public function setAudioRecordingSizeBytes($audioRecordingSizeBytes)
    {
        $this->container['audioRecordingSizeBytes'] = $audioRecordingSizeBytes;

        return $this;
    }

    /**
     * Gets createdDate
     * @return \DateTime
     */
    public function getCreatedDate()
    {
        return $this->container['createdDate'];
    }

    /**
     * Sets createdDate
     * @param \DateTime $createdDate Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCreatedDate($createdDate)
    {
        $this->container['createdDate'] = $createdDate;

        return $this;
    }

    /**
     * Gets modifiedDate
     * @return \DateTime
     */
    public function getModifiedDate()
    {
        return $this->container['modifiedDate'];
    }

    /**
     * Sets modifiedDate
     * @param \DateTime $modifiedDate Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setModifiedDate($modifiedDate)
    {
        $this->container['modifiedDate'] = $modifiedDate;

        return $this;
    }

    /**
     * Gets callerAddress
     * @return string
     */
    public function getCallerAddress()
    {
        return $this->container['callerAddress'];
    }

    /**
     * Sets callerAddress
     * @param string $callerAddress
     * @return $this
     */
    public function setCallerAddress($callerAddress)
    {
        $this->container['callerAddress'] = $callerAddress;

        return $this;
    }

    /**
     * Gets callerName
     * @return string
     */
    public function getCallerName()
    {
        return $this->container['callerName'];
    }

    /**
     * Sets callerName
     * @param string $callerName
     * @return $this
     */
    public function setCallerName($callerName)
    {
        $this->container['callerName'] = $callerName;

        return $this;
    }

    /**
     * Gets callerUser
     * @return \PureCloudSDK\User
     */
    public function getCallerUser()
    {
        return $this->container['callerUser'];
    }

    /**
     * Sets callerUser
     * @param \PureCloudSDK\User $callerUser
     * @return $this
     */
    public function setCallerUser($callerUser)
    {
        $this->container['callerUser'] = $callerUser;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


