# PureCloudSDK\RecordingApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteConversationIdRecordingsRecordingIdAnnotationsAnnotationId**](RecordingApi.md#deleteConversationIdRecordingsRecordingIdAnnotationsAnnotationId) | **DELETE** /api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations/{annotationId} | Delete annotation
[**deleteMediaretentionpolicies**](RecordingApi.md#deleteMediaretentionpolicies) | **DELETE** /api/v2/recording/mediaretentionpolicies | Delete media retention policies
[**deleteMediaretentionpoliciesPolicyId**](RecordingApi.md#deleteMediaretentionpoliciesPolicyId) | **DELETE** /api/v2/recording/mediaretentionpolicies/{policyId} | Delete a media retention policy
[**deleteOrphanId**](RecordingApi.md#deleteOrphanId) | **DELETE** /api/v2/orphanrecordings/{orphanId} | deletes a single orphan recording
[**getConversationIdRecordings**](RecordingApi.md#getConversationIdRecordings) | **GET** /api/v2/conversations/{conversationId}/recordings | Get all of a Conversation&#39;s Recordings.
[**getConversationIdRecordingsRecordingId**](RecordingApi.md#getConversationIdRecordingsRecordingId) | **GET** /api/v2/conversations/{conversationId}/recordings/{recordingId} | Gets a specific recording.
[**getConversationIdRecordingsRecordingIdAnnotations**](RecordingApi.md#getConversationIdRecordingsRecordingIdAnnotations) | **GET** /api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations | Get annotations for recording
[**getConversationIdRecordingsRecordingIdAnnotationsAnnotationId**](RecordingApi.md#getConversationIdRecordingsRecordingIdAnnotationsAnnotationId) | **GET** /api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations/{annotationId} | Get annotation
[**getLocalkeysSettings**](RecordingApi.md#getLocalkeysSettings) | **GET** /api/v2/recording/localkeys/settings | gets a list local key settings data
[**getLocalkeysSettingsSettingsId**](RecordingApi.md#getLocalkeysSettingsSettingsId) | **GET** /api/v2/recording/localkeys/settings/{settingsId} | Get the local encryption settings
[**getMediaretentionpolicies**](RecordingApi.md#getMediaretentionpolicies) | **GET** /api/v2/recording/mediaretentionpolicies | Gets media retention policy list with query options to filter on name and enabled.
[**getMediaretentionpoliciesPolicyId**](RecordingApi.md#getMediaretentionpoliciesPolicyId) | **GET** /api/v2/recording/mediaretentionpolicies/{policyId} | Get a media retention policy
[**getOrphanId**](RecordingApi.md#getOrphanId) | **GET** /api/v2/orphanrecordings/{orphanId} | Gets a single orphan recording
[**getOrphanrecordings**](RecordingApi.md#getOrphanrecordings) | **GET** /api/v2/orphanrecordings | Gets all orphan recordings
[**getRecordingkeys**](RecordingApi.md#getRecordingkeys) | **GET** /api/v2/recording/recordingkeys | Get encryption key list
[**getRecordingkeysRotationschedule**](RecordingApi.md#getRecordingkeysRotationschedule) | **GET** /api/v2/recording/recordingkeys/rotationschedule | Get key rotation schedule
[**getSettings**](RecordingApi.md#getSettings) | **GET** /api/v2/recording/settings | Get the Recording Settings for the Organization
[**getsScreensessions**](RecordingApi.md#getsScreensessions) | **GET** /api/v2/recordings/screensessions | Retrieves a paged listing of screen recording sessions
[**patchMediaretentionpoliciesPolicyId**](RecordingApi.md#patchMediaretentionpoliciesPolicyId) | **PATCH** /api/v2/recording/mediaretentionpolicies/{policyId} | Patch a media retention policy
[**patchsScreensessionsRecordingsessionId**](RecordingApi.md#patchsScreensessionsRecordingsessionId) | **PATCH** /api/v2/recordings/screensessions/{recordingSessionId} | Update a screen recording session
[**postConversationIdRecordingsRecordingIdAnnotations**](RecordingApi.md#postConversationIdRecordingsRecordingIdAnnotations) | **POST** /api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations | Create annotation
[**postLocalkeys**](RecordingApi.md#postLocalkeys) | **POST** /api/v2/recording/localkeys | create a local recording key
[**postLocalkeysSettings**](RecordingApi.md#postLocalkeysSettings) | **POST** /api/v2/recording/localkeys/settings | create settings for local key creation
[**postMediaretentionpolicies**](RecordingApi.md#postMediaretentionpolicies) | **POST** /api/v2/recording/mediaretentionpolicies | Create media retention policy
[**postRecordingkeys**](RecordingApi.md#postRecordingkeys) | **POST** /api/v2/recording/recordingkeys | Create encryption key
[**putConversationIdRecordingsRecordingId**](RecordingApi.md#putConversationIdRecordingsRecordingId) | **PUT** /api/v2/conversations/{conversationId}/recordings/{recordingId} | Updates the retention records on a recording.
[**putConversationIdRecordingsRecordingIdAnnotationsAnnotationId**](RecordingApi.md#putConversationIdRecordingsRecordingIdAnnotationsAnnotationId) | **PUT** /api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations/{annotationId} | Update annotation
[**putLocalkeysSettingsSettingsId**](RecordingApi.md#putLocalkeysSettingsSettingsId) | **PUT** /api/v2/recording/localkeys/settings/{settingsId} | Update the local encryption settings
[**putMediaretentionpoliciesPolicyId**](RecordingApi.md#putMediaretentionpoliciesPolicyId) | **PUT** /api/v2/recording/mediaretentionpolicies/{policyId} | Update a media retention policy
[**putRecordingkeysRotationschedule**](RecordingApi.md#putRecordingkeysRotationschedule) | **PUT** /api/v2/recording/recordingkeys/rotationschedule | Update key rotation schedule
[**putSettings**](RecordingApi.md#putSettings) | **PUT** /api/v2/recording/settings | Update the Recording Settings for the Organization


# **deleteConversationIdRecordingsRecordingIdAnnotationsAnnotationId**
> deleteConversationIdRecordingsRecordingIdAnnotationsAnnotationId($conversationId, $recordingId, $annotationId)

Delete annotation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$conversationId = "conversationId_example"; // string | Conversation ID
$recordingId = "recordingId_example"; // string | Recording ID
$annotationId = "annotationId_example"; // string | Annotation ID

try {
    $api_instance->deleteConversationIdRecordingsRecordingIdAnnotationsAnnotationId($conversationId, $recordingId, $annotationId);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->deleteConversationIdRecordingsRecordingIdAnnotationsAnnotationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| Conversation ID |
 **recordingId** | **string**| Recording ID |
 **annotationId** | **string**| Annotation ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteMediaretentionpolicies**
> string deleteMediaretentionpolicies($ids)

Delete media retention policies

Bulk delete of media retention policies, this will only delete the polices that match the ids specified in the query param.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$ids = "ids_example"; // string | 

try {
    $result = $api_instance->deleteMediaretentionpolicies($ids);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->deleteMediaretentionpolicies: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ids** | **string**|  |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteMediaretentionpoliciesPolicyId**
> string deleteMediaretentionpoliciesPolicyId($policyId)

Delete a media retention policy



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$policyId = "policyId_example"; // string | Policy ID

try {
    $result = $api_instance->deleteMediaretentionpoliciesPolicyId($policyId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->deleteMediaretentionpoliciesPolicyId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **policyId** | **string**| Policy ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteOrphanId**
> \PureCloudSDK\OrphanRecording deleteOrphanId($orphanId)

deletes a single orphan recording



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$orphanId = "orphanId_example"; // string | Orphan ID

try {
    $result = $api_instance->deleteOrphanId($orphanId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->deleteOrphanId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orphanId** | **string**| Orphan ID |

### Return type

[**\PureCloudSDK\OrphanRecording**](../Model/OrphanRecording.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationIdRecordings**
> \PureCloudSDK\Recording[] getConversationIdRecordings($conversationId, $maxWaitMs, $formatId)

Get all of a Conversation's Recordings.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$conversationId = "conversationId_example"; // string | Conversation ID
$maxWaitMs = 5000; // int | The maximum number of milliseconds to wait for the recording to be ready.
$formatId = "webm"; // string | The desired media format

try {
    $result = $api_instance->getConversationIdRecordings($conversationId, $maxWaitMs, $formatId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getConversationIdRecordings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| Conversation ID |
 **maxWaitMs** | **int**| The maximum number of milliseconds to wait for the recording to be ready. | [optional] [default to 5000]
 **formatId** | **string**| The desired media format | [optional] [default to webm]

### Return type

[**\PureCloudSDK\Recording[]**](../Model/Recording.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationIdRecordingsRecordingId**
> \PureCloudSDK\Recording getConversationIdRecordingsRecordingId($conversationId, $recordingId, $formatId, $download, $fileName)

Gets a specific recording.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$conversationId = "conversationId_example"; // string | Conversation ID
$recordingId = "recordingId_example"; // string | Recording ID
$formatId = "webm"; // string | The desired media format.
$download = false; // bool | requesting a download format of the recording
$fileName = "fileName_example"; // string | the name of the downloaded fileName

try {
    $result = $api_instance->getConversationIdRecordingsRecordingId($conversationId, $recordingId, $formatId, $download, $fileName);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getConversationIdRecordingsRecordingId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| Conversation ID |
 **recordingId** | **string**| Recording ID |
 **formatId** | **string**| The desired media format. | [optional] [default to webm]
 **download** | **bool**| requesting a download format of the recording | [optional] [default to false]
 **fileName** | **string**| the name of the downloaded fileName | [optional]

### Return type

[**\PureCloudSDK\Recording**](../Model/Recording.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationIdRecordingsRecordingIdAnnotations**
> \PureCloudSDK\Annotation[] getConversationIdRecordingsRecordingIdAnnotations($conversationId, $recordingId)

Get annotations for recording



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$conversationId = "conversationId_example"; // string | Conversation ID
$recordingId = "recordingId_example"; // string | Recording ID

try {
    $result = $api_instance->getConversationIdRecordingsRecordingIdAnnotations($conversationId, $recordingId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getConversationIdRecordingsRecordingIdAnnotations: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| Conversation ID |
 **recordingId** | **string**| Recording ID |

### Return type

[**\PureCloudSDK\Annotation[]**](../Model/Annotation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationIdRecordingsRecordingIdAnnotationsAnnotationId**
> \PureCloudSDK\Annotation getConversationIdRecordingsRecordingIdAnnotationsAnnotationId($conversationId, $recordingId, $annotationId)

Get annotation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$conversationId = "conversationId_example"; // string | Conversation ID
$recordingId = "recordingId_example"; // string | Recording ID
$annotationId = "annotationId_example"; // string | Annotation ID

try {
    $result = $api_instance->getConversationIdRecordingsRecordingIdAnnotationsAnnotationId($conversationId, $recordingId, $annotationId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getConversationIdRecordingsRecordingIdAnnotationsAnnotationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| Conversation ID |
 **recordingId** | **string**| Recording ID |
 **annotationId** | **string**| Annotation ID |

### Return type

[**\PureCloudSDK\Annotation**](../Model/Annotation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getLocalkeysSettings**
> \PureCloudSDK\LocalEncryptionConfigurationListing getLocalkeysSettings()

gets a list local key settings data



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();

try {
    $result = $api_instance->getLocalkeysSettings();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getLocalkeysSettings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\LocalEncryptionConfigurationListing**](../Model/LocalEncryptionConfigurationListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getLocalkeysSettingsSettingsId**
> \PureCloudSDK\LocalEncryptionConfiguration getLocalkeysSettingsSettingsId($settingsId)

Get the local encryption settings



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$settingsId = "settingsId_example"; // string | Settings Id

try {
    $result = $api_instance->getLocalkeysSettingsSettingsId($settingsId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getLocalkeysSettingsSettingsId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **settingsId** | **string**| Settings Id |

### Return type

[**\PureCloudSDK\LocalEncryptionConfiguration**](../Model/LocalEncryptionConfiguration.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getMediaretentionpolicies**
> \PureCloudSDK\PolicyEntityListing getMediaretentionpolicies($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $name, $enabled, $summary, $hasErrors)

Gets media retention policy list with query options to filter on name and enabled.

for a less verbose response, add summary=true to this endpoint

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$pageSize = 25; // int | The total page size requested
$pageNumber = 1; // int | The page number requested
$sortBy = "sortBy_example"; // string | variable name requested to sort by
$expand = NULL; // object[] | variable name requested by expand list
$nextPage = "nextPage_example"; // string | next page token
$previousPage = "previousPage_example"; // string | Previous page token
$name = "name_example"; // string | the policy name - used for filtering results in searches.
$enabled = true; // bool | checks to see if policy is enabled - use enabled = true or enabled = false
$summary = false; // bool | provides a less verbose response of policy lists.
$hasErrors = true; // bool | provides a way to fetch all policies with errors or policies that do not have errors

try {
    $result = $api_instance->getMediaretentionpolicies($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $name, $enabled, $summary, $hasErrors);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getMediaretentionpolicies: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| The total page size requested | [optional] [default to 25]
 **pageNumber** | **int**| The page number requested | [optional] [default to 1]
 **sortBy** | **string**| variable name requested to sort by | [optional]
 **expand** | [**object[]**](../Model/object.md)| variable name requested by expand list | [optional]
 **nextPage** | **string**| next page token | [optional]
 **previousPage** | **string**| Previous page token | [optional]
 **name** | **string**| the policy name - used for filtering results in searches. | [optional]
 **enabled** | **bool**| checks to see if policy is enabled - use enabled &#x3D; true or enabled &#x3D; false | [optional]
 **summary** | **bool**| provides a less verbose response of policy lists. | [optional] [default to false]
 **hasErrors** | **bool**| provides a way to fetch all policies with errors or policies that do not have errors | [optional]

### Return type

[**\PureCloudSDK\PolicyEntityListing**](../Model/PolicyEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getMediaretentionpoliciesPolicyId**
> \PureCloudSDK\Policy getMediaretentionpoliciesPolicyId($policyId)

Get a media retention policy



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$policyId = "policyId_example"; // string | Policy ID

try {
    $result = $api_instance->getMediaretentionpoliciesPolicyId($policyId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getMediaretentionpoliciesPolicyId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **policyId** | **string**| Policy ID |

### Return type

[**\PureCloudSDK\Policy**](../Model/Policy.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOrphanId**
> \PureCloudSDK\OrphanRecording getOrphanId($orphanId)

Gets a single orphan recording



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$orphanId = "orphanId_example"; // string | Orphan ID

try {
    $result = $api_instance->getOrphanId($orphanId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getOrphanId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orphanId** | **string**| Orphan ID |

### Return type

[**\PureCloudSDK\OrphanRecording**](../Model/OrphanRecording.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOrphanrecordings**
> \PureCloudSDK\OrphanRecordingListing getOrphanrecordings($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage)

Gets all orphan recordings



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$pageSize = 25; // int | The total page size requested
$pageNumber = 1; // int | The page number requested
$sortBy = "sortBy_example"; // string | variable name requested to sort by
$expand = NULL; // object[] | variable name requested by expand list
$nextPage = "nextPage_example"; // string | next page token
$previousPage = "previousPage_example"; // string | Previous page token

try {
    $result = $api_instance->getOrphanrecordings($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getOrphanrecordings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| The total page size requested | [optional] [default to 25]
 **pageNumber** | **int**| The page number requested | [optional] [default to 1]
 **sortBy** | **string**| variable name requested to sort by | [optional]
 **expand** | [**object[]**](../Model/object.md)| variable name requested by expand list | [optional]
 **nextPage** | **string**| next page token | [optional]
 **previousPage** | **string**| Previous page token | [optional]

### Return type

[**\PureCloudSDK\OrphanRecordingListing**](../Model/OrphanRecordingListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRecordingkeys**
> \PureCloudSDK\EncryptionKeyEntityListing getRecordingkeys($pageSize, $pageNumber)

Get encryption key list



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getRecordingkeys($pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getRecordingkeys: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\EncryptionKeyEntityListing**](../Model/EncryptionKeyEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRecordingkeysRotationschedule**
> \PureCloudSDK\KeyRotationSchedule getRecordingkeysRotationschedule()

Get key rotation schedule



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();

try {
    $result = $api_instance->getRecordingkeysRotationschedule();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getRecordingkeysRotationschedule: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\KeyRotationSchedule**](../Model/KeyRotationSchedule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSettings**
> \PureCloudSDK\RecordingSettings getSettings($createDefault)

Get the Recording Settings for the Organization



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$createDefault = false; // bool | If no settings are found, a new one is created with default values

try {
    $result = $api_instance->getSettings($createDefault);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getSettings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **createDefault** | **bool**| If no settings are found, a new one is created with default values | [optional] [default to false]

### Return type

[**\PureCloudSDK\RecordingSettings**](../Model/RecordingSettings.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getsScreensessions**
> \PureCloudSDK\ScreenRecordingSessionListing getsScreensessions($pageSize, $pageNumber)

Retrieves a paged listing of screen recording sessions



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getsScreensessions($pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->getsScreensessions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\ScreenRecordingSessionListing**](../Model/ScreenRecordingSessionListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchMediaretentionpoliciesPolicyId**
> \PureCloudSDK\Policy patchMediaretentionpoliciesPolicyId($policyId, $body)

Patch a media retention policy



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$policyId = "policyId_example"; // string | Policy ID
$body = new \PureCloudSDK\Policy(); // \PureCloudSDK\Policy | Policy

try {
    $result = $api_instance->patchMediaretentionpoliciesPolicyId($policyId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->patchMediaretentionpoliciesPolicyId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **policyId** | **string**| Policy ID |
 **body** | [**\PureCloudSDK\Policy**](../Model/\PureCloudSDK\Policy.md)| Policy |

### Return type

[**\PureCloudSDK\Policy**](../Model/Policy.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchsScreensessionsRecordingsessionId**
> patchsScreensessionsRecordingsessionId($recordingSessionId, $body)

Update a screen recording session



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$recordingSessionId = "recordingSessionId_example"; // string | Screen recording session ID
$body = new \PureCloudSDK\ScreenRecordingSessionRequest(); // \PureCloudSDK\ScreenRecordingSessionRequest | 

try {
    $api_instance->patchsScreensessionsRecordingsessionId($recordingSessionId, $body);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->patchsScreensessionsRecordingsessionId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **recordingSessionId** | **string**| Screen recording session ID |
 **body** | [**\PureCloudSDK\ScreenRecordingSessionRequest**](../Model/\PureCloudSDK\ScreenRecordingSessionRequest.md)|  | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationIdRecordingsRecordingIdAnnotations**
> \PureCloudSDK\Annotation postConversationIdRecordingsRecordingIdAnnotations($conversationId, $recordingId, $body)

Create annotation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$conversationId = "conversationId_example"; // string | Conversation ID
$recordingId = "recordingId_example"; // string | Recording ID
$body = new \PureCloudSDK\Annotation(); // \PureCloudSDK\Annotation | annotation

try {
    $result = $api_instance->postConversationIdRecordingsRecordingIdAnnotations($conversationId, $recordingId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->postConversationIdRecordingsRecordingIdAnnotations: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| Conversation ID |
 **recordingId** | **string**| Recording ID |
 **body** | [**\PureCloudSDK\Annotation**](../Model/\PureCloudSDK\Annotation.md)| annotation |

### Return type

[**\PureCloudSDK\Annotation**](../Model/Annotation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postLocalkeys**
> \PureCloudSDK\EncryptionKey postLocalkeys($body)

create a local recording key



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$body = new \PureCloudSDK\LocalEncryptionKeyRequest(); // \PureCloudSDK\LocalEncryptionKeyRequest | Local Encryption body

try {
    $result = $api_instance->postLocalkeys($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->postLocalkeys: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\LocalEncryptionKeyRequest**](../Model/\PureCloudSDK\LocalEncryptionKeyRequest.md)| Local Encryption body |

### Return type

[**\PureCloudSDK\EncryptionKey**](../Model/EncryptionKey.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postLocalkeysSettings**
> \PureCloudSDK\LocalEncryptionConfiguration postLocalkeysSettings($body)

create settings for local key creation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$body = new \PureCloudSDK\LocalEncryptionConfiguration(); // \PureCloudSDK\LocalEncryptionConfiguration | Local Encryption Configuration

try {
    $result = $api_instance->postLocalkeysSettings($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->postLocalkeysSettings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\LocalEncryptionConfiguration**](../Model/\PureCloudSDK\LocalEncryptionConfiguration.md)| Local Encryption Configuration |

### Return type

[**\PureCloudSDK\LocalEncryptionConfiguration**](../Model/LocalEncryptionConfiguration.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postMediaretentionpolicies**
> \PureCloudSDK\Policy postMediaretentionpolicies($body)

Create media retention policy



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$body = new \PureCloudSDK\PolicyCreate(); // \PureCloudSDK\PolicyCreate | Policy

try {
    $result = $api_instance->postMediaretentionpolicies($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->postMediaretentionpolicies: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\PolicyCreate**](../Model/\PureCloudSDK\PolicyCreate.md)| Policy |

### Return type

[**\PureCloudSDK\Policy**](../Model/Policy.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postRecordingkeys**
> \PureCloudSDK\EncryptionKey postRecordingkeys()

Create encryption key



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();

try {
    $result = $api_instance->postRecordingkeys();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->postRecordingkeys: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\EncryptionKey**](../Model/EncryptionKey.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putConversationIdRecordingsRecordingId**
> \PureCloudSDK\Recording putConversationIdRecordingsRecordingId($conversationId, $recordingId, $body)

Updates the retention records on a recording.

Currently supports updating and removing both archive and delete dates for eligible recordings. A request to change the archival date of an archived recording will result in a restoration of the recording until the new date set.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$conversationId = "conversationId_example"; // string | Conversation ID
$recordingId = "recordingId_example"; // string | Recording ID
$body = new \PureCloudSDK\Recording(); // \PureCloudSDK\Recording | recording

try {
    $result = $api_instance->putConversationIdRecordingsRecordingId($conversationId, $recordingId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->putConversationIdRecordingsRecordingId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| Conversation ID |
 **recordingId** | **string**| Recording ID |
 **body** | [**\PureCloudSDK\Recording**](../Model/\PureCloudSDK\Recording.md)| recording |

### Return type

[**\PureCloudSDK\Recording**](../Model/Recording.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putConversationIdRecordingsRecordingIdAnnotationsAnnotationId**
> \PureCloudSDK\Annotation putConversationIdRecordingsRecordingIdAnnotationsAnnotationId($conversationId, $recordingId, $annotationId, $body)

Update annotation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$conversationId = "conversationId_example"; // string | Conversation ID
$recordingId = "recordingId_example"; // string | Recording ID
$annotationId = "annotationId_example"; // string | Annotation ID
$body = new \PureCloudSDK\Annotation(); // \PureCloudSDK\Annotation | annotation

try {
    $result = $api_instance->putConversationIdRecordingsRecordingIdAnnotationsAnnotationId($conversationId, $recordingId, $annotationId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->putConversationIdRecordingsRecordingIdAnnotationsAnnotationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| Conversation ID |
 **recordingId** | **string**| Recording ID |
 **annotationId** | **string**| Annotation ID |
 **body** | [**\PureCloudSDK\Annotation**](../Model/\PureCloudSDK\Annotation.md)| annotation |

### Return type

[**\PureCloudSDK\Annotation**](../Model/Annotation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putLocalkeysSettingsSettingsId**
> \PureCloudSDK\LocalEncryptionConfiguration putLocalkeysSettingsSettingsId($settingsId, $body)

Update the local encryption settings



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$settingsId = "settingsId_example"; // string | Settings Id
$body = new \PureCloudSDK\LocalEncryptionConfiguration(); // \PureCloudSDK\LocalEncryptionConfiguration | Local Encryption metadata

try {
    $result = $api_instance->putLocalkeysSettingsSettingsId($settingsId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->putLocalkeysSettingsSettingsId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **settingsId** | **string**| Settings Id |
 **body** | [**\PureCloudSDK\LocalEncryptionConfiguration**](../Model/\PureCloudSDK\LocalEncryptionConfiguration.md)| Local Encryption metadata |

### Return type

[**\PureCloudSDK\LocalEncryptionConfiguration**](../Model/LocalEncryptionConfiguration.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putMediaretentionpoliciesPolicyId**
> \PureCloudSDK\Policy putMediaretentionpoliciesPolicyId($policyId, $body)

Update a media retention policy



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$policyId = "policyId_example"; // string | Policy ID
$body = new \PureCloudSDK\Policy(); // \PureCloudSDK\Policy | Policy

try {
    $result = $api_instance->putMediaretentionpoliciesPolicyId($policyId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->putMediaretentionpoliciesPolicyId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **policyId** | **string**| Policy ID |
 **body** | [**\PureCloudSDK\Policy**](../Model/\PureCloudSDK\Policy.md)| Policy |

### Return type

[**\PureCloudSDK\Policy**](../Model/Policy.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putRecordingkeysRotationschedule**
> \PureCloudSDK\KeyRotationSchedule putRecordingkeysRotationschedule($body)

Update key rotation schedule



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$body = new \PureCloudSDK\KeyRotationSchedule(); // \PureCloudSDK\KeyRotationSchedule | KeyRotationSchedule

try {
    $result = $api_instance->putRecordingkeysRotationschedule($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->putRecordingkeysRotationschedule: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\KeyRotationSchedule**](../Model/\PureCloudSDK\KeyRotationSchedule.md)| KeyRotationSchedule |

### Return type

[**\PureCloudSDK\KeyRotationSchedule**](../Model/KeyRotationSchedule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putSettings**
> \PureCloudSDK\RecordingSettings putSettings($body)

Update the Recording Settings for the Organization



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\RecordingApi();
$body = new \PureCloudSDK\RecordingSettings(); // \PureCloudSDK\RecordingSettings | Recording settings

try {
    $result = $api_instance->putSettings($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RecordingApi->putSettings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\RecordingSettings**](../Model/\PureCloudSDK\RecordingSettings.md)| Recording settings |

### Return type

[**\PureCloudSDK\RecordingSettings**](../Model/RecordingSettings.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

