<?php

/**
 * SmsPhoneNumber
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * SmsPhoneNumber Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class SmsPhoneNumber implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'SmsPhoneNumber';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'phoneNumber' => 'string',
        'phoneNumberType' => 'string',
        'provisionedThroughPureCloud' => 'bool',
        'phoneNumberStatus' => 'string',
        'countryCode' => 'string',
        'dateCreated' => '\DateTime',
        'dateModified' => '\DateTime',
        'createdBy' => '\PureCloudSDK\User',
        'modifiedBy' => '\PureCloudSDK\User',
        'version' => 'int',
        'purchaseDate' => '\DateTime',
        'cancellationDate' => '\DateTime',
        'renewalDate' => '\DateTime',
        'autoRenewable' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'phoneNumber' => 'phoneNumber',
        'phoneNumberType' => 'phoneNumberType',
        'provisionedThroughPureCloud' => 'provisionedThroughPureCloud',
        'phoneNumberStatus' => 'phoneNumberStatus',
        'countryCode' => 'countryCode',
        'dateCreated' => 'dateCreated',
        'dateModified' => 'dateModified',
        'createdBy' => 'createdBy',
        'modifiedBy' => 'modifiedBy',
        'version' => 'version',
        'purchaseDate' => 'purchaseDate',
        'cancellationDate' => 'cancellationDate',
        'renewalDate' => 'renewalDate',
        'autoRenewable' => 'autoRenewable',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'phoneNumber' => 'setPhoneNumber',
        'phoneNumberType' => 'setPhoneNumberType',
        'provisionedThroughPureCloud' => 'setProvisionedThroughPureCloud',
        'phoneNumberStatus' => 'setPhoneNumberStatus',
        'countryCode' => 'setCountryCode',
        'dateCreated' => 'setDateCreated',
        'dateModified' => 'setDateModified',
        'createdBy' => 'setCreatedBy',
        'modifiedBy' => 'setModifiedBy',
        'version' => 'setVersion',
        'purchaseDate' => 'setPurchaseDate',
        'cancellationDate' => 'setCancellationDate',
        'renewalDate' => 'setRenewalDate',
        'autoRenewable' => 'setAutoRenewable',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'phoneNumber' => 'getPhoneNumber',
        'phoneNumberType' => 'getPhoneNumberType',
        'provisionedThroughPureCloud' => 'getProvisionedThroughPureCloud',
        'phoneNumberStatus' => 'getPhoneNumberStatus',
        'countryCode' => 'getCountryCode',
        'dateCreated' => 'getDateCreated',
        'dateModified' => 'getDateModified',
        'createdBy' => 'getCreatedBy',
        'modifiedBy' => 'getModifiedBy',
        'version' => 'getVersion',
        'purchaseDate' => 'getPurchaseDate',
        'cancellationDate' => 'getCancellationDate',
        'renewalDate' => 'getRenewalDate',
        'autoRenewable' => 'getAutoRenewable',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const PHONE_NUMBER_TYPE_LOCAL = 'local';
    public const PHONE_NUMBER_TYPE_MOBILE = 'mobile';
    public const PHONE_NUMBER_TYPE_TOLLFREE = 'tollfree';
    public const PHONE_NUMBER_TYPE_SHORTCODE = 'shortcode';
    public const PHONE_NUMBER_STATUS_INVALID = 'INVALID';
    public const PHONE_NUMBER_STATUS_ACTIVE = 'ACTIVE';
    public const PHONE_NUMBER_STATUS_PORTING = 'PORTING';
    public const PHONE_NUMBER_STATUS_PENDING = 'PENDING';
    public const PHONE_NUMBER_STATUS_PENDING_CANCELLATION = 'PENDING_CANCELLATION';
    public const AUTO_RENEWABLE_QUARTERLY = 'Quarterly';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getPhoneNumberTypeAllowableValues()
    {
        return [
            self::PHONE_NUMBER_TYPE_LOCAL,
            self::PHONE_NUMBER_TYPE_MOBILE,
            self::PHONE_NUMBER_TYPE_TOLLFREE,
            self::PHONE_NUMBER_TYPE_SHORTCODE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getPhoneNumberStatusAllowableValues()
    {
        return [
            self::PHONE_NUMBER_STATUS_INVALID,
            self::PHONE_NUMBER_STATUS_ACTIVE,
            self::PHONE_NUMBER_STATUS_PORTING,
            self::PHONE_NUMBER_STATUS_PENDING,
            self::PHONE_NUMBER_STATUS_PENDING_CANCELLATION,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getAutoRenewableAllowableValues()
    {
        return [
            self::AUTO_RENEWABLE_QUARTERLY,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['phoneNumber'] = isset($data['phoneNumber']) ? $data['phoneNumber'] : null;
        $this->container['phoneNumberType'] = isset($data['phoneNumberType']) ? $data['phoneNumberType'] : null;
        $this->container['provisionedThroughPureCloud'] = isset($data['provisionedThroughPureCloud']) ? $data['provisionedThroughPureCloud'] : null;
        $this->container['phoneNumberStatus'] = isset($data['phoneNumberStatus']) ? $data['phoneNumberStatus'] : null;
        $this->container['countryCode'] = isset($data['countryCode']) ? $data['countryCode'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['dateModified'] = isset($data['dateModified']) ? $data['dateModified'] : null;
        $this->container['createdBy'] = isset($data['createdBy']) ? $data['createdBy'] : null;
        $this->container['modifiedBy'] = isset($data['modifiedBy']) ? $data['modifiedBy'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['purchaseDate'] = isset($data['purchaseDate']) ? $data['purchaseDate'] : null;
        $this->container['cancellationDate'] = isset($data['cancellationDate']) ? $data['cancellationDate'] : null;
        $this->container['renewalDate'] = isset($data['renewalDate']) ? $data['renewalDate'] : null;
        $this->container['autoRenewable'] = isset($data['autoRenewable']) ? $data['autoRenewable'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['phoneNumber'] === null) {
            $invalid_properties[] = "'phoneNumber' can't be null";
        }
        $allowed_values = array("local", "mobile", "tollfree", "shortcode");
        if (!in_array($this->container['phoneNumberType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'phoneNumberType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("INVALID", "ACTIVE", "PORTING", "PENDING", "PENDING_CANCELLATION");
        if (!in_array($this->container['phoneNumberStatus'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'phoneNumberStatus', must be one of #{allowed_values}.";
        }

        if ($this->container['version'] === null) {
            $invalid_properties[] = "'version' can't be null";
        }
        $allowed_values = array("Quarterly");
        if (!in_array($this->container['autoRenewable'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'autoRenewable', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['phoneNumber'] === null) {
            return false;
        }
        $allowed_values = array("local", "mobile", "tollfree", "shortcode");
        if (!in_array($this->container['phoneNumberType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("INVALID", "ACTIVE", "PORTING", "PENDING", "PENDING_CANCELLATION");
        if (!in_array($this->container['phoneNumberStatus'], $allowed_values)) {
            return false;
        }
        if ($this->container['version'] === null) {
            return false;
        }
        $allowed_values = array("Quarterly");
        if (!in_array($this->container['autoRenewable'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets phoneNumber
     * @return string
     */
    public function getPhoneNumber()
    {
        return $this->container['phoneNumber'];
    }

    /**
     * Sets phoneNumber
     * @param string $phoneNumber A phone number provisioned for SMS communications in E.164 format. E.g. +13175555555 or +34234234234
     * @return $this
     */
    public function setPhoneNumber($phoneNumber)
    {
        $this->container['phoneNumber'] = $phoneNumber;

        return $this;
    }

    /**
     * Gets phoneNumberType
     * @return string
     */
    public function getPhoneNumberType()
    {
        return $this->container['phoneNumberType'];
    }

    /**
     * Sets phoneNumberType
     * @param string $phoneNumberType Type of the phone number provisioned.
     * @return $this
     */
    public function setPhoneNumberType($phoneNumberType)
    {
        $allowed_values = array('local', 'mobile', 'tollfree', 'shortcode');
        if (!in_array($phoneNumberType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'phoneNumberType', must be one of 'local', 'mobile', 'tollfree', 'shortcode'");
        }
        $this->container['phoneNumberType'] = $phoneNumberType;

        return $this;
    }

    /**
     * Gets provisionedThroughPureCloud
     * @return bool
     */
    public function getProvisionedThroughPureCloud()
    {
        return $this->container['provisionedThroughPureCloud'];
    }

    /**
     * Sets provisionedThroughPureCloud
     * @param bool $provisionedThroughPureCloud Is set to false, if the phone number is provisioned through a SMS provider, outside of PureCloud
     * @return $this
     */
    public function setProvisionedThroughPureCloud($provisionedThroughPureCloud)
    {
        $this->container['provisionedThroughPureCloud'] = $provisionedThroughPureCloud;

        return $this;
    }

    /**
     * Gets phoneNumberStatus
     * @return string
     */
    public function getPhoneNumberStatus()
    {
        return $this->container['phoneNumberStatus'];
    }

    /**
     * Sets phoneNumberStatus
     * @param string $phoneNumberStatus Status of the provisioned phone number.
     * @return $this
     */
    public function setPhoneNumberStatus($phoneNumberStatus)
    {
        $allowed_values = array('INVALID', 'ACTIVE', 'PORTING', 'PENDING', 'PENDING_CANCELLATION');
        if (!in_array($phoneNumberStatus, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'phoneNumberStatus', must be one of 'INVALID', 'ACTIVE', 'PORTING', 'PENDING', 'PENDING_CANCELLATION'");
        }
        $this->container['phoneNumberStatus'] = $phoneNumberStatus;

        return $this;
    }

    /**
     * Gets countryCode
     * @return string
     */
    public function getCountryCode()
    {
        return $this->container['countryCode'];
    }

    /**
     * Sets countryCode
     * @param string $countryCode The ISO 3166-1 alpha-2 country code of the country this phone number is associated with.
     * @return $this
     */
    public function setCountryCode($countryCode)
    {
        $this->container['countryCode'] = $countryCode;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param \DateTime $dateCreated Date this phone number was provisioned. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets dateModified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['dateModified'];
    }

    /**
     * Sets dateModified
     * @param \DateTime $dateModified Date this phone number was modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($dateModified)
    {
        $this->container['dateModified'] = $dateModified;

        return $this;
    }

    /**
     * Gets createdBy
     * @return \PureCloudSDK\User
     */
    public function getCreatedBy()
    {
        return $this->container['createdBy'];
    }

    /**
     * Sets createdBy
     * @param \PureCloudSDK\User $createdBy User that provisioned this phone number
     * @return $this
     */
    public function setCreatedBy($createdBy)
    {
        $this->container['createdBy'] = $createdBy;

        return $this;
    }

    /**
     * Gets modifiedBy
     * @return \PureCloudSDK\User
     */
    public function getModifiedBy()
    {
        return $this->container['modifiedBy'];
    }

    /**
     * Sets modifiedBy
     * @param \PureCloudSDK\User $modifiedBy User that last modified this phone number
     * @return $this
     */
    public function setModifiedBy($modifiedBy)
    {
        $this->container['modifiedBy'] = $modifiedBy;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version Version number required for updates.
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets purchaseDate
     * @return \DateTime
     */
    public function getPurchaseDate()
    {
        return $this->container['purchaseDate'];
    }

    /**
     * Sets purchaseDate
     * @param \DateTime $purchaseDate Date this phone number was purchased, if the phoneNumberType is shortcode. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setPurchaseDate($purchaseDate)
    {
        $this->container['purchaseDate'] = $purchaseDate;

        return $this;
    }

    /**
     * Gets cancellationDate
     * @return \DateTime
     */
    public function getCancellationDate()
    {
        return $this->container['cancellationDate'];
    }

    /**
     * Sets cancellationDate
     * @param \DateTime $cancellationDate Contract end date of this phone number, if the phoneNumberType is shortcode. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCancellationDate($cancellationDate)
    {
        $this->container['cancellationDate'] = $cancellationDate;

        return $this;
    }

    /**
     * Gets renewalDate
     * @return \DateTime
     */
    public function getRenewalDate()
    {
        return $this->container['renewalDate'];
    }

    /**
     * Sets renewalDate
     * @param \DateTime $renewalDate Contract renewal date of this phone number, if the phoneNumberType is shortcode. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setRenewalDate($renewalDate)
    {
        $this->container['renewalDate'] = $renewalDate;

        return $this;
    }

    /**
     * Gets autoRenewable
     * @return string
     */
    public function getAutoRenewable()
    {
        return $this->container['autoRenewable'];
    }

    /**
     * Sets autoRenewable
     * @param string $autoRenewable Renewal time period of this phone number, if the phoneNumberType is shortcode.
     * @return $this
     */
    public function setAutoRenewable($autoRenewable)
    {
        $allowed_values = array('Quarterly');
        if (!in_array($autoRenewable, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'autoRenewable', must be one of 'Quarterly'");
        }
        $this->container['autoRenewable'] = $autoRenewable;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


