<?php

/**
 * UserDevice
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * UserDevice Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class UserDevice implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'UserDevice';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'deviceToken' => 'string',
        'notificationId' => 'string',
        'make' => 'string',
        'model' => 'string',
        'acceptNotifications' => 'bool',
        'type' => 'string',
        'sessionHash' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'deviceToken' => 'deviceToken',
        'notificationId' => 'notificationId',
        'make' => 'make',
        'model' => 'model',
        'acceptNotifications' => 'acceptNotifications',
        'type' => 'type',
        'sessionHash' => 'sessionHash',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'deviceToken' => 'setDeviceToken',
        'notificationId' => 'setNotificationId',
        'make' => 'setMake',
        'model' => 'setModel',
        'acceptNotifications' => 'setAcceptNotifications',
        'type' => 'setType',
        'sessionHash' => 'setSessionHash',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'deviceToken' => 'getDeviceToken',
        'notificationId' => 'getNotificationId',
        'make' => 'getMake',
        'model' => 'getModel',
        'acceptNotifications' => 'getAcceptNotifications',
        'type' => 'getType',
        'sessionHash' => 'getSessionHash',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const TYPE_ANDROID = 'android';
    public const TYPE_IOS = 'ios';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_ANDROID,
            self::TYPE_IOS,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['deviceToken'] = isset($data['deviceToken']) ? $data['deviceToken'] : null;
        $this->container['notificationId'] = isset($data['notificationId']) ? $data['notificationId'] : null;
        $this->container['make'] = isset($data['make']) ? $data['make'] : null;
        $this->container['model'] = isset($data['model']) ? $data['model'] : null;
        $this->container['acceptNotifications'] = isset($data['acceptNotifications']) ? $data['acceptNotifications'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['sessionHash'] = isset($data['sessionHash']) ? $data['sessionHash'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['deviceToken'] === null) {
            $invalid_properties[] = "'deviceToken' can't be null";
        }
        if ($this->container['notificationId'] === null) {
            $invalid_properties[] = "'notificationId' can't be null";
        }
        if ($this->container['make'] === null) {
            $invalid_properties[] = "'make' can't be null";
        }
        if ($this->container['model'] === null) {
            $invalid_properties[] = "'model' can't be null";
        }
        if ($this->container['acceptNotifications'] === null) {
            $invalid_properties[] = "'acceptNotifications' can't be null";
        }
        if ($this->container['type'] === null) {
            $invalid_properties[] = "'type' can't be null";
        }
        $allowed_values = array("android", "ios");
        if (!in_array($this->container['type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['deviceToken'] === null) {
            return false;
        }
        if ($this->container['notificationId'] === null) {
            return false;
        }
        if ($this->container['make'] === null) {
            return false;
        }
        if ($this->container['model'] === null) {
            return false;
        }
        if ($this->container['acceptNotifications'] === null) {
            return false;
        }
        if ($this->container['type'] === null) {
            return false;
        }
        $allowed_values = array("android", "ios");
        if (!in_array($this->container['type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets deviceToken
     * @return string
     */
    public function getDeviceToken()
    {
        return $this->container['deviceToken'];
    }

    /**
     * Sets deviceToken
     * @param string $deviceToken device token sent by mobile clients.
     * @return $this
     */
    public function setDeviceToken($deviceToken)
    {
        $this->container['deviceToken'] = $deviceToken;

        return $this;
    }

    /**
     * Gets notificationId
     * @return string
     */
    public function getNotificationId()
    {
        return $this->container['notificationId'];
    }

    /**
     * Sets notificationId
     * @param string $notificationId notification id of the device.
     * @return $this
     */
    public function setNotificationId($notificationId)
    {
        $this->container['notificationId'] = $notificationId;

        return $this;
    }

    /**
     * Gets make
     * @return string
     */
    public function getMake()
    {
        return $this->container['make'];
    }

    /**
     * Sets make
     * @param string $make make of the device.
     * @return $this
     */
    public function setMake($make)
    {
        $this->container['make'] = $make;

        return $this;
    }

    /**
     * Gets model
     * @return string
     */
    public function getModel()
    {
        return $this->container['model'];
    }

    /**
     * Sets model
     * @param string $model Device model
     * @return $this
     */
    public function setModel($model)
    {
        $this->container['model'] = $model;

        return $this;
    }

    /**
     * Gets acceptNotifications
     * @return bool
     */
    public function getAcceptNotifications()
    {
        return $this->container['acceptNotifications'];
    }

    /**
     * Sets acceptNotifications
     * @param bool $acceptNotifications if the device accepts notifications
     * @return $this
     */
    public function setAcceptNotifications($acceptNotifications)
    {
        $this->container['acceptNotifications'] = $acceptNotifications;

        return $this;
    }

    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type type of the device; ios or android
     * @return $this
     */
    public function setType($type)
    {
        $allowed_values = array('android', 'ios');
        if (!in_array($type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'type', must be one of 'android', 'ios'");
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets sessionHash
     * @return string
     */
    public function getSessionHash()
    {
        return $this->container['sessionHash'];
    }

    /**
     * Sets sessionHash
     * @param string $sessionHash
     * @return $this
     */
    public function setSessionHash($sessionHash)
    {
        $this->container['sessionHash'] = $sessionHash;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


