<?php

/**
 * WidgetClientConfig
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * WidgetClientConfig Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class WidgetClientConfig implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'WidgetClientConfig';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'v1' => '\PureCloudSDK\WidgetClientConfigV1',
        'v2' => '\PureCloudSDK\WidgetClientConfigV2',
        'v1Http' => '\PureCloudSDK\WidgetClientConfigV1Http',
        'thirdParty' => '\PureCloudSDK\WidgetClientConfigThirdParty'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'v1' => 'v1',
        'v2' => 'v2',
        'v1Http' => 'v1-http',
        'thirdParty' => 'third-party'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'v1' => 'setV1',
        'v2' => 'setV2',
        'v1Http' => 'setV1Http',
        'thirdParty' => 'setThirdParty'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'v1' => 'getV1',
        'v2' => 'getV2',
        'v1Http' => 'getV1Http',
        'thirdParty' => 'getThirdParty'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['v1'] = isset($data['v1']) ? $data['v1'] : null;
        $this->container['v2'] = isset($data['v2']) ? $data['v2'] : null;
        $this->container['v1Http'] = isset($data['v1Http']) ? $data['v1Http'] : null;
        $this->container['thirdParty'] = isset($data['thirdParty']) ? $data['thirdParty'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets v1
     * @return \PureCloudSDK\WidgetClientConfigV1
     */
    public function getV1()
    {
        return $this->container['v1'];
    }

    /**
     * Sets v1
     * @param \PureCloudSDK\WidgetClientConfigV1 $v1
     * @return $this
     */
    public function setV1($v1)
    {
        $this->container['v1'] = $v1;

        return $this;
    }

    /**
     * Gets v2
     * @return \PureCloudSDK\WidgetClientConfigV2
     */
    public function getV2()
    {
        return $this->container['v2'];
    }

    /**
     * Sets v2
     * @param \PureCloudSDK\WidgetClientConfigV2 $v2
     * @return $this
     */
    public function setV2($v2)
    {
        $this->container['v2'] = $v2;

        return $this;
    }

    /**
     * Gets v1Http
     * @return \PureCloudSDK\WidgetClientConfigV1Http
     */
    public function getV1Http()
    {
        return $this->container['v1Http'];
    }

    /**
     * Sets v1Http
     * @param \PureCloudSDK\WidgetClientConfigV1Http $v1Http
     * @return $this
     */
    public function setV1Http($v1Http)
    {
        $this->container['v1Http'] = $v1Http;

        return $this;
    }

    /**
     * Gets thirdParty
     * @return \PureCloudSDK\WidgetClientConfigThirdParty
     */
    public function getThirdParty()
    {
        return $this->container['thirdParty'];
    }

    /**
     * Sets thirdParty
     * @param \PureCloudSDK\WidgetClientConfigThirdParty $thirdParty
     * @return $this
     */
    public function setThirdParty($thirdParty)
    {
        $this->container['thirdParty'] = $thirdParty;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


