<?php

/**
 * WorkPlanActivity
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * WorkPlanActivity Class Doc Comment
 *
 * @category    Class */
 // @description Activity configured for shift in work plan
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class WorkPlanActivity implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'WorkPlanActivity';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'activityCodeId' => 'string',
        'description' => 'string',
        'lengthMinutes' => 'int',
        'startTimeIsRelativeToShiftStart' => 'bool',
        'flexibleStartTime' => 'bool',
        'earliestStartTimeMinutes' => 'int',
        'latestStartTimeMinutes' => 'int',
        'exactStartTimeMinutes' => 'int',
        'startTimeIncrementMinutes' => 'int',
        'countsAsPaidTime' => 'bool',
        'countsAsContiguousWorkTime' => 'bool',
        'id' => 'string',
        'delete' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'activityCodeId' => 'activityCodeId',
        'description' => 'description',
        'lengthMinutes' => 'lengthMinutes',
        'startTimeIsRelativeToShiftStart' => 'startTimeIsRelativeToShiftStart',
        'flexibleStartTime' => 'flexibleStartTime',
        'earliestStartTimeMinutes' => 'earliestStartTimeMinutes',
        'latestStartTimeMinutes' => 'latestStartTimeMinutes',
        'exactStartTimeMinutes' => 'exactStartTimeMinutes',
        'startTimeIncrementMinutes' => 'startTimeIncrementMinutes',
        'countsAsPaidTime' => 'countsAsPaidTime',
        'countsAsContiguousWorkTime' => 'countsAsContiguousWorkTime',
        'id' => 'id',
        'delete' => 'delete'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'activityCodeId' => 'setActivityCodeId',
        'description' => 'setDescription',
        'lengthMinutes' => 'setLengthMinutes',
        'startTimeIsRelativeToShiftStart' => 'setStartTimeIsRelativeToShiftStart',
        'flexibleStartTime' => 'setFlexibleStartTime',
        'earliestStartTimeMinutes' => 'setEarliestStartTimeMinutes',
        'latestStartTimeMinutes' => 'setLatestStartTimeMinutes',
        'exactStartTimeMinutes' => 'setExactStartTimeMinutes',
        'startTimeIncrementMinutes' => 'setStartTimeIncrementMinutes',
        'countsAsPaidTime' => 'setCountsAsPaidTime',
        'countsAsContiguousWorkTime' => 'setCountsAsContiguousWorkTime',
        'id' => 'setId',
        'delete' => 'setDelete'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'activityCodeId' => 'getActivityCodeId',
        'description' => 'getDescription',
        'lengthMinutes' => 'getLengthMinutes',
        'startTimeIsRelativeToShiftStart' => 'getStartTimeIsRelativeToShiftStart',
        'flexibleStartTime' => 'getFlexibleStartTime',
        'earliestStartTimeMinutes' => 'getEarliestStartTimeMinutes',
        'latestStartTimeMinutes' => 'getLatestStartTimeMinutes',
        'exactStartTimeMinutes' => 'getExactStartTimeMinutes',
        'startTimeIncrementMinutes' => 'getStartTimeIncrementMinutes',
        'countsAsPaidTime' => 'getCountsAsPaidTime',
        'countsAsContiguousWorkTime' => 'getCountsAsContiguousWorkTime',
        'id' => 'getId',
        'delete' => 'getDelete'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['activityCodeId'] = isset($data['activityCodeId']) ? $data['activityCodeId'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['lengthMinutes'] = isset($data['lengthMinutes']) ? $data['lengthMinutes'] : null;
        $this->container['startTimeIsRelativeToShiftStart'] = isset($data['startTimeIsRelativeToShiftStart']) ? $data['startTimeIsRelativeToShiftStart'] : null;
        $this->container['flexibleStartTime'] = isset($data['flexibleStartTime']) ? $data['flexibleStartTime'] : null;
        $this->container['earliestStartTimeMinutes'] = isset($data['earliestStartTimeMinutes']) ? $data['earliestStartTimeMinutes'] : null;
        $this->container['latestStartTimeMinutes'] = isset($data['latestStartTimeMinutes']) ? $data['latestStartTimeMinutes'] : null;
        $this->container['exactStartTimeMinutes'] = isset($data['exactStartTimeMinutes']) ? $data['exactStartTimeMinutes'] : null;
        $this->container['startTimeIncrementMinutes'] = isset($data['startTimeIncrementMinutes']) ? $data['startTimeIncrementMinutes'] : null;
        $this->container['countsAsPaidTime'] = isset($data['countsAsPaidTime']) ? $data['countsAsPaidTime'] : null;
        $this->container['countsAsContiguousWorkTime'] = isset($data['countsAsContiguousWorkTime']) ? $data['countsAsContiguousWorkTime'] : null;
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['delete'] = isset($data['delete']) ? $data['delete'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets activityCodeId
     * @return string
     */
    public function getActivityCodeId()
    {
        return $this->container['activityCodeId'];
    }

    /**
     * Sets activityCodeId
     * @param string $activityCodeId ID of the activity code associated with this activity
     * @return $this
     */
    public function setActivityCodeId($activityCodeId)
    {
        $this->container['activityCodeId'] = $activityCodeId;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description Description of the activity
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets lengthMinutes
     * @return int
     */
    public function getLengthMinutes()
    {
        return $this->container['lengthMinutes'];
    }

    /**
     * Sets lengthMinutes
     * @param int $lengthMinutes Length of the activity in minutes
     * @return $this
     */
    public function setLengthMinutes($lengthMinutes)
    {
        $this->container['lengthMinutes'] = $lengthMinutes;

        return $this;
    }

    /**
     * Gets startTimeIsRelativeToShiftStart
     * @return bool
     */
    public function getStartTimeIsRelativeToShiftStart()
    {
        return $this->container['startTimeIsRelativeToShiftStart'];
    }

    /**
     * Sets startTimeIsRelativeToShiftStart
     * @param bool $startTimeIsRelativeToShiftStart Whether the start time of the activity is relative to the start time of the shift it belongs to
     * @return $this
     */
    public function setStartTimeIsRelativeToShiftStart($startTimeIsRelativeToShiftStart)
    {
        $this->container['startTimeIsRelativeToShiftStart'] = $startTimeIsRelativeToShiftStart;

        return $this;
    }

    /**
     * Gets flexibleStartTime
     * @return bool
     */
    public function getFlexibleStartTime()
    {
        return $this->container['flexibleStartTime'];
    }

    /**
     * Sets flexibleStartTime
     * @param bool $flexibleStartTime Whether the start time of the activity is flexible
     * @return $this
     */
    public function setFlexibleStartTime($flexibleStartTime)
    {
        $this->container['flexibleStartTime'] = $flexibleStartTime;

        return $this;
    }

    /**
     * Gets earliestStartTimeMinutes
     * @return int
     */
    public function getEarliestStartTimeMinutes()
    {
        return $this->container['earliestStartTimeMinutes'];
    }

    /**
     * Sets earliestStartTimeMinutes
     * @param int $earliestStartTimeMinutes Earliest activity start in offset minutes relative to shift start time if startTimeIsRelativeToShiftStart == true else its based on midnight. Used if flexibleStartTime == true
     * @return $this
     */
    public function setEarliestStartTimeMinutes($earliestStartTimeMinutes)
    {
        $this->container['earliestStartTimeMinutes'] = $earliestStartTimeMinutes;

        return $this;
    }

    /**
     * Gets latestStartTimeMinutes
     * @return int
     */
    public function getLatestStartTimeMinutes()
    {
        return $this->container['latestStartTimeMinutes'];
    }

    /**
     * Sets latestStartTimeMinutes
     * @param int $latestStartTimeMinutes Latest activity start in offset minutes relative to shift start time if startTimeIsRelativeToShiftStart == true else its based on midnight. Used if flexibleStartTime == true
     * @return $this
     */
    public function setLatestStartTimeMinutes($latestStartTimeMinutes)
    {
        $this->container['latestStartTimeMinutes'] = $latestStartTimeMinutes;

        return $this;
    }

    /**
     * Gets exactStartTimeMinutes
     * @return int
     */
    public function getExactStartTimeMinutes()
    {
        return $this->container['exactStartTimeMinutes'];
    }

    /**
     * Sets exactStartTimeMinutes
     * @param int $exactStartTimeMinutes Exact activity start in offset minutes relative to shift start time if startTimeIsRelativeToShiftStart == true else its based on midnight. Used if flexibleStartTime == false
     * @return $this
     */
    public function setExactStartTimeMinutes($exactStartTimeMinutes)
    {
        $this->container['exactStartTimeMinutes'] = $exactStartTimeMinutes;

        return $this;
    }

    /**
     * Gets startTimeIncrementMinutes
     * @return int
     */
    public function getStartTimeIncrementMinutes()
    {
        return $this->container['startTimeIncrementMinutes'];
    }

    /**
     * Sets startTimeIncrementMinutes
     * @param int $startTimeIncrementMinutes Increment in offset minutes that would contribute to different possible start times for the activity
     * @return $this
     */
    public function setStartTimeIncrementMinutes($startTimeIncrementMinutes)
    {
        $this->container['startTimeIncrementMinutes'] = $startTimeIncrementMinutes;

        return $this;
    }

    /**
     * Gets countsAsPaidTime
     * @return bool
     */
    public function getCountsAsPaidTime()
    {
        return $this->container['countsAsPaidTime'];
    }

    /**
     * Sets countsAsPaidTime
     * @param bool $countsAsPaidTime Whether the activity is paid
     * @return $this
     */
    public function setCountsAsPaidTime($countsAsPaidTime)
    {
        $this->container['countsAsPaidTime'] = $countsAsPaidTime;

        return $this;
    }

    /**
     * Gets countsAsContiguousWorkTime
     * @return bool
     */
    public function getCountsAsContiguousWorkTime()
    {
        return $this->container['countsAsContiguousWorkTime'];
    }

    /**
     * Sets countsAsContiguousWorkTime
     * @param bool $countsAsContiguousWorkTime Whether the activity duration is counted towards contiguous work time
     * @return $this
     */
    public function setCountsAsContiguousWorkTime($countsAsContiguousWorkTime)
    {
        $this->container['countsAsContiguousWorkTime'] = $countsAsContiguousWorkTime;

        return $this;
    }

    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id ID of the activity. This is required only for the case of updating an existing activity
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets delete
     * @return bool
     */
    public function getDelete()
    {
        return $this->container['delete'];
    }

    /**
     * Sets delete
     * @param bool $delete If marked true for updating an existing activity, the activity will be permanently deleted
     * @return $this
     */
    public function setDelete($delete)
    {
        $this->container['delete'] = $delete;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


